/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.filter;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.filter.PatternType;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import java.io.IOException;

public abstract class Pattern
extends NamedElement {
    private String m_name;
    private int m_numberOfMatchedElements = -1;

    public Pattern(NamedElement parent) {
        super(parent);
    }

    public Pattern(NamedElement parent, String name) {
        super(parent);
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'PatternElement' must not be empty";
        this.m_name = name;
    }

    public abstract PatternType getType();

    public void setName(String name) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'setName' must not be empty";
        this.m_name = name;
    }

    @Override
    public final String getShortName() {
        return this.m_name;
    }

    @Override
    public final String getInformation() {
        return this.m_numberOfMatchedElements != -1 ? NumberUtility.format((Number)this.m_numberOfMatchedElements) + (this.m_numberOfMatchedElements == 1 ? " match" : " matches") : "";
    }

    public final int getNumberOfMatchedElements() {
        return this.m_numberOfMatchedElements;
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        assert (writer != null) : "Parameter 'writer' of method 'store' must not be null";
        super.store(writer);
        writer.writeString(this.m_name);
        writer.writeInt(this.m_numberOfMatchedElements);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        assert (reader != null) : "Parameter 'reader' of method 'retrieve' must not be null";
        super.retrieve(reader);
        this.m_name = reader.readString();
        this.m_numberOfMatchedElements = reader.readInt();
    }

    final void clear() {
        this.m_numberOfMatchedElements = -1;
    }

    final void initialize() {
        this.m_numberOfMatchedElements = 0;
    }

    protected final void incrementNumberOfMatchedElements() {
        ++this.m_numberOfMatchedElements;
    }

    public abstract boolean matches(String var1);
}

