/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.explorationview;

import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactProperties;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesNode;
import java.util.Collections;
import java.util.List;

public final class ReadOnlyArtifactNode
extends ArtifactPropertiesNode {
    private final Artifact m_artifact;

    public ReadOnlyArtifactNode(ArchitecturalViewElement parent, PresentationMode presentationMode, ArtifactProperties properties, Artifact artifact) {
        super(parent, presentationMode, true, properties);
        assert (artifact != null) : "Parameter 'artifact' of method 'ReadOnlyArtifactNode' must not be null";
        this.m_artifact = artifact;
    }

    @Override
    public NamedElement getFirstUnderlyingElement() {
        return this.m_artifact;
    }

    public Artifact getArtifact() {
        return this.m_artifact;
    }

    @Override
    public List<NamedElement> getUnderlyingElements() {
        return Collections.singletonList(this.m_artifact);
    }

    @Override
    public String getShortName() {
        return this.m_artifact.getShortName();
    }

    @Override
    public String getPresentationName(boolean shortName) {
        return this.m_artifact.getPresentationName(shortName);
    }

    @Override
    public void accept(NamedElement.INamedElementVisitor visitor) {
        if (visitor instanceof IVisitor) {
            ((IVisitor)visitor).visitReadOnlyArtifactNode(this);
        } else {
            super.accept(visitor);
        }
    }

    public static interface IVisitor
    extends NamedElement.INamedElementVisitor {
        public void visitReadOnlyArtifactNode(ReadOnlyArtifactNode var1);
    }
}

