/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.element;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import java.util.ArrayList;
import java.util.List;

public abstract class NamedElementVisitor
implements NamedElement.INamedElementVisitor {
    private final boolean m_allowDeletions;

    public NamedElementVisitor() {
        this.m_allowDeletions = false;
    }

    public NamedElementVisitor(boolean allowModifications) {
        this.m_allowDeletions = allowModifications;
    }

    @Override
    public void visitNamedElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
        this.visitChildrenOf(element);
    }

    public boolean done() {
        return false;
    }

    @Override
    public void visitChildrenOf(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
        if (!this.done() && !element.isProxy()) {
            List<NamedElement> children = element.getChildren();
            if (this.m_allowDeletions && !children.isEmpty()) {
                children = new ArrayList<NamedElement>(children);
            }
            for (NamedElement next : children) {
                if (this.done()) break;
                if (this.m_allowDeletions && !next.isValid()) continue;
                next.accept(this);
            }
        }
    }
}

