/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.element;

import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotReader;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotWriter;
import com.hello2morrow.sonargraph.core.model.snapshot.SnapshotArgument;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import java.io.IOException;

public abstract class NamedElementIssue
extends Issue {
    private static final String AFFECTED_ELEMENT = "affectedElement";
    private NamedElement m_affectedElement;

    protected NamedElementIssue() {
    }

    protected NamedElementIssue(NamedElement affectedElement) {
        assert (affectedElement != null) : "Parameter 'affectedElement' of method 'NamedElementBasedIssue' must not be null";
        this.m_affectedElement = affectedElement;
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeObjectReference(AFFECTED_ELEMENT, (IPersistable)this.m_affectedElement);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        reader.readObjectReference(AFFECTED_ELEMENT, NamedElement.class, e -> {
            NamedElement namedElement = this.m_affectedElement = e;
        });
    }

    @Override
    public NamedElement getAffectedElement() {
        assert (this.m_affectedElement != null) : "'m_affectedElement' of method 'getAffectedElements' must not be null";
        return this.m_affectedElement.getRepresentative();
    }

    @Override
    public boolean isExcluded() {
        return this.getAffectedElement().isExcluded();
    }

    @Override
    public boolean ignoreIssues() {
        return this.getAffectedElement().ignoreIssues();
    }

    @Override
    public boolean isValid() {
        return this.getAffectedElement().isValid();
    }

    @Property
    public String getElementName() {
        return this.getAffectedElement().getPresentationName(false);
    }

    @Override
    public int getLineNumber() {
        return this.getAffectedElement().getLineNumber();
    }

    @Override
    public void store(ISnapshotWriter writer) throws IOException {
        assert (this.m_affectedElement != null) : "'m_affectedElement' of method 'store' must not be null";
        super.store(writer);
        writer.write(this.m_affectedElement);
    }

    @Override
    public void retrieve(ISnapshotReader reader) throws ClassNotFoundException, IOException {
        super.retrieve(reader);
        this.m_affectedElement = reader.read(NamedElement.class, new SnapshotArgument[0]);
    }

    @Override
    public final Element.IPropertiesManager getPropertiesManager() {
        assert (this.m_affectedElement != null) : "'m_affectedElement' of method 'getPropertiesManager' must not be null";
        return this.m_affectedElement.getPropertiesManager();
    }
}

