/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.model.analysis;

import com.hello2morrow.sonargraph.core.model.analysis.CycleGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.ISingleIssueProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.resolution.CycleGroupKind;
import com.hello2morrow.sonargraph.core.model.snapshot.ISnapshotProcessor;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectReader;
import com.hello2morrow.sonargraph.foundation.persistence.IObjectWriter;
import com.hello2morrow.sonargraph.foundation.persistence.IPersistable;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.foundation.propertyreader.IntProperty;
import com.hello2morrow.sonargraph.foundation.propertyreader.Property;
import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AnalyzerCycleGroup
extends CycleGroup
implements ISingleIssueProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalyzerCycleGroup.class);
    private static final String STRUCTURAL_DEBT_INDEX = "structuralDebtIndex";
    private static final String COMPONENT_DEPENDENCIES_TO_REMOVE = "componentDependenciesToRemove";
    private static final String PARSER_DEPENDENCIES = "parserDependencies";
    private static final String PARSER_DEPENDENCIES_TO_REMOVE = "parserDependenciesToRemove";
    private static final String NAME_SUFFIX = "nameSuffix";
    private static final String SCOPE = "scope";
    private static final String DUPLICATE_OF = "duplicateOf";
    private static final String INVOLVED_SOURCES = "involvedSourceFiles";
    private static final String LOC_INVOLVED_SOURCES = "involvedLoc";
    private NamedElement m_scope;
    private AnalyzerCycleGroup m_duplicateOf;
    private String m_nameSuffix = "";
    private int m_parserDependencies = 0;
    private int m_parserDependenciesToRemove = 0;
    private int m_componentDependenciesToRemove = 0;
    private int m_structuralDebtIndex = 0;
    private int m_numberOfInvolvedSourceFiles = 0;
    private int m_locOfInvolvedSourceFiles = 0;

    public AnalyzerCycleGroup(NamedElement parent) {
        super(parent);
    }

    @Override
    public void writeAttributes(IObjectWriter writer) throws IOException {
        super.writeAttributes(writer);
        writer.writeObjectReference(SCOPE, (IPersistable)this.m_scope);
        writer.writeObjectReference(DUPLICATE_OF, (IPersistable)this.m_duplicateOf);
        writer.writeString(NAME_SUFFIX, this.m_nameSuffix);
        writer.writeInt(PARSER_DEPENDENCIES, this.m_parserDependencies);
        writer.writeInt(PARSER_DEPENDENCIES_TO_REMOVE, this.m_parserDependenciesToRemove);
        writer.writeInt(COMPONENT_DEPENDENCIES_TO_REMOVE, this.m_componentDependenciesToRemove);
        writer.writeInt(STRUCTURAL_DEBT_INDEX, this.m_structuralDebtIndex);
        writer.writeInt(INVOLVED_SOURCES, this.m_numberOfInvolvedSourceFiles);
        writer.writeInt(LOC_INVOLVED_SOURCES, this.m_locOfInvolvedSourceFiles);
    }

    @Override
    public void readAttributes(IObjectReader reader) throws IOException, RestoreException {
        super.readAttributes(reader);
        reader.readObjectReference(SCOPE, NamedElement.class, e -> {
            NamedElement namedElement = this.m_scope = e;
        });
        reader.readObjectReference(DUPLICATE_OF, AnalyzerCycleGroup.class, e -> {
            AnalyzerCycleGroup analyzerCycleGroup = this.m_duplicateOf = e;
        });
        this.m_nameSuffix = reader.readString(NAME_SUFFIX);
        Integer parserDependencies = reader.readInt(PARSER_DEPENDENCIES);
        if (parserDependencies == null) {
            throw new RestoreException("Misssing metric");
        }
        this.m_parserDependencies = parserDependencies;
        this.m_parserDependenciesToRemove = reader.readInt(PARSER_DEPENDENCIES_TO_REMOVE);
        this.m_componentDependenciesToRemove = reader.readInt(COMPONENT_DEPENDENCIES_TO_REMOVE);
        this.m_structuralDebtIndex = reader.readInt(STRUCTURAL_DEBT_INDEX);
        Integer involvedSources = reader.readInt(INVOLVED_SOURCES);
        if (involvedSources == null) {
            throw new RestoreException("Misssing metric");
        }
        this.m_numberOfInvolvedSourceFiles = involvedSources;
        this.m_locOfInvolvedSourceFiles = reader.readInt(LOC_INVOLVED_SOURCES);
    }

    public AnalyzerCycleGroup(NamedElement parent, NamedElement scope, boolean isCritical) {
        super(parent, isCritical);
        assert (scope != null) : "Parameter 'scope' of method 'CycleGroup' must not be null";
        this.m_scope = scope;
    }

    public final void setDuplicateOf(AnalyzerCycleGroup duplicateOf) {
        this.m_duplicateOf = duplicateOf;
    }

    public final AnalyzerCycleGroup getDuplicateOf() {
        return this.m_duplicateOf;
    }

    @Property
    public String duplicateOf() {
        return this.m_duplicateOf == null ? "" : this.m_duplicateOf.getName();
    }

    public boolean isDuplicate() {
        return this.m_duplicateOf != null;
    }

    public abstract IIssueId getCycleGroupIssueId();

    @Override
    public final String getShortName() {
        String isCritical = this.isCritical() ? "[Critical] " : "";
        String language = this.getLanguage() != null ? this.getLanguage().getPresentationName() + " " : "";
        return isCritical + language + this.getPresentationKind() + " " + this.m_nameSuffix;
    }

    @Override
    public final boolean persist(ISnapshotProcessor.Mode mode) {
        return false;
    }

    public void finish(String nameSuffix) {
        assert (nameSuffix != null) : "Parameter 'nameSuffix' of method 'setNameSuffix' must not be null";
        this.m_nameSuffix = nameSuffix;
        this.getCyclicNamedElements();
        this.getFullyQualifiedNamePart();
    }

    @Override
    public final String fullyQualifiedName() {
        return null;
    }

    public final String getNameSuffix() {
        return this.m_nameSuffix;
    }

    public final NamedElement getScope() {
        return this.m_scope;
    }

    public void setDependenciesInfo(int parserDependencies, int parserDependenciesToRemove, int componentDependenciesToRemove, int structuralDebtIndex) {
        this.m_parserDependencies = parserDependencies;
        this.m_parserDependenciesToRemove = parserDependenciesToRemove;
        this.m_componentDependenciesToRemove = componentDependenciesToRemove;
        this.m_structuralDebtIndex = structuralDebtIndex;
    }

    @IntProperty
    public int getParserDependencies() {
        return this.m_parserDependencies;
    }

    @IntProperty
    public int getParserDependenciesToRemove() {
        return this.m_parserDependenciesToRemove;
    }

    @IntProperty
    public int getComponentDependenciesToRemove() {
        return this.m_componentDependenciesToRemove;
    }

    @IntProperty
    public int getStructuralDebtIndex() {
        return this.m_structuralDebtIndex;
    }

    @Override
    public final Issue getAssociatedIssue() {
        List<Issue> issues = this.getIssues();
        return issues.size() == 1 ? issues.get(0) : null;
    }

    public String createIssueDescription() {
        if (this.m_scope != null) {
            return this.m_scope.getPresentationKind() + " '" + this.m_scope.getPresentationName(false) + "' contains " + this.getDescription();
        }
        return this.getDescription();
    }

    public void setInvolvedSourceFileInfo(int sourceFiles, int loc) {
        this.m_numberOfInvolvedSourceFiles = sourceFiles;
        this.m_locOfInvolvedSourceFiles = loc;
    }

    @IntProperty
    public int getNumberOfInvolvedSourceFiles() {
        return this.m_numberOfInvolvedSourceFiles;
    }

    @IntProperty
    public int getLinesOfCodeOfInvolvedSourceFiles() {
        return this.m_locOfInvolvedSourceFiles;
    }

    public static String translateHashPart(String hashPart, List<String> translatedFullyQualifiedNamesOfInvolvedElements) {
        assert (hashPart != null && hashPart.length() > 0) : "Parameter 'hashPart' of method 'translateHashPart' must not be empty";
        assert (translatedFullyQualifiedNamesOfInvolvedElements != null && !translatedFullyQualifiedNamesOfInvolvedElements.isEmpty()) : "Parameter 'translatedFullyQualifiedNamesOfInvolvedElements' of method 'translateHashPart' must not be empty";
        int pos = hashPart.lastIndexOf(124);
        if (pos != -1) {
            String hackMD5 = hashPart.substring(pos + 1);
            ArrayList<String> fqNames = new ArrayList<String>(translatedFullyQualifiedNamesOfInvolvedElements);
            Collections.sort(fqNames);
            StringBuilder elementsFqNames = new StringBuilder();
            for (String next : fqNames) {
                elementsFqNames.append(next);
            }
            return HashSupport.MD5.getHexString(elementsFqNames.toString()) + Element.INNER_NAME_PARTS_SEPARATOR + hackMD5;
        }
        LOGGER.warn("'hashPart' does not contain '|': " + hashPart);
        return hashPart;
    }

    public abstract CycleGroupKind getKind();
}

