/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.foundation.common.graph;

import com.hello2morrow.sonargraph.core.foundation.common.graph.CycleAnalyzer;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FASComputer;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetCycleAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetCycleDetector;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetInfo;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetNode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetNonProgressCompositeWorkerContext;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetSimpleCycle;
import com.hello2morrow.sonargraph.core.foundation.common.graph.FeedbackArcSetSimpleCyclesDetector;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IFeedbackArcSetAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FeedbackArcSetComputer {
    private static final int FAS_THRESHOLD = 300;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeedbackArcSetComputer.class);

    private FeedbackArcSetComputer() {
    }

    private static List<FeedbackArcSetSimpleCycle> sort(List<FeedbackArcSetSimpleCycle> simpleCycles) {
        assert (simpleCycles != null) : "Parameter 'simpleCycles' of method 'sort' must not be null";
        if (simpleCycles.size() <= 1) {
            return simpleCycles;
        }
        return simpleCycles.stream().sorted(Comparator.comparingInt(FeedbackArcSetSimpleCycle::getMinEdgeWeight).thenComparingInt(FeedbackArcSetSimpleCycle::getNumberOfEdges).thenComparingInt(FeedbackArcSetSimpleCycle::getWeight)).collect(Collectors.toList());
    }

    private static final List<FeedbackArcSetNode.Edge> reduceWeight(IWorkerContext workerContext, Set<FeedbackArcSetNode> cyclicNodes) {
        assert (cyclicNodes != null && cyclicNodes.size() >= 2) : "Parameter 'cyclicNodes' of method 'reduceWeight' must at least contain 2 nodes";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'reduceWeight' must not be null";
        workerContext.working("Weight reduction", false);
        ArrayList<FeedbackArcSetNode.Edge> removedEdges = new ArrayList<FeedbackArcSetNode.Edge>();
        Set<FeedbackArcSetNode> remainingCyclicNodes = cyclicNodes;
        List<FeedbackArcSetSimpleCycle> nextSimpleCycles = FeedbackArcSetSimpleCyclesDetector.getMinimalSimpleCycles(workerContext, remainingCyclicNodes);
        nextSimpleCycles = FeedbackArcSetComputer.sort(nextSimpleCycles);
        FeedbackArcSetSimpleCycle nextSimpleCycle = nextSimpleCycles.isEmpty() ? null : nextSimpleCycles.get(0);
        while (nextSimpleCycle != null) {
            if (workerContext.hasBeenCanceled()) {
                return Collections.emptyList();
            }
            int minWeight = nextSimpleCycle.getMinEdgeWeight();
            for (FeedbackArcSetNode.Edge nextEdge : nextSimpleCycle.getEdges()) {
                if (workerContext.hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                int nextWeight = nextEdge.getWeight();
                int newWeight = nextWeight - minWeight;
                assert (nextWeight >= 0) : "Weight of edge to reduce must not be negative: " + nextEdge.getFrom().getName() + " -> " + nextEdge.getTo().getName();
                nextEdge.setWeight(newWeight);
                if (newWeight != 0) continue;
                nextEdge.getFrom().removeOutgoingEdge(nextEdge);
                removedEdges.add(nextEdge);
            }
            if (FASComputer.containsCyclicNodes(remainingCyclicNodes)) {
                Iterator<FeedbackArcSetSimpleCycle> iter = nextSimpleCycles.iterator();
                block2: while (iter.hasNext()) {
                    if (workerContext.hasBeenCanceled()) {
                        return Collections.emptyList();
                    }
                    FeedbackArcSetSimpleCycle nextSimpleCycleToUpdate = iter.next();
                    for (FeedbackArcSetNode.Edge nextEdge : nextSimpleCycleToUpdate.getEdges()) {
                        if (nextEdge.getWeight() != 0) continue;
                        iter.remove();
                        continue block2;
                    }
                }
                if (!nextSimpleCycles.isEmpty()) {
                    nextSimpleCycles = FeedbackArcSetComputer.sort(nextSimpleCycles);
                    nextSimpleCycle = nextSimpleCycles.get(0);
                    continue;
                }
                FeedbackArcSetCycleAdapter nextCycleAdapter = new FeedbackArcSetCycleAdapter(remainingCyclicNodes);
                CycleAnalyzer.compute(nextCycleAdapter, new FeedbackArcSetNonProgressCompositeWorkerContext(workerContext));
                remainingCyclicNodes = nextCycleAdapter.getCyclicNodes();
                if (remainingCyclicNodes.isEmpty()) {
                    nextSimpleCycle = null;
                    continue;
                }
                nextSimpleCycles = FeedbackArcSetSimpleCyclesDetector.getMinimalSimpleCycles(workerContext, remainingCyclicNodes);
                nextSimpleCycle = (nextSimpleCycles = FeedbackArcSetComputer.sort(nextSimpleCycles)).isEmpty() ? null : nextSimpleCycles.get(0);
                continue;
            }
            nextSimpleCycle = null;
        }
        Collections.reverse(removedEdges);
        List<FeedbackArcSetNode.Edge> sortedRemovedEdges = removedEdges.stream().sorted(Comparator.comparingInt(FeedbackArcSetNode.Edge::getWeightOfUnderlyingEdge).reversed()).collect(Collectors.toList());
        return sortedRemovedEdges;
    }

    private static void calculateAdditionalInformation(Set<FeedbackArcSetNode> cyclicNodes, List<FeedbackArcSetNode.Edge> removedEdges, FeedbackArcSetInfo info, IWorkerContext workerContext) {
        assert (cyclicNodes != null && !cyclicNodes.isEmpty()) : "Parameter 'cyclicNodes' of method 'calculateAdditionalInformation' must not be empty";
        assert (removedEdges != null) : "Parameter 'removedEdges' of method 'calculateAdditionalInformation' must not be null";
        assert (info != null) : "Parameter 'info' of method 'calculateAdditionalInformation' must not be null";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'calculateAdditionalInformation' must not be null";
        THashMap removedEdgeToCyclicity = new THashMap(removedEdges.size());
        THashMap removedEdgeToCyclicNodes = new THashMap(removedEdges.size());
        THashMap removedEdgeToSumOfWeight = new THashMap(removedEdges.size());
        LinkedHashSet<INode.IEdge> overdefinedEdges = new LinkedHashSet<INode.IEdge>();
        workerContext.working("Calculating cyclicity, cylic node reduction and over-definition", true);
        workerContext.beginBlockOfWork(removedEdges.size() * 2);
        for (FeedbackArcSetNode.Edge nextOutgoingEdge : removedEdges) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            nextOutgoingEdge.getFrom().addOutgoingEdge(nextOutgoingEdge);
            workerContext.workItemCompleted();
        }
        int sumOfParserDependencies = 0;
        boolean isCycleAlreadyBroken = false;
        for (FeedbackArcSetNode.Edge nextOutgoingEdge : removedEdges) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            int weightOfCurrentEdge = nextOutgoingEdge.getWeightOfUnderlyingEdge();
            removedEdgeToSumOfWeight.put(nextOutgoingEdge.getUnderlyingEdge(), sumOfParserDependencies += weightOfCurrentEdge);
            nextOutgoingEdge.getFrom().removeOutgoingEdge(nextOutgoingEdge);
            FeedbackArcSetCycleAdapter nextCycleAdapter = new FeedbackArcSetCycleAdapter(cyclicNodes);
            CycleAnalyzer.compute(nextCycleAdapter, new FeedbackArcSetNonProgressCompositeWorkerContext(workerContext));
            int nextCyclicity = nextCycleAdapter.getCyclicity();
            removedEdgeToCyclicity.put(nextOutgoingEdge.getUnderlyingEdge(), nextCyclicity);
            removedEdgeToCyclicNodes.put(nextOutgoingEdge.getUnderlyingEdge(), nextCycleAdapter.getNumberOfCyclicNodes());
            if (isCycleAlreadyBroken) {
                overdefinedEdges.add(nextOutgoingEdge.getUnderlyingEdge());
            }
            isCycleAlreadyBroken = isCycleAlreadyBroken || nextCyclicity == 0;
            workerContext.workItemCompleted();
        }
        workerContext.endStep();
        info.setCyclicityPerEdge((Map<INode.IEdge, Integer>)removedEdgeToCyclicity);
        info.setCyclicNodesPerEdge((Map<INode.IEdge, Integer>)removedEdgeToCyclicNodes);
        info.setSumOfWeightPerEdge((Map<INode.IEdge, Integer>)removedEdgeToSumOfWeight);
        info.setOverdefinedEdges(overdefinedEdges);
    }

    private static void collectData(IWorkerContext workerContext, Set<? extends INode<?>> cyclicNodes, IFeedbackArcSetAdapter adapter, FeedbackArcSetInfo info, Set<FeedbackArcSetNode> feedbackArcSetNodesCollector, Set<INode.IEdge> edgesToKeepCollector, List<FeedbackArcSetNode.Edge> removedEdgesCollector) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'collectData' must not be null";
        assert (cyclicNodes != null && cyclicNodes.size() >= 2) : "Parameter 'cyclicNodes' of method 'collectData' must contain at least 2 nodes";
        assert (adapter != null) : "Parameter 'adapter' of method 'collectData' must not be null";
        assert (info != null) : "Parameter 'info' of method 'collectData' must not be null";
        assert (feedbackArcSetNodesCollector != null) : "Parameter 'feedbackArcSetNodesCollector' of method 'collectData' must not be null";
        assert (edgesToKeepCollector != null) : "Parameter 'edgesToKeepCollector' of method 'collectData' must not be null";
        assert (removedEdgesCollector != null) : "Parameter 'removedEdges' of method 'collectData' must not be null";
        THashMap nodeToFasNode = new THashMap(cyclicNodes.size());
        for (INode<?> nextNode : cyclicNodes) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            nodeToFasNode.put(nextNode, new FeedbackArcSetNode(nextNode));
        }
        ArrayList<FeedbackArcSetNode.Edge> edgesToRemove = new ArrayList<FeedbackArcSetNode.Edge>();
        ArrayList<FeedbackArcSetNode.Edge> edgesToKeep = new ArrayList<FeedbackArcSetNode.Edge>();
        int totalEdges = 0;
        int totalWeight = 0;
        int maxWeight = 0;
        for (Map.Entry nextEntry : nodeToFasNode.entrySet()) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            INode nextFromNode = (INode)nextEntry.getKey();
            FeedbackArcSetNode nextFromFeedbackArcSetNode = (FeedbackArcSetNode)nextEntry.getValue();
            for (INode.IEdge nextOutgoingEdge : nextFromNode.getOutgoingEdges()) {
                int nextWeight;
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                INode<?> nextToNode = nextOutgoingEdge.getTo();
                if (nextFromNode == nextToNode || !cyclicNodes.contains(nextToNode)) continue;
                FeedbackArcSetNode nextToFASNode = (FeedbackArcSetNode)nodeToFasNode.get(nextToNode);
                assert (nextToFASNode != null) : "'nextToFASNode' of method 'createStartData' must not be null";
                int nextWeightToSet = nextWeight = nextOutgoingEdge.getWeight();
                IFeedbackArcSetAdapter.EdgeHint nextHint = adapter.getHint(nextOutgoingEdge);
                switch (nextHint) {
                    case KEEP_IF_POSSIBLE: {
                        break;
                    }
                    case REMOVE: {
                        nextWeightToSet = -1;
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled hint: " + String.valueOf((Object)nextHint);
                        break;
                    }
                }
                maxWeight = Math.max(nextWeightToSet, maxWeight);
                FeedbackArcSetNode.Edge added = nextFromFeedbackArcSetNode.addOutgoingEdge(nextToFASNode, nextOutgoingEdge, nextWeightToSet);
                switch (nextHint) {
                    case KEEP_IF_POSSIBLE: {
                        edgesToKeep.add(added);
                        break;
                    }
                    case REMOVE: {
                        edgesToRemove.add(added);
                        break;
                    }
                    case NONE: {
                        break;
                    }
                    default: {
                        assert (false) : "Unhandled hint: " + String.valueOf((Object)nextHint);
                        break;
                    }
                }
                ++totalEdges;
                totalWeight += nextWeight;
            }
        }
        if (!edgesToKeep.isEmpty()) {
            int setWeightForEdgesToKeep = maxWeight + 1;
            for (FeedbackArcSetNode.Edge nextEdgeToKeep : edgesToKeep) {
                nextEdgeToKeep.setWeight(setWeightForEdgesToKeep);
            }
        }
        info.setOutgoingEdgesOfCyclicNodes(totalEdges);
        info.setWeightOfOutgoingEdgesOfCyclicNodes(totalWeight);
        if (!edgesToRemove.isEmpty()) {
            LOGGER.debug("Explicitly remove " + edgesToRemove.size() + " edge(s)");
            for (FeedbackArcSetNode.Edge nextOutgoingEdge : edgesToRemove) {
                assert (nextOutgoingEdge.getWeight() == -1) : "Unexpected weight: " + nextOutgoingEdge.getFrom().getName() + " -> " + nextOutgoingEdge.getTo().getName() + " [weight: " + nextOutgoingEdge.getWeight() + "]";
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Explicitly remove edge: " + nextOutgoingEdge.getFrom().getName() + " -> " + nextOutgoingEdge.getTo().getName() + " [weight: " + nextOutgoingEdge.getWeightOfUnderlyingEdge() + "]");
                }
                nextOutgoingEdge.getFrom().removeOutgoingEdge(nextOutgoingEdge);
                removedEdgesCollector.add(nextOutgoingEdge);
            }
        }
        if (!edgesToKeep.isEmpty()) {
            LOGGER.debug(edgesToKeep.size() + " edge(s) should be kept if possible");
            for (FeedbackArcSetNode.Edge nextOutgoingEdge : edgesToKeep) {
                LOGGER.debug("Keep edge if possible: " + nextOutgoingEdge.getFrom().getName() + " -> " + nextOutgoingEdge.getTo().getName() + " [weight: " + nextOutgoingEdge.getWeightOfUnderlyingEdge() + "]");
                edgesToKeepCollector.add(nextOutgoingEdge.getUnderlyingEdge());
            }
        }
        feedbackArcSetNodesCollector.addAll(nodeToFasNode.values());
    }

    public static void compute(IWorkerContext workerContext, IFeedbackArcSetAdapter adapter) {
        boolean edgesHaveBeenManuallyRemoved;
        Object cyclicFeedbackArcSetNodes;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'compute' must not be null";
        assert (adapter != null) : "Parameter 'adapter' of method 'compute' must not be null";
        if (adapter.calculateAdditionalInformation()) {
            workerContext.setNumberOfSteps(5, new int[]{3, 2, 10, 65, 20});
        } else {
            workerContext.setNumberOfSteps(4, new int[]{3, 2, 10, 85});
        }
        workerContext.working("Collect cyclic nodes", true);
        Collection<INode<?>> inputNodes = adapter.getNodes();
        assert (inputNodes != null && !inputNodes.isEmpty()) : "'inputNodes' of method 'FeedbackArcSetComputer' must not be empty";
        LOGGER.debug("Collect initial cyclic nodes from " + inputNodes.size() + " input nodes");
        FeedbackArcSetCycleAdapter initialCycleAdapter = new FeedbackArcSetCycleAdapter(inputNodes);
        CycleAnalyzer.compute(initialCycleAdapter, new FeedbackArcSetNonProgressCompositeWorkerContext(workerContext));
        Set cyclicInputNodes = initialCycleAdapter.getCyclicNodes();
        workerContext.endStep();
        if (cyclicInputNodes.isEmpty()) {
            LOGGER.debug("Skipping FAS computation - no cyclic nodes in input nodes found");
            return;
        }
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        FeedbackArcSetInfo info = new FeedbackArcSetInfo();
        info.setCyclicity(initialCycleAdapter.getCyclicity());
        info.setCyclicNodes(cyclicInputNodes.size());
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        if (cyclicInputNodes.size() > 300) {
            FASComputer.compute(workerContext, adapter, info, cyclicInputNodes);
            return;
        }
        workerContext.working("Compute feedback arc set", true);
        LOGGER.debug("Compute FAS for " + cyclicInputNodes.size() + " cyclic nodes");
        ArrayList<FeedbackArcSetNode.Edge> removedEdges = new ArrayList<FeedbackArcSetNode.Edge>();
        LinkedHashSet<INode.IEdge> edgesToKeep = new LinkedHashSet<INode.IEdge>();
        THashSet initialCyclicFeedbackArcSetNodes = new THashSet();
        FeedbackArcSetComputer.collectData(workerContext, cyclicInputNodes, adapter, info, (Set<FeedbackArcSetNode>)initialCyclicFeedbackArcSetNodes, edgesToKeep, removedEdges);
        assert (initialCyclicFeedbackArcSetNodes.size() == cyclicInputNodes.size()) : "Not all FAS nodes are cyclic";
        workerContext.endStep();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        if (!removedEdges.isEmpty()) {
            FeedbackArcSetCycleAdapter fasNodeCycleAdapter = new FeedbackArcSetCycleAdapter((Collection<INode<?>>)initialCyclicFeedbackArcSetNodes);
            CycleAnalyzer.compute(fasNodeCycleAdapter, new FeedbackArcSetNonProgressCompositeWorkerContext(workerContext));
            cyclicFeedbackArcSetNodes = fasNodeCycleAdapter.getCyclicNodes();
            edgesHaveBeenManuallyRemoved = true;
        } else {
            cyclicFeedbackArcSetNodes = initialCyclicFeedbackArcSetNodes;
            edgesHaveBeenManuallyRemoved = false;
        }
        if (!cyclicFeedbackArcSetNodes.isEmpty()) {
            LOGGER.debug("Weight reduction (phase 1 of FAS Algorithm)");
            removedEdges.addAll(FeedbackArcSetComputer.reduceWeight(workerContext, (Set<FeedbackArcSetNode>)cyclicFeedbackArcSetNodes));
            LOGGER.debug("Weight reduction (phase 1 of FAS Algorithm) - done");
        } else {
            LOGGER.debug("Skipping weight reduction (phase 1 of FAS Algorithm) - all cycles already broken due to explicitly removed edges");
        }
        workerContext.endStep();
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        workerContext.working("Re-adding removed edges", true);
        LOGGER.debug("Re-adding " + removedEdges.size() + " removed edges without re-introducing cycles (phase 2 of FAS Algorithm) ");
        workerContext.beginBlockOfWork(removedEdges.size());
        FeedbackArcSetCycleDetector cycleDetector = new FeedbackArcSetCycleDetector((Set<FeedbackArcSetNode>)initialCyclicFeedbackArcSetNodes, workerContext);
        int totalWeightOfEdgesToBeRemoved = 0;
        LinkedHashSet<INode.IEdge> feedbackArcSet = new LinkedHashSet<INode.IEdge>();
        Iterator removedEdgesIterator = removedEdges.iterator();
        while (removedEdgesIterator.hasNext()) {
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            FeedbackArcSetNode.Edge nextOutgoingEdge = (FeedbackArcSetNode.Edge)removedEdgesIterator.next();
            if (nextOutgoingEdge.getWeight() == -1) {
                nextUnderlyingEdge = nextOutgoingEdge.getUnderlyingEdge();
                feedbackArcSet.add(nextUnderlyingEdge);
                totalWeightOfEdgesToBeRemoved += nextUnderlyingEdge.getWeight();
            } else {
                nextOutgoingEdge.getFrom().addOutgoingEdge(nextOutgoingEdge);
                if (cycleDetector.hasCycles()) {
                    nextOutgoingEdge.getFrom().removeOutgoingEdge(nextOutgoingEdge);
                    nextUnderlyingEdge = nextOutgoingEdge.getUnderlyingEdge();
                    feedbackArcSet.add(nextUnderlyingEdge);
                    totalWeightOfEdgesToBeRemoved += nextUnderlyingEdge.getWeight();
                } else {
                    removedEdgesIterator.remove();
                }
            }
            workerContext.workItemCompleted();
        }
        workerContext.endStep();
        info.setWeightOfOutgoingEdgesToBeRemoved(totalWeightOfEdgesToBeRemoved);
        info.setOutgoingEdgesToBeRemoved(feedbackArcSet.size());
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        if (adapter.calculateAdditionalInformation()) {
            FeedbackArcSetComputer.calculateAdditionalInformation((Set<FeedbackArcSetNode>)initialCyclicFeedbackArcSetNodes, removedEdges, info, workerContext);
        }
        if (workerContext.hasBeenCanceled()) {
            return;
        }
        LinkedHashSet<INode.IEdge> notKeptEdges = new LinkedHashSet<INode.IEdge>(feedbackArcSet.stream().filter(e -> edgesToKeep.contains(e)).collect(Collectors.toList()));
        adapter.feedbackArcSet(info, feedbackArcSet, notKeptEdges);
        if (LOGGER.isDebugEnabled() && !notKeptEdges.isEmpty()) {
            LOGGER.debug(notKeptEdges.size() + " edge(s) could not be kept");
        }
        LOGGER.debug("Compute FAS for " + cyclicInputNodes.size() + " cyclic nodes - done: " + String.valueOf(info));
        if (LOGGER.isTraceEnabled() && !edgesHaveBeenManuallyRemoved) {
            Set<INode.IEdge> fas = FeedbackArcSetComputer.compute((IWorkerContext)DefaultWorkerContext.INSTANCE, cyclicInputNodes);
            int totalFASWeight = 0;
            for (INode.IEdge nextEdge : fas) {
                totalFASWeight += nextEdge.getWeight();
            }
            LOGGER.trace("FAS/FeedbackArcSet: " + fas.size() + " [" + totalFASWeight + "] / " + feedbackArcSet.size() + " [" + totalWeightOfEdgesToBeRemoved + "]");
            for (INode.IEdge nextEdge : feedbackArcSet) {
                fas.remove(nextEdge);
            }
            if (!fas.isEmpty()) {
                LOGGER.error("Different FAS results: ");
                for (INode.IEdge nextEdge : fas) {
                    LOGGER.error(String.valueOf(nextEdge));
                }
                assert (false) : "Different FAS results";
            }
        }
    }

    public static final Set<INode.IEdge> compute(IWorkerContext workerContext, Set<? extends INode<?>> cyclicNodes) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'compute' must not be null";
        assert (cyclicNodes != null && cyclicNodes.size() >= 2) : "Parameter 'cyclicNodes' of method 'compute' must contain at least 2 nodes";
        if (cyclicNodes.size() > 300) {
            return FASComputer.compute(workerContext, cyclicNodes);
        }
        THashMap nodeToFasNode = new THashMap(cyclicNodes.size());
        for (INode<?> iNode : cyclicNodes) {
            if (workerContext.hasBeenCanceled()) {
                return null;
            }
            nodeToFasNode.put(iNode, new FeedbackArcSetNode(iNode));
        }
        for (Map.Entry entry : nodeToFasNode.entrySet()) {
            if (workerContext.hasBeenCanceled()) {
                return Collections.emptySet();
            }
            INode nextFromNode = (INode)entry.getKey();
            FeedbackArcSetNode nextFromFeedbackArcSetNode = (FeedbackArcSetNode)entry.getValue();
            for (INode.IEdge nextOutgoingEdge : nextFromNode.getOutgoingEdges()) {
                int nextWeight;
                if (workerContext.hasBeenCanceled()) {
                    return Collections.emptySet();
                }
                INode<?> nextToNode = nextOutgoingEdge.getTo();
                if (nextFromNode == nextToNode || !cyclicNodes.contains(nextToNode)) continue;
                FeedbackArcSetNode nextToFeedbackArcSetNode = (FeedbackArcSetNode)nodeToFasNode.get(nextToNode);
                assert (nextToFeedbackArcSetNode != null) : "'nextToFeedbackArcSetNode' of method 'compute' must not be null";
                int nextWeightToSet = nextWeight = nextOutgoingEdge.getWeight();
                nextFromFeedbackArcSetNode.addOutgoingEdge(nextToFeedbackArcSetNode, nextOutgoingEdge, nextWeightToSet);
            }
        }
        if (workerContext.hasBeenCanceled()) {
            return Collections.emptySet();
        }
        FeedbackArcSetCycleAdapter feedbackArcSetCycleAdapter = new FeedbackArcSetCycleAdapter(nodeToFasNode.values());
        CycleAnalyzer.compute(feedbackArcSetCycleAdapter, new FeedbackArcSetNonProgressCompositeWorkerContext(workerContext));
        Set<FeedbackArcSetNode> cyclicFeedbackArcSetNodes = feedbackArcSetCycleAdapter.getCyclicNodes();
        assert (cyclicFeedbackArcSetNodes.size() == cyclicNodes.size()) : "Not all nodes are cyclic";
        List<FeedbackArcSetNode.Edge> removedEdges = FeedbackArcSetComputer.reduceWeight(workerContext, cyclicFeedbackArcSetNodes);
        if (workerContext.hasBeenCanceled()) {
            return Collections.emptySet();
        }
        FeedbackArcSetCycleDetector cycleDetector = new FeedbackArcSetCycleDetector(cyclicFeedbackArcSetNodes, workerContext);
        LinkedHashSet<INode.IEdge> feedbackArcSet = new LinkedHashSet<INode.IEdge>();
        Iterator<FeedbackArcSetNode.Edge> removedEdgesIterator = removedEdges.iterator();
        while (removedEdgesIterator.hasNext()) {
            if (workerContext.hasBeenCanceled()) {
                return Collections.emptySet();
            }
            FeedbackArcSetNode.Edge nextOutgoingEdge = removedEdgesIterator.next();
            assert (nextOutgoingEdge.getWeight() != -1) : "Unexpected manually removed edge: " + String.valueOf(nextOutgoingEdge);
            nextOutgoingEdge.getFrom().addOutgoingEdge(nextOutgoingEdge);
            if (cycleDetector.hasCycles()) {
                nextOutgoingEdge.getFrom().removeOutgoingEdge(nextOutgoingEdge);
                feedbackArcSet.add(nextOutgoingEdge.getUnderlyingEdge());
                continue;
            }
            removedEdgesIterator.remove();
        }
        return feedbackArcSet;
    }
}

