/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.treemap;

import com.hello2morrow.sonargraph.core.controller.system.base.IIssueParticipationProvider;
import com.hello2morrow.sonargraph.core.controller.system.treemap.ColorOrHeightFloatMetricValueAccessor;
import com.hello2morrow.sonargraph.core.controller.system.treemap.ColorOrHeightFloatOrIntScriptMetricValueAccessor;
import com.hello2morrow.sonargraph.core.controller.system.treemap.ColorOrHeightIntMetricValueAccessor;
import com.hello2morrow.sonargraph.core.controller.system.treemap.ColorOrHeightValueAccessor;
import com.hello2morrow.sonargraph.core.controller.system.treemap.IssueCollectorIntValueAccessor;
import com.hello2morrow.sonargraph.core.controller.system.treemap.LeafNodeColorCalculator;
import com.hello2morrow.sonargraph.core.controller.system.treemap.LeafNodeHeightCalculator;
import com.hello2morrow.sonargraph.core.controller.system.treemap.MessageCause;
import com.hello2morrow.sonargraph.core.controller.system.treemap.PhysicalComponentVisitor;
import com.hello2morrow.sonargraph.core.controller.system.treemap.PhysicalRecursiveElementInclusionCollector;
import com.hello2morrow.sonargraph.core.controller.system.treemap.PhysicalSourceFileVisitor;
import com.hello2morrow.sonargraph.core.controller.system.treemap.SizeIntMetricValueAccessor;
import com.hello2morrow.sonargraph.core.controller.system.treemap.SizeValueAccessor;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.DataEntry;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.IDataEntry;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.RecursiveDataEntry;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.SequenceAttribute;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.SizeDataEntry;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMap;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapData;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapGenerator;
import com.hello2morrow.sonargraph.core.foundation.common.treemap.TreeMapNode;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.analysis.ScriptMetricProvider;
import com.hello2morrow.sonargraph.core.model.common.IMetricLevel;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.PhysicalRecursiveElement;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.system.IMetricAccessor;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.treemap.ILeafInfoProvider;
import com.hello2morrow.sonargraph.core.model.treemap.IssueCollectorValueSource;
import com.hello2morrow.sonargraph.core.model.treemap.LeafNodeColor;
import com.hello2morrow.sonargraph.core.model.treemap.LeafNodeData;
import com.hello2morrow.sonargraph.core.model.treemap.MetricValueSource;
import com.hello2morrow.sonargraph.core.model.treemap.NoHeightValueSource;
import com.hello2morrow.sonargraph.core.model.treemap.NonLeafNodeData;
import com.hello2morrow.sonargraph.core.model.treemap.ScriptMetricValueSource;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapLeafElement;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapNodeData;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapProperties;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapRepresentation;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapType;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapValueSource;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TreeMapRepresentationCreator {
    private static Logger LOGGER = LoggerFactory.getLogger(TreeMapRepresentationCreator.class);

    private TreeMapRepresentationCreator() {
    }

    public static void updateScriptMetricValueSources(Installation installation, TreeMapProperties properties) {
        assert (installation != null) : "Parameter 'installation' of method 'updateScriptMetricValueSources' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'updateScriptMetricValueSources' must not be null";
        properties.clearScriptMetricValueColorSources();
        for (ScriptMetricProvider next : installation.getMetricProviders().getChildren(ScriptMetricProvider.class)) {
            for (IMetricDescriptor nextMetricDescriptor : next.getChildren(IMetricDescriptor.class)) {
                IMetricLevel nextLevel = nextMetricDescriptor.getLevel();
                if (nextLevel != CoreMetricLevel.COMPONENT && nextLevel != CoreMetricLevel.SOURCE_FILE) continue;
                properties.addScriptMetricValueColorSource(new ScriptMetricValueSource(nextMetricDescriptor));
            }
        }
    }

    private static void createMetricValueSource(Installation installation, TreeMapLeafElement leafElement, IMetricId metricId, Map<TreeMapLeafElement, List<TreeMapValueSource>> valueSources, IMetricLevel metricLevel, Map<IMetricDescriptor, MetricValueSource> descriptorToMetricValueSource) {
        assert (installation != null) : "Parameter 'installation' of method 'createMetricValueSource' must not be null";
        assert (leafElement != null) : "Parameter 'leafElement' of method 'createMetricValueSource' must not be null";
        assert (metricId != null) : "Parameter 'metricId' of method 'createMetricValueSource' must not be null";
        assert (valueSources != null) : "Parameter 'valueSources' of method 'createMetricValueSource' must not be null";
        assert (metricLevel != null) : "Parameter 'metricLevel' of method 'createMetricValueSource' must not be null";
        assert (descriptorToMetricValueSource != null) : "Parameter 'descriptorToMetricValueSource' of method 'createMetricValueSource' must not be null";
        block0: for (MetricProvider next : installation.getMetricProviders().getChildren(MetricProvider.class)) {
            if (next.getLanguage() != null) continue;
            for (IMetricDescriptor nextMetricDescriptor : next.getChildren(IMetricDescriptor.class)) {
                MetricValueSource nextMetricValueSource;
                if (nextMetricDescriptor.getMetricId() != metricId || nextMetricDescriptor.getLevel() != metricLevel) continue;
                List<TreeMapValueSource> nextValueSources = valueSources.get((Object)leafElement);
                if (nextValueSources == null) {
                    nextValueSources = new ArrayList<TreeMapValueSource>(5);
                    valueSources.put(leafElement, nextValueSources);
                }
                if ((nextMetricValueSource = descriptorToMetricValueSource.get(nextMetricDescriptor)) == null) {
                    nextMetricValueSource = new MetricValueSource(nextMetricDescriptor);
                    descriptorToMetricValueSource.put(nextMetricDescriptor, nextMetricValueSource);
                }
                nextValueSources.add(nextMetricValueSource);
                continue block0;
            }
        }
    }

    public static TreeMapProperties createDefaultProperties(Installation installation) {
        TreeMapLeafElement nextLeafElement;
        assert (installation != null) : "Parameter 'installation' of method 'createDefaultProperties' must not be null";
        THashMap descriptorToMetricValueSource = new THashMap();
        LinkedHashMap<TreeMapLeafElement, List<TreeMapValueSource>> sizeValueSources = new LinkedHashMap<TreeMapLeafElement, List<TreeMapValueSource>>();
        for (Map.Entry<TreeMapLeafElement, List<IMetricId>> nextEntry : SizeIntMetricValueAccessor.getSupportedSourceFileLevelMetricIds().entrySet()) {
            TreeMapLeafElement nextLeafElement2 = nextEntry.getKey();
            for (IMetricId iMetricId : nextEntry.getValue()) {
                TreeMapRepresentationCreator.createMetricValueSource(installation, nextLeafElement2, iMetricId, sizeValueSources, CoreMetricLevel.SOURCE_FILE, (Map<IMetricDescriptor, MetricValueSource>)descriptorToMetricValueSource);
            }
        }
        LinkedHashMap<TreeMapLeafElement, List<TreeMapValueSource>> colorValueSources = new LinkedHashMap<TreeMapLeafElement, List<TreeMapValueSource>>();
        LinkedHashMap<TreeMapLeafElement, List<TreeMapValueSource>> heightValueSources = new LinkedHashMap<TreeMapLeafElement, List<TreeMapValueSource>>();
        for (Map.Entry<TreeMapLeafElement, List<IMetricId>> nextEntry : ColorOrHeightFloatMetricValueAccessor.getSupportedSourceFileLevelMetricIds().entrySet()) {
            nextLeafElement = nextEntry.getKey();
            for (IMetricId iMetricId : nextEntry.getValue()) {
                TreeMapRepresentationCreator.createMetricValueSource(installation, nextLeafElement, iMetricId, colorValueSources, CoreMetricLevel.SOURCE_FILE, (Map<IMetricDescriptor, MetricValueSource>)descriptorToMetricValueSource);
                TreeMapRepresentationCreator.createMetricValueSource(installation, nextLeafElement, iMetricId, heightValueSources, CoreMetricLevel.SOURCE_FILE, (Map<IMetricDescriptor, MetricValueSource>)descriptorToMetricValueSource);
            }
        }
        for (Map.Entry<TreeMapLeafElement, List<IMetricId>> nextEntry : ColorOrHeightFloatMetricValueAccessor.getSupportedComponentLevelMetricIds().entrySet()) {
            nextLeafElement = nextEntry.getKey();
            for (IMetricId iMetricId : nextEntry.getValue()) {
                TreeMapRepresentationCreator.createMetricValueSource(installation, nextLeafElement, iMetricId, colorValueSources, CoreMetricLevel.COMPONENT, (Map<IMetricDescriptor, MetricValueSource>)descriptorToMetricValueSource);
                TreeMapRepresentationCreator.createMetricValueSource(installation, nextLeafElement, iMetricId, heightValueSources, CoreMetricLevel.COMPONENT, (Map<IMetricDescriptor, MetricValueSource>)descriptorToMetricValueSource);
            }
        }
        for (Map.Entry<TreeMapLeafElement, List<IMetricId>> nextEntry : ColorOrHeightIntMetricValueAccessor.getSupportedSourceFileLevelMetricIds().entrySet()) {
            nextLeafElement = nextEntry.getKey();
            for (IMetricId iMetricId : nextEntry.getValue()) {
                TreeMapRepresentationCreator.createMetricValueSource(installation, nextLeafElement, iMetricId, colorValueSources, CoreMetricLevel.SOURCE_FILE, (Map<IMetricDescriptor, MetricValueSource>)descriptorToMetricValueSource);
                TreeMapRepresentationCreator.createMetricValueSource(installation, nextLeafElement, iMetricId, heightValueSources, CoreMetricLevel.SOURCE_FILE, (Map<IMetricDescriptor, MetricValueSource>)descriptorToMetricValueSource);
            }
        }
        for (Map.Entry<TreeMapLeafElement, List<IMetricId>> nextEntry : ColorOrHeightIntMetricValueAccessor.getSupportedComponentLevelMetricIds().entrySet()) {
            nextLeafElement = nextEntry.getKey();
            for (IMetricId iMetricId : nextEntry.getValue()) {
                TreeMapRepresentationCreator.createMetricValueSource(installation, nextLeafElement, iMetricId, colorValueSources, CoreMetricLevel.COMPONENT, (Map<IMetricDescriptor, MetricValueSource>)descriptorToMetricValueSource);
                TreeMapRepresentationCreator.createMetricValueSource(installation, nextLeafElement, iMetricId, heightValueSources, CoreMetricLevel.COMPONENT, (Map<IMetricDescriptor, MetricValueSource>)descriptorToMetricValueSource);
            }
        }
        TreeMapValueSourceComparator treeMapValueSourceComparator = new TreeMapValueSourceComparator();
        IssueCollectorValueSource issueCollectorValueSource = new IssueCollectorValueSource();
        for (List nextColorValueSources : colorValueSources.values()) {
            Collections.sort(nextColorValueSources, treeMapValueSourceComparator);
            nextColorValueSources.add(0, issueCollectorValueSource);
        }
        NoHeightValueSource noHeightValueSource = new NoHeightValueSource();
        for (List list : heightValueSources.values()) {
            Collections.sort(list, treeMapValueSourceComparator);
            list.add(0, issueCollectorValueSource);
            list.add(0, noHeightValueSource);
        }
        return new TreeMapProperties(sizeValueSources, colorValueSources, heightValueSources, (TreeMapValueSource)((List)sizeValueSources.get((Object)TreeMapLeafElement.PHYSICAL_SOURCE_FILE)).get(0), (TreeMapValueSource)((List)colorValueSources.get((Object)TreeMapLeafElement.PHYSICAL_SOURCE_FILE)).get(0), noHeightValueSource, TreeMapLeafElement.PHYSICAL_SOURCE_FILE);
    }

    private static void collectDataBasedOnPhysicalComponent(IWorkerContext workerContext, List<Module> modules, final SizeValueAccessor sizeValueAccessor, final ColorOrHeightValueAccessor colorValueAccessor, final Map<NamedElement, ILeafInfoProvider> elementToColorInfoProvider, final ColorOrHeightValueAccessor heightValueAccessor, final Map<NamedElement, ILeafInfoProvider> elementToHeightInfoProvider, final TreeMapData data) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'collectDataBasedOnPhysicalComponent' must not be null";
        assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'collectDataBasedOnPhysicalComponent' must not be empty";
        assert (sizeValueAccessor != null) : "Parameter 'sizeValueAccessor' of method 'collectDataBasedOnPhysicalComponent' must not be null";
        assert (colorValueAccessor != null) : "Parameter 'colorValueAccessor' of method 'collectDataBasedOnPhysicalComponent' must not be null";
        assert (data != null) : "Parameter 'data' of method 'collectDataBasedOnPhysicalComponent' must not be null";
        assert (elementToColorInfoProvider != null) : "Parameter 'elementToColorInfoProvider' of method 'collectDataBasedOnPhysicalComponent' must not be null";
        PhysicalRecursiveElementInclusionCollector inclusionCollector = new PhysicalRecursiveElementInclusionCollector(IComponent.class);
        for (final Module next : modules) {
            next.accept(inclusionCollector);
            final Set<String> nextNames = inclusionCollector.consumeNames();
            PhysicalComponentVisitor visitor = new PhysicalComponentVisitor(new PhysicalComponentVisitor.IConsumer(){

                @Override
                public void consume(IComponent component) {
                    if (!$assertionsDisabled && component == null) {
                        throw new AssertionError((Object)"Parameter 'component' of method 'consume' must not be null");
                    }
                    if (component.isExcluded()) {
                        return;
                    }
                    int size = sizeValueAccessor.getSizeValue(component.getNamedElement());
                    if (size <= 0) {
                        return;
                    }
                    List<PhysicalRecursiveElement> parents = component.getNamedElement().getParents(PhysicalRecursiveElement.class, new Class[0]);
                    IDataEntry[] dataRecord = new IDataEntry[4];
                    dataRecord[0] = new DataEntry<Module>(next.getName(), next);
                    if (!parents.isEmpty()) {
                        Collections.reverse(parents);
                        ArrayList<String> names = new ArrayList<String>();
                        ArrayList<PhysicalRecursiveElement> underlying = new ArrayList<PhysicalRecursiveElement>();
                        for (PhysicalRecursiveElement next2 : parents) {
                            String nextName = next2.getName();
                            if (!nextNames.contains(nextName)) continue;
                            names.add(nextName);
                            underlying.add(next2);
                        }
                        dataRecord[1] = new RecursiveDataEntry<NamedElement>(names.toArray(new String[names.size()]), underlying.toArray(new NamedElement[underlying.size()]));
                    } else {
                        dataRecord[1] = new RecursiveDataEntry("None");
                    }
                    dataRecord[2] = new DataEntry<NamedElement>(component.getNamedElement().getName(), component.getNamedElement());
                    dataRecord[3] = new SizeDataEntry(size);
                    data.addDataRecord(dataRecord);
                    ILeafInfoProvider colorInfoProvider = colorValueAccessor.getInfoProvider(component.getNamedElement());
                    ILeafInfoProvider previousColorInfoProvider = elementToColorInfoProvider.put(component.getNamedElement(), colorInfoProvider);
                    if (!$assertionsDisabled && previousColorInfoProvider != null) {
                        throw new AssertionError((Object)"'previousColorInfoProvider' of method 'collectDataBasedOnPhysicalComponent' must  be null");
                    }
                    if (heightValueAccessor != null) {
                        if (!$assertionsDisabled && elementToHeightInfoProvider == null) {
                            throw new AssertionError((Object)"'elementToHeightValueProvider' of method 'collectDataBasedOnPhysicalComponent' must not be null");
                        }
                        ILeafInfoProvider heightInfoProvider = heightValueAccessor.getInfoProvider(component.getNamedElement());
                        ILeafInfoProvider previousHeightInfoProvider = elementToHeightInfoProvider.put(component.getNamedElement(), heightInfoProvider);
                        if (!$assertionsDisabled && previousHeightInfoProvider != null) {
                            throw new AssertionError((Object)"'previousColorInfoProvider' of method 'collectDataBasedOnPhysicalComponent' must  be null");
                        }
                    }
                }
            });
            next.accept(visitor);
        }
    }

    private static void collectDataBasedOnPhysicalSourceFile(IWorkerContext workerContext, List<Module> modules, final SizeValueAccessor sizeValueAccessor, final ColorOrHeightValueAccessor colorValueAccessor, final Map<NamedElement, ILeafInfoProvider> elementToColorInfoProvider, final ColorOrHeightValueAccessor heightValueAccessor, final Map<NamedElement, ILeafInfoProvider> elementToHeightInfoProvider, final TreeMapData data) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'collectDataBasedOnPhysicalSourceFile' must not be null";
        assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'collectDataBasedOnPhysicalSourceFile' must not be empty";
        assert (sizeValueAccessor != null) : "Parameter 'sizeValueAccessor' of method 'collectDataBasedOnPhysicalSourceFile' must not be null";
        assert (colorValueAccessor != null) : "Parameter 'colorValueAccessor' of method 'collectDataBasedOnPhysicalSourceFile' must not be null";
        assert (data != null) : "Parameter 'data' of method 'collectDataBasedOnPhysicalSourceFile' must not be null";
        assert (elementToColorInfoProvider != null) : "Parameter 'elementToColorInfoProvider' of method 'collectDataBasedOnPhysicalSourceFile' must not be null";
        PhysicalRecursiveElementInclusionCollector inclusionCollector = new PhysicalRecursiveElementInclusionCollector(SourceFile.class);
        for (final Module nextModule : modules) {
            nextModule.accept(inclusionCollector);
            final Set<String> nextNames = inclusionCollector.consumeNames();
            PhysicalSourceFileVisitor sourceFileVisitor = new PhysicalSourceFileVisitor(new PhysicalSourceFileVisitor.IConsumer(){

                @Override
                public void consume(SourceFile sourceFile) {
                    if (!$assertionsDisabled && sourceFile == null) {
                        throw new AssertionError((Object)"Parameter 'sourceFile' of method 'consume' must not be null");
                    }
                    if (sourceFile.isExcluded()) {
                        return;
                    }
                    int size = sizeValueAccessor.getSizeValue(sourceFile);
                    if (size <= 0) {
                        return;
                    }
                    List<PhysicalRecursiveElement> parents = sourceFile.getParents(PhysicalRecursiveElement.class, new Class[0]);
                    IDataEntry[] dataRecord = new IDataEntry[4];
                    dataRecord[0] = new DataEntry<Module>(nextModule.getName(), nextModule);
                    if (!parents.isEmpty()) {
                        Collections.reverse(parents);
                        ArrayList<String> names = new ArrayList<String>();
                        ArrayList<PhysicalRecursiveElement> underlying = new ArrayList<PhysicalRecursiveElement>();
                        for (PhysicalRecursiveElement next : parents) {
                            String nextName = next.getName();
                            if (!nextNames.contains(nextName)) continue;
                            names.add(nextName);
                            underlying.add(next);
                        }
                        dataRecord[1] = new RecursiveDataEntry<NamedElement>(names.toArray(new String[names.size()]), underlying.toArray(new NamedElement[underlying.size()]));
                    } else {
                        dataRecord[1] = new RecursiveDataEntry("None");
                    }
                    dataRecord[2] = new DataEntry<SourceFile>(sourceFile.getIdentifyingPath(), sourceFile);
                    dataRecord[3] = new SizeDataEntry(size);
                    data.addDataRecord(dataRecord);
                    ILeafInfoProvider colorInfoProvider = colorValueAccessor.getInfoProvider(sourceFile);
                    ILeafInfoProvider previousColorInfoProvider = elementToColorInfoProvider.put(sourceFile, colorInfoProvider);
                    if (!$assertionsDisabled && previousColorInfoProvider != null) {
                        throw new AssertionError((Object)"'previousColorInfoProvider' of method 'collectDataBasedOnPhysicalSourceFile' must  be null");
                    }
                    if (heightValueAccessor != null) {
                        if (!$assertionsDisabled && elementToHeightInfoProvider == null) {
                            throw new AssertionError((Object)"'elementToHeightValueProvider' of method 'collectDataBasedOnPhysicalSourceFile' must not be null");
                        }
                        ILeafInfoProvider heightInfoProvider = heightValueAccessor.getInfoProvider(sourceFile);
                        ILeafInfoProvider previousHeightInfoProvider = elementToHeightInfoProvider.put(sourceFile, heightInfoProvider);
                        if (!$assertionsDisabled && previousHeightInfoProvider != null) {
                            throw new AssertionError((Object)"'previousColorInfoProvider' of method 'collectDataBasedOnPhysicalSourceFile' must  be null");
                        }
                    }
                }
            });
            nextModule.accept(sourceFileVisitor);
        }
    }

    private static List<SequenceAttribute> getSequence(TreeMapLeafElement leafElement) {
        assert (leafElement != null) : "Parameter 'leafElement' of method 'getSequence' must not be null";
        ArrayList<SequenceAttribute> sequence = new ArrayList<SequenceAttribute>();
        switch (leafElement) {
            case PHYSICAL_COMPONENT: {
                sequence.add(new SequenceAttribute("Module"));
                sequence.add(new SequenceAttribute("Physical Recursive Element", true));
                sequence.add(new SequenceAttribute("Component"));
                break;
            }
            case PHYSICAL_SOURCE_FILE: {
                sequence.add(new SequenceAttribute("Module"));
                sequence.add(new SequenceAttribute("Physical Recursive Element", true));
                sequence.add(new SequenceAttribute("Source File"));
                break;
            }
            default: {
                assert (false) : "Unhandled leaf element: " + String.valueOf((Object)leafElement);
                break;
            }
        }
        sequence.trimToSize();
        return sequence;
    }

    private static SizeValueAccessor getSizeValueAccessor(Installation installation, SoftwareSystem system, TreeMapValueSource valueSource, TreeMapLeafElement leafElement) {
        assert (installation != null) : "Parameter 'installation' of method 'getSizeValueAccessor' must not be null";
        assert (system != null) : "Parameter 'system' of method 'getSizeValueAccessor' must not be null";
        assert (valueSource != null) : "Parameter 'valueSource' of method 'getSizeValueAccessor' must not be null";
        assert (leafElement != null) : "Parameter 'leafElement' of method 'getSizeValueAccessor' must not be null";
        if (valueSource instanceof MetricValueSource) {
            IMetricAccessor metricAccessor = installation.getExtension(IMetricAccessor.class);
            return new SizeIntMetricValueAccessor(metricAccessor, system, ((MetricValueSource)valueSource).getMetricDescriptor(), leafElement);
        }
        assert (false) : "Unhandled size value source: " + String.valueOf(valueSource);
        return null;
    }

    private static ColorOrHeightValueAccessor getColorOrHeightValueAccessor(Installation installation, SoftwareSystem system, TreeMapValueSource valueSource, TreeMapLeafElement leafElement) {
        assert (installation != null) : "Parameter 'installation' of method 'getColorValueAccessor' must not be null";
        assert (system != null) : "Parameter 'system' of method 'getColorValueAccessor' must not be null";
        assert (valueSource != null) : "Parameter 'valueSource' of method 'getColorValueAccessor' must not be null";
        assert (leafElement != null) : "Parameter 'leafElement' of method 'getColorValueAccessor' must not be null";
        LOGGER.debug("Create color or height value accessor for: " + String.valueOf(valueSource));
        if (valueSource instanceof MetricValueSource) {
            IMetricAccessor metricAccessor = installation.getExtension(IMetricAccessor.class);
            IMetricDescriptor metricDescriptor = ((MetricValueSource)valueSource).getMetricDescriptor();
            if (metricDescriptor.getMetricId().isFloat()) {
                return new ColorOrHeightFloatMetricValueAccessor(metricAccessor, system, metricDescriptor, leafElement);
            }
            return new ColorOrHeightIntMetricValueAccessor(metricAccessor, system, metricDescriptor, leafElement);
        }
        if (valueSource instanceof ScriptMetricValueSource) {
            return new ColorOrHeightFloatOrIntScriptMetricValueAccessor(installation, system, (ScriptMetricValueSource)valueSource);
        }
        if (valueSource instanceof IssueCollectorValueSource) {
            return new IssueCollectorIntValueAccessor((IssueCollectorValueSource)valueSource, system.getExtension(IIssueParticipationProvider.class));
        }
        assert (false) : "Unhandled color or height value source: " + String.valueOf(valueSource);
        return null;
    }

    public static TreeMapRepresentation create(IWorkerContext workerContext, Installation installation, SoftwareSystem system, List<Module> modules, NamedElement parent, TreeMapProperties properties, OperationResult result) {
        TreeMapType type;
        ColorOrHeightValueAccessor heightValueAccessor;
        THashMap elementToHeightInfoProvider;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'create' must not be null";
        assert (installation != null) : "Parameter 'installation' of method 'create' must not be null";
        assert (system != null) : "Parameter 'system' of method 'create' must not be null";
        assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'create' must not be empty";
        assert (parent != null) : "Parameter 'parent' of method 'create' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'create' must not be null";
        assert (result != null) : "Parameter 'result' of method 'create' must not be null";
        LOGGER.debug("Create treemap representation");
        ValidationResult validationResult = properties.isValid();
        if (!validationResult.isSuccess()) {
            result.addError((OperationResult.IMessageCause)MessageCause.TREEMAP_PROPERTIES_NOT_VALID, validationResult.toFormattedString(), new Object[0]);
            return null;
        }
        TreeMapLeafElement leafElement = properties.getLeafElement();
        workerContext.working("Collect data for '" + leafElement.getPresentationName() + "'", true);
        THashMap elementToColorInfoProvider = new THashMap();
        final SizeValueAccessor sizeValueAccessor = TreeMapRepresentationCreator.getSizeValueAccessor(installation, system, properties.getSizeSource(), leafElement);
        ColorOrHeightValueAccessor colorValueAccessor = TreeMapRepresentationCreator.getColorOrHeightValueAccessor(installation, system, properties.getColorSource(), leafElement);
        TreeMapValueSource heightValueSource = properties.getHeightSource();
        if (!(heightValueSource instanceof NoHeightValueSource)) {
            elementToHeightInfoProvider = new THashMap();
            heightValueAccessor = TreeMapRepresentationCreator.getColorOrHeightValueAccessor(installation, system, heightValueSource, leafElement);
            type = TreeMapType.THREE_DIMENSIONAL;
        } else {
            elementToHeightInfoProvider = null;
            heightValueAccessor = null;
            type = TreeMapType.TWO_DIMENSIONAL;
        }
        List<SequenceAttribute> sequence = TreeMapRepresentationCreator.getSequence(leafElement);
        TreeMapData data = new TreeMapData(sequence, sizeValueAccessor.getSizeAttribute());
        switch (leafElement) {
            case PHYSICAL_COMPONENT: {
                TreeMapRepresentationCreator.collectDataBasedOnPhysicalComponent(workerContext, modules, sizeValueAccessor, colorValueAccessor, (Map<NamedElement, ILeafInfoProvider>)elementToColorInfoProvider, heightValueAccessor, (Map<NamedElement, ILeafInfoProvider>)elementToHeightInfoProvider, data);
                break;
            }
            case PHYSICAL_SOURCE_FILE: {
                TreeMapRepresentationCreator.collectDataBasedOnPhysicalSourceFile(workerContext, modules, sizeValueAccessor, colorValueAccessor, (Map<NamedElement, ILeafInfoProvider>)elementToColorInfoProvider, heightValueAccessor, (Map<NamedElement, ILeafInfoProvider>)elementToHeightInfoProvider, data);
                break;
            }
            default: {
                assert (false) : "Unhandled leaf element: " + String.valueOf((Object)leafElement);
                break;
            }
        }
        if (!data.hasDataRecords()) {
            result.addError((OperationResult.IMessageCause)MessageCause.UNABLE_TO_CREATE_TREEMAP, "No leaf elements found.", new Object[0]);
            return null;
        }
        workerContext.working("Create treemap", true);
        int redThreshold = LeafNodeColorCalculator.getRedThreshold(properties.getRedThreshold(), colorValueAccessor.getValueRange());
        TreeMapGenerator<NamedElement, TreeMapNodeData> generator = new TreeMapGenerator<NamedElement, TreeMapNodeData>();
        TreeMap<NamedElement, TreeMapNodeData> treeMap = generator.generate(system.getName(), system, data, sequence, sizeValueAccessor.getSizeAttribute(), workerContext, new TreeMapGenerator.INodeCreationListener<NamedElement, TreeMapNodeData>((Map)elementToHeightInfoProvider, (Map)elementToColorInfoProvider, colorValueAccessor, redThreshold, heightValueAccessor){
            private final /* synthetic */ Map val$elementToHeightInfoProvider;
            private final /* synthetic */ Map val$elementToColorInfoProvider;
            private final /* synthetic */ ColorOrHeightValueAccessor val$colorValueAccessor;
            private final /* synthetic */ int val$redThreshold;
            private final /* synthetic */ ColorOrHeightValueAccessor val$heightValueAccessor;
            {
                this.val$elementToHeightInfoProvider = map;
                this.val$elementToColorInfoProvider = map2;
                this.val$colorValueAccessor = colorOrHeightValueAccessor;
                this.val$redThreshold = n;
                this.val$heightValueAccessor = colorOrHeightValueAccessor2;
            }

            @Override
            public void nonLeafNodeCreated(TreeMapNode<NamedElement, TreeMapNodeData> node) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'nonLeafNodeCreated' must not be null");
                }
                node.setAssociatedData(new NonLeafNodeData(sizeValueAccessor.getSizeInfoProvider(), this.val$elementToHeightInfoProvider != null ? node.getLevel() * 2 : -1));
            }

            @Override
            public void leafNodeCreated(TreeMapNode<NamedElement, TreeMapNodeData> node) {
                int normalizedHeight;
                ILeafInfoProvider heightInfoProvider;
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'leafNodeCreated' must not be null");
                }
                NamedElement associatedElement = node.getAssociatedElement();
                ILeafInfoProvider colorInfoProvider = (ILeafInfoProvider)this.val$elementToColorInfoProvider.get(associatedElement);
                if (!$assertionsDisabled && colorInfoProvider == null) {
                    throw new AssertionError((Object)"'colorInfoProvider' of method 'leafNodeCreated' must not be null");
                }
                LeafNodeColor color = LeafNodeColorCalculator.calculate(this.val$colorValueAccessor.getValueRange(), colorInfoProvider.getValue(), this.val$redThreshold);
                if (this.val$elementToHeightInfoProvider != null) {
                    if (!$assertionsDisabled && this.val$heightValueAccessor == null) {
                        throw new AssertionError((Object)"'heightValueAccessor' of method 'leafNodeCreated' must not be null");
                    }
                    heightInfoProvider = (ILeafInfoProvider)this.val$elementToHeightInfoProvider.get(associatedElement);
                    if (!$assertionsDisabled && heightInfoProvider == null) {
                        throw new AssertionError((Object)"'heightInfoProvider' of method 'create' must not be null");
                    }
                    normalizedHeight = LeafNodeHeightCalculator.calculate(this.val$heightValueAccessor.getValueRange(), heightInfoProvider.getValue());
                } else {
                    heightInfoProvider = null;
                    normalizedHeight = -1;
                }
                node.setAssociatedData(new LeafNodeData(sizeValueAccessor.getSizeInfoProvider(), colorInfoProvider, color, heightInfoProvider, normalizedHeight));
            }
        });
        TreeMapRepresentation.Info info = new TreeMapRepresentation.Info(properties.getLeafElement().getPresentationName(), properties.getSizeSource().getPresentationName(), properties.getColorSource().getPresentationName(), heightValueAccessor != null ? properties.getHeightSource().getPresentationName() : null);
        TreeMapRepresentation representation = new TreeMapRepresentation(parent, modules, treeMap, type, info);
        parent.addChild(representation);
        LOGGER.debug("Create treemap representation - done");
        return representation;
    }

    public static void updateLeafInfo(Installation installation, SoftwareSystem system, TreeMapProperties properties, TreeMapRepresentation representation) {
        ColorOrHeightValueAccessor heightValueAccessor;
        THashMap elementToHeightInfoProvider;
        assert (installation != null) : "Parameter 'installation' of method 'updateLeafInfo' must not be null";
        assert (system != null) : "Parameter 'system' of method 'updateLeafInfo' must not be null";
        assert (properties != null) : "Parameter 'properties' of method 'updateLeafInfo' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'updateLeafInfo' must not be null";
        LOGGER.debug("Update leaf info");
        THashMap elementToColorInfoProvider = new THashMap();
        final ColorOrHeightValueAccessor colorValueAccessor = TreeMapRepresentationCreator.getColorOrHeightValueAccessor(installation, system, properties.getColorSource(), properties.getLeafElement());
        TreeMapValueSource heightValueSource = properties.getHeightSource();
        if (!(heightValueSource instanceof NoHeightValueSource)) {
            elementToHeightInfoProvider = new THashMap();
            heightValueAccessor = TreeMapRepresentationCreator.getColorOrHeightValueAccessor(installation, system, heightValueSource, properties.getLeafElement());
        } else {
            elementToHeightInfoProvider = null;
            heightValueAccessor = null;
        }
        representation.getTreeMapNode().accept(new TreeMapNode.IVisitor<NamedElement, TreeMapNodeData>((Map)elementToColorInfoProvider, heightValueAccessor, (Map)elementToHeightInfoProvider){
            private final /* synthetic */ Map val$elementToColorInfoProvider;
            private final /* synthetic */ ColorOrHeightValueAccessor val$heightValueAccessor;
            private final /* synthetic */ Map val$elementToHeightInfoProvider;
            {
                this.val$elementToColorInfoProvider = map;
                this.val$heightValueAccessor = colorOrHeightValueAccessor2;
                this.val$elementToHeightInfoProvider = map2;
            }

            @Override
            public boolean visitNode(TreeMapNode<NamedElement, TreeMapNodeData> node) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'process' must not be null");
                }
                if (node.isLeaf()) {
                    ILeafInfoProvider colorInfoProvider = colorValueAccessor.getInfoProvider(node.getAssociatedElement());
                    ILeafInfoProvider previousColorInfoProvider = this.val$elementToColorInfoProvider.put(node.getAssociatedElement(), colorInfoProvider);
                    if (!$assertionsDisabled && previousColorInfoProvider != null) {
                        throw new AssertionError((Object)"'previousColorInfoProvider' of method 'updateLeafInfo' must  be null");
                    }
                    if (this.val$heightValueAccessor != null) {
                        if (!$assertionsDisabled && this.val$elementToHeightInfoProvider == null) {
                            throw new AssertionError((Object)"'elementToHeightInfoProvider' of method 'updateLeafInfo' must not be null");
                        }
                        ILeafInfoProvider heightInfoProvider = this.val$heightValueAccessor.getInfoProvider(node.getAssociatedElement());
                        ILeafInfoProvider previousHeightInfoProvider = this.val$elementToHeightInfoProvider.put(node.getAssociatedElement(), heightInfoProvider);
                        if (!$assertionsDisabled && previousHeightInfoProvider != null) {
                            throw new AssertionError((Object)"'previousHeightInfoProvider' of method 'updateLeafInfo' must  be null");
                        }
                    }
                }
                return true;
            }
        });
        int redThreshold = LeafNodeColorCalculator.getRedThreshold(properties.getRedThreshold(), colorValueAccessor.getValueRange());
        representation.getTreeMapNode().accept(new TreeMapNode.IVisitor<NamedElement, TreeMapNodeData>((Map)elementToColorInfoProvider, colorValueAccessor, redThreshold, (Map)elementToHeightInfoProvider, heightValueAccessor){
            private final /* synthetic */ Map val$elementToColorInfoProvider;
            private final /* synthetic */ ColorOrHeightValueAccessor val$colorValueAccessor;
            private final /* synthetic */ int val$redThreshold;
            private final /* synthetic */ Map val$elementToHeightInfoProvider;
            private final /* synthetic */ ColorOrHeightValueAccessor val$heightValueAccessor;
            {
                this.val$elementToColorInfoProvider = map;
                this.val$colorValueAccessor = colorOrHeightValueAccessor;
                this.val$redThreshold = n;
                this.val$elementToHeightInfoProvider = map2;
                this.val$heightValueAccessor = colorOrHeightValueAccessor2;
            }

            @Override
            public boolean visitNode(TreeMapNode<NamedElement, TreeMapNodeData> node) {
                if (!$assertionsDisabled && node == null) {
                    throw new AssertionError((Object)"Parameter 'node' of method 'process' must not be null");
                }
                if (node.isLeaf()) {
                    int normalizedHeight;
                    ILeafInfoProvider heightInfoProvider;
                    NamedElement associatedElement = node.getAssociatedElement();
                    if (!$assertionsDisabled && associatedElement == null) {
                        throw new AssertionError((Object)"'associatedElement' of method 'updateLeafInfo' must not be null");
                    }
                    TreeMapNodeData data = node.getAssociatedData();
                    if (!$assertionsDisabled && data == null) {
                        throw new AssertionError((Object)"'data' of method 'updateLeafInfo' must not be null");
                    }
                    ILeafInfoProvider colorInfoProvider = (ILeafInfoProvider)this.val$elementToColorInfoProvider.get(associatedElement);
                    if (!$assertionsDisabled && colorInfoProvider == null) {
                        throw new AssertionError((Object)"'colorInfoProvider' of method 'updateLeafInfo' must not be null");
                    }
                    LeafNodeColor color = LeafNodeColorCalculator.calculate(this.val$colorValueAccessor.getValueRange(), colorInfoProvider.getValue(), this.val$redThreshold);
                    if (this.val$elementToHeightInfoProvider != null) {
                        if (!$assertionsDisabled && this.val$heightValueAccessor == null) {
                            throw new AssertionError((Object)"'heightValueAccessor' of method 'visitNode' must not be null");
                        }
                        heightInfoProvider = (ILeafInfoProvider)this.val$elementToHeightInfoProvider.get(associatedElement);
                        if (!$assertionsDisabled && heightInfoProvider == null) {
                            throw new AssertionError((Object)"'heightInfoProvider' of method 'updateLeafInfo' must not be null");
                        }
                        normalizedHeight = LeafNodeHeightCalculator.calculate(this.val$heightValueAccessor.getValueRange(), heightInfoProvider.getValue());
                    } else {
                        heightInfoProvider = null;
                        normalizedHeight = -1;
                    }
                    data.updateLeafInfo(colorInfoProvider, color, heightInfoProvider, normalizedHeight);
                }
                return true;
            }
        });
        LOGGER.debug("Update leaf info - done");
    }

    private static final class TreeMapValueSourceComparator
    implements Comparator<TreeMapValueSource> {
        private TreeMapValueSourceComparator() {
        }

        @Override
        public int compare(TreeMapValueSource s1, TreeMapValueSource s2) {
            assert (s1 != null) : "Parameter 's1' of method 'compare' must not be null";
            assert (s2 != null) : "Parameter 's2' of method 'compare' must not be null";
            if (s1 == s2) {
                return 0;
            }
            return s1.getPresentationName().compareTo(s2.getPresentationName());
        }
    }
}

