/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.treemap;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.treemap.ILeafColorInfoProvider;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Locale;

final class FloatMetricBasedColorProvider
implements ILeafColorInfoProvider {
    private static final DecimalFormat FORMAT = (DecimalFormat)DecimalFormat.getInstance(Locale.getDefault());
    private final IMetricId m_metricId;
    private final Float m_value;

    static {
        FORMAT.setRoundingMode(RoundingMode.HALF_UP);
    }

    FloatMetricBasedColorProvider(IMetricId metricId, Float value) {
        assert (metricId != null) : "Parameter 'metricId' of method 'FloatMetricBasedColorProvider' must not be null";
        assert (value != null) : "Parameter 'value' of method 'FloatMetricBasedColorProvider' must not be null";
        assert (value.intValue() >= 0) : "'value' most not be negative";
        this.m_metricId = metricId;
        this.m_value = value;
    }

    @Override
    public String getInformation() {
        return this.m_metricId.getPresentationName() + ": " + FORMAT.format(NumberUtility.round((double)this.m_value.floatValue(), (int)100));
    }

    @Override
    public int getColorValue() {
        return this.m_value.intValue();
    }
}

