/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.script;

import com.hello2morrow.sonargraph.api.Aggregator;
import com.hello2morrow.sonargraph.core.model.common.AutoCompletionProposal;
import com.hello2morrow.sonargraph.core.model.element.ClosureParameterType;
import com.hello2morrow.sonargraph.core.model.script.IScriptApi;
import com.hello2morrow.sonargraph.core.model.script.ScriptAutoCompletionProposal;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import gnu.trove.set.hash.THashSet;
import groovy.lang.Script;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScriptAutoCompletionProposalsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptAutoCompletionProposalsCollector.class);
    private static final char DOT = '.';
    private static final char EQUALS = '=';
    private static final char BLANK = ' ';
    private static final char TAB = '\t';
    private static final char BACKSLASH_N = '\n';
    private static final char BACKSLASH_R = '\r';
    private static final char OPENING_BRACE = '(';
    private static final char CLOSING_BRACE = ')';
    private static final char[] ALL_DELIMITERS_VARIABLE_DETECTION = new char[]{'.', '\n', '\r', '=', ' ', '\t', '(', ')', '!', '&', '|', ',', ';', '{', '}'};
    private static final Set<String> ALL_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION;
    private static final Set<String> BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION;
    private static final Set<String> NON_BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION;
    private static final Set<String> NATIVE_DATA_TYPES;
    private static final Map<String, ClassInfo> SPECIAL_CLASSES;
    private static final String OPENING_BRACE_AS_STRING;
    private static final String CLOSING_BRACE_AS_STRING;
    private static final String TAB_AS_STRING;
    private static final String BLANK_AS_STRING;
    private static final String BACKSLASH_N_AS_STRING;
    private static final String BACKSLASH_R_AS_STRING;
    private static final String DOT_AS_STRING;
    private static final String EQUALS_AS_STRING;
    private static final String IN_AS_STRING = "in";
    private static final String ARROW_AS_STRING = "->";
    private Map<String, ClassInfo> m_variables;
    private List<String> m_tokens;
    private IScriptApi m_scriptApi;
    private ClassLoader m_classLoader;
    private int m_offset;

    static {
        OPENING_BRACE_AS_STRING = String.valueOf('(');
        CLOSING_BRACE_AS_STRING = String.valueOf(')');
        TAB_AS_STRING = String.valueOf('\t');
        BLANK_AS_STRING = String.valueOf(' ');
        BACKSLASH_N_AS_STRING = String.valueOf('\n');
        BACKSLASH_R_AS_STRING = String.valueOf('\r');
        DOT_AS_STRING = String.valueOf('.');
        EQUALS_AS_STRING = String.valueOf('=');
        NON_BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION = new THashSet(2);
        NON_BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION.add(String.valueOf(' '));
        NON_BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION.add(String.valueOf('\t'));
        ALL_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION = new THashSet(ALL_DELIMITERS_VARIABLE_DETECTION.length);
        BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION = new THashSet(ALL_DELIMITERS_VARIABLE_DETECTION.length);
        char[] cArray = ALL_DELIMITERS_VARIABLE_DETECTION;
        int n = ALL_DELIMITERS_VARIABLE_DETECTION.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            String nextAsString = String.valueOf(c);
            ALL_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION.add(nextAsString);
            if (!NON_BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION.contains(nextAsString)) {
                BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION.add(nextAsString);
            }
            ++n2;
        }
        NATIVE_DATA_TYPES = new THashSet(8);
        NATIVE_DATA_TYPES.add("byte");
        NATIVE_DATA_TYPES.add("short");
        NATIVE_DATA_TYPES.add("int");
        NATIVE_DATA_TYPES.add("long");
        NATIVE_DATA_TYPES.add("float");
        NATIVE_DATA_TYPES.add("double");
        NATIVE_DATA_TYPES.add("boolean");
        NATIVE_DATA_TYPES.add("char");
        SPECIAL_CLASSES = new TreeMap<String, ClassInfo>();
        SPECIAL_CLASSES.put("Byte", new ClassInfo("Byte", Byte.class));
        SPECIAL_CLASSES.put("Short", new ClassInfo("Short", Short.class));
        SPECIAL_CLASSES.put("Integer", new ClassInfo("Integer", Integer.class));
        SPECIAL_CLASSES.put("Long", new ClassInfo("Long", Long.class));
        SPECIAL_CLASSES.put("Float", new ClassInfo("Float", Float.class));
        SPECIAL_CLASSES.put("Double", new ClassInfo("Double", Double.class));
        SPECIAL_CLASSES.put("Boolean", new ClassInfo("Boolean", Boolean.class));
        SPECIAL_CLASSES.put("String", new ClassInfo("String", String.class));
        SPECIAL_CLASSES.put("Enum", new ClassInfo("Enum", Enum.class));
        SPECIAL_CLASSES.put("Collections", new ClassInfo("Collections", Collections.class));
        SPECIAL_CLASSES.put("Aggregator", new ClassInfo("Aggregator", Aggregator.class));
    }

    private ScriptAutoCompletionProposalsCollector() {
    }

    private Class<?> getClass(ClassLoader classLoader, String name) {
        assert (classLoader != null) : "Parameter 'classLoader' of method 'getClass' must not be null";
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'getClass' must not be empty";
        try {
            return classLoader.loadClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private ClassInfo detectVariableClass(int pos) {
        assert (this.m_tokens != null) : "'m_tokens' of method 'detectVariableClass' must not be null";
        assert (this.m_scriptApi != null) : "'m_scriptApi' of method 'detectVariableClass' must not be null";
        assert (this.m_classLoader != null) : "'m_classLoader' of method 'detectVariableClass' must not be null";
        String lhs = null;
        int i = pos - 1;
        while (i >= 0) {
            String nextPreviousToken = this.m_tokens.get(i);
            if (BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION.contains(nextPreviousToken)) break;
            if (!NON_BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION.contains(nextPreviousToken)) {
                lhs = nextPreviousToken;
                break;
            }
            --i;
        }
        ClassInfo classInfo = null;
        if (lhs != null) {
            if (NATIVE_DATA_TYPES.contains(lhs)) {
                classInfo = new ClassInfo(lhs, null);
            } else {
                String checkClass = lhs;
                int posOfTemplateChar = lhs.indexOf(60);
                if (posOfTemplateChar != -1) {
                    checkClass = lhs.substring(0, posOfTemplateChar);
                }
                if (checkClass != null && !checkClass.isEmpty()) {
                    Class<?> clazz = this.getClass(this.m_classLoader, checkClass);
                    if (clazz == null) {
                        for (String next : this.m_scriptApi.getImports()) {
                            if (next.endsWith("." + checkClass) && (clazz = this.getClass(this.m_classLoader, next)) != null) break;
                        }
                        if (clazz == null) {
                            for (String next : this.m_scriptApi.getStarImports()) {
                                clazz = this.getClass(this.m_classLoader, next + "." + checkClass);
                                if (clazz != null) break;
                            }
                        }
                    }
                    if (clazz != null) {
                        classInfo = new ClassInfo(clazz.getSimpleName(), clazz);
                    }
                }
            }
        }
        return classInfo;
    }

    private void addVariablesAndToplevelMethods(Script script, int offset, List<AutoCompletionProposal> proposals) {
        block12: {
            String presentationProposal;
            String nextVariable;
            Method next;
            String startsWith;
            block11: {
                String lastToken;
                assert (offset >= 0) : "'offset' must not be negative";
                assert (proposals != null) : "Parameter 'proposals' of method 'addVariables' must not be null";
                LOGGER.debug("Add variables");
                startsWith = "";
                if (!this.m_tokens.isEmpty() && this.isJavaIdentifier(lastToken = this.m_tokens.get(this.m_tokens.size() - 1))) {
                    startsWith = lastToken;
                }
                if (!startsWith.isEmpty()) break block11;
                for (Map.Entry<String, ClassInfo> nextEntry : this.m_variables.entrySet()) {
                    String nextVariable2 = nextEntry.getKey();
                    proposals.add(new ScriptAutoCompletionProposal(nextVariable2 + " : " + nextEntry.getValue().getName(), nextVariable2, offset, 0, 0, ScriptAutoCompletionProposal.Type.VARIABLE));
                }
                if (script == null) break block12;
                Method[] methodArray = script.getClass().getMethods();
                int nextVariable2 = methodArray.length;
                int n = 0;
                while (n < nextVariable2) {
                    next = methodArray[n];
                    if (next.getName().startsWith("println")) {
                        proposals.add(this.createProposal(next, this.m_offset, 0));
                    }
                    ++n;
                }
                break block12;
            }
            for (Map.Entry<String, ClassInfo> nextEntry : this.m_variables.entrySet()) {
                nextVariable = nextEntry.getKey();
                if (!nextVariable.startsWith(startsWith)) continue;
                presentationProposal = nextVariable + " : " + nextEntry.getValue().getName();
                proposals.add(new ScriptAutoCompletionProposal(presentationProposal, nextVariable, offset - startsWith.length(), startsWith.length(), 0, ScriptAutoCompletionProposal.Type.VARIABLE));
            }
            for (Map.Entry<String, ClassInfo> nextEntry : SPECIAL_CLASSES.entrySet()) {
                nextVariable = nextEntry.getKey();
                if (!nextVariable.startsWith(startsWith)) continue;
                presentationProposal = nextVariable + " : " + nextEntry.getValue().getName();
                proposals.add(new ScriptAutoCompletionProposal(presentationProposal, nextVariable, offset - startsWith.length(), startsWith.length(), 0, ScriptAutoCompletionProposal.Type.VARIABLE));
            }
            if (script != null) {
                Method[] methodArray = script.getClass().getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    next = methodArray[n2];
                    if (next.getName().startsWith("println") && next.getName().startsWith(startsWith)) {
                        proposals.add(this.createProposal(next, this.m_offset - startsWith.length(), startsWith.length()));
                    }
                    ++n2;
                }
            }
        }
    }

    private ScriptAutoCompletionProposal createProposal(Field field, int offset, int length) {
        assert (field != null) : "Parameter 'field' of method 'createProposal' must not be null";
        Class<?> nextType = field.getType();
        return new ScriptAutoCompletionProposal(field.getName() + (String)(nextType != null ? " : " + nextType.getSimpleName() : ""), field.getName(), offset, length, 0, ScriptAutoCompletionProposal.Type.FIELD);
    }

    private ScriptAutoCompletionProposal createProposal(Method method, int offset, int length) {
        String proposal;
        assert (method != null) : "Parameter 'method' of method 'createProposal' must not be null";
        Class<?> returnType = method.getReturnType();
        StringBuilder builder = new StringBuilder(method.getName());
        builder.append("(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 0) {
            Class<?>[] classArray = parameterTypes;
            int n = parameterTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> nextParameterClazz = classArray[n2];
                builder.append(nextParameterClazz.getSimpleName()).append(",");
                ++n2;
            }
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(")");
        if (parameterTypes.length == 1 && parameterTypes[0].getSimpleName().equals("Closure")) {
            StringBuilder closureBuilder = new StringBuilder();
            closureBuilder.append(method.getName()).append("\n{\n");
            ClosureParameterType closureParameterType = method.getAnnotation(ClosureParameterType.class);
            if (closureParameterType != null) {
                String parameterType = closureParameterType.parameterType().getSimpleName();
                closureBuilder.append("    ").append(parameterType).append(" next").append(parameterType).append(" -> \n");
                closureBuilder.append("    ").append("    ").append("println(next").append(parameterType).append(")\n");
            }
            closureBuilder.append("}");
            proposal = closureBuilder.toString();
        } else {
            proposal = builder.toString();
        }
        if (returnType != null) {
            builder.append(" : ").append(returnType.getSimpleName());
        }
        return new ScriptAutoCompletionProposal(builder.toString(), proposal, offset, length, 0, ScriptAutoCompletionProposal.Type.METHOD);
    }

    private void collectQualifiedProposals(Class<?> clazz, List<String> tokens, List<AutoCompletionProposal> proposals) {
        assert (clazz != null) : "Parameter 'clazz' of method 'collectQualifiedProposals' must not be null";
        assert (tokens != null) : "Parameter 'tokens' of method 'collectQualifiedProposals' must not be null";
        assert (proposals != null) : "Parameter 'proposals' of method 'collectQualifiedProposals' must not be null";
        if (tokens.isEmpty()) {
            AccessibleObject next;
            AccessibleObject[] accessibleObjectArray = clazz.getFields();
            int n = accessibleObjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                next = accessibleObjectArray[n2];
                proposals.add(this.createProposal((Field)next, this.m_offset, 0));
                ++n2;
            }
            accessibleObjectArray = clazz.getMethods();
            n = accessibleObjectArray.length;
            n2 = 0;
            while (n2 < n) {
                next = accessibleObjectArray[n2];
                proposals.add(this.createProposal((Method)next, this.m_offset, 0));
                ++n2;
            }
        } else {
            String nextToken = tokens.remove(0);
            if (this.isJavaIdentifier(nextToken)) {
                if (tokens.isEmpty()) {
                    AccessibleObject next;
                    AccessibleObject[] accessibleObjectArray = clazz.getFields();
                    int n = accessibleObjectArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        next = accessibleObjectArray[n3];
                        if (((Field)next).getName().startsWith(nextToken)) {
                            proposals.add(this.createProposal((Field)next, this.m_offset - nextToken.length(), nextToken.length()));
                        }
                        ++n3;
                    }
                    accessibleObjectArray = clazz.getMethods();
                    n = accessibleObjectArray.length;
                    n3 = 0;
                    while (n3 < n) {
                        next = accessibleObjectArray[n3];
                        if (((Method)next).getName().startsWith(nextToken)) {
                            proposals.add(this.createProposal((Method)next, this.m_offset - nextToken.length(), nextToken.length()));
                        }
                        ++n3;
                    }
                } else {
                    AccessibleObject next;
                    LOGGER.debug(nextToken);
                    Class<?> nextClazz = null;
                    AccessibleObject[] accessibleObjectArray = clazz.getFields();
                    int n = accessibleObjectArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        next = accessibleObjectArray[n4];
                        if (((Field)next).getName().startsWith(nextToken)) {
                            nextClazz = next.getClass();
                            break;
                        }
                        ++n4;
                    }
                    if (nextClazz == null) {
                        accessibleObjectArray = clazz.getMethods();
                        n = accessibleObjectArray.length;
                        n4 = 0;
                        while (n4 < n) {
                            next = accessibleObjectArray[n4];
                            if (((Method)next).getName().startsWith(nextToken)) {
                                Class<?> returnClass;
                                nextClazz = next.getClass();
                                if (tokens.isEmpty() || !OPENING_BRACE_AS_STRING.equals(tokens.get(0))) break;
                                Iterator<String> iter = tokens.iterator();
                                while (iter.hasNext()) {
                                    String nextTokenToCheck = iter.next();
                                    iter.remove();
                                    if (DOT_AS_STRING.equals(nextTokenToCheck)) break;
                                }
                                if ((returnClass = ((Method)next).getReturnType()) == null) break;
                                nextClazz = returnClass;
                                break;
                            }
                            ++n4;
                        }
                    }
                    if (nextClazz != null) {
                        this.collectQualifiedProposals(nextClazz, tokens, proposals);
                    }
                }
            }
        }
    }

    private boolean isJavaIdentifier(String token) {
        assert (token != null) : "Parameter 'token' of method 'isJavaIdentifier' must not be null";
        if (!token.isEmpty()) {
            int i = 0;
            while (i < token.length()) {
                if (!Character.isJavaIdentifierPart(token.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private void addMembers(int offset, List<AutoCompletionProposal> proposals) {
        assert (offset >= 0) : "'offset' must not be negative";
        assert (proposals != null) : "Parameter 'proposals' of method 'addMembers' must not be null";
        assert (this.m_tokens.size() >= 2) : "At least 2 tokens needed";
        LOGGER.debug("Add members");
        ArrayList<String> relevantTokens = new ArrayList<String>();
        boolean inParameterList = false;
        int i = this.m_tokens.size() - 1;
        while (i >= 0) {
            String nextToken = this.m_tokens.get(i);
            if (this.isJavaIdentifier(nextToken)) {
                relevantTokens.add(nextToken);
            } else if (DOT_AS_STRING.equals(nextToken)) {
                relevantTokens.add(nextToken);
            } else if (CLOSING_BRACE_AS_STRING.equals(nextToken)) {
                if (inParameterList) break;
                inParameterList = true;
                relevantTokens.add(nextToken);
            } else if (OPENING_BRACE_AS_STRING.equals(nextToken)) {
                if (!inParameterList) break;
                inParameterList = false;
                relevantTokens.add(nextToken);
            } else {
                LOGGER.debug(nextToken);
                break;
            }
            --i;
        }
        if (relevantTokens.size() >= 2) {
            String firstRelevantToken;
            Collections.reverse(relevantTokens);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Next tokens:");
                relevantTokens.forEach(t -> LOGGER.trace(t));
            }
            if (this.isJavaIdentifier(firstRelevantToken = (String)relevantTokens.remove(0)) && DOT_AS_STRING.equals(relevantTokens.remove(0))) {
                Class<?> clazz;
                ClassInfo classInfo = this.m_variables.get(firstRelevantToken);
                if (classInfo == null) {
                    classInfo = SPECIAL_CLASSES.get(firstRelevantToken);
                }
                if (classInfo != null && (clazz = classInfo.getClazz()) != null) {
                    this.collectQualifiedProposals(clazz, relevantTokens, proposals);
                }
            }
        }
        LOGGER.debug("Add members - done");
    }

    private void tokenizeAndAddVariables(String text) {
        assert (this.m_scriptApi != null) : "'m_scriptApi' of method 'tokenizeAndAddVariables' must not be null";
        assert (this.m_tokens != null) : "'m_tokens' of method 'tokenizeAndAddVariables' must not be null";
        assert (this.m_variables != null) : "'m_variables' of method 'tokenizeAndAddVariables' must not be null";
        assert (this.m_offset >= 0) : "'offset' must not be negative";
        assert (text != null) : "Parameter 'text' of method 'tokenizeAndAddVariables' must not be null";
        LOGGER.debug("Tokenize and add variables");
        for (Map.Entry<String, StrictPair<Object, Class<?>>> nextEntry : this.m_scriptApi.getRoots().entrySet()) {
            Class nextClazz = (Class)nextEntry.getValue().getSecond();
            this.m_variables.put(nextEntry.getKey(), new ClassInfo(nextClazz.getSimpleName(), nextClazz));
        }
        String textBefore = text.substring(0, this.m_offset);
        StringTokenizer tokenizer = new StringTokenizer(textBefore, String.valueOf(ALL_DELIMITERS_VARIABLE_DETECTION), true);
        ArrayList<Integer> posEqualsAndArrow = new ArrayList<Integer>(50);
        ArrayList<Integer> posIn = new ArrayList<Integer>(50);
        int pos = 0;
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            this.m_tokens.add(nextToken);
            if (EQUALS_AS_STRING.equals(nextToken)) {
                posEqualsAndArrow.add(pos - 1);
            } else if (IN_AS_STRING.equals(nextToken)) {
                posIn.add(pos - 1);
            } else if (ARROW_AS_STRING.equals(nextToken)) {
                posEqualsAndArrow.add(pos - 1);
            }
            ++pos;
        }
        block2: for (Integer next : posEqualsAndArrow) {
            int i = next;
            while (i >= 0) {
                String nextPreviousToken = this.m_tokens.get(i);
                if (BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION.contains(nextPreviousToken)) continue block2;
                if (!NON_BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION.contains(nextPreviousToken)) {
                    ClassInfo nextClassInfo = this.detectVariableClass(i);
                    if (nextClassInfo == null) continue block2;
                    this.m_variables.put(nextPreviousToken, nextClassInfo);
                    continue block2;
                }
                --i;
            }
        }
        for (Integer next : posIn) {
            Class<?> clazz;
            ClassInfo classInfo;
            String variableName = null;
            int i = next;
            while (i >= 0) {
                String nextPreviousToken = this.m_tokens.get(i);
                if (BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION.contains(nextPreviousToken)) break;
                if (!NON_BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION.contains(nextPreviousToken)) {
                    variableName = nextPreviousToken;
                    break;
                }
                --i;
            }
            if (variableName == null) continue;
            String in = null;
            int i2 = next;
            while (i2 < this.m_tokens.size()) {
                String nextToken = this.m_tokens.get(i2);
                if (BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION.contains(nextToken)) break;
                if (!NON_BREAKING_DELIMITERS_AS_STRINGS_VARIABLE_DETECTION.contains(nextToken) && !IN_AS_STRING.equals(nextToken)) {
                    in = nextToken;
                    break;
                }
                ++i2;
            }
            if (in == null || (classInfo = this.m_variables.get(in)) == null || (clazz = classInfo.getClazz()) == null || !clazz.getName().equals("java.util.Map")) continue;
            this.m_variables.put(variableName, new ClassInfo(variableName, Map.Entry.class));
            LOGGER.debug("Added variable: " + variableName + " in " + in + " [" + String.valueOf(classInfo) + "]");
        }
        LOGGER.debug("Tokenize and add variables - done");
    }

    List<AutoCompletionProposal> getProposals(Script script, IScriptApi scriptApi, ClassLoader classLoader, String text, int offset) {
        assert (scriptApi != null) : "Parameter 'scriptApi' of method 'getProposals' must not be null";
        assert (classLoader != null) : "Parameter 'classLoader' of method 'getProposals' must not be null";
        assert (text != null) : "Parameter 'text' of method 'getProposals' must not be null";
        assert (offset >= 0) : "'offset' must not be negative";
        try {
            String lastToken;
            LOGGER.debug("Calculate scipt auto completion proposals");
            this.m_scriptApi = scriptApi;
            this.m_classLoader = classLoader;
            this.m_variables = new TreeMap<String, ClassInfo>();
            this.m_tokens = new ArrayList<String>(1000);
            this.m_offset = offset;
            this.tokenizeAndAddVariables(text);
            boolean isQualifiedAccess = false;
            int numberOfTokens = this.m_tokens.size();
            if (numberOfTokens > 0 && DOT_AS_STRING.equals(this.m_tokens.get(numberOfTokens - 1))) {
                isQualifiedAccess = true;
            } else if (numberOfTokens >= 2 && this.isJavaIdentifier(this.m_tokens.get(numberOfTokens - 1)) && DOT_AS_STRING.equals(this.m_tokens.get(numberOfTokens - 2))) {
                isQualifiedAccess = true;
            } else if (!(numberOfTokens <= 0 || BACKSLASH_N_AS_STRING.equals(lastToken = this.m_tokens.get(numberOfTokens - 1)) || BACKSLASH_R_AS_STRING.equals(lastToken) || BLANK_AS_STRING.equals(lastToken) || TAB_AS_STRING.equals(lastToken) || this.isJavaIdentifier(lastToken))) {
                return Collections.emptyList();
            }
            ArrayList<AutoCompletionProposal> proposals = new ArrayList<AutoCompletionProposal>(20);
            if (!isQualifiedAccess) {
                this.addVariablesAndToplevelMethods(script, offset, proposals);
            } else {
                this.addMembers(offset, proposals);
            }
            List<AutoCompletionProposal> sortedProposals = proposals.stream().sorted((p1, p2) -> p1.getPresentationProposal().compareTo(p2.getPresentationProposal())).collect(Collectors.toList());
            this.m_scriptApi = null;
            this.m_classLoader = null;
            this.m_offset = -1;
            this.m_tokens = null;
            this.m_variables = null;
            LOGGER.debug("Calculate scipt auto completion proposals - done");
            return sortedProposals;
        }
        catch (Throwable t) {
            LOGGER.error("Unable to collect proposals", t);
            return Collections.emptyList();
        }
    }

    public static List<AutoCompletionProposal> getAutoCompletionProposals(Script script, IScriptApi scriptApi, ClassLoader classLoader, String text, int offset, int line) {
        assert (scriptApi != null) : "Parameter 'scriptApi' of method 'getAutoCompletionProposals' must not be null";
        assert (classLoader != null) : "Parameter 'classLoader' of method 'getAutoCompletionProposals' must not be null";
        assert (text != null) : "Parameter 'text' of method 'getAutoCompletionProposals' must not be null";
        assert (offset >= 0) : "'offset' must not be negative";
        assert (line >= 0) : "'line' must not be negative";
        ScriptAutoCompletionProposalsCollector collector = new ScriptAutoCompletionProposalsCollector();
        return collector.getProposals(script, scriptApi, classLoader, text, offset);
    }

    static final class ClassInfo {
        private final String m_name;
        private final Class<?> m_clazz;

        ClassInfo(String name, Class<?> clazz) {
            assert (name != null && name.length() > 0) : "Parameter 'name' of method 'ClassInfo' must not be empty";
            this.m_name = name;
            this.m_clazz = clazz;
        }

        String getName() {
            return this.m_name;
        }

        Class<?> getClazz() {
            return this.m_clazz;
        }

        public String toString() {
            return this.m_name + (String)(this.m_clazz != null ? ": " + this.m_clazz.getSimpleName() : "");
        }
    }
}

