/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.representation.NodeType;
import com.hello2morrow.sonargraph.core.model.representation.Representation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class RepresentationDescriptorCalculator<T extends Representation> {
    private final Map<Class<? extends NamedElement>, List<String>> m_originalInputNodesClassToDescriptors = new HashMap<Class<? extends NamedElement>, List<String>>();
    private final Map<Class<? extends NamedElement>, List<String>> m_mainNodesClassToDescriptors = new HashMap<Class<? extends NamedElement>, List<String>>();
    private final Map<Class<? extends NamedElement>, List<String>> m_additionalNodesclassToDescriptors = new HashMap<Class<? extends NamedElement>, List<String>>();

    public RepresentationDescriptorCalculator(T representation) {
        assert (representation != null) : "Parameter 'representation' of method 'RepresentationDescriptorContainer' must not be null";
        this.finishInitialization();
        this.saveDescriptors(representation);
    }

    protected void finishInitialization() {
    }

    protected abstract void saveDescriptors(T var1);

    protected final void addDescriptors(Class<? extends NamedElement> clazz, Stream<String> descriptorsToAdd, NodeType nodeType) {
        assert (clazz != null) : "Parameter 'clazz' of method 'addDescriptors' must not be null";
        assert (descriptorsToAdd != null) : "Parameter 'descriptorsToAdd' of method 'addDescriptors' must not be null";
        assert (nodeType != null) : "Parameter 'nodeType' of method 'addDescriptors' must not be null";
        Map<Class<NamedElement>, List<String>> collector = this.getMap(nodeType);
        List<String> previous = collector.get(clazz);
        if (previous != null) {
            previous.addAll(descriptorsToAdd.collect(Collectors.toList()));
        } else {
            collector.put(clazz, descriptorsToAdd.collect(Collectors.toList()));
        }
    }

    private Map<Class<? extends NamedElement>, List<String>> getMap(NodeType nodeType) {
        return switch (nodeType) {
            case NodeType.ORIGINAL -> this.m_originalInputNodesClassToDescriptors;
            case NodeType.MAIN -> this.m_mainNodesClassToDescriptors;
            case NodeType.ADDITIONAL -> this.m_additionalNodesclassToDescriptors;
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected 'nodeType': " + String.valueOf((Object)nodeType)));
                }
                yield null;
            }
        };
    }

    public final Map<Class<? extends NamedElement>, List<String>> getClassToDescriptors(NodeType nodeType) {
        return this.getMap(nodeType);
    }
}

