/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.api.IParserDependencyType;
import com.hello2morrow.sonargraph.core.controller.system.representation.ConnectedProgrammingElementCollector;
import com.hello2morrow.sonargraph.core.foundation.common.graph.IConnectedNodeRunnerAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class ConnectedNodeRunnerAdapter
implements IConnectedNodeRunnerAdapter {
    private final IWorkerContext m_workerContext;
    private final Set<NodeAdapter> m_startNodes;
    private final DependencyEndpointCollector m_collector;
    private final Set<IParserDependencyType> m_allowedDependencyTypes;
    private final Set<NodeAdapter> m_collectedConnectedNodes;
    private final NodeRunnerMode m_nodeRunnerMode;
    private Set<ProgrammingElement> m_programmingElements;
    private Set<ProgrammingElement> m_entryPointsOfNextLevel;

    ConnectedNodeRunnerAdapter(IWorkerContext workerContext, Set<NodeAdapter> startNodes, DependencyEndpointCollector collector, Set<IParserDependencyType> allowedDependencyTypes, Set<NodeAdapter> collectedConnectedNodes, NodeRunnerMode nodeRunnerMode) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'ConnectedNodeRunnerAdapter' must not be null";
        assert (startNodes != null) : "Parameter 'startNodes' of method 'ConnectedNodeRunnerAdapter' must not be null";
        assert (collector != null) : "Parameter 'collector' of method 'ConnectedNodeRunnerAdapter' must not be null";
        assert (collectedConnectedNodes != null) : "Parameter 'collectedConnectedNodes' of method 'ConnectedNodeRunnerAdapter' must not be null";
        assert (nodeRunnerMode != null) : "Parameter 'nodeType' of method 'ConnectedNodeRunnerAdapter' must not be null";
        this.m_workerContext = workerContext;
        this.m_startNodes = startNodes;
        this.m_collector = collector;
        this.m_allowedDependencyTypes = allowedDependencyTypes;
        this.m_collectedConnectedNodes = collectedConnectedNodes;
        this.m_nodeRunnerMode = nodeRunnerMode;
    }

    @Override
    public final Collection<? extends INode<?>> getStartNodes() {
        return this.m_startNodes;
    }

    protected final boolean isAllowed(ParserDependency parserDependency) {
        assert (parserDependency != null) : "Parameter 'parserDependency' of method 'isAllowed' must not be null";
        if (this.m_allowedDependencyTypes != null) {
            return this.m_allowedDependencyTypes.contains(parserDependency.getDependencyType().getGenericDependencyType());
        }
        return true;
    }

    protected abstract boolean keep(ProgrammingElement var1, Set<ProgrammingElement> var2);

    protected abstract ConnectedProgrammingElementCollector createConnectedProgramminElementCollector();

    @Override
    public final void aboutToProcessLevel(Collection<INode<?>> nodes) {
        assert (nodes != null) : "Parameter 'nodes' of method 'aboutToProcessLevel' must not be null";
        if (this.m_nodeRunnerMode == NodeRunnerMode.PARSER_DEPENDENCY) {
            HashSet<ProgrammingElement> nextProgrammingElements = new HashSet<ProgrammingElement>();
            for (INode<?> nextNode : nodes) {
                Object nextUnderlyingObject = nextNode.getUnderlyingObject();
                assert (nextUnderlyingObject != null && nextUnderlyingObject instanceof NamedElement) : "Unexpected class in method 'aboutToProcessLevel': " + String.valueOf(nextUnderlyingObject);
                NamedElement nextNamedElement = (NamedElement)nextUnderlyingObject;
                Collection<ProgrammingElement> nextProgrammingElementsForElement = this.m_collector.getProgrammingElements(nextNamedElement);
                nextProgrammingElements.addAll(nextProgrammingElementsForElement);
            }
            if (this.m_programmingElements != null) {
                ConnectedProgrammingElementCollector connectedProgrammingElementNodeRunner = this.createConnectedProgramminElementCollector();
                this.m_programmingElements.addAll(connectedProgrammingElementNodeRunner.collect(this.m_workerContext, this.m_entryPointsOfNextLevel, nextProgrammingElements));
                this.m_entryPointsOfNextLevel.clear();
                Iterator iterator = nextProgrammingElements.iterator();
                while (iterator.hasNext()) {
                    ProgrammingElement nextProgrammingElement = (ProgrammingElement)iterator.next();
                    if (this.keep(nextProgrammingElement, this.m_programmingElements)) continue;
                    iterator.remove();
                }
            } else {
                assert (this.m_entryPointsOfNextLevel == null) : "'m_entryPointsOfNextLevel' of method 'aboutToProcessLevel' must be null";
                this.m_entryPointsOfNextLevel = new HashSet<ProgrammingElement>();
            }
            this.m_programmingElements = nextProgrammingElements;
        }
    }

    protected abstract boolean processEdges(ParserDependencyNodeAdapter var1, Set<ProgrammingElement> var2, Set<ProgrammingElement> var3, Set<ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>> var4);

    @Override
    public final boolean visitConnectedNode(INode<?> node) {
        assert (node != null && node instanceof NodeAdapter) : "Unexpected class in method 'visitConnectedNode': " + String.valueOf(node);
        this.m_collectedConnectedNodes.add((NodeAdapter)node);
        if (this.m_programmingElements != null) {
            assert (this.m_entryPointsOfNextLevel != null) : "'m_entryPointsOfNextLevel' of method 'visitConnectedNode' must not be null";
            assert (node instanceof ParserDependencyNodeAdapter) : "Unexpected class in method 'visitConnectedNode': " + String.valueOf(node);
            HashSet<ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>> toBeRemovedEdgesCollector = new HashSet<ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter>>();
            boolean result = this.processEdges((ParserDependencyNodeAdapter)node, this.m_programmingElements, this.m_entryPointsOfNextLevel, toBeRemovedEdgesCollector);
            for (ParserDependencyEdgeAdapter parserDependencyEdgeAdapter : toBeRemovedEdgesCollector) {
                ((ParserDependencyNodeAdapter)parserDependencyEdgeAdapter.getFrom()).removeOutgoingEdge(parserDependencyEdgeAdapter);
                ((ParserDependencyNodeAdapter)parserDependencyEdgeAdapter.getTo()).removeIncomingEdge(parserDependencyEdgeAdapter);
            }
            return result;
        }
        return true;
    }

    protected final NodeRunnerMode getNodeRunnerMode() {
        return this.m_nodeRunnerMode;
    }

    public static enum NodeRunnerMode {
        PARSER_DEPENDENCY,
        AGGREGATED_DEPENDENCY_EXCLUDING_NESTED_TYPES,
        AGGREGATED_DEPENDENCY_WITH_NESTED_TYPES;

    }
}

