/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.representation;

import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElementContainer;
import com.hello2morrow.sonargraph.core.model.architecture.AssignedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import java.util.HashSet;
import java.util.Set;

public final class AssignedComponentCollector
extends NamedElementVisitor
implements AssignedElement.IVisitor {
    private final NamedElement m_elementToMatch;
    private final Set<NamedElement> m_allElementsToMatch;
    private final Set<AssignedElement> m_underlyingComponents = new HashSet<AssignedElement>();

    public AssignedComponentCollector(NamedElement elementToMatch, Set<NamedElement> allElementsToMatch) {
        assert (elementToMatch != null && elementToMatch instanceof ArchitectureElementContainer) : "Unexpected class in method 'AssignedComponentCollector': " + String.valueOf(elementToMatch);
        assert (allElementsToMatch != null) : "Parameter 'allElementsToMatch' of method 'AssignedComponentCollector' must not be null";
        this.m_elementToMatch = elementToMatch;
        this.m_allElementsToMatch = allElementsToMatch;
    }

    @Override
    public void visitNamedElement(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
        if (!element.equals(this.m_elementToMatch) && this.m_allElementsToMatch.contains(element)) {
            return;
        }
        this.visitChildrenOf(element);
    }

    @Override
    public void visitAssignedElement(AssignedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitAssignedComponent' must not be null";
        if (!this.m_allElementsToMatch.contains(element)) {
            this.m_underlyingComponents.add(element);
        }
    }

    @Override
    public void visitChildrenOf(NamedElement element) {
        assert (element != null) : "Parameter 'element' of method 'visitChildrenOf' must not be null";
        for (NamedElement namedElement : element.getAllChildren()) {
            namedElement.accept(this);
        }
    }

    public Set<AssignedElement> getUnderlyingComponents() {
        return this.m_underlyingComponents;
    }
}

