/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.migration;

import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.file.TFileBasedXmlElementAttributesExtractor;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class RegexBasedFileMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RegexBasedFileMigration.class);
    private final CoreFileType m_coreFileTypeToMigrate;
    private final String m_rootElementName;
    private final boolean m_writeToDisk;
    private final boolean m_migrateVersion;

    protected RegexBasedFileMigration(CoreFileType fileTypeToMigrate, String rootElementName, boolean writeToDisk, boolean migrateVersion) {
        assert (fileTypeToMigrate != null) : "Parameter 'fileTypeToMigrate' of method 'RegexBasedFileMigration' must not be null";
        assert (rootElementName != null && rootElementName.length() > 0) : "Parameter 'rootElementName' of method 'RegexBasedFileMigration' must not be empty";
        this.m_coreFileTypeToMigrate = fileTypeToMigrate;
        this.m_rootElementName = rootElementName;
        this.m_writeToDisk = writeToDisk;
        this.m_migrateVersion = migrateVersion;
    }

    public void migrate(String currentVersion, TFile directory, OperationResult result) {
        assert (directory != null) : "Parameter 'directory' of method 'migrate' must not be null";
        assert (result != null) : "Parameter 'result' of method 'migrate' must not be null";
        if (!directory.exists()) {
            return;
        }
        if (!directory.canRead()) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.NO_PERMISSION, "Migration of " + this.m_coreFileTypeToMigrate.getPresentationName() + "' files requires read permission.", new Object[0]);
            return;
        }
        TFile[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(RegexBasedFileMigration.this.m_coreFileTypeToMigrate.getDefaultExtension());
            }
        });
        if (files == null || files.length == 0) {
            return;
        }
        int successfullyMigrated = 0;
        int failedMigrations = 0;
        TFile[] tFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            TFile next = tFileArray[n2];
            try {
                Map attributes = TFileBasedXmlElementAttributesExtractor.process((TFile)next, (String)this.m_rootElementName);
                if (attributes == null) {
                    result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "Not an XML file '" + next.getAbsolutePath() + "'.", new Object[0]);
                    ++failedMigrations;
                } else {
                    String version = (String)attributes.get("version");
                    if (version == null || version.isEmpty()) {
                        result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "No 'version' info found in XML file '" + next.getAbsolutePath() + "'.", new Object[0]);
                        ++failedMigrations;
                    } else if (this.needsMigration(version)) {
                        String originalContent = FileUtility.getFileContent((TFile)next);
                        String migrated = this.m_migrateVersion ? this.migrateVersion(version, currentVersion, originalContent) : originalContent;
                        migrated = this.migrateContent(migrated, result);
                        if (this.m_writeToDisk) {
                            FileUtility.writeFileContent((String)migrated.trim(), (TFile)next);
                        }
                        ++successfullyMigrated;
                    }
                }
            }
            catch (IOException e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.IO_EXCEPTION, (Throwable)e);
                ++failedMigrations;
            }
            ++n2;
        }
        if (failedMigrations == 0 && successfullyMigrated > 0) {
            LOGGER.debug("Successfully migrated {} of {} {} files.", new Object[]{successfullyMigrated, files.length, this.m_coreFileTypeToMigrate.getPresentationName()});
        } else if (failedMigrations > 0) {
            LOGGER.error("Migration of {} files: {} successful, {} failed of a total of {} files", new Object[]{this.m_coreFileTypeToMigrate.getPresentationName(), successfullyMigrated, failedMigrations, files.length});
        }
    }

    protected abstract boolean needsMigration(String var1);

    protected abstract String migrateContent(String var1, OperationResult var2);

    protected String addAdditionalVersionAttribute(String oldVersion, String currentVersion) {
        assert (oldVersion != null && oldVersion.length() > 0) : "Parameter 'oldVersion' of method 'migrateVersion' must not be empty";
        assert (currentVersion != null && currentVersion.length() > 0) : "Parameter 'currentVersion' of method 'migrateVersion' must not be empty";
        return "";
    }

    private String migrateVersion(String oldVersion, String currentVersion, String content) {
        assert (oldVersion != null && oldVersion.length() > 0) : "Parameter 'oldVersion' of method 'migrateVersion' must not be empty";
        assert (currentVersion != null && currentVersion.length() > 0) : "Parameter 'currentVersion' of method 'migrateVersion' must not be empty";
        assert (content != null && content.length() > 0) : "Parameter 'content' of method 'migrateVersion' must not be empty";
        String vmElement = "(<" + this.m_rootElementName + " version=\")" + oldVersion.replace(".", "\\.") + "\">";
        String vmElementReplacement = "$1" + currentVersion + "\"" + this.addAdditionalVersionAttribute(oldVersion, currentVersion) + ">";
        String replace = content.replaceFirst(vmElement, vmElementReplacement);
        return replace;
    }
}

