/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewArchitectureCheck;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewElementResolver;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNodeInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNodeSorter;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewUpwardDependencyMinimizer;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.AssignableToArtifactNotRemovedByFocusCollector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.CollapseInfo;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.CollapseToArtifactsCollector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.DependencyHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ExpandToArtifactsCollector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ExpandToAssignableToArtifactsCollector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FinishElementStructureVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.FinishInitialElementStructureVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.IExplorationViewRepresentationHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NodeHandler;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationPrinter;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.RepresentationVisibleLeafNodeSelector;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.SetPresentationModeVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.StructureIntegrityChecker;
import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.element.NamedElementUtility;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.event.ArchitecturalViewModifiedEvent;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactPropertiesNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExpandCollapseRequest;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewSortMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.NodeLocation;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveNode;
import com.hello2morrow.sonargraph.core.model.explorationview.PartialAlternativeInfo;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementAggregatingNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RepresentationHandler
implements IExplorationViewRepresentationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepresentationHandler.class);

    private RepresentationHandler() {
    }

    static void resetRelativePath(ArchitecturalViewElement element) {
        assert (element != null) : "Parameter 'element' of method 'resetRelativePath' must not be null";
        element.accept(new ResetRelativePathVisitor());
    }

    public static ExplorationViewRepresentation isCollapseAllPossible(ExplorationViewRepresentation representation, List<ArchitecturalViewNode> nodes, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
        assert (nodes != null) : "Parameter 'nodes' of method 'isCollapseAllPossible' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'isCollapseAllPossible' must not be null";
        ExplorationViewRepresentation useRepresentation = representation != null ? representation : RepresentationHandler.getRepresentation(nodes, dependencies);
        for (ArchitecturalViewNode next : useRepresentation.getVisibleNodeChildren()) {
            if (!next.isExpanded()) continue;
            return useRepresentation;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger collapseAll(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'collapseAll' must not be null";
        ExplorationViewRepresentation explorationViewRepresentation = representation;
        synchronized (explorationViewRepresentation) {
            List<ArchitecturalViewNode> expanded = representation.getVisibleNodeChildren().stream().filter(n -> n.isExpanded()).collect(Collectors.toList());
            if (!expanded.isEmpty()) {
                RepresentationHandler.aboutToChangeStructure(false, representation);
                RepresentationHandler.removeAggregatedDependencies(false, representation);
                expanded.forEach(e -> RepresentationHandler.collapse(e, representation));
                RepresentationHandler.createAggregatedDependencies(false, representation);
                RepresentationHandler.structureChanged(false, false, representation);
                return ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.COLLAPSE;
            }
            return null;
        }
    }

    public static ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger selectAll(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'selectAll' must not be null";
        RepresentationVisibleLeafNodeSelector selector = new RepresentationVisibleLeafNodeSelector();
        representation.accept(selector);
        return selector.hasSelectionChanged() ? ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.SELECTION : null;
    }

    public static boolean isSelectDependenciesPossible(List<ArchitecturalViewNode> nodes) {
        assert (nodes != null) : "Parameter 'nodes' of method 'isSelectDependenciesPossible' must not be null";
        for (ArchitecturalViewNode nextNode : nodes) {
            Iterator<ArchitecturalViewNode.ArchitecturalViewDependency> in = nextNode.getIncomingDependenciesIterator();
            while (in.hasNext()) {
                ArchitecturalViewNode.ArchitecturalViewDependency nextIn = in.next();
                if (nextIn.isSelected()) continue;
                return true;
            }
            Iterator<ArchitecturalViewNode.ArchitecturalViewDependency> out = nextNode.getOutgoingDependenciesIterator();
            while (out.hasNext()) {
                ArchitecturalViewNode.ArchitecturalViewDependency nextOut = out.next();
                if (nextOut.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    public static ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger selectDependencies(List<ArchitecturalViewNode> nodes) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'selectDependencies' must not be empty";
        boolean selectionChanged = false;
        for (ArchitecturalViewNode nextNode : nodes) {
            Iterator<ArchitecturalViewNode.ArchitecturalViewDependency> in = nextNode.getIncomingDependenciesIterator();
            while (in.hasNext()) {
                ArchitecturalViewNode.ArchitecturalViewDependency nextIn = in.next();
                if (nextIn.isSelected()) continue;
                nextIn.setSelected(true);
                selectionChanged = true;
            }
            Iterator<ArchitecturalViewNode.ArchitecturalViewDependency> out = nextNode.getOutgoingDependenciesIterator();
            while (out.hasNext()) {
                ArchitecturalViewNode.ArchitecturalViewDependency nextOut = out.next();
                if (nextOut.isSelected()) continue;
                nextOut.setSelected(true);
                selectionChanged = true;
            }
        }
        return selectionChanged ? ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.SELECTION : null;
    }

    static void collapse(ArchitecturalViewNode node, ExplorationViewRepresentation representation) {
        assert (node != null) : "Parameter 'node' of method 'collapse' must not be null";
        assert (node.isExpanded()) : "Not expanded: " + node.getElementInfo();
        assert (representation != null) : "Parameter 'representation' of method 'collapse' must not be null";
        RepresentationHandler.collapse(node.getNodeChildren(n -> true, false), null, representation);
        node.setExpanded(false);
        NodeHandler.updateExpandableState(node, representation);
    }

    static void collapse(List<ArchitecturalViewNode> children, CollapseInfo info, ExplorationViewRepresentation representation) {
        assert (children != null) : "Parameter 'children' of method 'collapse' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'collapse' must not be null";
        if (info != null) {
            info.incNumberOfVisibleChildren(children.size());
        }
        for (ArchitecturalViewNode nextChild : children) {
            DependencyHandler.removeDependencies(nextChild, false, representation);
            if (nextChild.isSelected()) {
                if (info != null) {
                    info.incNumberOfSelectedChildren();
                }
                nextChild.setSelected(false);
            }
            if (nextChild.isExpanded()) {
                RepresentationHandler.collapse(nextChild.getNodeChildren(ArchitecturalViewElement.NOT_REMOVED, false), info, representation);
                nextChild.setExpanded(false);
            }
            NodeHandler.updateExpandableState(nextChild, representation);
        }
    }

    static void collapseAll(boolean deselect, ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'collapseAll' must not be null";
        for (ArchitecturalViewNode next : representation.getAllNodeChildren(n -> true, false)) {
            if (next.isExpanded()) {
                RepresentationHandler.collapse(next, representation);
            }
            if (!deselect) continue;
            next.setSelected(false);
        }
    }

    private static boolean isExpandToArtifactsPossible(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'isExpandCollapseToArtifactsPossible' must not be null";
        return node instanceof ArtifactPropertiesNode;
    }

    private static boolean isExpandToAssignableToArtifactsPossible(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'isExpandToAssignableToArtifactsPossible' must not be null";
        return !(node instanceof AssignableToArtifactNode) && !(node instanceof ProgrammingElementNode);
    }

    private static boolean includeInExpandCollapse(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'includeInExpandCollapse' must not be null";
        return !node.isSuppressed() && ArchitecturalViewElement.NOT_REMOVED.test(node);
    }

    private static boolean isCollapseToArtifactsPossible(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'isCollapseToArtifactsPossible' must not be null";
        if (!(node instanceof ArtifactPropertiesNode)) {
            ArchitecturalViewNode current = node.getNodeParent();
            while (current != null) {
                if (current instanceof ArtifactPropertiesNode) {
                    return true;
                }
                current = current.getNodeParent();
            }
        }
        return false;
    }

    public static ExpandCollapseRequest isCollapseToArtifactsPossible(ExplorationViewRepresentation representation, List<ArchitecturalViewNode> nodes, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, boolean firstElementOnly) {
        ExplorationViewRepresentation representationFromNodesOrDependencies;
        assert (nodes != null) : "Parameter 'nodes' of method 'isCollapseToArtifactsPossible' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'isCollapseToArtifactsPossible' must not be null";
        if (representation != null) {
            LinkedHashSet<ArtifactPropertiesNode> nodesCollector = firstElementOnly ? null : new LinkedHashSet<ArtifactPropertiesNode>();
            CollapseToArtifactsCollector nodeCollector = new CollapseToArtifactsCollector(nodesCollector);
            representation.accept(nodeCollector);
            if (firstElementOnly && nodeCollector.done()) {
                return new ExpandCollapseRequest(representation, ExpandCollapseRequest.Type.COLLAPSE);
            }
            if (!firstElementOnly && !nodesCollector.isEmpty()) {
                return new ExpandCollapseRequest(representation, nodesCollector, ExpandCollapseRequest.Type.COLLAPSE);
            }
        } else if (!(nodes.isEmpty() && dependencies.isEmpty() || (representationFromNodesOrDependencies = RepresentationHandler.getRepresentation(nodes, dependencies)) == null)) {
            THashSet nodesCollector;
            THashSet tHashSet = nodesCollector = firstElementOnly ? null : new THashSet();
            if (!nodes.isEmpty()) {
                CollapseToArtifactsCollector nodeCollector = new CollapseToArtifactsCollector((Collection<ArtifactPropertiesNode>)nodesCollector);
                for (ArchitecturalViewNode nextNode : NamedElementUtility.normalize(nodes, false, new Class[0])) {
                    if (!RepresentationHandler.isCollapseToArtifactsPossible(nextNode)) continue;
                    nextNode.accept(nodeCollector);
                    if (!firstElementOnly || !nodeCollector.done()) continue;
                    return new ExpandCollapseRequest(representationFromNodesOrDependencies, ExpandCollapseRequest.Type.COLLAPSE);
                }
            }
            if (!dependencies.isEmpty()) {
                for (ArchitecturalViewNode.ArchitecturalViewDependency nextDependency : dependencies) {
                    ArchitecturalViewNode fromNode = nextDependency.getFrom();
                    ArchitecturalViewNode toNode = nextDependency.getTo();
                    boolean fromNodeIsPossible = RepresentationHandler.isCollapseToArtifactsPossible(fromNode);
                    boolean toNodeIsPossible = RepresentationHandler.isCollapseToArtifactsPossible(toNode);
                    if (!fromNodeIsPossible && !toNodeIsPossible) continue;
                    for (ParserDependency nextParserDependency : nextDependency.getParserDependencies()) {
                        ArchitecturalViewNode nextFromNode = representationFromNodesOrDependencies.getLeafNode(nextParserDependency.getFrom());
                        ArchitecturalViewNode nextToNode = representationFromNodesOrDependencies.getLeafNode(nextParserDependency.getTo());
                        assert (nextFromNode != null) : "'nextFromNode' of method 'isExpandToArtifactsPossible' must not be null";
                        assert (nextToNode != null) : "'nextToNode' of method 'isExpandToArtifactsPossible' must not be null";
                        ArtifactPropertiesNode nextFromArtifactNode = nextFromNode.getParent(ArtifactPropertiesNode.class, ParentMode.SELF_OR_FIRST_PARENT);
                        ArtifactPropertiesNode nextToArtifactNode = nextToNode.getParent(ArtifactPropertiesNode.class, ParentMode.SELF_OR_FIRST_PARENT);
                        if ((nextFromArtifactNode == null || !RepresentationHandler.includeInExpandCollapse(nextFromArtifactNode)) && (nextToArtifactNode == null || !RepresentationHandler.includeInExpandCollapse(nextToArtifactNode))) continue;
                        if (firstElementOnly) {
                            return new ExpandCollapseRequest(representationFromNodesOrDependencies, ExpandCollapseRequest.Type.COLLAPSE);
                        }
                        if (nextFromArtifactNode != null) {
                            nodesCollector.add(nextFromArtifactNode);
                        }
                        if (nextToArtifactNode == null) continue;
                        nodesCollector.add(nextToArtifactNode);
                    }
                }
            }
            if (!firstElementOnly && !nodesCollector.isEmpty()) {
                return new ExpandCollapseRequest(representationFromNodesOrDependencies, (Set<? extends ArchitecturalViewNode>)nodesCollector, ExpandCollapseRequest.Type.COLLAPSE);
            }
        }
        return null;
    }

    public static ExpandCollapseRequest isExpandToArtifactsPossible(ExplorationViewRepresentation representation, List<ArchitecturalViewNode> nodes, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, boolean firstElementOnly) {
        ExplorationViewRepresentation representationFromNodesOrDependencies;
        assert (nodes != null) : "Parameter 'nodes' of method 'isExpandToArtifactsPossible' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'isExpandToArtifactsPossible' must not be null";
        if (representation != null) {
            LinkedHashSet<ArtifactPropertiesNode> nodesCollector = firstElementOnly ? null : new LinkedHashSet<ArtifactPropertiesNode>();
            ExpandToArtifactsCollector nodeCollector = new ExpandToArtifactsCollector(nodesCollector);
            representation.accept(nodeCollector);
            if (firstElementOnly && nodeCollector.done()) {
                return new ExpandCollapseRequest(representation, ExpandCollapseRequest.Type.EXPAND);
            }
            if (!firstElementOnly && !nodesCollector.isEmpty()) {
                return new ExpandCollapseRequest(representation, nodesCollector, ExpandCollapseRequest.Type.EXPAND);
            }
        } else if (!(nodes.isEmpty() && dependencies.isEmpty() || (representationFromNodesOrDependencies = RepresentationHandler.getRepresentation(nodes, dependencies)) == null)) {
            THashSet nodesCollector;
            THashSet tHashSet = nodesCollector = firstElementOnly ? null : new THashSet();
            if (!nodes.isEmpty()) {
                ExpandToArtifactsCollector nodeCollector = new ExpandToArtifactsCollector((Collection<ArtifactPropertiesNode>)nodesCollector);
                for (ArchitecturalViewNode nextNode : NamedElementUtility.normalize(nodes, true, new Class[0])) {
                    if (!RepresentationHandler.isExpandToArtifactsPossible(nextNode)) continue;
                    nextNode.accept(nodeCollector);
                    if (!firstElementOnly || !nodeCollector.done()) continue;
                    return new ExpandCollapseRequest(representationFromNodesOrDependencies, ExpandCollapseRequest.Type.EXPAND);
                }
            }
            if (!dependencies.isEmpty()) {
                for (ArchitecturalViewNode.ArchitecturalViewDependency nextDependency : dependencies) {
                    ArchitecturalViewNode fromNode = nextDependency.getFrom();
                    ArchitecturalViewNode toNode = nextDependency.getTo();
                    boolean fromNodeIsPossible = RepresentationHandler.isExpandToArtifactsPossible(fromNode);
                    boolean toNodeIsPossible = RepresentationHandler.isExpandToArtifactsPossible(toNode);
                    if (!fromNodeIsPossible && !toNodeIsPossible) continue;
                    for (ParserDependency nextParserDependency : nextDependency.getParserDependencies()) {
                        ArchitecturalViewNode nextFromNode = representationFromNodesOrDependencies.getLeafNode(nextParserDependency.getFrom());
                        ArchitecturalViewNode nextToNode = representationFromNodesOrDependencies.getLeafNode(nextParserDependency.getTo());
                        assert (nextFromNode != null) : "'nextFromNode' of method 'isExpandToArtifactsPossible' must not be null";
                        assert (nextToNode != null) : "'nextToNode' of method 'isExpandToArtifactsPossible' must not be null";
                        ArtifactPropertiesNode nextFromArtifactNode = nextFromNode.getParent(ArtifactPropertiesNode.class, ParentMode.SELF_OR_FIRST_PARENT);
                        ArtifactPropertiesNode nextToArtifactNode = nextToNode.getParent(ArtifactPropertiesNode.class, ParentMode.SELF_OR_FIRST_PARENT);
                        if ((nextFromArtifactNode == null || !RepresentationHandler.includeInExpandCollapse(nextFromArtifactNode)) && (nextToArtifactNode == null || !RepresentationHandler.includeInExpandCollapse(nextToArtifactNode))) continue;
                        if (firstElementOnly) {
                            return new ExpandCollapseRequest(representationFromNodesOrDependencies, ExpandCollapseRequest.Type.EXPAND);
                        }
                        if (nextFromArtifactNode != null) {
                            nodesCollector.add(nextFromArtifactNode);
                        }
                        if (nextToArtifactNode == null) continue;
                        nodesCollector.add(nextToArtifactNode);
                    }
                }
            }
            if (!firstElementOnly && !nodesCollector.isEmpty()) {
                return new ExpandCollapseRequest(representationFromNodesOrDependencies, (Set<? extends ArchitecturalViewNode>)nodesCollector, ExpandCollapseRequest.Type.EXPAND);
            }
        }
        return null;
    }

    public static ExpandCollapseRequest isExpandToAssignableToArtifactsPossible(List<ArchitecturalViewNode> nodes, List<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies, boolean firstElementOnly) {
        ExplorationViewRepresentation representationFromNodesOrDependencies;
        assert (nodes != null) : "Parameter 'nodes' of method 'isExpandToAssignableToArtifactsPossible' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'isExpandToAssignableToArtifactsPossible' must not be null";
        if (!(nodes.isEmpty() && dependencies.isEmpty() || (representationFromNodesOrDependencies = RepresentationHandler.getRepresentation(nodes, dependencies)) == null)) {
            THashSet nodesCollector;
            THashSet tHashSet = nodesCollector = firstElementOnly ? null : new THashSet();
            if (!nodes.isEmpty()) {
                ExpandToAssignableToArtifactsCollector nodeCollector = new ExpandToAssignableToArtifactsCollector((Collection<AssignableToArtifactNode>)nodesCollector);
                for (ArchitecturalViewNode nextNode : NamedElementUtility.normalize(nodes, true, new Class[0])) {
                    if (!RepresentationHandler.isExpandToAssignableToArtifactsPossible(nextNode)) continue;
                    nextNode.accept(nodeCollector);
                    if (!firstElementOnly || !nodeCollector.done()) continue;
                    return new ExpandCollapseRequest(representationFromNodesOrDependencies, ExpandCollapseRequest.Type.EXPAND);
                }
            }
            if (!dependencies.isEmpty()) {
                for (ArchitecturalViewNode.ArchitecturalViewDependency nextDependency : dependencies) {
                    ArchitecturalViewNode fromNode = nextDependency.getFrom();
                    ArchitecturalViewNode toNode = nextDependency.getTo();
                    boolean fromNodeIsPossible = RepresentationHandler.isExpandToAssignableToArtifactsPossible(fromNode);
                    boolean toNodeIsPossible = RepresentationHandler.isExpandToAssignableToArtifactsPossible(toNode);
                    if (!fromNodeIsPossible && !toNodeIsPossible) continue;
                    for (ParserDependency nextParserDependency : nextDependency.getParserDependencies()) {
                        ArchitecturalViewNode nextFromNode = representationFromNodesOrDependencies.getLeafNode(nextParserDependency.getFrom());
                        ArchitecturalViewNode nextToNode = representationFromNodesOrDependencies.getLeafNode(nextParserDependency.getTo());
                        assert (nextFromNode != null) : "'nextFromNode' of method 'isExpandToAssignableToArtifactsPossible' must not be null";
                        assert (nextToNode != null) : "'nextToNode' of method 'isExpandToAssignableToArtifactsPossible' must not be null";
                        AssignableToArtifactNode nextFromAssignableToArtifactNode = nextFromNode.getParent(AssignableToArtifactNode.class, ParentMode.SELF_OR_FIRST_PARENT);
                        assert (nextFromAssignableToArtifactNode != null) : "'nextFromAssignableToArtifactNode' of method 'isExpandToAssignableToArtifactsPossible' must not be null";
                        AssignableToArtifactNode nextToAssignableToArtifactNode = nextToNode.getParent(AssignableToArtifactNode.class, ParentMode.SELF_OR_FIRST_PARENT);
                        assert (nextToAssignableToArtifactNode != null) : "'nextToAssignableToArtifactNode' of method 'isExpandToAssignableToArtifactsPossible' must not be null";
                        if (!RepresentationHandler.includeInExpandCollapse(nextFromAssignableToArtifactNode) || !RepresentationHandler.includeInExpandCollapse(nextToAssignableToArtifactNode)) continue;
                        if (firstElementOnly) {
                            return new ExpandCollapseRequest(representationFromNodesOrDependencies, ExpandCollapseRequest.Type.EXPAND);
                        }
                        nodesCollector.add(nextFromAssignableToArtifactNode);
                        nodesCollector.add(nextToAssignableToArtifactNode);
                    }
                }
            }
            if (!firstElementOnly && !nodesCollector.isEmpty()) {
                return new ExpandCollapseRequest(representationFromNodesOrDependencies, (Set<? extends ArchitecturalViewNode>)nodesCollector, ExpandCollapseRequest.Type.EXPAND);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger processExpandCollapseRequest(ExpandCollapseRequest request) {
        ExplorationViewRepresentation representation;
        assert (request != null) : "Parameter 'request' of method 'processExpandCollapseRequest' must not be null";
        ExplorationViewRepresentation explorationViewRepresentation = representation = request.getRepresentation();
        synchronized (explorationViewRepresentation) {
            RepresentationHandler.aboutToChangeStructure(false, representation);
            RepresentationHandler.removeAggregatedDependencies(false, request.getRepresentation());
            NodeHandler.resetSelection(request.getRepresentation());
            switch (request.getType()) {
                case COLLAPSE: {
                    boolean collapsed = false;
                    for (ArchitecturalViewNode architecturalViewNode : request.getNodes()) {
                        if (!architecturalViewNode.isExpanded()) continue;
                        RepresentationHandler.collapse(architecturalViewNode, representation);
                        collapsed = true;
                    }
                    RepresentationHandler.createAggregatedDependencies(false, request.getRepresentation());
                    RepresentationHandler.structureChanged(false, false, request.getRepresentation());
                    return collapsed ? ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.COLLAPSE : null;
                }
                case EXPAND: {
                    boolean bl = NodeHandler.expandParentChainOf(request.getNodes(), null, request.getRepresentation(), false);
                    RepresentationHandler.createAggregatedDependencies(false, request.getRepresentation());
                    RepresentationHandler.structureChanged(false, false, request.getRepresentation());
                    return bl ? ArchitecturalViewModifiedEvent.ArchitecturalViewModification.Trigger.EXPAND : null;
                }
            }
            assert (false) : "Unhandled type: " + String.valueOf((Object)request.getType());
            return null;
        }
    }

    static void removeProgrammingElementsFromParents(Collection<ProgrammingElement> programmingElements, ArchitecturalViewNode startNode, Set<AssignableNode> assignableNodeParents) {
        assert (programmingElements != null) : "Parameter 'programmingElements' of method 'removeProgrammingElementsFromParents' must not be null";
        assert (startNode != null) : "Parameter 'startNode' of method 'removeProgrammingElementsFromParents' must not be null";
        assert (assignableNodeParents != null) : "Parameter 'assignableNodeParents' of method 'removeProgrammingElementsFromParents' must not be null";
        if (startNode instanceof ProgrammingElementAggregatingNode) {
            ((ProgrammingElementAggregatingNode)startNode).removeProgrammingElements(programmingElements);
            if (startNode instanceof AssignableNode) {
                assignableNodeParents.add((AssignableNode)startNode);
            }
        }
        ProgrammingElementAggregatingNode currentParent = startNode.getParent(ProgrammingElementAggregatingNode.class, ParentMode.ONLY_DIRECT_PARENT);
        while (currentParent != null) {
            currentParent.removeProgrammingElements(programmingElements);
            if (currentParent instanceof AssignableNode) {
                assignableNodeParents.add((AssignableNode)currentParent);
            }
            currentParent = currentParent.getParent(ProgrammingElementAggregatingNode.class, ParentMode.ONLY_DIRECT_PARENT);
        }
    }

    static void addProgrammingElementsToParents(Collection<ProgrammingElement> programmingElements, ArchitecturalViewNode startNode, Set<AssignableNode> assignableNodeParents) {
        assert (programmingElements != null) : "Parameter 'programmingElements' of method 'addProgrammingElementsToParents' must not be null";
        assert (startNode != null) : "Parameter 'startNode' of method 'addProgrammingElementsToParents' must not be null";
        assert (assignableNodeParents != null) : "Parameter 'assignableNodeParents' of method 'addProgrammingElementsToParents' must not be null";
        if (startNode instanceof ProgrammingElementAggregatingNode) {
            ((ProgrammingElementAggregatingNode)startNode).addProgrammingElements(programmingElements);
            if (startNode instanceof AssignableNode) {
                assignableNodeParents.add((AssignableNode)startNode);
            }
        }
        ProgrammingElementAggregatingNode currentParent = startNode.getParent(ProgrammingElementAggregatingNode.class, ParentMode.ONLY_DIRECT_PARENT);
        while (currentParent != null) {
            currentParent.addProgrammingElements(programmingElements);
            if (currentParent instanceof AssignableNode) {
                assignableNodeParents.add((AssignableNode)currentParent);
            }
            currentParent = currentParent.getParent(ProgrammingElementAggregatingNode.class, ParentMode.ONLY_DIRECT_PARENT);
        }
    }

    static void removeProgrammingElementsFromParents(ArchitecturalViewNode node, Set<AssignableNode> assignableNodeParents) {
        assert (node != null) : "Parameter 'node' of method 'removeProgrammingElementsFromParents' must not be null";
        assert (assignableNodeParents != null) : "Parameter 'assignableNodeParents' of method 'removeProgrammingElementsFromParents' must not be null";
        Collection<ProgrammingElement> programmingElements = node.getProgrammingElements();
        ProgrammingElementAggregatingNode currentParent = node.getParent(ProgrammingElementAggregatingNode.class, ParentMode.ONLY_DIRECT_PARENT);
        while (currentParent != null) {
            currentParent.removeProgrammingElements(programmingElements);
            if (currentParent instanceof AssignableNode) {
                assignableNodeParents.add((AssignableNode)currentParent);
            }
            currentParent = currentParent.getParent(ProgrammingElementAggregatingNode.class, ParentMode.ONLY_DIRECT_PARENT);
        }
    }

    static void addProgrammingElementsToParents(ArchitecturalViewNode node, Set<AssignableNode> assignableNodeParents) {
        assert (node != null) : "Parameter 'node' of method 'addProgrammingElementsToParents' must not be null";
        assert (assignableNodeParents != null) : "Parameter 'assignableNodeParents' of method 'addProgrammingElementsToParents' must not be null";
        Collection<ProgrammingElement> programmingElements = node.getProgrammingElements();
        ProgrammingElementAggregatingNode currentParent = node.getParent(ProgrammingElementAggregatingNode.class, ParentMode.ONLY_DIRECT_PARENT);
        while (currentParent != null) {
            currentParent.addProgrammingElements(programmingElements);
            if (currentParent instanceof AssignableNode) {
                assignableNodeParents.add((AssignableNode)currentParent);
            }
            currentParent = currentParent.getParent(ProgrammingElementAggregatingNode.class, ParentMode.ONLY_DIRECT_PARENT);
        }
    }

    static void removeProgrammingElementsFromParents(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'removeProgrammingElementsFromParents' must not be null";
        Collection<ProgrammingElement> programmingElements = node.getProgrammingElements();
        ProgrammingElementAggregatingNode currentParent = node.getParent(ProgrammingElementAggregatingNode.class, ParentMode.ONLY_DIRECT_PARENT);
        while (currentParent != null) {
            currentParent.removeProgrammingElements(programmingElements);
            currentParent = currentParent.getParent(ProgrammingElementAggregatingNode.class, ParentMode.ONLY_DIRECT_PARENT);
        }
    }

    static void addProgrammingElementsToParents(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'addProgrammingElementsToParents' must not be null";
        Collection<ProgrammingElement> programmingElements = node.getProgrammingElements();
        ProgrammingElementAggregatingNode currentParent = node.getParent(ProgrammingElementAggregatingNode.class, ParentMode.ONLY_DIRECT_PARENT);
        while (currentParent != null) {
            currentParent.addProgrammingElements(programmingElements);
            currentParent = currentParent.getParent(ProgrammingElementAggregatingNode.class, ParentMode.ONLY_DIRECT_PARENT);
        }
    }

    static List<StrictPair<String, String>> getDependencyInfo(Collection<ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
        assert (dependencies != null) : "Parameter 'dependencies' of method 'getDependencyInfo' must not be null";
        if (dependencies.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StrictPair<String, String>> dependenciesInfo = new ArrayList<StrictPair<String, String>>(dependencies.size());
        dependencies.forEach(d -> {
            boolean bl = dependenciesInfo.add(new StrictPair((Object)d.getFrom().getRelativePath(), (Object)d.getTo().getRelativePath()));
        });
        return dependenciesInfo;
    }

    static List<ArchitecturalViewNode.ArchitecturalViewDependency> selectDependencies(List<StrictPair<String, String>> dependenciesInfo, ExplorationViewRepresentation representation) {
        assert (dependenciesInfo != null) : "Parameter 'dependenciesInfo' of method 'selectDependencies' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'selectDependencies' must not be null";
        if (!dependenciesInfo.isEmpty()) {
            ArrayList<ArchitecturalViewNode.ArchitecturalViewDependency> selected = new ArrayList<ArchitecturalViewNode.ArchitecturalViewDependency>();
            for (StrictPair<String, String> next : dependenciesInfo) {
                ArchitecturalViewNode.ArchitecturalViewDependency nextDependency;
                ArchitecturalViewNode nextTo;
                ArchitecturalViewNode nextFrom = ArchitecturalViewElementResolver.resolve((String)next.getFirst(), ArchitecturalViewNode.class, representation, false);
                if (nextFrom == null || (nextTo = ArchitecturalViewElementResolver.resolve((String)next.getSecond(), ArchitecturalViewNode.class, representation, false)) == null || (nextDependency = nextFrom.getOutgoingDependency(nextTo)) == null) continue;
                nextDependency.setSelected(true);
                selected.add(nextDependency);
            }
            return selected;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static ExplorationViewRepresentation getRepresentation(Collection<? extends IArchitecturalViewElement> elements) {
        void var2_5;
        assert (elements != null) : "Parameter 'elements' of method 'getRepresentation' must not be null";
        if (elements.isEmpty()) {
            return null;
        }
        THashSet architecturalViewElements = new THashSet();
        for (IArchitecturalViewElement iArchitecturalViewElement : elements) {
            if (iArchitecturalViewElement instanceof ArchitecturalViewElement) {
                architecturalViewElements.add((ArchitecturalViewElement)iArchitecturalViewElement);
                continue;
            }
            if (iArchitecturalViewElement instanceof ArchitecturalViewNode.ArchitecturalViewDependency) {
                architecturalViewElements.add(((ArchitecturalViewNode.ArchitecturalViewDependency)iArchitecturalViewElement).getFrom());
                architecturalViewElements.add(((ArchitecturalViewNode.ArchitecturalViewDependency)iArchitecturalViewElement).getTo());
                continue;
            }
            assert (false) : "Unhandled class: " + iArchitecturalViewElement.getClass().getName();
        }
        Object var2_4 = null;
        for (ArchitecturalViewElement nextElement : architecturalViewElements) {
            ExplorationViewRepresentation nextRepresentation = nextElement.getParent(ExplorationViewRepresentation.class, ParentMode.SELF_OR_FIRST_PARENT);
            if (nextRepresentation == null) {
                return null;
            }
            if (var2_5 == null) {
                ExplorationViewRepresentation explorationViewRepresentation = nextRepresentation;
                continue;
            }
            if (var2_5 == nextRepresentation) continue;
            return null;
        }
        return var2_5;
    }

    static ExplorationViewRepresentation getRepresentation(Collection<? extends ArchitecturalViewNode> nodes, Collection<? extends ArchitecturalViewNode.ArchitecturalViewDependency> dependencies) {
        assert (nodes != null) : "Parameter 'nodes' of method 'getRepresentation' must not be null";
        assert (dependencies != null) : "Parameter 'dependencies' of method 'getRepresentation' must not be null";
        if (nodes.isEmpty() && dependencies.isEmpty()) {
            return null;
        }
        THashSet allNodes = new THashSet(nodes);
        for (ArchitecturalViewNode.ArchitecturalViewDependency architecturalViewDependency : dependencies) {
            allNodes.add(architecturalViewDependency.getFrom());
            allNodes.add(architecturalViewDependency.getTo());
        }
        return RepresentationHandler.getRepresentation((Collection<? extends IArchitecturalViewElement>)allNodes);
    }

    static void aboutToChangeStructure(boolean force, ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'aboutToChangeStructure' must not be null";
        if (force || !representation.inModification()) {
            RepresentationPrinter.print(representation, "aboutToChangeStructure");
        }
    }

    static void structureChanged(boolean force, boolean programmingElementsChanged, ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'structureChanged' must not be null";
        if (force || !representation.inModification()) {
            RepresentationPrinter.print(representation, "structureChanged");
            StructureIntegrityChecker.check(representation, programmingElementsChanged);
        }
    }

    public static void finishInitialElementCreation(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'finishInitialElementCreation' must not be null";
        assert (representation.inInitialCreation()) : "Not in initial creation";
        assert (representation.getFocus().isEmpty()) : "Focus must be empty";
        assert (representation.getPresentationMode() == PresentationMode.HIERARCHICAL) : "Unexpected presentation mode: " + String.valueOf((Object)representation.getPresentationMode());
        LOGGER.debug("Finish initial element creation");
        representation.finishInitialElementCreation();
        StructureIntegrityChecker.checkAfterInitialCreation(representation);
        LOGGER.debug("Finish initial element creation - done");
    }

    public static ArchitecturalViewNodeInfo finishInitialElementStructure(PresentationMode presentationMode, ExplorationViewRepresentation representation) {
        assert (presentationMode != null) : "Parameter 'presentationMode' of method 'finishInitialElementStructure' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'finishInitialElementStructure' must not be null";
        assert (representation.inInitialCreation()) : "Not in initial creation";
        assert (representation.getFocus().isEmpty()) : "Focus must be empty";
        assert (representation.getPresentationMode() == PresentationMode.HIERARCHICAL) : "Unexpected presentation mode: " + String.valueOf((Object)representation.getPresentationMode());
        LOGGER.debug("Finish initial element structure");
        if (!representation.getPresentationMode().equals((Object)presentationMode)) {
            LOGGER.debug("Switch presentation mode from '" + String.valueOf((Object)representation.getPresentationMode()) + "' to '" + String.valueOf((Object)presentationMode) + "'");
            representation.accept(new SetPresentationModeVisitor(presentationMode));
        }
        FinishInitialElementStructureVisitor visitor = new FinishInitialElementStructureVisitor(representation);
        representation.accept(visitor);
        representation.finishInitialElementStructure(visitor.getNumberOfInternalAssignableToArtifactNodes(), visitor.getNumberOfExternalAssignableToArtifactNodes());
        LOGGER.debug("Finish initial element structure - done");
        return visitor.getArchitecturalViewNodeInfo();
    }

    static ArchitecturalViewNodeInfo finishElementStructure(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'finishElementStructure' must not be null";
        LOGGER.debug("Finish element structure");
        FinishElementStructureVisitor visitor = new FinishElementStructureVisitor(representation);
        representation.accept(visitor);
        LOGGER.debug("Finish  element structure - done");
        return visitor.getArchitecturalViewNodeInfo();
    }

    static void finishElementStructureAfterOperationApply(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'finishRecursiveElementStructure' must not be null";
        if (!representation.inModification()) {
            ArchitecturalViewNodeInfo nodeInfo = RepresentationHandler.finishElementStructure(representation);
            RepresentationHandler.sortNodes((IWorkerContext)DefaultWorkerContext.INSTANCE, nodeInfo.getLeafNodes(), representation);
            NodeHandler.applySelectionAndExpansionState(nodeInfo.getSelectedNodes(), nodeInfo.getExpandedNodes(), representation);
        }
    }

    static void finishArtifactCreation(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'finishArtifactCreation' must not be null";
        if (!representation.inModification()) {
            LOGGER.debug("Finish artifact creation");
            ArchitecturalViewArchitectureCheck.checkAssignmentMode(representation);
            LOGGER.debug("Finish artifact creation - done");
        }
    }

    static void finishProgrammingElementNodeCreation(List<ProgrammingElementNode> created, ExplorationViewRepresentation representation) {
        assert (created != null && !created.isEmpty()) : "Parameter 'created' of method 'finishProgrammingElementNodeCreation' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'finishProgrammingElementNodeCreation' must not be null";
        ExplorationViewSortMode mode = representation.getSortMode();
        LOGGER.debug("Sort " + created.size() + " created programming element nodes '" + String.valueOf((Object)mode) + "'");
        long start = System.currentTimeMillis();
        switch (mode) {
            case LEVELIZE: 
            case LEVELIZE_ALL: {
                ArchitecturalViewUpwardDependencyMinimizer.levelizeCreatedProgrammingElementNodes((IWorkerContext)DefaultWorkerContext.INSTANCE, created, representation);
                break;
            }
            case ALPHA: 
            case LOC: 
            case SEC: {
                ArchitecturalViewNodeSorter.sortCreatedProgrammingElementNodes((IWorkerContext)DefaultWorkerContext.INSTANCE, created, representation);
                break;
            }
            default: {
                assert (false) : "Unhandled sort mode: " + String.valueOf((Object)mode);
                break;
            }
        }
        LOGGER.debug("Sort - done [" + (System.currentTimeMillis() - start) + "]");
    }

    static void sortNodes(IWorkerContext workerContext, List<ArchitecturalViewNode> leafNodes, ExplorationViewRepresentation representation) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'sortNodes' must not be null";
        assert (leafNodes != null && !leafNodes.isEmpty()) : "Parameter 'leafNodes' of method 'sortNodes' must not be empty";
        assert (representation != null) : "Parameter 'representation' of method 'sortNodes' must not be null";
        ExplorationViewSortMode mode = representation.getSortMode();
        LOGGER.debug("Sort " + leafNodes.size() + " leaf nodes '" + String.valueOf((Object)mode) + "'");
        long start = System.currentTimeMillis();
        switch (mode) {
            case LEVELIZE: 
            case LEVELIZE_ALL: {
                ArchitecturalViewUpwardDependencyMinimizer.levelizeLeafNodes(workerContext, leafNodes, representation);
                break;
            }
            case ALPHA: 
            case LOC: 
            case SEC: {
                ArchitecturalViewNodeSorter.sortLeafNodes(workerContext, leafNodes, representation);
                break;
            }
            default: {
                assert (false) : "Unhandled sort mode: " + String.valueOf((Object)mode);
                break;
            }
        }
        LOGGER.debug("Sort - done [" + (System.currentTimeMillis() - start) + "]");
    }

    static void createAggregatedDependencies(boolean force, ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'createAggregatedDependencies' must not be null";
        if (force || !representation.inModification()) {
            LOGGER.debug("Create aggregated dependencies");
            ArchitecturalViewArchitectureCheck.check(representation);
            DependencyHandler.createDependencies(representation);
            LOGGER.debug("Create aggregated dependencies - done");
        }
    }

    static void removeAggregatedDependencies(boolean force, ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'removeAggregatedDependencies' must not be null";
        if (force || !representation.inModification()) {
            LOGGER.debug("Remove aggregated dependencies");
            DependencyHandler.removeDependencies(representation);
            LOGGER.debug("Remove aggregated dependencies - done");
        }
    }

    public static void updateAggregatedDependencies(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'updateAggregatedDependencies' must not be null";
        if (!representation.inModification()) {
            LOGGER.debug("Update aggregated dependencies");
            ArchitecturalViewArchitectureCheck.check(representation);
            DependencyHandler.updateDependencies(representation);
            LOGGER.debug("Update aggregated dependencies - done");
        }
    }

    static void reset(Map<AssignableToArtifactNode, NodeLocation> nodeToOriginalLocation, ExplorationViewRepresentation representation) {
        assert (nodeToOriginalLocation != null) : "Parameter 'nodeToOriginalLocation' of method 'reset' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'reset' must not be null";
        LOGGER.debug("Reset representation '" + representation.getElementInfo(true, false) + "'");
        for (Map.Entry<AssignableToArtifactNode, NodeLocation> nextEntry : nodeToOriginalLocation.entrySet()) {
            AssignableToArtifactNode nextNode = nextEntry.getKey();
            LOGGER.debug("Reset node location: " + nextNode.getElementInfo(true, false));
            nextNode.setPrototypeElement(null);
            RepresentationHandler.removeProgrammingElementsFromParents(nextNode);
            String nextRelPath = nextEntry.getValue().getParentPath();
            ArchitecturalViewElement nextTarget = ArchitecturalViewElementResolver.resolve(nextRelPath, ArchitecturalViewElement.class, representation, true);
            assert (nextTarget != null) : "'nextTarget' of method 'reset' must not be null";
            nextNode.changeParentAndOrPos(nextTarget, -1);
            RepresentationHandler.resetRelativePath(nextNode);
            RepresentationHandler.addProgrammingElementsToParents(nextNode);
        }
        NodeHandler.reset(representation);
        LOGGER.debug("Reset representation '" + representation.getElementInfo(true, false) + "' - done");
    }

    static PartialAlternativeInfo calculatePartialAlternativeInfo(Collection<ArchitecturalViewNode> nodes, List<Class<? extends ArchitecturalViewNode>> exclude) {
        assert (nodes != null && !nodes.isEmpty()) : "Parameter 'nodes' of method 'calculatePartialAlternativeInfo' must not be empty";
        assert (exclude != null) : "Parameter 'exclude' of method 'calculatePartialAlternativeInfo' must not be null";
        AssignableToArtifactNotRemovedByFocusCollector collector = new AssignableToArtifactNotRemovedByFocusCollector();
        ArrayList<ArchitecturalViewNode> replaceablePartialNodes = new ArrayList<ArchitecturalViewNode>();
        ArrayList<ArchitecturalViewNode> alternativeNodes = new ArrayList<ArchitecturalViewNode>();
        for (ArchitecturalViewNode nextNode : nodes) {
            if (nextNode.hasPartialElements() && !NodeHandler.exclude(nextNode, exclude)) {
                RecursiveNode nextRecursiveNode = NodeHandler.recursively(nextNode, nextNode.getPresentationMode());
                if (nextRecursiveNode == null) {
                    nextNode.accept(collector);
                } else {
                    for (NonRecursiveNode nextNonRecursiveNode : nextRecursiveNode.getChildren(NonRecursiveNode.class)) {
                        nextNonRecursiveNode.accept(collector);
                    }
                }
                if (!collector.isEmpty()) {
                    replaceablePartialNodes.add(nextNode);
                    alternativeNodes.addAll(collector.consume());
                    continue;
                }
                alternativeNodes.add(nextNode);
                continue;
            }
            alternativeNodes.add(nextNode);
        }
        if (replaceablePartialNodes.isEmpty()) {
            return null;
        }
        alternativeNodes.removeAll(replaceablePartialNodes);
        if (alternativeNodes.isEmpty()) {
            return null;
        }
        return new PartialAlternativeInfo(replaceablePartialNodes, alternativeNodes);
    }

    static final class ResetRelativePathVisitor
    extends ArchitecturalViewVisitor {
        ResetRelativePathVisitor() {
        }

        @Override
        public void visitArchitecturalViewElement(ArchitecturalViewElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewElement' must not be null";
            element.resetRelativePath();
            super.visitArchitecturalViewElement(element);
        }
    }
}

