/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewVisitor;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.NodeHandler;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.AssignableToArtifactNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewFocus;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.NonRecursiveNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ParserDependencyEndPoints;
import com.hello2morrow.sonargraph.core.model.explorationview.ProgrammingElementNode;
import com.hello2morrow.sonargraph.core.model.explorationview.RecursiveNode;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FocusApplyVisitor
extends ArchitecturalViewVisitor
implements ArchitecturalViewNode.IVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(FocusApplyVisitor.class);
    private final RemoveFromFocusVisitor m_removeFromFocusVisitor;
    private final ExplorationViewFocus m_focus;
    private final ExplorationViewRepresentation m_representation;

    static void applyFocus(ExplorationViewFocus focus, List<ProgrammingElementNode> created, ExplorationViewRepresentation representation) {
        assert (focus != null) : "Parameter 'focus' of method 'applyFocus' must not be null";
        assert (created != null && !created.isEmpty()) : "Parameter 'created' of method 'applyFocus' must not be empty";
        block0: for (ProgrammingElementNode next : created) {
            assert (!next.isDeleted()) : "Already deleted: " + next.getElementInfo();
            assert (!next.isRemovedByFocus()) : "Already removed by focus: " + next.getElementInfo();
            Collection<ProgrammingElement> relevantProgrammingElements = next.getRelevantProgrammingElements();
            assert (relevantProgrammingElements != null && !relevantProgrammingElements.isEmpty()) : "'relevantProgrammingElements' of method 'applyFocus' must not be empty";
            if (FocusApplyVisitor.nodeRemovedByFocus(relevantProgrammingElements, focus, representation)) {
                next.setRemovedByFocus(true);
                next.setExpanded(false);
                next.setSelected(false);
                continue;
            }
            List underlyingProgrammingElements = next.getUnderlyingProgrammingElements();
            for (ProgrammingElement nextProgrammingElement : relevantProgrammingElements) {
                if (underlyingProgrammingElements.contains(nextProgrammingElement) || focus.includesProgrammingElement(nextProgrammingElement)) continue;
                next.setHasPartialElements(true);
                continue block0;
            }
        }
    }

    static void hasPartialDependencies(ArchitecturalViewNode node) {
        assert (node != null) : "Parameter 'node' of method 'hasPartialDependencies' must not be null";
        if (!node.hasPartialDependencies()) {
            node.setHasPartialDependencies(true);
            ArchitecturalViewNode currentParent = node.getNodeParent();
            while (currentParent != null && !currentParent.hasPartialDependencies()) {
                currentParent.setHasPartialDependencies(true);
                currentParent = currentParent.getNodeParent();
            }
        }
    }

    private static boolean nodeRemovedByFocus(Collection<ProgrammingElement> programmingElements, ExplorationViewFocus focus, ExplorationViewRepresentation representation) {
        assert (programmingElements != null && !programmingElements.isEmpty()) : "Parameter 'programmingElements' of method 'removedByFocus' must not be empty";
        assert (focus != null) : "Parameter 'focus' of method 'removedByFocus' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'removedByFocus' must not be null";
        for (ProgrammingElement next : programmingElements) {
            if (!focus.includesProgrammingElement(next)) continue;
            return false;
        }
        ParserDependencyEndPoints endPoints = new ParserDependencyEndPoints();
        for (ProgrammingElement next : programmingElements) {
            Iterator<ParserDependency> depIter = next.getDependencyIterator();
            while (depIter.hasNext()) {
                ParserDependency nextParserDependency = depIter.next();
                if (!representation.includeParserDependency(nextParserDependency, endPoints) || !focus.includesParserDependency(nextParserDependency, endPoints.getFrom(), endPoints.getTo())) continue;
                return false;
            }
        }
        return true;
    }

    private FocusApplyVisitor(ExplorationViewFocus focus, ExplorationViewRepresentation representation) {
        assert (focus != null) : "Parameter 'focus' of method 'FocusApplyVisitor' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'FocusApplyVisitor' must not be null";
        this.m_removeFromFocusVisitor = new RemoveFromFocusVisitor(focus);
        this.m_focus = focus;
        this.m_representation = representation;
    }

    @Override
    public void visitArchitecturalViewNode(ArchitecturalViewNode element) {
        Collection<ProgrammingElement> relevantProgrammingElements;
        assert (element != null) : "Parameter 'element' of method 'visitArchitecturalViewNode' must not be null";
        boolean visitChildren = true;
        if (!element.isDeleted() && !element.isRemovedByFocus() && !(relevantProgrammingElements = element.getRelevantProgrammingElements()).isEmpty() && FocusApplyVisitor.nodeRemovedByFocus(relevantProgrammingElements, this.m_focus, this.m_representation)) {
            ArchitecturalViewNode currentParent = element.getNodeParent();
            while (currentParent != null && !currentParent.hasPartialElements()) {
                currentParent.setHasPartialElements(true);
                currentParent = currentParent.getNodeParent();
            }
            RecursiveNode recursiveNode = NodeHandler.recursively(element, element.getPresentationMode());
            if (recursiveNode == null) {
                element.accept(this.m_removeFromFocusVisitor);
                visitChildren = false;
            } else {
                recursiveNode.setRemovedByFocus(true);
                recursiveNode.setExpanded(false);
                recursiveNode.setSelected(false);
                for (NonRecursiveNode nextNonRecursiveNode : recursiveNode.getChildren(NonRecursiveNode.class)) {
                    nextNonRecursiveNode.accept(this.m_removeFromFocusVisitor);
                }
            }
        }
        if (visitChildren) {
            this.visitChildrenOf(element);
        }
        NodeHandler.updateExpandableState(element, this.m_representation);
        if (!element.isExpandable()) {
            element.setExpanded(false);
        }
    }

    static void apply(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'apply' must not be null";
        ExplorationViewFocus focus = representation.getFocus();
        focus.aboutToApply();
        if (!focus.isEmpty()) {
            LOGGER.debug("Apply focus: " + String.valueOf(focus));
            representation.accept(new FocusApplyVisitor(focus, representation));
            LOGGER.debug("Apply focus - done");
        }
        focus.applyFinished();
        LOGGER.debug("Not applied empty focus");
    }

    private static final class RemoveFromFocusVisitor
    extends ArchitecturalViewVisitor
    implements AssignableToArtifactNode.IVisitor,
    ArchitecturalViewNode.IVisitor {
        private final ExplorationViewFocus m_focus;

        RemoveFromFocusVisitor(ExplorationViewFocus focus) {
            assert (focus != null) : "Parameter 'focus' of method 'RemoveFromFocusVisitor' must not be null";
            this.m_focus = focus;
        }

        @Override
        public final void visitArchitecturalViewNode(ArchitecturalViewNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitAssignableNode' must not be null";
            element.setRemovedByFocus(true);
            element.setExpanded(false);
            element.setSelected(false);
            this.visitChildrenOf(element);
        }

        @Override
        public void visitAssignableToArtifactNode(AssignableToArtifactNode element) {
            assert (element != null) : "Parameter 'element' of method 'visitAssignableToArtifactNode' must not be null";
            this.m_focus.nodeRemovedByFocus(element);
            this.visitArchitecturalViewNode(element);
        }
    }
}

