/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.explorationview;

import com.hello2morrow.sonargraph.core.controller.system.dependenciesview.ArchitectureIssuesProcessor;
import com.hello2morrow.sonargraph.core.model.dependenciesview.DependenciesViewRepresentationInfo;
import com.hello2morrow.sonargraph.core.model.element.IVirtualModel;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import gnu.trove.set.hash.THashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArchitecturalViewArchitectureIssueProcessor
extends ArchitectureIssuesProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitecturalViewArchitectureIssueProcessor.class);
    private final Set<ArchitecturalViewNode> m_leafNodesWithViolations = new THashSet();
    private final Set<ArchitecturalViewNode> m_leafNodesWithIncomingViolations = new THashSet();
    private final Set<ArchitecturalViewNode> m_leafNodesWithDeprecations = new THashSet();
    private final ExplorationViewRepresentation m_representation;

    ArchitecturalViewArchitectureIssueProcessor(ExplorationViewRepresentation representation) {
        assert (representation != null) : "Parameter 'representation' of method 'ArchitecturalViewArchitectureIssueProcessor' must not be null";
        this.m_representation = representation;
    }

    @Override
    protected void clear(DependenciesViewRepresentationInfo info) {
        ArchitecturalViewNode current;
        ProgrammingElement nextFrom;
        for (ParserDependency nextParserDependency : info.getViolations(true).keySet()) {
            ProgrammingElement nextTo;
            ArchitecturalViewNode nextToLeafNode;
            nextFrom = nextParserDependency.getFrom();
            ArchitecturalViewNode nextFromLeafNode = this.m_representation.getLeafNode(nextFrom);
            if (nextFromLeafNode != null) {
                current = nextFromLeafNode;
                while (current != null && current.hasViolation()) {
                    current.setHasViolation(false);
                    current = current.getNodeParent();
                }
            } else {
                LOGGER.error("No from leaf node found for: " + String.valueOf(nextFrom));
            }
            if ((nextToLeafNode = this.m_representation.getLeafNode(nextTo = nextParserDependency.getTo())) != null) {
                ArchitecturalViewNode current2 = nextToLeafNode;
                while (current2 != null && current2.hasIncomingViolation()) {
                    current2.setHasIncomingViolation(false);
                    current2 = current2.getNodeParent();
                }
                continue;
            }
            LOGGER.error("No to leaf node found for: " + String.valueOf(nextTo));
        }
        LOGGER.debug("Reset architecture deprecations in read only mode");
        for (ParserDependency nextParserDependency : info.getDeprecations(true).keySet()) {
            nextFrom = nextParserDependency.getFrom();
            ArchitecturalViewNode nextLeafNode = this.m_representation.getLeafNode(nextFrom);
            if (nextLeafNode != null) {
                current = nextLeafNode;
                while (current != null && current.hasDeprecation()) {
                    current.setHasDeprecation(false);
                    current = current.getNodeParent();
                }
                continue;
            }
            LOGGER.error("No leaf node found for: " + String.valueOf(nextFrom));
        }
        super.clear(info);
    }

    @Override
    protected void hasArchitectureViolation(ProgrammingElement from, ProgrammingElement to) {
        assert (from != null) : "Parameter 'from' of method 'hasArchitectureViolation' must not be null";
        assert (to != null) : "Parameter 'to' of method 'hasArchitectureViolation' must not be null";
        ArchitecturalViewNode fromLeaf = this.m_representation.getLeafNode(from);
        if (fromLeaf == null) {
            LOGGER.error("No from leaf node found for: " + String.valueOf(from));
        } else {
            this.m_leafNodesWithViolations.add(fromLeaf);
        }
        ArchitecturalViewNode toLeaf = this.m_representation.getLeafNode(to);
        if (toLeaf == null) {
            LOGGER.error("No to leaf node found for: " + String.valueOf(to));
        } else {
            this.m_leafNodesWithIncomingViolations.add(toLeaf);
        }
    }

    @Override
    protected void hasArchitectureDeprecation(ProgrammingElement from) {
        assert (from != null) : "Parameter 'from' of method 'hasArchitectureDeprecation' must not be null";
        ArchitecturalViewNode leaf = this.m_representation.getLeafNode(from);
        if (leaf == null) {
            LOGGER.error("No leaf node found for: " + String.valueOf(from));
        } else {
            this.m_leafNodesWithDeprecations.add(leaf);
        }
    }

    @Override
    public void process(IVirtualModel virtualModel, String basedOnArchitectureFileIdentifyingPath, boolean isLogical, DependenciesViewRepresentationInfo info) {
        ArchitecturalViewNode current;
        super.process(virtualModel, basedOnArchitectureFileIdentifyingPath, isLogical, info);
        for (ArchitecturalViewNode nextLeafNode : this.m_leafNodesWithViolations) {
            nextLeafNode.setHasViolation(true);
            current = nextLeafNode.getNodeParent();
            while (current != null && !current.hasViolation()) {
                current.setHasViolation(true);
                current = current.getNodeParent();
            }
        }
        for (ArchitecturalViewNode nextLeafNode : this.m_leafNodesWithIncomingViolations) {
            nextLeafNode.setHasIncomingViolation(true);
            current = nextLeafNode.getNodeParent();
            while (current != null && !current.hasIncomingViolation()) {
                current.setHasIncomingViolation(true);
                current = current.getNodeParent();
            }
        }
        for (ArchitecturalViewNode nextLeafNode : this.m_leafNodesWithDeprecations) {
            nextLeafNode.setHasDeprecation(true);
            current = nextLeafNode.getNodeParent();
            while (current != null && !current.hasDeprecation()) {
                current.setHasDeprecation(true);
                current = current.getNodeParent();
            }
        }
        this.m_leafNodesWithViolations.clear();
        this.m_leafNodesWithIncomingViolations.clear();
        this.m_leafNodesWithDeprecations.clear();
    }
}

