/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.AbstractIssueDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.MetricDiffProcessor;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.ThresholdViolationIssue;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.ThresholdViolationIssueDiff;
import com.hello2morrow.sonargraph.foundation.utilities.NumberUtility;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import com.hello2morrow.sonargraph.integration.access.model.INamedElement;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.IThresholdViolationIssue;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ThresholdIssueDiffProcessor
extends AbstractIssueDiffProcessor<IThresholdViolationIssue, ThresholdViolationIssue> {
    public ThresholdIssueDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, Set<IIssue> allBaselineIssues, SoftwareSystem currentSystem, Set<Issue> allCurrentIssues, Map<NamedElement, String> namedElementToFqNameCache) {
        super(baselineSystem, baselineSystemInfoProcessor, allBaselineIssues, currentSystem, allCurrentIssues, namedElementToFqNameCache, IThresholdViolationIssue.class, ThresholdViolationIssue.class);
    }

    @Override
    protected Set<IssueCategory> getToleratedIssueCategories() {
        return EnumSet.of(IssueCategory.THRESHOLD_VIOLATION);
    }

    @Override
    protected void computeDiffs(NamedElement parent, List<IThresholdViolationIssue> baselineIssues, List<ThresholdViolationIssue> currentIssues) {
        assert (parent != null) : "Parameter 'parent' of method 'computeDiffs' must not be null";
        assert (baselineIssues != null) : "Parameter 'baselineIssues' of method 'computeDiffs' must not be null";
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'computeDiffs' must not be null";
        HashMap<String, Map> baselineFqNameToMetricIdToIssue = new HashMap<String, Map>();
        for (IThresholdViolationIssue nextBaseline : baselineIssues) {
            String fqName = this.getBaselineOriginalFqName((INamedElement)nextBaseline.getAffectedNamedElements().get(0));
            Map metricIdToIssue = baselineFqNameToMetricIdToIssue.computeIfAbsent(fqName, name -> new HashMap(2));
            String metricId = nextBaseline.getThreshold().getMetricId().getName();
            metricIdToIssue.put(metricId, nextBaseline);
        }
        HashMap<String, Map> currentFqNameToMetricIdToIssue = new HashMap<String, Map>();
        for (Issue issue : currentIssues) {
            assert (issue != null && issue instanceof ThresholdViolationIssue) : "Unexpected class in method 'computeDiffs': " + String.valueOf(issue);
            ThresholdViolationIssue thresholdIssue = (ThresholdViolationIssue)issue;
            String fqName = this.getOrCreateFqNameFromCachedElement(thresholdIssue.getAffectedElement());
            Map metricIdToIssue = currentFqNameToMetricIdToIssue.computeIfAbsent(fqName, name -> new HashMap(2));
            String metricId = thresholdIssue.getThreshold().getMetricDescriptor().getMetricId().getStandardName();
            metricIdToIssue.put(metricId, thresholdIssue);
        }
        for (Map.Entry entry : baselineFqNameToMetricIdToIssue.entrySet()) {
            ThresholdViolationIssueDiff diff;
            String baselineFqName = (String)entry.getKey();
            Map baselineMetricIdToIssue = (Map)entry.getValue();
            Map currentMetricIdToIssue = (Map)currentFqNameToMetricIdToIssue.remove(baselineFqName);
            if (currentMetricIdToIssue != null) {
                for (Map.Entry baselineEntry : baselineMetricIdToIssue.entrySet()) {
                    String metricId = (String)baselineEntry.getKey();
                    IThresholdViolationIssue baselineIssue = (IThresholdViolationIssue)baselineEntry.getValue();
                    ThresholdViolationIssue currentIssue = (ThresholdViolationIssue)currentMetricIdToIssue.remove(metricId);
                    if (currentIssue != null) {
                        ThresholdViolationIssueDiff diff2;
                        Pair<IDiffElement.Change, String> resolutionChange = this.determineResolutionChange(baselineIssue, currentIssue);
                        Pair<IDiffElement.Change, Number> valueChange = this.interpretValueChange(baselineIssue, currentIssue);
                        IDiffElement.Change severityChange = this.determineSeverityChange(baselineIssue, currentIssue);
                        IDiffElement.Change resultingChange = this.createThresholdChange((IDiffElement.Change)((Object)resolutionChange.getFirst()), severityChange, (IDiffElement.Change)((Object)valueChange.getFirst()));
                        String changeDetails = this.createChangeDetails(baselineIssue, currentIssue, (String)resolutionChange.getSecond(), (IDiffElement.Change)((Object)valueChange.getFirst()), (Number)valueChange.getSecond(), severityChange);
                        if (changeDetails != null) {
                            ThresholdViolationIssueDiff diff3 = new ThresholdViolationIssueDiff(parent, baselineIssue, currentIssue, resultingChange, changeDetails);
                        } else {
                            diff2 = new ThresholdViolationIssueDiff(parent, baselineIssue, currentIssue, resultingChange);
                        }
                        parent.addChild(diff2);
                        continue;
                    }
                    ThresholdViolationIssueDiff diff3 = new ThresholdViolationIssueDiff(parent, (IThresholdViolationIssue)baselineEntry.getValue(), null, IDiffElement.Change.REMOVED);
                    parent.addChild(diff3);
                }
                for (Map.Entry currentMetricIdToIssueEntry : currentMetricIdToIssue.entrySet()) {
                    diff = new ThresholdViolationIssueDiff(parent, null, (ThresholdViolationIssue)currentMetricIdToIssueEntry.getValue(), IDiffElement.Change.ADDED);
                    parent.addChild(diff);
                }
                continue;
            }
            for (Map.Entry baselineEntry : baselineMetricIdToIssue.entrySet()) {
                diff = new ThresholdViolationIssueDiff(parent, (IThresholdViolationIssue)baselineEntry.getValue(), null, IDiffElement.Change.REMOVED);
                parent.addChild(diff);
            }
        }
        for (Map.Entry entry : currentFqNameToMetricIdToIssue.entrySet()) {
            for (Map.Entry currentMetricIdToIssueEntry : ((Map)entry.getValue()).entrySet()) {
                ThresholdViolationIssueDiff diff = new ThresholdViolationIssueDiff(parent, null, (ThresholdViolationIssue)currentMetricIdToIssueEntry.getValue(), IDiffElement.Change.ADDED);
                parent.addChild(diff);
            }
        }
    }

    private Pair<IDiffElement.Change, Number> interpretValueChange(IThresholdViolationIssue baselineIssue, ThresholdViolationIssue currentIssue) {
        float lowerThreshold;
        float value;
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'interpretValueChange' must not be null";
        assert (currentIssue != null) : "Parameter 'currentIssue' of method 'interpretValueChange' must not be null";
        IMetricId metricId = currentIssue.getThreshold().getMetricDescriptor().getMetricId();
        Pair<IDiffElement.Change, Pair<Number, Number>> valueChange = MetricDiffProcessor.determineChangeOfValues(metricId, baselineIssue.getMetricValue(), currentIssue.getValue(), true);
        IDiffElement.Change interpretedChange = metricId.isFloat() ? ((value = currentIssue.getValue().floatValue()) < (lowerThreshold = currentIssue.getThreshold().getLowerThreshold().floatValue()) && valueChange.getFirst() == IDiffElement.Change.WORSENED ? IDiffElement.Change.IMPROVED : (IDiffElement.Change)((Object)valueChange.getFirst())) : ((value = currentIssue.getValue().intValue()) < (lowerThreshold = currentIssue.getThreshold().getLowerThreshold().intValue()) && valueChange.getFirst() == IDiffElement.Change.WORSENED ? IDiffElement.Change.IMPROVED : (IDiffElement.Change)((Object)valueChange.getFirst()));
        return new Pair((Object)interpretedChange, (Object)((Number)((Pair)valueChange.getSecond()).getFirst()));
    }

    private IDiffElement.Change createThresholdChange(IDiffElement.Change resolutionChange, IDiffElement.Change severityChange, IDiffElement.Change valueChange) {
        assert (resolutionChange != null) : "Parameter 'resolutionChange' of method 'createThresholdChange' must not be null";
        assert (valueChange != null) : "Parameter 'valueChange' of method 'createThresholdChange' must not be null";
        assert (severityChange != null) : "Parameter 'severityChange' of method 'createThresholdChange' must not be null";
        if (resolutionChange != IDiffElement.Change.UNMODIFIED) {
            return resolutionChange;
        }
        if (severityChange != IDiffElement.Change.UNMODIFIED) {
            return severityChange;
        }
        if (valueChange != IDiffElement.Change.UNMODIFIED) {
            return valueChange;
        }
        return resolutionChange;
    }

    private String createChangeDetails(IThresholdViolationIssue baselineIssue, ThresholdViolationIssue currentIssue, String resolutionChange, IDiffElement.Change valueChange, Number valueDifference, IDiffElement.Change severityChange) {
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'createChangeDetails' must not be null";
        assert (currentIssue != null) : "Parameter 'currentIssue' of method 'createChangeDetails' must not be null";
        assert (resolutionChange != null) : "Parameter 'resolutionChange' of method 'createChangeDetails' must not be null";
        assert (valueChange != null) : "Parameter 'valueChange' of method 'createChangeDetails' must not be null";
        assert (valueDifference != null) : "Parameter 'valueDifference' of method 'createChangeDetails' must not be null";
        assert (severityChange != null) : "Parameter 'severityChange' of method 'createChangeDetails' must not be null";
        boolean isFloat = currentIssue.getThreshold().getMetricDescriptor().getMetricId().isFloat();
        StringBuilder result = new StringBuilder();
        if (resolutionChange.length() > 0) {
            result.append(resolutionChange);
        }
        if (valueChange != IDiffElement.Change.UNMODIFIED) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("Value changed: ");
            Number baselineValue = isFloat ? (Number)Float.valueOf(baselineIssue.getMetricValue().floatValue()) : (Number)baselineIssue.getMetricValue().intValue();
            result.append(NumberUtility.format((Number)baselineValue)).append(" -> ").append(NumberUtility.format((Number)currentIssue.getValue()));
            result.append(" (");
            if (valueDifference.floatValue() > 0.0f) {
                result.append("+");
            }
            result.append(NumberUtility.format((Number)valueDifference));
            result.append(")");
        }
        if (severityChange != IDiffElement.Change.UNMODIFIED) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("Severity changed: ");
            result.append(baselineIssue.getThreshold().getSeverity().getPresentationName()).append(" -> ").append(currentIssue.getThreshold().getSeverity().getPresentationName());
        }
        return result.length() == 0 ? null : result.toString();
    }

    private IDiffElement.Change determineSeverityChange(IThresholdViolationIssue baselineIssue, ThresholdViolationIssue currentIssue) {
        assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'determineSeverityChange' must not be null";
        assert (currentIssue != null) : "Parameter 'currentIssue' of method 'determineSeverityChange' must not be null";
        com.hello2morrow.sonargraph.integration.access.model.Severity baselineSeverity = baselineIssue.getThreshold().getSeverity();
        Severity currentSeverity = currentIssue.getThreshold().getSeverity();
        assert (currentSeverity == Severity.WARNING || currentSeverity == Severity.ERROR) : "Unsupported current threshold severity: " + String.valueOf((Object)currentSeverity);
        switch (baselineSeverity) {
            case WARNING: {
                if (currentSeverity == Severity.WARNING) {
                    return IDiffElement.Change.UNMODIFIED;
                }
                if (currentSeverity == Severity.ERROR) {
                    return IDiffElement.Change.WORSENED;
                }
                assert (false) : "Unexpected transition to " + String.valueOf((Object)currentSeverity);
                return null;
            }
            case ERROR: {
                if (currentSeverity == Severity.ERROR) {
                    return IDiffElement.Change.UNMODIFIED;
                }
                if (currentSeverity == Severity.WARNING) {
                    return IDiffElement.Change.IMPROVED;
                }
                assert (false) : "Unexpected transition to " + String.valueOf((Object)currentSeverity);
                return null;
            }
        }
        assert (false) : "Unsupported threshold severity " + String.valueOf(baselineSeverity);
        return null;
    }
}

