/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.IResolutionChangeProvider;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.system.diff.IDiffElement;
import com.hello2morrow.sonargraph.core.model.system.diff.issue.IssueDiff;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.integration.access.model.IIssue;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

abstract class SimpleIssueMatcher<B extends IIssue, C extends Issue> {
    private final IResolutionChangeProvider<B, C> m_resolutionChangeProvider;

    public SimpleIssueMatcher(IResolutionChangeProvider<B, C> resolutionChangeProvider) {
        assert (resolutionChangeProvider != null) : "Parameter 'resolutionChangeProvider' of method 'SimpleIssueMatcher' must not be null";
        this.m_resolutionChangeProvider = resolutionChangeProvider;
    }

    public final void matchIssues(NamedElement parent, List<B> baselineIssues, List<C> currentIssues) {
        assert (parent != null) : "Parameter 'parent' of method 'matchIssues' must not be null";
        assert (baselineIssues != null) : "Parameter 'baselineIssues' of method 'matchIssues' must not be null";
        assert (currentIssues != null) : "Parameter 'currentIssues' of method 'matchIssues' must not be null";
        LinkedHashSet<B> baselineNamedElementIssues = new LinkedHashSet<B>(baselineIssues);
        LinkedHashSet<C> currentNamedElementIssues = new LinkedHashSet<C>(currentIssues);
        this.processIssues(parent, baselineIssues, baselineNamedElementIssues, currentNamedElementIssues);
        baselineNamedElementIssues.forEach(baselineIssue -> {
            IssueDiff<IIssue, Object> diff = this.createDiff(parent, baselineIssue, null, IDiffElement.Change.REMOVED, null);
            parent.addChild(diff);
        });
        currentNamedElementIssues.forEach(currentIssue -> {
            IssueDiff<Object, Issue> diff = this.createDiff(parent, null, currentIssue, IDiffElement.Change.ADDED, null);
            parent.addChild(diff);
        });
    }

    protected void processIssues(NamedElement parent, List<B> baselineIssues, Set<B> baselineNamedElementIssues, Set<C> currentNamedElementIssues) {
        for (IIssue nextBaselineIssue : baselineIssues) {
            MatchResult<IIssue, C> matchResult = this.findMatchingIssue(nextBaselineIssue, currentNamedElementIssues);
            if (matchResult == null) continue;
            this.handleMatch(parent, baselineNamedElementIssues, currentNamedElementIssues, matchResult);
        }
    }

    protected void handleMatch(NamedElement parent, Set<B> baselineNamedElementIssues, Set<C> currentNamedElementIssues, MatchResult<B, C> matchResult) {
        IDiffElement.Change resultingChange;
        assert (parent != null) : "Parameter 'parent' of method 'handleMatch' must not be null";
        assert (baselineNamedElementIssues != null) : "Parameter 'baselineNamedElementIssues' of method 'handleMatch' must not be null";
        assert (currentNamedElementIssues != null) : "Parameter 'currentNamedElementIssues' of method 'handleMatch' must not be null";
        assert (matchResult != null) : "Parameter 'matchResult' of method 'handleMatch' must not be null";
        Pair<IDiffElement.Change, String> resolutionChange = this.m_resolutionChangeProvider.determineResolutionChange((IIssue)matchResult.getBaselineIssue(), (Issue)matchResult.getCurrentIssue());
        StringBuilder changeDescription = new StringBuilder();
        if (resolutionChange.getFirst() != IDiffElement.Change.UNMODIFIED) {
            resultingChange = (IDiffElement.Change)((Object)resolutionChange.getFirst());
            changeDescription.append((String)resolutionChange.getSecond());
        } else {
            resultingChange = matchResult.getChange();
        }
        if (matchResult.getChange() != IDiffElement.Change.UNMODIFIED) {
            if (changeDescription.length() > 0) {
                changeDescription.append(". ");
            }
            changeDescription.append(matchResult.getChangeDescription());
        }
        IssueDiff<IIssue, Issue> diff = this.createDiff(parent, (IIssue)matchResult.getBaselineIssue(), (Issue)matchResult.getCurrentIssue(), resultingChange, changeDescription.toString());
        parent.addChild(diff);
        currentNamedElementIssues.remove(matchResult.getCurrentIssue());
        baselineNamedElementIssues.remove(matchResult.getBaselineIssue());
    }

    protected abstract IssueDiff<B, C> createDiff(NamedElement var1, B var2, C var3, IDiffElement.Change var4, String var5);

    protected abstract MatchResult<B, C> findMatchingIssue(B var1, Set<C> var2);

    public static final class MatchResult<B, C> {
        private final B m_baselineIssue;
        private final C m_currentIssue;
        private final double m_similarity;
        private final IDiffElement.Change m_change;
        private final String m_changeDescription;

        public MatchResult(B baselineIssue, C currentIssue, double similarity, IDiffElement.Change change, String changeDescription) {
            assert (baselineIssue != null) : "Parameter 'baselineIssue' of method 'MatchResult' must not be null";
            assert (currentIssue != null) : "Parameter 'currentIssue' of method 'MatchResult' must not be null";
            assert (change != null) : "Parameter 'change' of method 'MatchResult' must not be null";
            assert (changeDescription != null) : "Parameter 'changeDescription' of method 'MatchResult' must not be null";
            this.m_baselineIssue = baselineIssue;
            this.m_currentIssue = currentIssue;
            this.m_similarity = similarity;
            this.m_change = change;
            this.m_changeDescription = changeDescription;
        }

        public B getBaselineIssue() {
            return this.m_baselineIssue;
        }

        public C getCurrentIssue() {
            return this.m_currentIssue;
        }

        public double getSimilarity() {
            return this.m_similarity;
        }

        public IDiffElement.Change getChange() {
            return this.m_change;
        }

        public String getChangeDescription() {
            return this.m_changeDescription;
        }
    }
}

