/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.diff;

import com.hello2morrow.sonargraph.core.controller.system.diff.AbstractResolutionDiffProcessor;
import com.hello2morrow.sonargraph.core.controller.system.diff.BaselinePriorityConverter;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.resolution.TaskDefinition;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.controller.ISystemInfoProcessor;
import com.hello2morrow.sonargraph.integration.access.model.ISoftwareSystem;
import com.hello2morrow.sonargraph.integration.access.model.ITaskDefinition;
import com.hello2morrow.sonargraph.integration.access.model.ResolutionType;
import java.util.StringJoiner;

public abstract class AbstractTaskResolutionDiffProcessor<B extends ITaskDefinition, C extends TaskDefinition>
extends AbstractResolutionDiffProcessor<B, C> {
    public AbstractTaskResolutionDiffProcessor(ISoftwareSystem baselineSystem, ISystemInfoProcessor baselineSystemInfoProcessor, SoftwareSystem currentSystem, ResolutionType resolutionType, Class<B> baselineResolutionClass, Class<C> currentResolutionClass) {
        super(baselineSystem, baselineSystemInfoProcessor, currentSystem, resolutionType, baselineResolutionClass, currentResolutionClass);
    }

    @Override
    protected void addToChangeDescription(B baseline, C current, StringJoiner changeDescriptionParts) {
        Priority baselinePriority = BaselinePriorityConverter.convertPriority(baseline.getPriority());
        if (baselinePriority != ((TaskDefinition)current).getPriority()) {
            changeDescriptionParts.add("Priority: " + baseline.getPriority().getPresentationName() + " -> " + ((TaskDefinition)current).getPriority().getPresentationName());
        }
        if (!baseline.getAssignee().equals(((TaskDefinition)current).getAssignee())) {
            changeDescriptionParts.add("Assignee: " + baseline.getAssignee() + " -> " + ((TaskDefinition)current).getAssignee());
        }
    }
}

