/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.architecture;

import com.hello2morrow.javapg.runtime.messaging.MessageReporter;
import com.hello2morrow.javapg.runtime.messaging.Position;
import com.hello2morrow.javapg.runtime.tree.InnerNode;
import com.hello2morrow.javapg.runtime.tree.Visitor;
import com.hello2morrow.sonargraph.core.controller.system.analysis.IArchitectureFileAccess;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchParser;
import com.hello2morrow.sonargraph.core.controller.system.architecture.ArchitectureBuilder;
import com.hello2morrow.sonargraph.core.controller.system.architecture.IArchitectureFileLoader;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFileIssue;
import com.hello2morrow.sonargraph.core.model.architecture.ConnectionScheme;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArchitectureFileLoader
implements IArchitectureFileLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitectureFileLoader.class);
    private final IArchitectureFileAccess m_architectureFileAccess;
    private final Deque<ArchitectureFile> m_loadStack = new ArrayDeque<ArchitectureFile>();

    public ArchitectureFileLoader(IArchitectureFileAccess access) {
        assert (access != null) : "Parameter 'access' of method 'ArchitectureFileLoader' must not be null";
        this.m_architectureFileAccess = access;
    }

    public void readArchitectureFile(final ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'readArchitectureFile' must not be null";
        ArchParser parser = new ArchParser(new MessageReporter(){

            public void reportMessage(int severity, Position pos, String msg) {
                LOGGER.debug("Syntax error in architecture file {} at line {} position {}", new Object[]{architectureFile, pos.getLine(), pos.getColumn()});
                architectureFile.addIssue(new ArchitectureFileIssue(architectureFile, msg, pos.getLine(), pos.getColumn()));
            }
        });
        ArchitectureBuilder builder = new ArchitectureBuilder(architectureFile, this, this.m_architectureFileAccess, this.m_architectureFileAccess.getSupportedModels(), this.m_architectureFileAccess.getUsedLanguages());
        String fileContent = this.m_architectureFileAccess.getArchitectureFileContentForCompilation(architectureFile.getIdentifyingPath());
        LOGGER.debug("readArchitectureFile {} with content", (Object)architectureFile.getIdentifyingPath());
        try {
            Throwable throwable = null;
            Object var6_9 = null;
            try (StringReader reader = new StringReader(fileContent);){
                InnerNode ast = parser.parse(reader, architectureFile.getName());
                if (ast != null) {
                    ast.accept((Visitor)builder);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            assert (false) : "We are not reading from a file - should not happen: " + ExceptionUtility.collectAll((Throwable)e);
        }
        catch (Throwable t) {
            LOGGER.error("Exception while analyzing architecture file " + architectureFile.getIdentifyingPath(), t);
            architectureFile.removeChildren(ArchitectureElement.class, ConnectionScheme.class);
            throw t;
        }
        architectureFile.modelLoaded(true);
    }

    public void loadArchitectureFile(ArchitectureFile architectureFile) {
        assert (architectureFile != null) : "Parameter 'architectureFile' of method 'loadArchitectureFile' must not be null";
        this.m_loadStack.push(architectureFile);
        this.readArchitectureFile(architectureFile);
        this.m_loadStack.pop();
    }

    @Override
    public ArchitectureFile loadArchitectureFile(String name, Consumer<String> errorMessageConsumer) {
        ArchitectureFile architectureFile;
        Object identifyingPath;
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'loadArchitectureFile' must not be empty";
        assert (errorMessageConsumer != null) : "Parameter 'errorMessageConsumer' of method 'loadArchitectureFile' must not be null";
        Object object = identifyingPath = !name.startsWith("./") ? "./" + name : name;
        if (!CoreFileType.ARCHITECTURE.endsWith((String)identifyingPath)) {
            identifyingPath = (String)identifyingPath + CoreFileType.ARCHITECTURE.getDefaultExtension();
        }
        if ((architectureFile = this.m_architectureFileAccess.getArchitectureFile((String)identifyingPath)) == null) {
            String fileName = name.endsWith(CoreFileType.ARCHITECTURE.getDefaultExtension()) ? name : name + CoreFileType.ARCHITECTURE.getDefaultExtension();
            String msg = String.format("Cannot locate architecture file '%s'", fileName);
            errorMessageConsumer.accept(msg);
            return null;
        }
        if (this.m_loadStack.contains(architectureFile)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Recursive inclusion of architecture files: ");
            this.m_loadStack.stream().forEach(af -> {
                StringBuilder stringBuilder2 = sb.append(af.getShortName()).append("->");
            });
            sb.append(name);
            errorMessageConsumer.accept(sb.toString());
            return null;
        }
        if (!architectureFile.modelLoaded()) {
            this.loadArchitectureFile(architectureFile);
        }
        return architectureFile;
    }
}

