/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.duplicate;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.DuplicateBlockInfo;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.DuplicateBlockInfoEQClass;
import com.hello2morrow.sonargraph.core.foundation.common.duplicatecode.DuplicateCodeChecker;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlock;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockIssue;
import com.hello2morrow.sonargraph.core.model.analysis.DuplicateCodeBlockOccurrence;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.SourceFileIssueParticipationInfo;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ResolutionNameComparator;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.system.IRelevantSourceFileIterator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import com.hello2morrow.sonargraph.foundation.utilities.StrictPair;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DuplicateCodeAnalyzerAdapter
extends AnalyzerAdapter {
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.DUPLICATE_CODE;
    private static final Logger LOGGER = LoggerFactory.getLogger(DuplicateCodeAnalyzerAdapter.class);

    public DuplicateCodeAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, ID);
    }

    @Override
    public void runJobs(AnalyzerResult result) {
        DuplicateCodeAnalyzerJob job = new DuplicateCodeAnalyzerJob(this.getGroup(), result, this.getController());
        job.start();
    }

    @Override
    protected List<IIssueId> getIssueIds(AnalyzerResult result) {
        ArrayList<IIssueId> ids = new ArrayList<IIssueId>(super.getIssueIds(result));
        ids.add(CoreIssueId.DUPLICATE_CODE_BLOCK);
        return ids;
    }

    @Override
    protected boolean clearResult(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'clearResult' must not be null";
        result.removeChildren(SourceFileIssueParticipationInfo.class);
        return super.clearResult(result);
    }

    @Override
    public boolean canStoreResult() {
        return true;
    }

    @Override
    protected void resultSuccessfullyRestored(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
        DuplicateCodeAnalyzerAdapter.fillCache(result);
        super.resultSuccessfullyRestored(result);
    }

    private static void fillCache(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'fillCache' must not be null";
        assert (result.getFirstChild(SourceFileIssueParticipationInfo.class) == null) : "Info already present";
        SourceFileIssueParticipationInfo<DuplicateCodeBlockIssue> info = new SourceFileIssueParticipationInfo<DuplicateCodeBlockIssue>(result);
        result.addChild(info);
        for (DuplicateCodeBlock nextCodeBlock : result.getChildren(DuplicateCodeBlock.class)) {
            THashSet sourceFiles = new THashSet();
            for (DuplicateCodeBlockOccurrence nextOccurrence : nextCodeBlock.getChildren(DuplicateCodeBlockOccurrence.class)) {
                sourceFiles.add(nextOccurrence.getSourceFile());
            }
            info.add((DuplicateCodeBlockIssue)nextCodeBlock.getAssociatedIssue(), (Set<SourceFile>)sourceFiles);
        }
        info.finishModification();
    }

    private boolean toleranceAndDistanceMatches(DuplicateCodeBlock nextCodeBlock) {
        StrictPair<String, Double> matchingInfoSummary = nextCodeBlock.getMatchingInfoSummary();
        double differenceRatio = (Double)matchingInfoSummary.getSecond();
        double threshold = 0.1;
        if (Double.compare(differenceRatio, 0.1) > 0) {
            LOGGER.debug("Difference in tolerance and distance detected with a ratio of diff/occurrence-size {} > {}: {}", new Object[]{differenceRatio, 0.1, matchingInfoSummary.getFirst()});
            return false;
        }
        return true;
    }

    private final class DuplicateCodeAnalyzerJob
    extends AnalyzerJob {
        DuplicateCodeAnalyzerJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(group, result, controller);
        }

        @Override
        public void internalRun() {
            DuplicateCodeAnalyzerConfiguration configuration = this.getAnalyzer().getConfiguration(DuplicateCodeAnalyzerConfiguration.class);
            assert (configuration != null) : "'configuration' of method 'internalRun' must not be null";
            int minimalLineLength = configuration.getMinimalLineLength();
            int maximalTolerance = configuration.getMaximalTolerancePerEdit();
            int minimalBlockLength = configuration.getMinimalBlockLength();
            int maximumNumberOfCopies = configuration.getMaximumNumberOfCopies();
            int maximumRelativeTolerancePercentage = configuration.getMaximumRelativeTolerancePercentage();
            IWorkerContext workerContext = this.getWorkerContext();
            DuplicateCodeChecker duplicateCodeChecker = new DuplicateCodeChecker(minimalLineLength, maximalTolerance, minimalBlockLength, maximumNumberOfCopies, maximumRelativeTolerancePercentage, workerContext);
            IRelevantSourceFileIterator relevantSourceFileIterator = this.getSoftwareSystem().getExtension(ISoftwareSystemProvider.class).getRelevantSourceFileIterator();
            List<DuplicateBlockInfoEQClass> duplicateBlockInfoEQClassList = duplicateCodeChecker.compute(relevantSourceFileIterator, relevantSourceFileIterator.getTotalNumberOfRelevantSourceFiles());
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            assert (duplicateBlockInfoEQClassList != null) : "'duplicateBlockInfoEQClassList' of method 'internalRun' must not be null";
            int counter = 1;
            ArrayList<DuplicateCodeBlock> duplicateCodeBlocks = new ArrayList<DuplicateCodeBlock>();
            DuplicateCodeBlockOccurrenceComparator comparator = new DuplicateCodeBlockOccurrenceComparator();
            for (DuplicateBlockInfoEQClass nextDuplicateBlockInfoEQClass : duplicateBlockInfoEQClassList) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                List<DuplicateBlockInfo> nextOccurrences = nextDuplicateBlockInfoEQClass.getElements();
                if (nextOccurrences.size() < 2) continue;
                DuplicateCodeBlock nextCodeBlock = new DuplicateCodeBlock(null, nextDuplicateBlockInfoEQClass, counter++);
                ArrayList<DuplicateCodeBlockOccurrence> occurrences = new ArrayList<DuplicateCodeBlockOccurrence>(nextOccurrences.size());
                for (DuplicateBlockInfo nextBlockInfo : nextOccurrences) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    DuplicateCodeBlockOccurrence nextOccurrence = new DuplicateCodeBlockOccurrence(nextCodeBlock, nextBlockInfo);
                    occurrences.add(nextOccurrence);
                }
                Collections.sort(occurrences, comparator);
                for (DuplicateCodeBlockOccurrence occ : occurrences) {
                    nextCodeBlock.addChild(occ);
                }
                duplicateCodeBlocks.add(nextCodeBlock);
            }
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            Collections.sort(duplicateCodeBlocks, ResolutionNameComparator.INSTANCE);
            AnalyzerResult result = this.getResult();
            for (DuplicateCodeBlock nextCodeBlock : duplicateCodeBlocks) {
                nextCodeBlock.setParent(result);
                result.addChild(nextCodeBlock);
                DuplicateCodeBlockIssue nextIssue = new DuplicateCodeBlockIssue(nextCodeBlock, nextCodeBlock.createIssueDescription());
                nextCodeBlock.addIssue(nextIssue);
            }
            if (LOGGER.isDebugEnabled()) {
                int mismatchCount = 0;
                for (DuplicateCodeBlock nextCodeBlock : duplicateCodeBlocks) {
                    if (DuplicateCodeAnalyzerAdapter.this.toleranceAndDistanceMatches(nextCodeBlock)) continue;
                    ++mismatchCount;
                }
                LOGGER.debug("{} of {} duplicate code blocks contain occurrences where tolerance and distance values differ.", (Object)mismatchCount, (Object)duplicateCodeBlocks.size());
            }
            DuplicateCodeAnalyzerAdapter.fillCache(result);
        }
    }

    static final class DuplicateCodeBlockOccurrenceComparator
    implements Comparator<NamedElement> {
        DuplicateCodeBlockOccurrenceComparator() {
        }

        @Override
        public int compare(NamedElement occurrence1, NamedElement occurrence2) {
            assert (occurrence1 != null && occurrence1 instanceof DuplicateCodeBlockOccurrence) : "Unexpected class in method 'compare': " + String.valueOf(occurrence1);
            assert (occurrence2 != null && occurrence2 instanceof DuplicateCodeBlockOccurrence) : "Unexpected class in method 'compare': " + String.valueOf(occurrence2);
            return ((DuplicateCodeBlockOccurrence)occurrence1).getName().compareTo(((DuplicateCodeBlockOccurrence)occurrence2).getName());
        }
    }
}

