/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.cycles;

import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.cycles.BreakupMetricsAnalyzer;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.foundation.common.graph.CycleAnalyzer;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INode;
import com.hello2morrow.sonargraph.core.foundation.common.graph.INodeRankAdapter;
import com.hello2morrow.sonargraph.core.foundation.common.graph.NodeRank;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerCycleGroup;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerAdapter;
import com.hello2morrow.sonargraph.core.model.analysis.CycleAnalyzerConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssue;
import com.hello2morrow.sonargraph.core.model.analysis.CycleGroupIssueSourceFilesParticipationInfo;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.SourceFileIssueParticipationInfo;
import com.hello2morrow.sonargraph.core.model.analysis.StringList;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ResolutionNameComparator;
import com.hello2morrow.sonargraph.core.model.metrics.ValueList;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.EdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.IType;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.INamedElementResolver;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.persistence.RestoreException;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CyclesAnalyzerAdapter
extends AnalyzerAdapter {
    public static final Predicate<ProgrammingElement> PE = pe -> !pe.isExcluded() && !pe.ignoreIssues() && !pe.getRefactoringState().hasBeenDeleted();
    public static final Predicate<ParserDependency> PD = pd -> !pd.isExcluded() && !pd.getTo().isExcluded() && !pd.ignoreIssues() && pd.includeInCycleAnalysis() && !pd.getRefactoringState().hasBeenDeleted();
    private static final Logger LOGGER = LoggerFactory.getLogger(CyclesAnalyzerAdapter.class);

    protected CyclesAnalyzerAdapter(IAnalyzerController controller, IConfigurableAnalyzerId analyzerId) {
        super(controller, analyzerId);
    }

    protected abstract IIssueId getIssueId();

    protected CycleAnalyzerConfiguration getConfiguration() {
        return this.getAnalyzer().getConfiguration(CycleAnalyzerConfiguration.class);
    }

    @Override
    public boolean canStoreResult() {
        return true;
    }

    @Override
    protected void saveResult(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'saveResult' must not be null";
        INamedElementResolver resolver = this.getController().getResolver();
        SourceFileIssueParticipationInfo info = result.getUniqueChild(SourceFileIssueParticipationInfo.class);
        if (info != null) {
            ArrayList<String> flattened = new ArrayList<String>();
            for (Map.Entry nextEntry : info.getSourceFileToIssues().entrySet()) {
                flattened.add(resolver.getDescriptor(nextEntry.getKey()));
                for (CycleGroupIssue nextIssue : nextEntry.getValue()) {
                    flattened.add(resolver.getDescriptor(nextIssue));
                }
                flattened.add(null);
            }
            StringList stringList = new StringList(result, flattened.toArray(new String[flattened.size()]));
            result.addChild(stringList);
        }
        super.saveResult(result);
        result.removeChildren(StringList.class);
    }

    @Override
    protected void resultSuccessfullyRestored(AnalyzerResult result) throws RestoreException {
        assert (result != null) : "Parameter 'result' of method 'resultSuccessfullyRestored' must not be null";
        StringList stringList = result.getUniqueChild(StringList.class);
        if (stringList != null) {
            SourceFileIssueParticipationInfo info = result.getUniqueChild(SourceFileIssueParticipationInfo.class);
            if (info == null) {
                info = new SourceFileIssueParticipationInfo(result);
                result.addChild(info);
            }
            INamedElementResolver resolver = this.getController().getResolver();
            SourceFile resolvedSourceFile = null;
            THashSet resolvedIssues = new THashSet();
            String[] stringArray = stringList.getList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String next = stringArray[n2];
                if (resolvedSourceFile == null) {
                    assert (next != null && next.length() > 0) : "'next' of method 'resultSuccessfullyRestored' must not be empty";
                    nextResolved = resolver.resolve(next);
                    if (nextResolved == null || !(nextResolved instanceof SourceFile)) {
                        throw new RestoreException("Unable to restore source file: " + next);
                    }
                    resolvedSourceFile = (SourceFile)nextResolved;
                } else if (next != null) {
                    nextResolved = resolver.resolve(next);
                    if (nextResolved == null || !(nextResolved instanceof CycleGroupIssue)) {
                        throw new RestoreException("Unable to restore issue: " + next);
                    }
                    resolvedIssues.add((CycleGroupIssue)nextResolved);
                } else {
                    if (resolvedIssues.isEmpty()) {
                        throw new RestoreException("Unable to restore issues");
                    }
                    info.put(resolvedSourceFile, resolvedIssues);
                    resolvedSourceFile = null;
                    resolvedIssues.clear();
                }
                ++n2;
            }
            result.removeChild(stringList);
        }
        super.resultSuccessfullyRestored(result);
    }

    @Override
    protected boolean clearResult(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'clearResult' must not be null";
        boolean removed = super.clearResult(result);
        return removed |= result.removeChildren(SourceFileIssueParticipationInfo.class);
    }

    @Override
    protected List<IIssueId> getIssueIds(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'getIssueIds' must not be null";
        ArrayList<IIssueId> ids = new ArrayList<IIssueId>(super.getIssueIds(result));
        ids.add(this.getIssueId());
        return ids;
    }

    @Override
    protected IssueFilter getIssueFilter(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'getIssueFilter' must not be null";
        IssueFilter filter = super.getIssueFilter(result);
        filter.addIgnore(issue -> issue instanceof CycleGroupIssue && ((CycleGroupIssue)issue).getAnalyzerId() != this.getAnalyzerId());
        return filter;
    }

    protected abstract class CyclesAnalyzerJob
    extends AnalyzerJob {
        private IMetricDescriptor m_numberOfIncomingDependenciesMetric;
        private IMetricDescriptor m_numberOfOutgoingDependenciesMetric;
        private IMetricDescriptor m_instabilityMetric;
        private IMetricDescriptor m_rankMetric;
        private ValueList m_rankValues;
        private ValueList m_incomingDependencies;
        private ValueList m_outgoingDependencies;
        private ValueList m_instability;
        private final int m_criticalCycleGroupSize;

        protected CyclesAnalyzerJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(group, result, controller);
            this.m_criticalCycleGroupSize = CyclesAnalyzerAdapter.this.getConfiguration().getCriticalCycleGroupSize();
        }

        protected Integer getIndex() {
            return null;
        }

        private String getCycleGroupNameSuffix(int index) {
            Integer baseIndex = this.getIndex();
            return (String)(baseIndex != null ? String.valueOf(baseIndex) + "." : "") + index;
        }

        protected final void setRankMetric(IMetricDescriptor rankMetric) {
            this.m_rankMetric = rankMetric;
        }

        protected final void setNumberOfIncomingDependenciesMetric(IMetricDescriptor numberOfIncomingDependenciesMetric) {
            this.m_numberOfIncomingDependenciesMetric = numberOfIncomingDependenciesMetric;
        }

        protected final void setNumberOfOutgoingDependenciesMetric(IMetricDescriptor numberOfOutgoingDependenciesMetric) {
            this.m_numberOfOutgoingDependenciesMetric = numberOfOutgoingDependenciesMetric;
        }

        protected final void setInstabilityMetric(IMetricDescriptor instabilityMetric) {
            this.m_instabilityMetric = instabilityMetric;
        }

        protected abstract Collection<? extends NamedElement> getNamedElements();

        protected boolean isCriticalSize(int cycleGroupSize) {
            return cycleGroupSize >= this.m_criticalCycleGroupSize;
        }

        protected abstract AnalyzerCycleGroup createCycleGroup(boolean var1);

        protected NamedElement getScope() {
            return this.getSoftwareSystem();
        }

        private void setNumberOfConnectedDependencies(NamedElement element, int incoming, int outgoing) {
            assert (element != null) : "Parameter 'element' of method 'setNumberOfConnectedDependencies' must not be null";
            if (this.m_incomingDependencies == null && this.m_numberOfIncomingDependenciesMetric != null) {
                this.m_incomingDependencies = CyclesAnalyzerAdapter.this.createValueList(this.getResult(), this.m_numberOfIncomingDependenciesMetric, this.getScope());
            }
            if (this.m_incomingDependencies != null) {
                this.m_incomingDependencies.addValue(element, incoming);
            }
            if (this.m_outgoingDependencies == null && this.m_numberOfOutgoingDependenciesMetric != null) {
                this.m_outgoingDependencies = CyclesAnalyzerAdapter.this.createValueList(this.getResult(), this.m_numberOfOutgoingDependenciesMetric, this.getScope());
            }
            if (this.m_outgoingDependencies != null) {
                this.m_outgoingDependencies.addValue(element, outgoing);
            }
            if (this.m_instabilityMetric != null) {
                if (this.m_instability == null) {
                    this.m_instability = CyclesAnalyzerAdapter.this.createValueList(this.getResult(), this.m_instabilityMetric, null);
                }
                float instability = incoming + outgoing > 0 ? (float)outgoing / (float)(incoming + outgoing) : 1.0f;
                this.m_instability.addValue(element, Float.valueOf(instability));
                this.calculateElementMetrics(element, instability);
            }
        }

        protected NodeAdapterSet<ParserDependencyNodeAdapter> createNodeAdapterSet(Collection<? extends NamedElement> elements) {
            return new ParserDependencyNodeAdapterSet(this.getWorkerContext(), elements, new DependencyEndpointCollector(), PE, PD);
        }

        protected abstract boolean discardIfContainedInOneModule();

        protected void setDistance(NamedElement element, float value) {
        }

        protected void setAbstractness(NamedElement element, float value) {
        }

        protected abstract List<IType> getTypes(NamedElement var1);

        protected final void calculateElementMetrics(NamedElement namedElement, float instability) {
            assert (namedElement != null) : "Parameter 'namedElement' of method 'calculateElementMetrics' must not be null";
            int totalTypes = 0;
            int abstractTypes = 0;
            for (IType type : this.getTypes(namedElement)) {
                ++totalTypes;
                if (!type.isAbstract()) continue;
                ++abstractTypes;
            }
            if (totalTypes > 0) {
                float abstractness = (float)abstractTypes / (float)totalTypes;
                this.setAbstractness(namedElement, abstractness);
                this.setDistance(namedElement, abstractness + instability - 1.0f);
            }
        }

        private boolean inDifferentModules(NodeAdapterSet<ParserDependencyNodeAdapter> nodeAdapterSet, Set<ParserDependencyNodeAdapter> cycleGroup) {
            assert (nodeAdapterSet != null) : "Parameter 'nodeAdapterSet' of method 'inDifferentModules' must not be null";
            assert (cycleGroup != null) : "Parameter 'cycleGroup' of method 'inDifferentModules' must not be null";
            IWorkerContext workerContext = this.getWorkerContext();
            Module currentModule = null;
            for (ParserDependencyNodeAdapter nextCyclicFrom : cycleGroup) {
                if (workerContext.hasBeenCanceled()) {
                    return false;
                }
                for (ParserDependencyNodeAdapter nextCyclicTo : cycleGroup) {
                    ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> foundEdge;
                    if (workerContext.hasBeenCanceled()) {
                        return false;
                    }
                    if (nextCyclicFrom == nextCyclicTo || (foundEdge = nextCyclicFrom.getOutgoingEdge(nextCyclicTo)) == null) continue;
                    for (ParserDependency next : foundEdge.getDependencies()) {
                        if (workerContext.hasBeenCanceled()) {
                            return false;
                        }
                        Module nextFromModule = next.getFrom().getParent(Module.class, new Class[0]);
                        assert (nextFromModule != null) : "'nextFromModule' of method 'inDifferentModules' must not be null";
                        if (currentModule == null) {
                            currentModule = nextFromModule;
                        } else if (currentModule != nextFromModule) {
                            return true;
                        }
                        Module nextToModule = next.getTo().getParent(Module.class, new Class[0]);
                        assert (nextToModule != null) : "'nextToModule' of method 'inDifferentModules' must not be null";
                        assert (currentModule != null) : "'currentModule' of method 'inDifferentModules' must not be null";
                        if (currentModule == nextToModule) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private void logDuplicateInCycleGroup(Set<ParserDependencyNodeAdapter> cycleGroup, NamedElement duplicate) {
            assert (cycleGroup != null) : "Parameter 'cycleGroup' of method 'logDuplicateInCycleGroup' must not be null";
            assert (duplicate != null) : "Parameter 'duplicate' of method 'logDuplicateInCycleGroup' must not be null";
            LOGGER.error("Duplicate cyclic element [" + duplicate.getClass().getSimpleName() + "] " + duplicate.getFullyQualifiedName());
            LOGGER.error("In cycle of " + cycleGroup.size() + " elements:");
            for (ParserDependencyNodeAdapter nextInCycleGroup : cycleGroup) {
                LOGGER.error("[" + nextInCycleGroup.getUnderlyingObject().getClass().getSimpleName() + "] " + nextInCycleGroup.getUnderlyingObject().getFullyQualifiedName());
            }
        }

        private List<AnalyzerCycleGroup> processCycles(NodeAdapterSet<ParserDependencyNodeAdapter> nodeAdapterSet, CycleAnalyzerAdapter cycleAnalyzerAdapter, Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>> cycleGroupToNodes) {
            assert (nodeAdapterSet != null) : "Parameter 'nodeAdapterSet' of method 'processCycles' must not be null";
            assert (cycleAnalyzerAdapter != null) : "Parameter 'cycleAnalyzerAdapter' of method 'processCycles' must not be null";
            assert (cycleGroupToNodes != null) : "Parameter 'cycleGroupToNodes' of method 'processCycles' must not be null";
            IWorkerContext workerContext = this.getWorkerContext();
            THashMap indexToNodeAdapters = new THashMap();
            for (NodeAdapter nodeAdapter : cycleAnalyzerAdapter.getCyclicNodes()) {
                if (workerContext.hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                assert (nodeAdapter != null && nodeAdapter instanceof ParserDependencyNodeAdapter) : "Unexpected class in method 'processCycles': " + String.valueOf(nodeAdapter);
                Integer nextGroupIndex = cycleAnalyzerAdapter.getGroup(nodeAdapter);
                Set nextNodeAdapters = (Set)indexToNodeAdapters.get(nextGroupIndex);
                if (nextNodeAdapters == null) {
                    nextNodeAdapters = new THashSet();
                    indexToNodeAdapters.put(nextGroupIndex, nextNodeAdapters);
                }
                nextNodeAdapters.add((ParserDependencyNodeAdapter)nodeAdapter);
            }
            ArrayList<AnalyzerCycleGroup> arrayList = new ArrayList<AnalyzerCycleGroup>();
            for (Map.Entry nextEntry : indexToNodeAdapters.entrySet()) {
                if (workerContext.hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                Set nextCycleGroupNodeAdapters = (Set)nextEntry.getValue();
                if (this.discardIfContainedInOneModule() && !this.inDifferentModules(nodeAdapterSet, nextCycleGroupNodeAdapters)) continue;
                AnalyzerCycleGroup nextCreatedCycleGroup = this.createCycleGroup(this.isCriticalSize(nextCycleGroupNodeAdapters.size()));
                THashSet nextUnderlyingCyclicElements = new THashSet(nextCycleGroupNodeAdapters.size());
                Iterator iterator = nextCycleGroupNodeAdapters.iterator();
                while (iterator.hasNext()) {
                    ParserDependencyNodeAdapter nextNodeAdapter = (ParserDependencyNodeAdapter)iterator.next();
                    NamedElement nextUnderlyingCyclicElement = nextNodeAdapter.getUnderlyingObject();
                    if (!nextUnderlyingCyclicElements.add(nextUnderlyingCyclicElement)) {
                        this.logDuplicateInCycleGroup(nextCycleGroupNodeAdapters, nextUnderlyingCyclicElement);
                        continue;
                    }
                    nextCreatedCycleGroup.addCyclicElement(nextUnderlyingCyclicElement);
                }
                arrayList.add(nextCreatedCycleGroup);
                cycleGroupToNodes.put(nextCreatedCycleGroup, nextCycleGroupNodeAdapters);
            }
            Collections.sort(arrayList, ResolutionNameComparator.INSTANCE);
            AnalyzerResult result = this.getResult();
            for (AnalyzerCycleGroup next : arrayList) {
                next.setParent(result);
                result.addChild(next);
            }
            Iterator<ParserDependencyNodeAdapter> iterator = nodeAdapterSet.iterator();
            while (iterator.hasNext()) {
                if (workerContext.hasBeenCanceled()) {
                    return Collections.emptyList();
                }
                ParserDependencyNodeAdapter nextNodeAdapter = iterator.next();
                this.setNumberOfConnectedDependencies(nextNodeAdapter.getUnderlyingObject(), nextNodeAdapter.getNumberOfIncomingEdges(), nextNodeAdapter.getNumberOfOutgoingEdges());
            }
            return arrayList;
        }

        protected void finished(AnalyzerResult result) {
            assert (result != null) : "Parameter 'result' of method 'finished' must not be null";
        }

        @Override
        public void internalRun() {
            CycleGroupIssueSourceFilesParticipationInfo cycleToInvolvedSourceFiles;
            IWorkerContext workerContext = this.getWorkerContext();
            workerContext.setNumberOfSteps(7, new int[]{5, 5, 10, 40, 5, 30, 5});
            workerContext.beginSubTask("Get relevant elements");
            Collection<? extends NamedElement> elements = this.getNamedElements();
            workerContext.endSubTask();
            if (workerContext.hasBeenCanceled() || elements.isEmpty()) {
                return;
            }
            workerContext.beginSubTask("Creating node adapter set");
            NodeAdapterSet<ParserDependencyNodeAdapter> nodeAdapterSet = this.createNodeAdapterSet(elements);
            workerContext.endSubTask();
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.beginSubTask("Computing rank");
            AnalyzerResult analyzerResult = this.getResult();
            this.computeRank(nodeAdapterSet, analyzerResult);
            workerContext.endSubTask();
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.beginSubTask("Analyze cycles");
            CycleAnalyzerAdapter cycleAnalyzerAdapter = new CycleAnalyzerAdapter(nodeAdapterSet);
            CycleAnalyzer.compute(cycleAnalyzerAdapter, workerContext);
            workerContext.endSubTask();
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.beginSubTask("Process cycles");
            THashMap cycleGroupToNodeAdapters = new THashMap();
            List<AnalyzerCycleGroup> sortedCycleGroups = this.processCycles(nodeAdapterSet, cycleAnalyzerAdapter, (Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>>)cycleGroupToNodeAdapters);
            workerContext.endSubTask();
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.beginSubTask("Calculating breakup metrics for cycles");
            if (!cycleGroupToNodeAdapters.isEmpty()) {
                workerContext.beginSubTask("Calculating cycle breakup for cycle");
                BreakupMetricsAnalyzer.calculate((Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>>)cycleGroupToNodeAdapters, workerContext);
                workerContext.endSubTask();
            }
            workerContext.endSubTask();
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            workerContext.beginSubTask("Finish cycles");
            SourceFileIssueParticipationInfo<CycleGroupIssue> sourceFileParticipationInfo = analyzerResult.getUniqueChild(SourceFileIssueParticipationInfo.class);
            if (sourceFileParticipationInfo == null) {
                sourceFileParticipationInfo = new SourceFileIssueParticipationInfo<CycleGroupIssue>(analyzerResult);
                analyzerResult.addChild(sourceFileParticipationInfo);
            }
            if ((cycleToInvolvedSourceFiles = analyzerResult.getUniqueChild(CycleGroupIssueSourceFilesParticipationInfo.class)) == null) {
                cycleToInvolvedSourceFiles = new CycleGroupIssueSourceFilesParticipationInfo(analyzerResult, CyclesAnalyzerAdapter.this.getIssueId());
                analyzerResult.addChild(cycleToInvolvedSourceFiles);
            }
            this.computeSourceFileInfo(workerContext, (Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>>)cycleGroupToNodeAdapters, sortedCycleGroups, sourceFileParticipationInfo, cycleToInvolvedSourceFiles);
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            this.finished(analyzerResult);
            workerContext.endSubTask();
        }

        private void computeSourceFileInfo(IWorkerContext workerContext, Map<AnalyzerCycleGroup, Set<? extends NodeAdapter>> cycleGroupToNodeAdapters, List<AnalyzerCycleGroup> sortedCycleGroups, SourceFileIssueParticipationInfo<CycleGroupIssue> sourceFileParticipationInfo, CycleGroupIssueSourceFilesParticipationInfo cycleToInvolvedSourceFiles) {
            int index = 1;
            for (AnalyzerCycleGroup nextCycleGroup : sortedCycleGroups) {
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                CycleGroupIssue issue = new CycleGroupIssue(nextCycleGroup, nextCycleGroup.createIssueDescription(), CyclesAnalyzerAdapter.this.getAnalyzerId(), nextCycleGroup.getCycleGroupIssueId(), nextCycleGroup.isCritical() ? Severity.ERROR : Severity.WARNING);
                nextCycleGroup.addIssue(issue);
                nextCycleGroup.finish(this.getCycleGroupNameSuffix(index));
                ++index;
                Set<? extends NodeAdapter> nextNodeAdaptersInCycleGroup = cycleGroupToNodeAdapters.get(nextCycleGroup);
                if (nextNodeAdaptersInCycleGroup == null) continue;
                Set<NamedElement> nextCyclicNamedElements = nextCycleGroup.getCyclicNamedElements();
                THashSet sourceFiles = new THashSet();
                for (NodeAdapter nodeAdapter : nextNodeAdaptersInCycleGroup) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    for (EdgeAdapter<? extends NodeAdapter> edgeAdapter : nodeAdapter.getOutgoingEdges()) {
                        if (workerContext.hasBeenCanceled()) {
                            return;
                        }
                        assert (edgeAdapter != null && edgeAdapter instanceof ParserDependencyEdgeAdapter) : "Unexpected class in method 'internalRun': " + String.valueOf(edgeAdapter);
                        for (ParserDependency nextOutParserDependency : ((ParserDependencyEdgeAdapter)edgeAdapter).getDependencies()) {
                            if (workerContext.hasBeenCanceled()) {
                                return;
                            }
                            if (!nextCyclicNamedElements.contains(edgeAdapter.getTo().getUnderlyingObject())) continue;
                            ProgrammingElement nextFrom = nextOutParserDependency.getFrom();
                            SourceFile nextSourceFile = nextFrom.getParent(SourceFile.class, new Class[0]);
                            if (nextSourceFile != null) {
                                sourceFiles.add(nextSourceFile);
                                continue;
                            }
                            LOGGER.error("No source file parent found for: " + String.valueOf(nextFrom));
                            NamedElement current = nextFrom.getParent();
                            while (current != null) {
                                LOGGER.error("Parent: " + String.valueOf(current));
                                current = current.getParent();
                            }
                        }
                    }
                }
                sourceFileParticipationInfo.add(issue, (Set<SourceFile>)sourceFiles);
                cycleToInvolvedSourceFiles.add(issue, (Set<SourceFile>)sourceFiles);
                int n = sourceFiles.parallelStream().mapToInt(s -> s.getLinesOfCode()).filter(lines -> lines > 0).sum();
                nextCycleGroup.setInvolvedSourceFileInfo(sourceFiles.size(), n);
            }
            cycleToInvolvedSourceFiles.finishModification();
            sourceFileParticipationInfo.finishModification();
        }

        private void computeRank(final NodeAdapterSet<ParserDependencyNodeAdapter> nodeAdapterSet, final AnalyzerResult analyzerResult) {
            assert (nodeAdapterSet != null) : "Parameter 'nodeAdapterSet' of method 'computeRank' must not be null";
            assert (analyzerResult != null) : "Parameter 'analyzerResult' of method 'computeRank' must not be null";
            if (this.m_rankMetric != null) {
                NodeRank nodeRankComputer = new NodeRank();
                nodeRankComputer.compute(new INodeRankAdapter(){

                    @Override
                    public Collection<? extends INode<?>> getNodes() {
                        return nodeAdapterSet.getNodes();
                    }

                    @Override
                    public void setRank(INode<?> node, double rank) {
                        if (CyclesAnalyzerJob.this.m_rankValues == null) {
                            CyclesAnalyzerJob.this.m_rankValues = CyclesAnalyzerAdapter.this.createValueList(analyzerResult, CyclesAnalyzerJob.this.m_rankMetric, null);
                        }
                        NamedElement element = (NamedElement)node.getUnderlyingObject();
                        CyclesAnalyzerJob.this.m_rankValues.addValue(element, rank);
                    }
                }, this.getWorkerContext());
            }
        }
    }

    protected abstract class CyclesAnalyzerJobOnModules
    extends CyclesAnalyzerJob {
        private int m_currentIndex;
        private Module m_currentModule;
        private final Workspace m_workspace;

        protected CyclesAnalyzerJobOnModules(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller, Workspace workspace) {
            super(group, result, controller);
            this.m_currentIndex = 1;
            this.m_workspace = workspace;
        }

        @Override
        protected final Integer getIndex() {
            return this.m_currentIndex;
        }

        @Override
        protected final NamedElement getScope() {
            return this.m_currentModule;
        }

        protected abstract Language getLanguage();

        @Override
        public final void internalRun() {
            final Language language = this.getLanguage();
            List<Module> modules = language == null ? this.m_workspace.getChildren(Module.class) : this.m_workspace.getChildren(new NamedElement.IFilter(){

                @Override
                public boolean accept(NamedElement namedElement) {
                    if (!($assertionsDisabled || namedElement != null && namedElement instanceof Module)) {
                        throw new AssertionError((Object)("Unexpected class in method 'accept': " + String.valueOf(namedElement)));
                    }
                    return language.equals(namedElement.getLanguage());
                }
            }, Module.class);
            if (!modules.isEmpty()) {
                IWorkerContext workerContext = this.getWorkerContext();
                workerContext.setNumberOfSteps(modules.size());
                for (Module nextModule : modules) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    this.m_currentModule = nextModule;
                    workerContext.beginSubTask(nextModule.getName());
                    super.internalRun();
                    workerContext.endSubTask();
                    ++this.m_currentIndex;
                }
            }
        }
    }
}

