/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system.analysis.architecture;

import com.hello2morrow.sonargraph.core.controller.system.analysis.architecture.ArchitectureCheck;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerAdapter;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.AnalyzerJob;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerController;
import com.hello2morrow.sonargraph.core.controller.system.base.IArchitectureFileProvider;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import com.hello2morrow.sonargraph.core.model.analysis.ArchitectureCheckConfiguration;
import com.hello2morrow.sonargraph.core.model.analysis.CoreAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IConfigurableAnalyzerId;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricDescriptor;
import com.hello2morrow.sonargraph.core.model.analysis.MetricProvider;
import com.hello2morrow.sonargraph.core.model.analysis.transients.AssignedElementsResult;
import com.hello2morrow.sonargraph.core.model.analysis.transients.ComponentsWithViolationsResult;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureDeprecationIssueId;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureProviderId;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViolationIssueId;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureViolationIssueInfo;
import com.hello2morrow.sonargraph.core.model.architecture.Artifact;
import com.hello2morrow.sonargraph.core.model.architecture.Connector;
import com.hello2morrow.sonargraph.core.model.architecture.DeprecatedArtifactNotEmptyissue;
import com.hello2morrow.sonargraph.core.model.architecture.EmptyArchitectureElementIssue;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitecturalModelProvider;
import com.hello2morrow.sonargraph.core.model.architecture.IArchitectureElementContainer;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableFilter;
import com.hello2morrow.sonargraph.core.model.architecture.Interface;
import com.hello2morrow.sonargraph.core.model.architecture.PatternHasNoMatchesIssue;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.common.IssueCategory;
import com.hello2morrow.sonargraph.core.model.common.Severity;
import com.hello2morrow.sonargraph.core.model.element.CoreIssueId;
import com.hello2morrow.sonargraph.core.model.element.CoreProviderId;
import com.hello2morrow.sonargraph.core.model.element.Dependency;
import com.hello2morrow.sonargraph.core.model.element.DependencyIssue;
import com.hello2morrow.sonargraph.core.model.element.IAssignableToArtifact;
import com.hello2morrow.sonargraph.core.model.element.IElement;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.ParentMode;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.FilePath;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.programming.AggregatedDependency;
import com.hello2morrow.sonargraph.core.model.programming.DependencyEndpointCollector;
import com.hello2morrow.sonargraph.core.model.programming.LogicalProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.NodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependency;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyEdgeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapter;
import com.hello2morrow.sonargraph.core.model.programming.ParserDependencyNodeAdapterSet;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.TopLevelLogicalProgrammingElementCollector;
import com.hello2morrow.sonargraph.core.model.resolution.IssueFilter;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.IMetricsProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.ModuleBasedLogicalNamespaceRoot;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.collections.MultipleValueMap;
import com.hello2morrow.sonargraph.foundation.utilities.HashSupport;
import com.hello2morrow.sonargraph.foundation.utilities.IStandardEnumeration;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArchitectureCheckAnalyzerAdapter
extends AnalyzerAdapter {
    private static final Predicate<ProgrammingElement> PE = pe -> !pe.isExcluded() && !pe.getRefactoringState().hasBeenDeleted();
    private static final Predicate<ParserDependency> PD = pd -> !pd.isExcluded() && !pd.getTo().isExcluded() && pd.isArchitectureRelevant() && !pd.getRefactoringState().hasBeenDeleted();
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitectureCheckAnalyzerAdapter.class);
    public static final IConfigurableAnalyzerId ID = CoreAnalyzerId.ARCHITECTURE_CHECK;
    private final IMetricDescriptor m_systemUnassignedComponents;
    private final IMetricDescriptor m_systemUnassignedLogicalElements;
    private final IMetricDescriptor m_systemArtifactCount;
    private final IMetricDescriptor m_systemEmptyArtifactCount;
    private final IMetricDescriptor m_systemComponentsInDeprecatedArtifacts;
    private final IMetricDescriptor m_systemElementsInDeprecatedArtifacts;
    private final IMetricDescriptor m_moduleUnassignedComponents;
    private final IMetricDescriptor m_moduleUnassignedLogicalElements;
    private final IMetricDescriptor m_systemViolationsParserDependencies;
    private final IMetricDescriptor m_systemIgnoredViolationsParserDependencies;
    private final IMetricDescriptor m_systemViolationsComponentDependencies;
    private final IMetricDescriptor m_systemViolatingComponents;
    private final IMetricDescriptor m_moduleViolationsParserDependencies;
    private final IMetricDescriptor m_moduleIgnoredViolationsParserDependencies;
    private final IMetricDescriptor m_moduleViolationsComponentDependencies;
    private final IMetricDescriptor m_moduleViolatingComponents;
    private final IMetricDescriptor m_componentViolationsParserDependencies;
    private final IMetricDescriptor m_componentViolationsComponentDependencies;
    private final IMetricDescriptor m_systemDeprecatedParserDependencies;
    private final IMetricDescriptor m_systemIgnoredDeprecatedParserDependencies;
    private final IMetricDescriptor m_moduleDeprecatedParserDependencies;
    private final IMetricDescriptor m_moduleIgnoredDeprecatedParserDependencies;

    public ArchitectureCheckAnalyzerAdapter(IAnalyzerController controller) {
        super(controller, ID);
        MetricProvider mp = this.getInstallation().getExtension(IMetricsProvider.class).getMetricProvider(CoreProviderId.INSTANCE);
        this.m_systemUnassignedComponents = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_UNASSIGNED_COMPONENTS, CoreMetricLevel.SYSTEM);
        this.m_systemUnassignedLogicalElements = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_UNASSIGNED_LOGICAL_ELEMENTS, CoreMetricLevel.SYSTEM);
        this.m_systemArtifactCount = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_ARTIFACT_COUNT, CoreMetricLevel.SYSTEM);
        this.m_systemEmptyArtifactCount = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_EMPTY_ARTIFACT_COUNT, CoreMetricLevel.SYSTEM);
        this.m_systemComponentsInDeprecatedArtifacts = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_COMPONENTS_IN_DEPRECATED_ARTIFACTS, CoreMetricLevel.SYSTEM);
        this.m_systemElementsInDeprecatedArtifacts = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_LOGICAL_ELEMENTS_IN_DEPRECATED_ARTIFACTS, CoreMetricLevel.SYSTEM);
        this.m_moduleUnassignedComponents = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_UNASSIGNED_COMPONENTS, CoreMetricLevel.MODULE);
        this.m_moduleUnassignedLogicalElements = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_UNASSIGNED_LOGICAL_ELEMENTS, CoreMetricLevel.MODULE);
        this.m_systemViolationsParserDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_VIOLATIONS_PARSER_DEPENDENCIES, CoreMetricLevel.SYSTEM);
        this.m_systemIgnoredViolationsParserDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_IGNORED_VIOLATIONS_PARSER_DEPENDENCIES, CoreMetricLevel.SYSTEM);
        this.m_systemViolationsComponentDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_VIOLATIONS_COMPONENT_DEPENDENCIES, CoreMetricLevel.SYSTEM);
        this.m_systemViolatingComponents = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_VIOLATING_COMPONENTS, CoreMetricLevel.SYSTEM);
        this.m_moduleViolationsParserDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_VIOLATIONS_PARSER_DEPENDENCIES, CoreMetricLevel.MODULE);
        this.m_moduleIgnoredViolationsParserDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_IGNORED_VIOLATIONS_PARSER_DEPENDENCIES, CoreMetricLevel.MODULE);
        this.m_moduleViolationsComponentDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_VIOLATIONS_COMPONENT_DEPENDENCIES, CoreMetricLevel.MODULE);
        this.m_moduleViolatingComponents = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_VIOLATING_COMPONENTS, CoreMetricLevel.MODULE);
        this.m_componentViolationsParserDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_VIOLATIONS_PARSER_DEPENDENCIES, CoreMetricLevel.COMPONENT);
        this.m_componentViolationsComponentDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_VIOLATIONS_COMPONENT_DEPENDENCIES, CoreMetricLevel.COMPONENT);
        this.m_systemDeprecatedParserDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_DEPRECATED_PARSER_DEPENDENCIES, CoreMetricLevel.SYSTEM);
        this.m_systemIgnoredDeprecatedParserDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_IGNORED_DEPRECATED_PARSER_DEPENDENCIES, CoreMetricLevel.SYSTEM);
        this.m_moduleDeprecatedParserDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_DEPRECATED_PARSER_DEPENDENCIES, CoreMetricLevel.MODULE);
        this.m_moduleIgnoredDeprecatedParserDependencies = this.addMetricDescriptorIfNotExistent(mp, CoreMetricId.CORE_IGNORED_DEPRECATED_PARSER_DEPENDENCIES, CoreMetricLevel.MODULE);
    }

    @Override
    protected long getLastModifiedTimestamp() {
        long result = super.getLastModifiedTimestamp();
        for (ArchitectureFile af : this.getSoftwareSystem().getUniqueExistingChild(Files.class).getArchitecture().getChildren(ArchitectureFile.class)) {
            result = Long.max(result, af.getFile().lastModified());
        }
        return result;
    }

    @Override
    protected void runJobs(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'runJobs' must not be null";
        new ArchitectureAnalyzerJob(this.getGroup(), result, this.getController()).start();
    }

    @Override
    protected boolean clearResult(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'clearResult' must not be null";
        boolean done = super.clearResult(result);
        ArchitectureViolationIssueInfo issueInfo = result.getUniqueChild(ArchitectureViolationIssueInfo.class);
        if (issueInfo != null) {
            this.getController().getInstallation().removeProviderIds(issueInfo.getProviderIds());
            issueInfo.remove();
        }
        return done;
    }

    @Override
    protected List<IIssueId> getIssueIds(AnalyzerResult result) {
        assert (result != null) : "Parameter 'result' of method 'getIssueIds' must not be null";
        ArrayList<IIssueId> ids = new ArrayList<IIssueId>(super.getIssueIds(result));
        ids.add(CoreIssueId.EMPTY_ARCHITECTURE_ELEMENT);
        ids.add(CoreIssueId.PATTERN_HAS_NO_MATCHES);
        ids.add(CoreIssueId.DEPRECATED_ARTIFACT_NOT_EMPTY);
        ids.add(ArchitectureViolationIssueId.INSTANCE);
        ids.add(ArchitectureDeprecationIssueId.INSTANCE);
        return ids;
    }

    private class ArchitectureAnalyzerJob
    extends AnalyzerJob {
        private Set<IAssignableFilter> m_neverMatchedFilters;
        private int m_artifactCount;
        private int m_emptyArtifactCount;

        ArchitectureAnalyzerJob(AnalyzerGroup group, AnalyzerResult result, IAnalyzerController controller) {
            super(group, result, controller);
            this.m_neverMatchedFilters = new THashSet();
        }

        @Override
        protected void internalRun() {
            LOGGER.debug("Architecture check");
            IWorkerContext workerContext = this.getWorkerContext();
            SoftwareSystem softwareSystem = this.getSoftwareSystem();
            IArchitectureFileProvider architectureProvider = softwareSystem.getExtension(IArchitectureFileProvider.class);
            ArchitectureCheckConfiguration configuration = this.getAnalyzer().getConfiguration(ArchitectureCheckConfiguration.class);
            assert (configuration != null) : "'configuration' of method 'internalRun' must not be null";
            List<ArchitectureFile> toBeChecked = Collections.emptyList();
            List<String> identifyingPaths = configuration.getIdentifyingPaths();
            if (!identifyingPaths.isEmpty()) {
                toBeChecked = new ArrayList<ArchitectureFile>(identifyingPaths.size());
                for (String next : identifyingPaths) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    ArchitectureFile nextArchitectureFile = architectureProvider.getArchitectureFile(next);
                    if (nextArchitectureFile == null) continue;
                    toBeChecked.add(nextArchitectureFile);
                }
            }
            if (workerContext.hasBeenCanceled()) {
                return;
            }
            AnalyzerResult result = this.getResult();
            if (!toBeChecked.isEmpty()) {
                workerContext.setNumberOfSteps(5, new int[]{5, 15, 20, 50, 10});
                ArchitectureViolationIssueInfo issueInfo = new ArchitectureViolationIssueInfo(result);
                result.addChild(issueInfo);
                List<ArchitectureAnalyzerManager> analyzerManagers = Arrays.asList(new PhysicalArchitectureAnalyzerManager(), new LogicalArchitectureAnalyzerManager());
                VirtualModel currentModel = ArchitectureCheckAnalyzerAdapter.this.getCurrentModel();
                block1: for (ArchitectureFile nextArchitectureFile : toBeChecked) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    for (ArchitectureAnalyzerManager analyzerManager : analyzerManagers) {
                        if (workerContext.hasBeenCanceled()) {
                            return;
                        }
                        if (analyzerManager.offerArchitectureFile(nextArchitectureFile, issueInfo, currentModel)) continue block1;
                    }
                }
                this.getInstallation().addProviderIds(issueInfo.getProviderIds());
                workerContext.endStep();
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                THashSet assignedElements = new THashSet();
                analyzerManagers.forEach(arg_0 -> ArchitectureAnalyzerJob.lambda$0((Set)assignedElements, arg_0));
                analyzerManagers.forEach(m -> m.calculateUnassignedElementsPerModuleMetrics(architectureProvider));
                analyzerManagers.forEach(m -> m.checkArtifacts());
                analyzerManagers.forEach(m -> m.storeDeprecatedAssignmentMetrics());
                ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, this.getSoftwareSystem(), this.m_artifactCount, ArchitectureCheckAnalyzerAdapter.this.m_systemArtifactCount);
                ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, this.getSoftwareSystem(), this.m_emptyArtifactCount, ArchitectureCheckAnalyzerAdapter.this.m_systemEmptyArtifactCount);
                workerContext.endStep();
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                workerContext.beginSubTask("Computing dependencies");
                workerContext.setNumberOfSteps(analyzerManagers.size());
                analyzerManagers.forEach(m -> m.calculateDependencies());
                workerContext.endSubTask();
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                workerContext.beginSubTask("Checking dependencies");
                workerContext.setNumberOfSteps(toBeChecked.size());
                analyzerManagers.forEach(m -> m.checkForViolations());
                workerContext.endSubTask();
                if (workerContext.hasBeenCanceled()) {
                    return;
                }
                MetricHandler systemHandler = new MetricHandler(softwareSystem, true);
                THashMap moduleHandlers = new THashMap();
                for (Module module : softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    moduleHandlers.put(module, new MetricHandler(module, false));
                }
                for (Issue nextIssue : currentModel.getIssueList(new IssueFilter((IStandardEnumeration[])new IssueCategory[]{IssueCategory.ARCHITECTURE_VIOLATION, IssueCategory.ARCHITECTURE_DEPRECATION})).getIssues()) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    assert (nextIssue instanceof DependencyIssue) : "Unexpected class in method 'internalRun': " + String.valueOf(nextIssue);
                    DependencyIssue nextDependencyIssue = (DependencyIssue)nextIssue;
                    systemHandler.processIssue(nextDependencyIssue);
                    Dependency dep = nextDependencyIssue.getAffectedElement();
                    Module module = dep.getUnderlyingFrom().getParent(Module.class, new Class[0]);
                    assert (module != null) : "'module' of method 'internalRun' must not be null";
                    ((MetricHandler)moduleHandlers.get(module)).processIssue(nextDependencyIssue);
                }
                systemHandler.finish(workerContext, result);
                moduleHandlers.values().forEach(h -> h.finish(workerContext, result));
                THashSet componentsWithViolations = new THashSet(systemHandler.getComponentsWithViolations());
                THashSet componentsWithDeprecations = new THashSet(systemHandler.getComponentsWithDeprecations());
                result.addChild(new ComponentsWithViolationsResult(result, (Set<IComponent>)componentsWithViolations, (Set<IComponent>)componentsWithDeprecations));
                result.addChild(new AssignedElementsResult(result, (Set<NamedElement>)assignedElements));
                workerContext.endStep();
            } else {
                result.addChild(new ComponentsWithViolationsResult(result, Collections.emptySet(), Collections.emptySet()));
                result.addChild(new AssignedElementsResult(result, Collections.emptySet()));
            }
            LOGGER.debug("Architecture check - done");
        }

        private static /* synthetic */ void lambda$0(Set set, ArchitectureAnalyzerManager m) {
            boolean bl = set.addAll(m.collectAssignedElements());
        }

        private abstract class ArchitectureAnalyzer
        implements ArchitectureCheck.IConsumer {
            private final Map<NamedElement, Artifact> m_assignmentMap = new THashMap();
            private final ArchitectureFile m_architectureFile;
            private final VirtualModel m_vm;
            private final ArchitectureProviderId m_issueProviderId;

            protected ArchitectureAnalyzer(ArchitectureFile architectureFile, VirtualModel vm) {
                assert (architectureFile != null) : "Parameter 'architectureFile' of method 'ArchitectureAnalyzer' must not be null";
                assert (vm != null) : "Parameter 'vm' of method 'ArchitectureAnalyzer' must not be null";
                this.m_architectureFile = architectureFile;
                this.m_vm = vm;
                this.m_issueProviderId = new ArchitectureProviderId(architectureFile.getIdentifyingPath());
            }

            ArchitectureProviderId getIssueProviderId() {
                return this.m_issueProviderId;
            }

            List<NamedElement> getAssignedElements() {
                IWorkerContext workerContext = ArchitectureAnalyzerJob.this.getWorkerContext();
                ArrayList<NamedElement> assignedComponents = new ArrayList<NamedElement>();
                for (Artifact nextArtifact : this.m_architectureFile.getArtifacts()) {
                    if (workerContext.hasBeenCanceled()) {
                        return Collections.emptyList();
                    }
                    for (IAssignableToArtifact nextComponent : nextArtifact.getAssignedElements()) {
                        this.m_assignmentMap.put(nextComponent.getNamedElement(), nextArtifact);
                        assignedComponents.add(nextComponent.getNamedElement());
                    }
                }
                return assignedComponents;
            }

            @Override
            public void addViolatingDependency(Artifact fromArtifact, Artifact toArtifact, ParserDependency parserDependency) {
                assert (fromArtifact != null) : "Parameter 'fromArtifact' of method 'addViolatingDependency' must not be null";
                assert (toArtifact != null) : "Parameter 'toArtifact' of method 'addViolatingDependency' must not be null";
                assert (parserDependency != null) : "Parameter 'parserDependency' of method 'addViolatingDependency' must not be null";
                IArchitectureElementContainer current = fromArtifact;
                while (current != null && !current.hasViolations()) {
                    current.setHasViolations(true);
                    current = current.getContainer().getParent(IArchitectureElementContainer.class, ParentMode.ONLY_DIRECT_PARENT);
                }
            }

            private void checkForViolations(IWorkerContext workerContext, Set<NamedElement> usedComponents, NodeAdapterSet<ParserDependencyNodeAdapter> dependencyGraph) {
                assert (workerContext != null) : "Parameter 'workerContext' of method 'checkForViolations' must not be null";
                assert (usedComponents != null) : "Parameter 'usedComponents' of method 'checkForViolations' must not be null";
                assert (dependencyGraph != null) : "Parameter 'dependencyGraph' of method 'checkForViolations' must not be null";
                workerContext.beginBlockOfWork(usedComponents.size());
                for (NamedElement componentElement : usedComponents) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    if (componentElement.isExternal()) continue;
                    Artifact fromArtifact = this.m_assignmentMap.get(componentElement);
                    if (fromArtifact != null && !fromArtifact.isExternal()) {
                        if (workerContext.hasBeenCanceled()) {
                            return;
                        }
                        ParserDependencyNodeAdapter node = dependencyGraph.getNodeAdapterFor(componentElement);
                        assert (node != null);
                        for (ParserDependencyEdgeAdapter<ParserDependencyNodeAdapter> edge : node.getOutgoingEdges()) {
                            Artifact toArtifact = this.m_assignmentMap.get(((ParserDependencyNodeAdapter)edge.getTo()).getUnderlyingObject());
                            if (toArtifact == null || toArtifact == fromArtifact || toArtifact.hasAsParent(fromArtifact, false)) continue;
                            ArchitectureCheck.checkEdge(edge, fromArtifact, toArtifact, (IAssignableToArtifact)((Object)componentElement), (IAssignableToArtifact)((Object)((ParserDependencyNodeAdapter)edge.getTo()).getUnderlyingObject()), this.m_issueProviderId, this.m_architectureFile, this.m_vm, this, workerContext);
                        }
                    }
                    workerContext.workItemCompleted();
                }
                workerContext.endStep();
            }

            protected abstract void handleAssignmentToDeprecatedArtifacts(int var1);

            private void reportNonMatchingFilters(ArchitectureElement element, List<IAssignableFilter> nonMatchingFilters) {
                assert (element != null) : "Parameter 'element' of method 'reportNonMatchingFilters' must not be null";
                assert (nonMatchingFilters != null && nonMatchingFilters.size() > 0) : "Parameter 'nonMatchingFilters' of method 'reportNonMatchingFilters' must not be empty";
                String localName = element.getLocalName();
                for (IAssignableFilter filter : nonMatchingFilters) {
                    if (!ArchitectureAnalyzerJob.this.m_neverMatchedFilters.add(filter) || filter.isOptional()) continue;
                    String nextOriginalPattern = filter.getOriginalPattern();
                    assert (nextOriginalPattern != null && nextOriginalPattern.length() > 0) : "'nextOriginalPattern' of method 'reportNonMatchingFilters' must not be empty";
                    String key = HashSupport.MD5.getHexString(localName + nextOriginalPattern);
                    if (element.getReferencedFromLineNumber() == -1) {
                        element.addIssue(new PatternHasNoMatchesIssue(element, "Pattern does not match any assignable", key, filter.getLineNumber()));
                        continue;
                    }
                    FilePath target = element.getDefiningFile();
                    if (target == null) {
                        String description = String.format("Pattern '%s' of element '%s' does not match any assignable in this context", nextOriginalPattern, element.getName());
                        element.addIssue(new PatternHasNoMatchesIssue(element, description, key, element.getContextLineNumber()));
                        continue;
                    }
                    target.addIssue(new PatternHasNoMatchesIssue(target, "Pattern does not match any assignable", key, filter.getLineNumber()));
                }
            }

            private void checkArtifacts() {
                IWorkerContext workerContext = ArchitectureAnalyzerJob.this.getWorkerContext();
                for (Artifact nextArtifact : this.m_architectureFile.getArtifacts()) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    if (nextArtifact.isEmpty()) {
                        if (!nextArtifact.isOptional() && !nextArtifact.isDeprecated()) {
                            nextArtifact.addIssue(new EmptyArchitectureElementIssue(nextArtifact, "Artifact '" + nextArtifact.getName() + "'", nextArtifact.getContextLineNumber()));
                            ++ArchitectureAnalyzerJob.this.m_emptyArtifactCount;
                        }
                    } else if (nextArtifact.isDeprecated()) {
                        nextArtifact.addIssue(new DeprecatedArtifactNotEmptyissue(nextArtifact, "Artifact '" + nextArtifact.getName() + "'", nextArtifact.getContextLineNumber()));
                        this.handleAssignmentToDeprecatedArtifacts(nextArtifact.getNumberOfAssignedElements());
                    } else {
                        List<IAssignableFilter> nonMatchingFilters = nextArtifact.getNonMatchingFilters();
                        if (!nonMatchingFilters.isEmpty()) {
                            this.reportNonMatchingFilters(nextArtifact, nonMatchingFilters);
                        }
                        for (Interface nextInterface : nextArtifact.getInterfaces()) {
                            if (nextInterface.isOptional()) continue;
                            if (nextInterface.isEmpty()) {
                                nextInterface.addIssue(new EmptyArchitectureElementIssue(nextInterface, "Interface '" + nextInterface.getName() + "'", nextInterface.getContextLineNumber()));
                                continue;
                            }
                            List<IAssignableFilter> nonMatchingInterfaceFilters = nextInterface.getNonMatchingFilters();
                            if (nonMatchingInterfaceFilters.isEmpty()) continue;
                            this.reportNonMatchingFilters(nextInterface, nonMatchingInterfaceFilters);
                        }
                        for (Connector nextConnector : nextArtifact.getConnectors()) {
                            if (nextConnector.isOptional()) continue;
                            if (nextConnector.isEmpty()) {
                                nextConnector.addIssue(new EmptyArchitectureElementIssue(nextConnector, "Connector '" + nextConnector.getName() + "'", nextConnector.getContextLineNumber()));
                                continue;
                            }
                            List<IAssignableFilter> nonMatchingConnectorFilters = nextConnector.getNonMatchingFilters();
                            if (nonMatchingConnectorFilters.isEmpty()) continue;
                            this.reportNonMatchingFilters(nextConnector, nonMatchingConnectorFilters);
                        }
                    }
                    ++ArchitectureAnalyzerJob.this.m_artifactCount;
                }
            }
        }

        private abstract class ArchitectureAnalyzerManager {
            private final List<ArchitectureAnalyzer> m_analyzers = new ArrayList<ArchitectureAnalyzer>();
            private final Set<NamedElement> m_assignedElements = new THashSet();
            private final IArchitecturalModelProvider.ArchitectureModel m_model;
            private NodeAdapterSet<ParserDependencyNodeAdapter> m_dependencyGraph = null;
            private int m_elementsAssignedToDeprecatedArtifacts = 0;

            protected ArchitectureAnalyzerManager(IArchitecturalModelProvider.ArchitectureModel model) {
                assert (model != null) : "Parameter 'model' of method 'ArchitectureAnalyzerManager' must not be null";
                this.m_model = model;
            }

            private final boolean offerArchitectureFile(ArchitectureFile architectureFile, ArchitectureViolationIssueInfo issueInfo, VirtualModel vm) {
                assert (architectureFile != null) : "Parameter 'architectureFile' of method 'createAnalyzer' must not be null";
                assert (issueInfo != null) : "Parameter 'issueInfo' of method 'offerArchitectureFile' must not be null";
                assert (vm != null) : "Parameter 'vm' of method 'createAnalyzer' must not be null";
                if (architectureFile.getModel().equals((Object)this.m_model)) {
                    ArchitectureAnalyzer analyzer = this.createAnalyzer(architectureFile, vm);
                    this.m_analyzers.add(analyzer);
                    issueInfo.addIssueProviderId(analyzer.getIssueProviderId());
                    return true;
                }
                return false;
            }

            protected void handleAssignmentToDeprecatedArtifacts(int assignedElements) {
                this.m_elementsAssignedToDeprecatedArtifacts += assignedElements;
            }

            protected abstract ArchitectureAnalyzer createAnalyzer(ArchitectureFile var1, VirtualModel var2);

            private Set<NamedElement> collectAssignedElements() {
                IWorkerContext workerContext = ArchitectureAnalyzerJob.this.getWorkerContext();
                for (ArchitectureAnalyzer analyzer : this.m_analyzers) {
                    if (workerContext.hasBeenCanceled()) {
                        return Collections.emptySet();
                    }
                    this.m_assignedElements.addAll(analyzer.getAssignedElements());
                }
                return this.m_assignedElements;
            }

            protected abstract void addUnassignedElement(IAssignableToArtifact var1);

            protected abstract void storeUnassignedMetrics(Collection<IAssignableToArtifact> var1);

            private void calculateUnassignedElementsPerModuleMetrics(IArchitectureFileProvider architectureProvider) {
                Collection<IAssignableToArtifact> unassignedElements = architectureProvider.getUnassignedInternalComponents(this.m_model);
                unassignedElements.forEach(e -> this.addUnassignedElement((IAssignableToArtifact)e));
                this.storeUnassignedMetrics(unassignedElements);
            }

            protected abstract void doStoreDeprecatedAssignmentMetrics(int var1);

            private void storeDeprecatedAssignmentMetrics() {
                this.doStoreDeprecatedAssignmentMetrics(this.m_elementsAssignedToDeprecatedArtifacts);
            }

            public void checkArtifacts() {
                this.m_analyzers.forEach(a -> a.checkArtifacts());
            }

            protected abstract NodeAdapterSet<ParserDependencyNodeAdapter> createNodeAdapterSet(Set<NamedElement> var1);

            private void calculateDependencies() {
                if (!this.m_assignedElements.isEmpty()) {
                    ArchitectureAnalyzerJob.this.getWorkerContext().beginSubTask("Calculating dependencies for model: " + String.valueOf((Object)this.m_model));
                    this.m_dependencyGraph = this.createNodeAdapterSet(this.m_assignedElements);
                    ArchitectureAnalyzerJob.this.getWorkerContext().endSubTask();
                } else {
                    ArchitectureAnalyzerJob.this.getWorkerContext().endStep();
                }
            }

            private void checkForViolations() {
                IWorkerContext workerContext = ArchitectureAnalyzerJob.this.getWorkerContext();
                if (!this.m_assignedElements.isEmpty()) {
                    this.m_analyzers.forEach(a -> a.checkForViolations(workerContext, this.m_assignedElements, this.m_dependencyGraph));
                }
            }

            protected void addViolatingDependency(Map<Artifact, Map<Artifact, AggregatedDependency>> violationMap, Artifact from, Artifact to, ParserDependency dep) {
                AggregatedDependency aggrDep;
                THashMap targetMap = violationMap.get(from);
                if (targetMap == null) {
                    targetMap = new THashMap();
                    violationMap.put(from, (Map<Artifact, AggregatedDependency>)targetMap);
                }
                if ((aggrDep = targetMap.get(to)) == null) {
                    aggrDep = new AggregatedDependency(from, to);
                    targetMap.put(to, aggrDep);
                }
                aggrDep.add(dep);
            }
        }

        private class LogicalArchitectureAnalyzerManager
        extends ArchitectureAnalyzerManager {
            private final Map<Module, Integer> m_unassignedElementsPerModule;
            private final Map<Artifact, Map<Artifact, AggregatedDependency>> m_violationMap;

            private LogicalArchitectureAnalyzerManager() {
                super(IArchitecturalModelProvider.ArchitectureModel.LOGICAL);
                this.m_unassignedElementsPerModule = new THashMap();
                this.m_violationMap = new THashMap();
                IWorkerContext workerContext = ArchitectureAnalyzerJob.this.getWorkerContext();
                for (Module module : ArchitectureAnalyzerJob.this.getSoftwareSystem().getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    this.m_unassignedElementsPerModule.put(module, 0);
                }
            }

            @Override
            protected ArchitectureAnalyzer createAnalyzer(ArchitectureFile architectureFile, VirtualModel vm) {
                return new LogicalArchitectureAnalyzer(architectureFile, vm);
            }

            @Override
            protected void addUnassignedElement(IAssignableToArtifact element) {
                ModuleBasedLogicalNamespaceRoot root = element.getNamedElement().getParent(ModuleBasedLogicalNamespaceRoot.class, new Class[0]);
                assert (root != null);
                Module module = root.getPhysicalElement();
                this.m_unassignedElementsPerModule.put(module, this.m_unassignedElementsPerModule.get(module) + 1);
            }

            @Override
            protected void storeUnassignedMetrics(Collection<IAssignableToArtifact> unassigned) {
                this.m_unassignedElementsPerModule.forEach((mod, v) -> ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(ArchitectureAnalyzerJob.this.getResult(), (NamedElement)mod, (Number)v, ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_moduleUnassignedLogicalElements));
                ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(ArchitectureAnalyzerJob.this.getResult(), ArchitectureAnalyzerJob.this.getSoftwareSystem(), unassigned.size(), ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_systemUnassignedLogicalElements);
            }

            @Override
            protected NodeAdapterSet<ParserDependencyNodeAdapter> createNodeAdapterSet(Set<NamedElement> assignedElements) {
                TopLevelLogicalProgrammingElementCollector collector = new TopLevelLogicalProgrammingElementCollector();
                assignedElements.forEach(e -> collector.addLogicalprogrammingElement((LogicalProgrammingElement)e));
                return new ParserDependencyNodeAdapterSet(ArchitectureAnalyzerJob.this.getWorkerContext(), assignedElements, collector, PE, PD);
            }

            @Override
            protected void doStoreDeprecatedAssignmentMetrics(int value) {
                ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(ArchitectureAnalyzerJob.this.getResult(), ArchitectureAnalyzerJob.this.getSoftwareSystem(), value, ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_systemElementsInDeprecatedArtifacts);
            }

            private class LogicalArchitectureAnalyzer
            extends ArchitectureAnalyzer {
                private LogicalArchitectureAnalyzer(ArchitectureFile architectureFile, VirtualModel vm) {
                    super(architectureFile, vm);
                }

                @Override
                public void addViolatingDependency(Artifact from, Artifact to, ParserDependency dep) {
                    LogicalArchitectureAnalyzerManager.this.addViolatingDependency(LogicalArchitectureAnalyzerManager.this.m_violationMap, from, to, dep);
                    super.addViolatingDependency(from, to, dep);
                }

                @Override
                protected void handleAssignmentToDeprecatedArtifacts(int assignedElements) {
                    LogicalArchitectureAnalyzerManager.this.handleAssignmentToDeprecatedArtifacts(assignedElements);
                }
            }
        }

        private class MetricHandler {
            private final NamedElement m_scope;
            private final boolean m_isSystemScope;
            private int m_violations;
            private int m_deprecations;
            private int m_ignoredViolations;
            private int m_ignoredDeprecations;
            private final MultipleValueMap<IComponent, IComponent> m_componentViolations = new MultipleValueMap();
            private final MultipleValueMap<IComponent, Dependency> m_violationMap = new MultipleValueMap();
            private final Set<IComponent> m_componentsWithViolations = new THashSet();
            private final Set<IComponent> m_componentsWithDeprecations = new THashSet();

            private MetricHandler(NamedElement scope, boolean isSystemScope) {
                this.m_scope = scope;
                this.m_isSystemScope = isSystemScope;
            }

            private void processIssue(DependencyIssue issue) {
                assert (issue != null) : "Parameter 'issue' of method 'processIssue' must not be null";
                Dependency dependency = issue.getAffectedElement();
                assert (dependency.getUnderlyingFrom().isValid());
                IComponent from = dependency.getUnderlyingFrom().getParent(IComponent.class, ParentMode.SELF_OR_FIRST_PARENT);
                assert (from != null) : dependency.getUnderlyingFrom().toString() + " does not belong to a component";
                assert (dependency.getUnderlyingTo().isValid()) : "Invalid " + dependency.getUnderlyingTo().getShortName() + ". " + from.toString() + ": " + dependency.getLineNumber();
                IComponent to = dependency.getUnderlyingTo().getParent(IComponent.class, ParentMode.SELF_OR_FIRST_PARENT);
                assert (to != null) : dependency.getUnderlyingTo().toString() + " does not belong to a component. " + from.toString() + ": " + dependency.getLineNumber();
                if (issue.getSeverity() == Severity.ERROR) {
                    ++this.m_violations;
                    this.m_componentViolations.putIfNotPresent((Object)from, (Object)to);
                    this.m_componentsWithViolations.add(from);
                    if (!this.m_isSystemScope) {
                        this.m_violationMap.put((Object)from, (Object)dependency);
                    }
                    if (issue.isIgnored()) {
                        ++this.m_ignoredViolations;
                    }
                } else {
                    assert (issue.getSeverity() == Severity.WARNING);
                    ++this.m_deprecations;
                    this.m_componentsWithDeprecations.add(from);
                    if (issue.isIgnored()) {
                        ++this.m_ignoredDeprecations;
                    }
                }
            }

            private void finish(IWorkerContext workerContext, AnalyzerResult result) {
                assert (workerContext != null) : "Parameter 'workerContext' of method 'finish' must not be null";
                assert (result != null) : "Parameter 'result' of method 'finish' must not be null";
                if (this.m_isSystemScope) {
                    ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, this.m_scope, this.m_violations, ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_systemViolationsParserDependencies);
                    ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, this.m_scope, this.m_ignoredViolations, ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_systemIgnoredViolationsParserDependencies);
                    ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, this.m_scope, this.m_componentViolations.values().size(), ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_systemViolationsComponentDependencies);
                    ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, this.m_scope, this.m_componentViolations.size(), ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_systemViolatingComponents);
                    ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, this.m_scope, this.m_deprecations, ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_systemDeprecatedParserDependencies);
                    ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, this.m_scope, this.m_ignoredDeprecations, ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_systemIgnoredDeprecatedParserDependencies);
                } else {
                    ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, this.m_scope, this.m_violations, ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_moduleViolationsParserDependencies);
                    ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, this.m_scope, this.m_ignoredViolations, ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_moduleIgnoredViolationsParserDependencies);
                    ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, this.m_scope, this.m_componentViolations.values().size(), ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_moduleViolationsComponentDependencies);
                    ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, this.m_scope, this.m_componentViolations.size(), ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_moduleViolatingComponents);
                    ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, this.m_scope, this.m_deprecations, ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_moduleDeprecatedParserDependencies);
                    ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, this.m_scope, this.m_ignoredDeprecations, ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_moduleIgnoredDeprecatedParserDependencies);
                    THashSet remainingComponentsInModule = new THashSet();
                    this.m_scope.getChildrenRecursively(IComponent.class, IComponent.class).stream().filter(c -> !c.isExcluded()).forEach(arg_0 -> MetricHandler.lambda$1((Set)remainingComponentsInModule, arg_0));
                    for (IElement comp : this.m_componentViolations.keySet()) {
                        if (workerContext.hasBeenCanceled()) {
                            return;
                        }
                        List deps = this.m_violationMap.get((Object)comp);
                        List targets = this.m_componentViolations.get((Object)comp);
                        NamedElement componentElement = comp.getNamedElement();
                        ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, componentElement, deps.size(), ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_componentViolationsParserDependencies);
                        ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, componentElement, targets.size(), ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_componentViolationsComponentDependencies);
                        remainingComponentsInModule.remove(componentElement);
                    }
                    for (IElement comp : remainingComponentsInModule) {
                        if (workerContext.hasBeenCanceled()) {
                            return;
                        }
                        ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, (NamedElement)comp, 0, ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_componentViolationsParserDependencies);
                        ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(result, (NamedElement)comp, 0, ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_componentViolationsComponentDependencies);
                    }
                }
            }

            private Set<IComponent> getComponentsWithViolations() {
                return this.m_componentsWithViolations;
            }

            public Set<IComponent> getComponentsWithDeprecations() {
                return this.m_componentsWithDeprecations;
            }

            private static /* synthetic */ void lambda$1(Set set, IComponent c) {
                boolean bl = set.add(c.getNamedElement());
            }
        }

        private class PhysicalArchitectureAnalyzerManager
        extends ArchitectureAnalyzerManager {
            private final Map<Module, Integer> m_unassignedComponentsPerModule;
            private final Map<Artifact, Map<Artifact, AggregatedDependency>> m_violationMap;

            private PhysicalArchitectureAnalyzerManager() {
                super(IArchitecturalModelProvider.ArchitectureModel.PHYSICAL);
                this.m_unassignedComponentsPerModule = new THashMap();
                this.m_violationMap = new THashMap();
                IWorkerContext workerContext = ArchitectureAnalyzerJob.this.getWorkerContext();
                for (Module module : ArchitectureAnalyzerJob.this.getSoftwareSystem().getUniqueExistingChild(Workspace.class).getChildren(Module.class)) {
                    if (workerContext.hasBeenCanceled()) {
                        return;
                    }
                    this.m_unassignedComponentsPerModule.put(module, 0);
                }
            }

            @Override
            protected ArchitectureAnalyzer createAnalyzer(ArchitectureFile architectureFile, VirtualModel vm) {
                return new PhysicalArchitectureAnalyzer(architectureFile, vm);
            }

            @Override
            protected void addUnassignedElement(IAssignableToArtifact element) {
                Module module = element.getNamedElement().getParent(Module.class, new Class[0]);
                assert (module != null) : "Element has no module: " + element.getNamedElement().getDebugInfo();
                Integer val = this.m_unassignedComponentsPerModule.get(module);
                assert (val != null) : "Unknown module: " + module.getDebugInfo();
                this.m_unassignedComponentsPerModule.put(module, val + 1);
            }

            @Override
            protected void storeUnassignedMetrics(Collection<IAssignableToArtifact> unassigned) {
                this.m_unassignedComponentsPerModule.forEach((mod, v) -> ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(ArchitectureAnalyzerJob.this.getResult(), (NamedElement)mod, (Number)v, ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_moduleUnassignedComponents));
                ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(ArchitectureAnalyzerJob.this.getResult(), ArchitectureAnalyzerJob.this.getSoftwareSystem(), unassigned.size(), ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_systemUnassignedComponents);
            }

            @Override
            protected NodeAdapterSet<ParserDependencyNodeAdapter> createNodeAdapterSet(Set<NamedElement> assignedElements) {
                return new ParserDependencyNodeAdapterSet(ArchitectureAnalyzerJob.this.getWorkerContext(), assignedElements, new DependencyEndpointCollector(), PE, PD);
            }

            @Override
            protected void doStoreDeprecatedAssignmentMetrics(int value) {
                ArchitectureCheckAnalyzerAdapter.this.storeMetricValue(ArchitectureAnalyzerJob.this.getResult(), ArchitectureAnalyzerJob.this.getSoftwareSystem(), value, ((ArchitectureAnalyzerJob)ArchitectureAnalyzerJob.this).ArchitectureCheckAnalyzerAdapter.this.m_systemComponentsInDeprecatedArtifacts);
            }

            private class PhysicalArchitectureAnalyzer
            extends ArchitectureAnalyzer {
                private PhysicalArchitectureAnalyzer(ArchitectureFile architectureFile, VirtualModel vm) {
                    super(architectureFile, vm);
                }

                @Override
                public void addViolatingDependency(Artifact from, Artifact to, ParserDependency dep) {
                    PhysicalArchitectureAnalyzerManager.this.addViolatingDependency(PhysicalArchitectureAnalyzerManager.this.m_violationMap, from, to, dep);
                    super.addViolatingDependency(from, to, dep);
                }

                @Override
                protected void handleAssignmentToDeprecatedArtifacts(int assignedElements) {
                    PhysicalArchitectureAnalyzerManager.this.handleAssignmentToDeprecatedArtifacts(assignedElements);
                }
            }
        }
    }
}

