/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.IRestoreData;
import com.hello2morrow.sonargraph.core.controller.system.RevertData;
import com.hello2morrow.sonargraph.core.controller.system.UndoRedoData;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.IAnalyzerExecutionController;
import com.hello2morrow.sonargraph.core.controller.system.analysis.base.ResetMode;
import com.hello2morrow.sonargraph.core.controller.system.base.IFinishModelProcessor;
import com.hello2morrow.sonargraph.core.controller.system.base.ISnapshotController;
import com.hello2morrow.sonargraph.core.controller.system.base.ISoftwareSystemLifecycleListener;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IUndoRedoExtension;
import com.hello2morrow.sonargraph.core.foundation.common.history.FileHistoryOperation;
import com.hello2morrow.sonargraph.core.foundation.common.history.IFileHistoryEntry;
import com.hello2morrow.sonargraph.core.foundation.common.history.ModifiableFileHistory;
import com.hello2morrow.sonargraph.core.foundation.common.history.RestoreStateDto;
import com.hello2morrow.sonargraph.core.model.common.AnalyzerGroup;
import com.hello2morrow.sonargraph.core.model.element.INavigationState;
import com.hello2morrow.sonargraph.core.model.event.Modification;
import com.hello2morrow.sonargraph.core.model.event.SoftwareSystemEvent;
import com.hello2morrow.sonargraph.core.model.event.UndoRedoAvailabilityEvent;
import com.hello2morrow.sonargraph.core.model.history.GlobalHistory;
import com.hello2morrow.sonargraph.core.model.path.IModifiableFile;
import com.hello2morrow.sonargraph.core.model.path.SoftwareSystemFile;
import com.hello2morrow.sonargraph.core.model.system.Files;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.OptionalExtension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.transaction.AnalyzerExecutionInfo;
import com.hello2morrow.sonargraph.core.model.transaction.IUndoRedoProvider;
import com.hello2morrow.sonargraph.core.model.transaction.TransactionContext;
import com.hello2morrow.sonargraph.core.model.transaction.TransactionType;
import com.hello2morrow.sonargraph.core.model.transaction.UndoRedoMessageCause;
import com.hello2morrow.sonargraph.core.persistence.history.HistoryStateFilePersistence;
import com.hello2morrow.sonargraph.core.persistence.history.HistoryTablePersistence;
import com.hello2morrow.sonargraph.foundation.activity.DefaultWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventManager;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.integration.access.foundation.AggregatingClassLoader;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UndoRedoExtension
extends OptionalExtension
implements IUndoRedoExtension,
ISoftwareSystemLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(UndoRedoExtension.class);
    private static final String HISTORY_PATH = "history";
    private static final String SEPARATOR = "_";
    private final Map<Class<? extends IModifiableFile>, IUndoRedoProvider> m_undoRedoProviderMap = new THashMap();
    private final Map<String, ModifiableFileHistory> m_fileIdToHistoryMap = new THashMap();
    private final GlobalHistory m_globalHistoryTable = new GlobalHistory();
    private final IFinishModelProcessor m_finishModelProcessor;
    private final Installation m_installation;
    private final SoftwareSystem m_softwareSystem;
    private final ISnapshotController m_snapshotController;
    private final IAnalyzerExecutionController m_controller;
    private HistoryStateFilePersistence m_historyStateFilePersistence;
    private TFile m_dataDirectory;
    private HistoryTablePersistence m_historyTablePersistence;

    public UndoRedoExtension(Installation installation, SoftwareSystem system, ISnapshotController snapshotController, IAnalyzerExecutionController analyzerExecutionController, IFinishModelProcessor finishModelProcessor, boolean enabled) {
        super(enabled);
        assert (installation != null) : "Parameter 'installation' of method 'UndoRedoFunctionalExtension' must not be null";
        assert (system != null) : "Parameter 'system' of method 'UndoRedoExtension' must not be null";
        assert (snapshotController != null) : "Parameter 'snapshotController' of method 'UndoRedoExtension' must not be null";
        assert (analyzerExecutionController != null) : "Parameter 'analyzerExecutionController' of method 'UndoRedoExtension' must not be null";
        assert (finishModelProcessor != null) : "Parameter 'finishModelProcessor' of method 'UndoRedoExtension' must not be null";
        this.m_installation = installation;
        this.m_softwareSystem = system;
        this.m_controller = analyzerExecutionController;
        this.m_snapshotController = snapshotController;
        this.m_finishModelProcessor = finishModelProcessor;
        if (this.isEnabled()) {
            this.m_finishModelProcessor.addListener(this);
        }
    }

    @Override
    public void finishSoftwareSystemInitialization(OperationResult result) {
        assert (result != null) : "Parameter 'result' of method 'finishSoftwareSystemInitialization' must not be null";
        if (this.isEnabled()) {
            TFile hiddenDataDirectory = this.m_softwareSystem.getUniqueExistingChild(Files.class).getHiddenDataDirectory();
            TFile historyDir = new TFile((File)hiddenDataDirectory, HISTORY_PATH);
            if (historyDir.exists() && historyDir.isDirectory()) {
                try {
                    historyDir.rm_r();
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to delete history directory '" + historyDir.getAbsolutePath() + "'");
                }
            }
            this.m_dataDirectory = FileUtility.getOrCreateDirectory((TFile)historyDir, (OperationResult)result);
            if (!result.isFailure()) {
                this.m_historyStateFilePersistence = new HistoryStateFilePersistence(this.m_dataDirectory);
                if (LOGGER.isDebugEnabled()) {
                    this.m_historyTablePersistence = new HistoryTablePersistence(this.m_dataDirectory, this.m_installation.getVersion(), new AggregatingClassLoader(Arrays.asList(this.getClass().getClassLoader())));
                }
            } else {
                LOGGER.error("Unable to create history directory: " + result.toString());
            }
        }
    }

    void addUndoRedoProvider(IUndoRedoProvider provider) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (provider != null) : "Parameter 'provider' of method 'addUndoRedoProvider' must not be null";
        for (Class<? extends IModifiableFile> next : provider.getModifiableFileClasses()) {
            IUndoRedoProvider previous = this.m_undoRedoProviderMap.put(next, provider);
            assert (previous == null) : "'previous' of method 'addUndoRedoProvider' must  be null";
        }
    }

    public IUndoRedoProvider getUndoRedoProvider(Class<? extends IModifiableFile> clazz) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (clazz != null) : "Parameter 'clazz' of method 'getUndoRedoProvider' must not be null";
        return this.m_undoRedoProviderMap.get(clazz);
    }

    private void saveState(TransactionContext context, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (context != null) : "Parameter 'context' of method 'saveState' must not be null";
        assert (result != null) : "Parameter 'result' of method 'saveState' must not be null";
        this.removeHistoryEntries(result, context.getDeletedFiles());
        this.createInitialFileHistoryEntries(context.getCreatedFiles(), context, result);
        if (context.getTransactionType() == TransactionType.UNDOABLE) {
            for (IModifiableFile nextFile : context.getModifiedFiles()) {
                IUndoRedoProvider undoRedoProvider = this.m_undoRedoProviderMap.get(nextFile.getClass());
                if (undoRedoProvider == null) {
                    LOGGER.debug(String.format("No UndoRedoProvider defined for class '%s'", nextFile.getClass().getCanonicalName()));
                    continue;
                }
                ModifiableFileHistory fileHistory = this.m_fileIdToHistoryMap.get(nextFile.getFileId());
                assert (fileHistory != null) : "History for file '" + nextFile.getAbsolutePath() + "' with fileId '" + nextFile.getFileId() + "' must exist";
                List<GlobalHistory.Entry> obsoleteEntries = this.m_globalHistoryTable.addEntry(new GlobalHistory.Entry(nextFile, context.getName(), context.getId(), context.getModifications()));
                this.removeObsoleteEntries(obsoleteEntries, result);
                GlobalHistory.Entry addedEntry = (GlobalHistory.Entry)this.m_globalHistoryTable.getLastAddedEntry();
                addedEntry.setNavigationState(context.getNavigationState());
                if (fileHistory.getSize() > 0) {
                    undoRedoProvider.updatePreviousEntry(fileHistory, nextFile);
                }
                String entryName = this.createStateFileName(nextFile, context.getId());
                List<ModifiableFileHistory.FileHistoryEntry> removedEntries = this.createFileHistoryEntry(context, result, nextFile, undoRedoProvider, fileHistory, entryName, true);
                this.removeObsoleteFileHistoryEntries(removedEntries, fileHistory);
            }
        } else if (context.getTransactionType() == TransactionType.SAVE) {
            for (IModifiableFile nextFile : context.getModifiedFiles()) {
                IUndoRedoProvider undoRedoProvider = this.m_undoRedoProviderMap.get(nextFile.getClass());
                if (undoRedoProvider == null) {
                    LOGGER.debug(String.format("No UndoRedoProvider defined for class '%s'", nextFile.getClass().getCanonicalName()));
                    continue;
                }
                ModifiableFileHistory fileHistory = this.m_fileIdToHistoryMap.get(nextFile.getFileId());
                assert (fileHistory != null) : "History for file '" + nextFile.getAbsolutePath() + "' with fileId '" + nextFile.getFileId() + "' must exist";
                if (fileHistory.getSize() > 0) {
                    undoRedoProvider.updatePreviousEntry(fileHistory, nextFile);
                }
                String entryName = this.createStateFileName(nextFile, context.getId());
                List<ModifiableFileHistory.FileHistoryEntry> removedEntries = this.createFileHistoryEntry(context, result, nextFile, undoRedoProvider, fileHistory, entryName, true);
                this.removeObsoleteFileHistoryEntries(removedEntries, fileHistory);
            }
        } else {
            this.resetHistoryForModifiedFiles(context, result);
        }
        this.removeHistoryEntries(result, context.getReloadedFiles());
        this.createInitialFileHistoryEntries(context.getReloadedFiles(), context, result);
        this.processLastStateForSavedFiles(context, result);
        SoftwareSystemFile systemFile = this.m_softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFile();
        if (context.getTransactionType() != TransactionType.UNDOABLE && context.getTransactionType() != TransactionType.SAVE || !context.getCreatedFiles().contains(systemFile) && !context.getModifiedFiles().contains(systemFile) && !context.getSavedFiles().contains(systemFile) && !context.getReloadedFiles().contains(systemFile)) {
            this.updateSoftwareSystemState(context);
        }
        this.logHistoryState(context);
        this.signalUndoRedoAvailability();
    }

    private void finishRestore(TransactionContext context, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (context != null) : "Parameter 'context' of method 'finishRestore' must not be null";
        assert (result != null) : "Parameter 'result' of method 'finishRestore' must not be null";
        Set<IModifiableFile> created = context.getCreatedFiles();
        if (!created.isEmpty()) {
            this.createInitialFileHistoryEntries(created, context, result);
        }
    }

    private void updateSoftwareSystemState(TransactionContext context) {
        assert (this.isEnabled()) : "Extension not enabled";
        SoftwareSystemFile systemFile = this.m_softwareSystem.getUniqueExistingChild(Files.class).getSoftwareSystemFile();
        IUndoRedoProvider undoRedoProvider = this.m_undoRedoProviderMap.get(SoftwareSystemFile.class);
        ModifiableFileHistory fileHistory = this.m_fileIdToHistoryMap.get(systemFile.getFileId());
        ModifiableFileHistory.FileHistoryEntry entry = (ModifiableFileHistory.FileHistoryEntry)fileHistory.getLastAddedEntry();
        undoRedoProvider.updateState(systemFile, entry, context.invalidatesParserModel());
    }

    private List<ModifiableFileHistory.FileHistoryEntry> createFileHistoryEntry(TransactionContext context, OperationResult result, IModifiableFile modifiableFile, IUndoRedoProvider undoRedoProvider, ModifiableFileHistory fileHistory, String entryName, boolean needsSave) {
        assert (this.isEnabled()) : "Extension not enabled";
        ArrayList<ModifiableFileHistory.FileHistoryEntry> removedEntries = new ArrayList();
        OperationResultWithOutcome<TFile> saveStateResult = this.m_historyStateFilePersistence.saveState(modifiableFile, entryName, undoRedoProvider);
        if (saveStateResult.isSuccess()) {
            removedEntries = undoRedoProvider.createEntry(context, modifiableFile, fileHistory, needsSave, (TFile)saveStateResult.getOutcome());
            if (LOGGER.isDebugEnabled()) {
                result.addMessagesFrom(this.m_historyTablePersistence.persist(this.m_globalHistoryTable));
            }
            return removedEntries;
        }
        LOGGER.error(String.format("Failed to save state for '%s', command '%s'", modifiableFile.getAbsolutePath(), context.getName()));
        result.addMessagesFrom(saveStateResult);
        return removedEntries;
    }

    private void createInitialFileHistoryEntries(Collection<IModifiableFile> modifiableFiles, TransactionContext context, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (modifiableFiles != null) : "Parameter 'modifiableFiles' of method 'createInitialFileHistoryEntries' must not be null";
        assert (context != null) : "Parameter 'context' of method 'createInitialFileHistoryEntries' must not be null";
        assert (result != null) : "Parameter 'result' of method 'createInitialFileHistoryEntries' must not be null";
        for (IModifiableFile nextFile : modifiableFiles) {
            IUndoRedoProvider undoRedoProvider = this.m_undoRedoProviderMap.get(nextFile.getClass());
            if (undoRedoProvider == null) continue;
            assert (!this.m_fileIdToHistoryMap.containsKey(nextFile.getFileId())) : "Added file '" + nextFile.getIdentifyingPath() + "' must not be present in file history.";
            ModifiableFileHistory fileHistory = undoRedoProvider.createFileHistory(nextFile.getFile().getName(), nextFile.getFileId());
            ModifiableFileHistory previousHistory = this.m_fileIdToHistoryMap.put(nextFile.getFileId(), fileHistory);
            assert (previousHistory == null) : "No history expected for created file " + nextFile.getIdentifyingPath();
            String entryName = this.createStateFileName(nextFile, context.getId());
            this.createFileHistoryEntry(context, result, nextFile, undoRedoProvider, fileHistory, entryName, false);
        }
    }

    private void initializeFileHistory(OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (result != null) : "Parameter 'result' of method 'refreshFiles' must not be null";
        TransactionContext context = this.m_finishModelProcessor.createTxContextForFileHistoryInitialization();
        context.setNeedsReparseFlagModification(this.m_softwareSystem.consumeNeedsReparseModification());
        this.createInitialFileHistoryEntries(this.m_softwareSystem.getUniqueExistingChild(Files.class).getModifiableFiles(), context, result);
    }

    private void removeHistoryEntries(OperationResult result, Collection<IModifiableFile> toDelete) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (result != null) : "Parameter 'result' of method 'removeHistoryEntries' must not be null";
        assert (toDelete != null) : "Parameter 'toDelete' of method 'removeHistoryEntries' must not be null";
        for (IModifiableFile nextToDelete : toDelete) {
            IUndoRedoProvider undoRedoProvider = this.m_undoRedoProviderMap.get(nextToDelete.getClass());
            if (undoRedoProvider == null) continue;
            String fileId = nextToDelete.getFileId();
            ModifiableFileHistory fileHistory = this.m_fileIdToHistoryMap.remove(fileId);
            assert (fileHistory != null) : "fileHistory for file '" + nextToDelete.getAbsolutePath() + "', id=" + nextToDelete.getFileId() + " must exist";
            ArrayList<GlobalHistory.Entry> toRemove = new ArrayList<GlobalHistory.Entry>();
            for (GlobalHistory.Entry entry : this.m_globalHistoryTable.getEntries()) {
                if (!entry.getFileId().equals(fileId)) continue;
                toRemove.add(entry);
            }
            for (GlobalHistory.Entry entry : toRemove) {
                boolean removed = this.m_globalHistoryTable.removeEntry(entry);
                assert (removed) : "Entry '" + entry.toString() + "' already removed";
            }
            for (ModifiableFileHistory.FileHistoryEntry fileHistoryEntry : fileHistory.getEntries()) {
                TFile stateFile = new TFile(fileHistoryEntry.getPath());
                if (!stateFile.exists()) continue;
                try {
                    stateFile.rm();
                }
                catch (IOException ex) {
                    result.addWarning((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, "Failed to delete history state file '" + fileHistoryEntry.getPath() + "'", new Object[0]);
                }
            }
            this.removeExplicitlyAddedLastSavedStateIfExists(fileHistory, result);
            fileHistory.clear();
        }
    }

    private void removeExplicitlyAddedLastSavedStateIfExists(ModifiableFileHistory fileHistory, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (fileHistory != null) : "Parameter 'fileHistory' of method 'removeExplicitlyAddedLastSavedStateIfExists' must not be null";
        assert (result != null) : "Parameter 'result' of method 'removeExplicitlyAddedLastSavedStateIfExists' must not be null";
        ModifiableFileHistory.FileHistoryEntry explicitlyAddedLastSavedEntry = fileHistory.invalidateExplicitlyAddedLastSavedEntry();
        if (explicitlyAddedLastSavedEntry != null) {
            try {
                TFile file = new TFile(explicitlyAddedLastSavedEntry.getPath());
                if (file.exists()) {
                    TFile.rm((File)file);
                }
            }
            catch (IOException e) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, (Throwable)e);
            }
        }
    }

    private String createStateFileName(IModifiableFile file, long txId) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (file != null) : "Parameter 'file' of method 'createStateFileName' must not be null";
        return String.format("%06d", txId) + SEPARATOR + file.getFileId();
    }

    private void resetHistoryForModifiedFiles(TransactionContext context, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (context != null) : "Parameter 'context' of method 'resetHistoryForModifiedFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'resetHistoryForModifiedFiles' must not be null";
        Set<IModifiableFile> modifiedFiles = context.getModifiedFiles();
        if (modifiedFiles.isEmpty()) {
            return;
        }
        for (IModifiableFile nextFile : modifiedFiles) {
            IUndoRedoProvider undoRedoProvider = this.m_undoRedoProviderMap.get(nextFile.getClass());
            if (undoRedoProvider == null) continue;
            String fileId = nextFile.getFileId();
            ModifiableFileHistory fileHistory = this.m_fileIdToHistoryMap.get(fileId);
            assert (fileHistory != null) : "fileHistory for file '" + nextFile.getAbsolutePath() + "', id=" + nextFile.getFileId() + " must exist";
            ArrayList<GlobalHistory.Entry> toRemove = new ArrayList<GlobalHistory.Entry>();
            for (GlobalHistory.Entry entry : this.m_globalHistoryTable.getEntries()) {
                if (!entry.getFileId().equals(fileId)) continue;
                toRemove.add(entry);
            }
            for (GlobalHistory.Entry entry : toRemove) {
                boolean removed = this.m_globalHistoryTable.removeEntry(entry);
                assert (removed) : "Entry '" + entry.toString() + "' already removed";
            }
            boolean keepLastSavedState = nextFile.needsSave();
            for (ModifiableFileHistory.FileHistoryEntry entry : fileHistory.getEntries()) {
                if (keepLastSavedState && !entry.needsSave()) {
                    fileHistory.setExplicitlyAddedLastSavedEntry(entry);
                    continue;
                }
                TFile stateFile = new TFile(entry.getPath());
                if (!stateFile.exists()) continue;
                try {
                    stateFile.rm();
                }
                catch (IOException ex) {
                    result.addWarning((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE, "Failed to delete history state file '" + entry.getPath() + "'", new Object[0]);
                }
            }
            if (!keepLastSavedState) {
                this.removeExplicitlyAddedLastSavedStateIfExists(fileHistory, result);
            }
            fileHistory.clear();
            String entryName = this.createStateFileName(nextFile, context.getId());
            this.createFileHistoryEntry(context, result, nextFile, undoRedoProvider, fileHistory, entryName, false);
        }
    }

    private OperationResult processLastStateForSavedFiles(TransactionContext context, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (context != null) : "Parameter 'context' of method 'updateLastStateForSavedFiles' must not be null";
        assert (result != null) : "Parameter 'result' of method 'updateLastStateForSavedFiles' must not be null";
        for (IModifiableFile nextFile : context.getSavedFiles()) {
            LOGGER.debug("Update history state for " + nextFile.getAbsolutePath());
            IUndoRedoProvider undoRedoProvider = this.m_undoRedoProviderMap.get(nextFile.getClass());
            assert (undoRedoProvider != null) : "'undoRedoProvider' must not be null";
            ModifiableFileHistory fileHistory = this.m_fileIdToHistoryMap.get(nextFile.getFileId());
            ModifiableFileHistory.FileHistoryEntry entry = (ModifiableFileHistory.FileHistoryEntry)fileHistory.getLastAddedEntry();
            if (entry != null) {
                undoRedoProvider.updateState(nextFile, entry, context.invalidatesParserModel());
            } else {
                LOGGER.warn("No last added entry found for: " + String.valueOf(nextFile));
            }
            this.removeExplicitlyAddedLastSavedStateIfExists(fileHistory, result);
        }
        return result;
    }

    public void logHistoryState(TransactionContext context) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        if (!this.isEnabled()) {
            LOGGER.debug("**********************  No undo/redo history state for disabled extension ******************");
            return;
        }
        LOGGER.debug("**********************  Undo/redo history state ******************");
        LOGGER.debug(String.format("GlobalHistory[size=%d; nextPositionToAddEntry=%d]", this.m_globalHistoryTable.getSize(), this.m_globalHistoryTable.getUndoEntriesSize()));
        boolean index = false;
        ArrayList<GlobalHistory.Entry> currentEntries = new ArrayList<GlobalHistory.Entry>();
        GlobalHistory.Entry currentEntry = (GlobalHistory.Entry)this.m_globalHistoryTable.getLastAddedEntry();
        LOGGER.debug("  Entries for undo:");
        if (currentEntry != null) {
            for (GlobalHistory.Entry nextEntry : this.m_globalHistoryTable.getUndoEntries()) {
                if (nextEntry.getTransactionId() < currentEntry.getTransactionId()) {
                    LOGGER.debug("    " + this.logGlobalEntry(context, 0, nextEntry));
                    continue;
                }
                LOGGER.debug("last executed operation: " + this.logGlobalEntry(context, 0, nextEntry));
                currentEntries.add(nextEntry);
            }
        }
        LOGGER.debug("  Entries for redo:");
        for (GlobalHistory.Entry nextEntry : this.m_globalHistoryTable.getRedoEntries()) {
            LOGGER.debug("    " + this.logGlobalEntry(context, 0, nextEntry));
        }
        LOGGER.debug("");
        for (GlobalHistory.Entry nextCurrentEntry : currentEntries) {
            ModifiableFileHistory fileHistory = this.m_fileIdToHistoryMap.get(nextCurrentEntry.getFileId());
            LOGGER.debug("  File history for files involved in last operation: " + fileHistory.toString());
            int currentPos = fileHistory.getUndoEntriesSize();
            LOGGER.debug(String.format("     %d Entries for undo: ", currentPos - 1));
            int i = 0;
            for (IFileHistoryEntry nextEntry : fileHistory.getUndoEntries()) {
                LOGGER.debug("       " + this.logFileEntry(i++, nextEntry));
                if (i == fileHistory.getUndoEntriesSize() - 1) break;
            }
            LOGGER.debug("       Last operation:" + this.logFileEntry(currentPos, (IFileHistoryEntry)fileHistory.getLastAddedEntry()));
            LOGGER.debug(String.format("     %d Entries for redo: ", fileHistory.getRedoEntriesSize()));
            i = 0;
            for (IFileHistoryEntry nextEntry : fileHistory.getRedoEntries()) {
                LOGGER.debug("       " + this.logFileEntry(i++, nextEntry));
            }
        }
        LOGGER.debug("*************************************************************");
    }

    private String logFileEntry(int i, IFileHistoryEntry entry) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (entry != null) : "Parameter 'entry' of method 'logFileEntry' must not be null";
        return String.format("[%02d] command '%s'", i, entry.toString());
    }

    private String logGlobalEntry(TransactionContext context, int index, GlobalHistory.Entry entry) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (entry != null) : "Parameter 'entry' of method 'logGlobalEntry' must not be null";
        assert (index >= 0) : "Parameter 'index' of method 'logGlobalEntry' must be >= 0";
        return String.format("[%02d] Transaction '%d', command '%s', modifications '%s', file '%s'", index, context != null ? context.getId() : entry.getTransactionId(), entry.getCommandName(), entry.getModifications(), entry.getPath());
    }

    private void removeObsoleteEntries(List<GlobalHistory.Entry> obsoleteEntries, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (obsoleteEntries != null) : "Parameter 'obsoleteEntries' of method 'removeObsoleteEntries' must not be null";
        assert (result != null) : "Parameter 'result' of method 'removeObsoleteEntries' must not be null";
        if (obsoleteEntries.isEmpty()) {
            return;
        }
        for (GlobalHistory.Entry nextEntry : obsoleteEntries) {
            ModifiableFileHistory fileHistory = this.m_fileIdToHistoryMap.get(nextEntry.getFileId());
            ModifiableFileHistory.FileHistoryEntry toRemoveState = fileHistory.removeEntry(nextEntry.getTransactionId());
            if (toRemoveState == null) continue;
            result.addMessagesFrom(this.deleteHistoryStateFile(toRemoveState, fileHistory));
        }
    }

    private OperationResult deleteHistoryStateFile(ModifiableFileHistory.FileHistoryEntry toRemoveState, ModifiableFileHistory history) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (toRemoveState != null) : "Parameter 'toRemoveState' of method 'deleteHistoryStateFile' must not be null";
        assert (history != null) : "Parameter 'history' of method 'deleteHistoryStateFile' must not be null";
        OperationResult result = new OperationResult("Remove obsolete history state file");
        String toRemovePath = toRemoveState.getPath();
        if (!toRemoveState.needsSave()) {
            history.setExplicitlyAddedLastSavedEntry(toRemoveState);
        } else {
            TFile file = new TFile(toRemovePath);
            if (!file.exists()) {
                return result;
            }
            try {
                file.rm();
            }
            catch (IOException ex) {
                LOGGER.error(String.format("Failed to delete state file '%s'", file.getAbsolutePath()), (Throwable)ex);
            }
        }
        return result;
    }

    private void removeObsoleteFileHistoryEntries(List<ModifiableFileHistory.FileHistoryEntry> removedEntries, ModifiableFileHistory fileHistory) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (removedEntries != null) : "Parameter 'removedEntries' of method 'removeObsoleteFileHistoryEntries' must not be null";
        if (removedEntries.size() == 0) {
            return;
        }
        ArrayList<Long> transactionIds = new ArrayList<Long>();
        for (ModifiableFileHistory.FileHistoryEntry next : removedEntries) {
            transactionIds.add(next.getTransactionId());
            this.deleteHistoryStateFile(next, fileHistory);
        }
        this.m_globalHistoryTable.removeTransactions(transactionIds);
    }

    private OperationResult clearHistory() {
        assert (this.isEnabled()) : "Extension not enabled";
        OperationResult result = new OperationResult("Delete history directory '" + this.m_dataDirectory.getAbsolutePath() + "'");
        this.m_globalHistoryTable.clear();
        this.m_fileIdToHistoryMap.clear();
        try {
            this.m_dataDirectory.rm_r();
            this.m_dataDirectory.mkdir();
        }
        catch (IOException ex) {
            result.addError((OperationResult.IMessageCause)IOMessageCause.FAILED_TO_DELETE_DIRECTORY, (Throwable)ex);
        }
        return result;
    }

    @Override
    public void initialized(IWorkerContext workerContext, SoftwareSystem softwareSystem, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'initialized' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'initialized' must not be null";
        assert (result != null) : "Parameter 'result' of method 'initialized' must not be null";
        this.initializeFileHistory(result);
    }

    @Override
    public void transactionFinished(SoftwareSystem softwareSystem, TransactionContext context, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'transactionFinished' must not be null";
        assert (context != null) : "Parameter 'context' of method 'transactionFinished' must not be null";
        assert (result != null) : "Parameter 'result' of method 'transactionFinished' must not be null";
        if (context.getTransactionType() == TransactionType.RESTORE) {
            this.finishRestore(context, result);
        } else if (!context.isEmpty()) {
            this.saveState(context, result);
        }
    }

    @Override
    public void savedAs(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, EnumSet<Modification> modifications, TFile oldSystemDirectory, OperationResult result, boolean baseDirectoryChanged) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'savedAs' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'savedAs' must not be null";
        assert (oldSystemDirectory != null) : "Parameter 'oldSystemDirectory' of method 'savedAs' must not be null";
        assert (result != null) : "Parameter 'result' of method 'savedAs' must not be null";
        OperationResult clearAndInitializeResult = this.clearHistory();
        this.initializeFileHistory(clearAndInitializeResult);
        result.addMessagesFromMaintainingCurrentOutcome(clearAndInitializeResult);
        eventsToDispatch.add(new UndoRedoAvailabilityEvent(this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class), false, false));
    }

    @Override
    public void released(SoftwareSystem softwareSystem, List<SoftwareSystemEvent> eventsToDispatch, OperationResult result) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'released' must not be null";
        assert (eventsToDispatch != null) : "Parameter 'eventsToDispatch' of method 'released' must not be null";
        OperationResult clearResult = this.clearHistory();
        result.addMessagesFromMaintainingCurrentOutcome(clearResult);
        eventsToDispatch.add(new UndoRedoAvailabilityEvent(this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class), false, false));
    }

    @Override
    public int getNumberOfRestorableTransactions() {
        return this.m_globalHistoryTable.getNumberOfStoredTransactions();
    }

    private Collection<AnalyzerGroup> cancelAnalyzers(List<? extends IRestoreData> restoreInfos) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (restoreInfos != null) : "Parameter 'restoreInfos' of method 'cancelAnalyzers' must not be null";
        HashSet<AnalyzerGroup> analyzerGroups = new HashSet<AnalyzerGroup>();
        boolean reRunAllAnalyzers = false;
        for (IRestoreData iRestoreData : restoreInfos) {
            IUndoRedoProvider nextUndoRedoProvider = iRestoreData.getUndoRedoProvider();
            AnalyzerExecutionInfo executionInfo = nextUndoRedoProvider.getAnalyzerExecutionInfo(iRestoreData.getIdentifyingPath(), iRestoreData.getStateDto());
            switch (executionInfo.getMode()) {
                case ALL: {
                    reRunAllAnalyzers = true;
                    break;
                }
                case GROUPS: {
                    analyzerGroups.addAll(executionInfo.getGroups());
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    assert (false) : "Unhandled mode: " + String.valueOf((Object)executionInfo.getMode());
                    break;
                }
            }
            if (reRunAllAnalyzers) break;
        }
        if (reRunAllAnalyzers) {
            this.m_controller.cancelAndResetAllAnalyzers(ResetMode.ALL);
            return null;
        }
        if (!analyzerGroups.isEmpty()) {
            return this.m_controller.cancelAndResetAnalyzerGroups(analyzerGroups, ResetMode.ALL);
        }
        return analyzerGroups;
    }

    private void runAnalyzers(Collection<AnalyzerGroup> groups) {
        assert (this.isEnabled()) : "Extension not enabled";
        if (groups == null) {
            this.m_controller.runAutomatedAnalyzers(null);
        } else if (!groups.isEmpty()) {
            this.m_controller.runAnalyzerGroups(groups);
        }
    }

    private List<UndoRedoData> createUndoRedoData(List<GlobalHistory.Entry> entries, FileHistoryOperation operation) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (entries != null) : "Parameter 'entries' of method 'createUndoRedoData' must not be null";
        assert (operation != null) : "Parameter 'operation' of method 'createUndoRedoData' must not be null";
        ArrayList<UndoRedoData> data = new ArrayList<UndoRedoData>(entries.size());
        for (GlobalHistory.Entry entry : entries) {
            IUndoRedoProvider undoRedoProvider = this.m_undoRedoProviderMap.get(entry.getClazz());
            assert (undoRedoProvider != null) : "'nextUndoRedoProvider' of method 'createUndoRedoData' must not be null";
            ModifiableFileHistory fileHistory = this.m_fileIdToHistoryMap.get(entry.getFileId());
            RestoreStateDto dto = this.initializeRestoreDto(entry, operation, fileHistory, false);
            if (dto == null) continue;
            data.add(new UndoRedoData(undoRedoProvider, entry, dto));
        }
        return data;
    }

    @Override
    public OperationResult redo(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'redo' must not be null";
        if (!this.isRedoAvailable()) {
            return new OperationResult("No redo available");
        }
        this.m_snapshotController.waitForSaveToComplete();
        OperationResult result = null;
        INavigationState navigationState = null;
        EnumSet<Modification> determinedModifications = EnumSet.noneOf(Modification.class);
        List<GlobalHistory.Entry> entries = this.m_globalHistoryTable.redo();
        ArrayList<IModifiableFile> restoredFiles = new ArrayList<IModifiableFile>();
        List<UndoRedoData> restoreInfos = this.createUndoRedoData(entries, FileHistoryOperation.REDO);
        Collection<AnalyzerGroup> groups = this.cancelAnalyzers(restoreInfos);
        for (UndoRedoData next : restoreInfos) {
            if (result == null) {
                result = new OperationResult(String.format("Redo operation '%s'", next.getEntry().getCommandName()));
            }
            workerContext.working(String.format("Redo operation '%s'", next.getEntry().getCommandName()), true);
            List<String> otherEntriesOfTx = entries.stream().filter(e -> e != next.getEntry()).map(e -> e.getFileId()).collect(Collectors.toList());
            OperationResultWithOutcome<? extends IModifiableFile> restoreStateResult = this.restoreState(next, otherEntriesOfTx, FileHistoryOperation.REDO, determinedModifications);
            if (restoreStateResult.getErrorCauses().contains((Object)UndoRedoMessageCause.RESTORE_ABORTED)) {
                this.m_globalHistoryTable.undo();
                return result;
            }
            result.addMessagesFrom(restoreStateResult);
            if (restoreStateResult.getOutcome() != null) {
                restoredFiles.add((IModifiableFile)restoreStateResult.getOutcome());
            }
            this.logHistoryState(null);
            navigationState = next.getEntry().getNavigationState();
        }
        this.m_finishModelProcessor.finishRestore((IWorkerContext)DefaultWorkerContext.INSTANCE, this.m_softwareSystem, determinedModifications, restoredFiles, navigationState, result);
        this.runAnalyzers(groups);
        this.signalUndoRedoAvailability();
        return result;
    }

    @Override
    public OperationResult undo(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'undo' must not be null";
        if (!this.isUndoAvailable()) {
            return new OperationResult("No undo available");
        }
        this.m_snapshotController.waitForSaveToComplete();
        GlobalHistory.Entry entry = (GlobalHistory.Entry)this.m_globalHistoryTable.getNextEntryForUndo();
        OperationResult result = new OperationResult(String.format("Undo operation '%s'", entry.getCommandName()));
        workerContext.working(result.getDescription(), true);
        List<GlobalHistory.Entry> entries = this.m_globalHistoryTable.undo();
        EnumSet<Modification> determinedModifications = EnumSet.noneOf(Modification.class);
        ArrayList<IModifiableFile> restoredFiles = new ArrayList<IModifiableFile>();
        INavigationState restoreNavigationState = null;
        List<UndoRedoData> restoreInfos = this.createUndoRedoData(entries, FileHistoryOperation.UNDO);
        Collection<AnalyzerGroup> groups = this.cancelAnalyzers(restoreInfos);
        for (UndoRedoData next : restoreInfos) {
            List<String> otherEntriesOfTx;
            OperationResultWithOutcome<? extends IModifiableFile> restoreStateResult = this.restoreState(next, otherEntriesOfTx = entries.stream().filter(e -> e != next.getEntry()).map(e -> e.getFileId()).collect(Collectors.toList()), FileHistoryOperation.UNDO, determinedModifications);
            if (restoreStateResult.getErrorCauses().contains((Object)UndoRedoMessageCause.RESTORE_ABORTED)) {
                this.m_globalHistoryTable.redo();
                result.addMessagesFrom(restoreStateResult);
                return result;
            }
            result.addMessagesFrom(restoreStateResult);
            if (restoreStateResult.getOutcome() != null) {
                restoredFiles.add((IModifiableFile)restoreStateResult.getOutcome());
            }
            this.logHistoryState(null);
            restoreNavigationState = entry.getNavigationState();
        }
        this.m_finishModelProcessor.finishRestore((IWorkerContext)DefaultWorkerContext.INSTANCE, this.m_softwareSystem, determinedModifications, restoredFiles, restoreNavigationState, result);
        this.runAnalyzers(groups);
        this.signalUndoRedoAvailability();
        return result;
    }

    @Override
    public String getConfirmationMessageForNextRestore(FileHistoryOperation operation) {
        assert (this.isEnabled()) : "Extension not enabled";
        GlobalHistory.Entry entryForRestore = null;
        entryForRestore = operation == FileHistoryOperation.UNDO ? this.getNextEntryForUndo() : this.getNextEntryForRedo();
        assert (entryForRestore != null) : "no history available";
        IUndoRedoProvider undoRedoProvider = this.m_undoRedoProviderMap.get(entryForRestore.getClazz());
        assert (undoRedoProvider != null) : "'undoRedoProvider' of method 'getConfirmationMessageForNextRestore' must not be null";
        ModifiableFileHistory fileHistory = this.m_fileIdToHistoryMap.get(entryForRestore.getFileId());
        RestoreStateDto dto = this.initializeRestoreDto(entryForRestore, operation, fileHistory, true);
        return undoRedoProvider.getConfirmationMessageForNextRestore(dto);
    }

    private OperationResultWithOutcome<? extends IModifiableFile> restoreState(UndoRedoData undoRedoData, List<String> otherEntriesOfTx, FileHistoryOperation operation, EnumSet<Modification> determinedModifications) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (undoRedoData != null) : "Parameter 'undoRedoData' of method 'restoreState' must not be null";
        assert (otherEntriesOfTx != null) : "Parameter 'otherEntriesOfTx' of method 'restoreState' must not be null";
        assert (operation != null) : "Parameter 'operation' of method 'restoreState' must not be null";
        assert (determinedModifications != null) : "Parameter 'determinedModifications' of method 'restoreState' must not be null";
        IUndoRedoProvider undoRedoProvider = undoRedoData.getUndoRedoProvider();
        GlobalHistory.Entry entry = undoRedoData.getEntry();
        RestoreStateDto dto = undoRedoData.getStateDto();
        ModifiableFileHistory fileHistory = this.m_fileIdToHistoryMap.get(entry.getFileId());
        OperationResultWithOutcome<? extends IModifiableFile> result = this.m_historyStateFilePersistence.restoreState(undoRedoProvider, dto, determinedModifications, otherEntriesOfTx);
        determinedModifications.addAll(entry.getModifications());
        assert (result != null) : "Returned result must not be null";
        IModifiableFile restoredFile = (IModifiableFile)result.getOutcome();
        if (restoredFile == null || result.isFailure()) {
            if (operation == FileHistoryOperation.UNDO) {
                fileHistory.redoIt();
            } else if (operation == FileHistoryOperation.REDO) {
                fileHistory.undoIt();
            } else assert (false) : "Unsupported operation: " + operation.name();
            LOGGER.error(String.format("%s operation not successful for '%s'", operation.name(), dto.getCurrentStateFileEntry().toString()));
        } else {
            if (operation == FileHistoryOperation.UNDO && !entry.getIdentifyingPath().equals(restoredFile.getIdentifyingPath()) || operation == FileHistoryOperation.REDO && !fileHistory.getNextEntryForUndo().getIdentifyingPath().equals(restoredFile.getIdentifyingPath())) {
                dto.getCurrentStateFileEntry().setNeedsSave(false, true);
            } else {
                restoredFile.setNeedsSave(dto.getCurrentStateFileEntry().needsSave());
            }
            if (restoredFile.getTimestamp() != restoredFile.getFile().lastModified()) {
                LOGGER.error("Timestamps don't match for file '" + restoredFile.getIdentifyingPath() + "'");
            }
        }
        return result;
    }

    private RestoreStateDto initializeRestoreDto(GlobalHistory.Entry entry, FileHistoryOperation operation, ModifiableFileHistory fileHistory, boolean peekOnly) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (entry != null) : "Parameter 'entry' of method 'initializeRestoreDto' must not be null";
        assert (operation != null) : "Parameter 'operation' of method 'initializeRestoreDto' must not be null";
        assert (fileHistory != null) : "File history must exist for '" + entry.getClazz().getCanonicalName() + "', name '" + entry.getIdentifyingPath() + "'";
        if (operation == FileHistoryOperation.UNDO && !fileHistory.isUndoPossible()) {
            return null;
        }
        if (operation == FileHistoryOperation.REDO && !fileHistory.isRedoPossible()) {
            return null;
        }
        RestoreStateDto dto = new RestoreStateDto(operation);
        dto.setModifiableFileId(entry.getFileId());
        dto.setModifiableFilePath(entry.getPath());
        ModifiableFileHistory.FileHistoryEntry currentEntry = null;
        currentEntry = operation == FileHistoryOperation.UNDO ? (peekOnly ? fileHistory.getNextEntryForUndo() : fileHistory.undoIt()) : (peekOnly ? (ModifiableFileHistory.FileHistoryEntry)fileHistory.getNextEntryForRedo() : fileHistory.redoIt());
        dto.setCurrentStateFileEntry(currentEntry);
        return dto;
    }

    @Override
    public boolean isUndoAvailable() {
        return this.isEnabled() && this.m_globalHistoryTable.isUndoPossible();
    }

    @Override
    public boolean isRedoAvailable() {
        return this.isEnabled() && this.m_globalHistoryTable.isRedoPossible();
    }

    private void signalUndoRedoAvailability() {
        assert (this.isEnabled()) : "Extension not enabled";
        UndoRedoAvailabilityEvent event = new UndoRedoAvailabilityEvent(this.m_softwareSystem.getExtension(ISoftwareSystemProvider.class), this.isUndoAvailable(), this.isRedoAvailable());
        EventManager.getInstance().dispatch((Object)this, (Event)event);
    }

    @Override
    public GlobalHistory.Entry getNextEntryForUndo() {
        return !this.isUndoAvailable() ? null : ((GlobalHistory.Entry)this.m_globalHistoryTable.getLastAddedEntry()).copy();
    }

    @Override
    public GlobalHistory.Entry getNextEntryForRedo() {
        return !this.isRedoAvailable() ? null : ((GlobalHistory.Entry)this.m_globalHistoryTable.getNextEntryForRedo()).copy();
    }

    @Override
    public int getHistorySize(IModifiableFile file) {
        ModifiableFileHistory history = this.m_fileIdToHistoryMap.get(file.getFileId());
        if (history != null) {
            return history.getSize() - 1;
        }
        return -1;
    }

    private List<RevertData> createRevertData(List<IModifiableFile> files) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (files != null && !files.isEmpty()) : "Parameter 'files' of method 'createRevertData' must not be empty";
        ArrayList<RevertData> data = new ArrayList<RevertData>(files.size());
        for (IModifiableFile nextFile : files) {
            IUndoRedoProvider undoRedoProvider = this.m_undoRedoProviderMap.get(nextFile.getClass());
            assert (undoRedoProvider != null) : "Parameter 'undoRedoProvider' of method 'createRevertData' must not be null";
            ModifiableFileHistory history = this.m_fileIdToHistoryMap.get(nextFile.getFileId());
            assert (history != null) : "history for file " + nextFile.getIdentifyingPath() + " must not be null";
            RestoreStateDto dto = undoRedoProvider.startRevertOperation(history, nextFile);
            assert (dto.getCurrentStateFileEntry().getPath() != null && dto.getCurrentStateFileEntry().getPath().length() > 0) : "Path of entry to history state file must not be empty";
            data.add(new RevertData(undoRedoProvider, nextFile, history, dto));
        }
        return data;
    }

    @Override
    public OperationResult revert(IWorkerContext workerContext, List<IModifiableFile> files) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (workerContext != null) : "Parameter 'workerContext' of method 'revert' must not be null";
        assert (files != null && !files.isEmpty()) : "Parameter 'file' of method 'revert' must not be null or empty";
        this.m_snapshotController.waitForSaveToComplete();
        OperationResult overallResult = new OperationResult("Revert");
        List<RevertData> revertData = this.createRevertData(files);
        Collection<AnalyzerGroup> groups = this.cancelAnalyzers(revertData);
        EnumSet<Modification> determinedModifications = EnumSet.noneOf(Modification.class);
        HashSet<Long> toBeRemovedTxIds = new HashSet<Long>();
        for (RevertData next : revertData) {
            RestoreStateDto dto;
            IModifiableFile file = next.getModifiableFile();
            IUndoRedoProvider undoRedoProvider = next.getUndoRedoProvider();
            OperationResultWithOutcome<? extends IModifiableFile> result = this.m_historyStateFilePersistence.restoreState(undoRedoProvider, dto = next.getStateDto(), determinedModifications, Collections.emptyList());
            if (result.isSuccess()) {
                file.setNeedsSave(true);
                file.setNeedsSave(false);
                for (ModifiableFileHistory.FileHistoryEntry historyEntry : undoRedoProvider.finishRevertOperation(next.getHistory(), dto)) {
                    toBeRemovedTxIds.add(historyEntry.getTransactionId());
                    this.deleteHistoryStateFile(historyEntry, next.getHistory());
                }
            }
            overallResult.addMessagesFrom(result);
        }
        this.m_globalHistoryTable.removeTransactions(toBeRemovedTxIds);
        this.m_finishModelProcessor.finishModification(workerContext, this.m_softwareSystem, determinedModifications, overallResult);
        this.runAnalyzers(groups);
        return overallResult;
    }

    @Override
    public boolean isRevertAvailable() {
        return this.isEnabled() && !this.m_softwareSystem.getUniqueExistingChild(Files.class).getModifiableFilesNeedingSave().isEmpty();
    }

    public ModifiableFileHistory.FileHistoryEntry getLastAddedHistoryEntry(String fileId) {
        assert (this.isEnabled()) : "Extension not enabled";
        assert (fileId != null && fileId.length() > 0) : "Parameter 'fileId' of method 'getLastAddedHistoryEntry' must not be empty";
        assert (this.m_fileIdToHistoryMap.containsKey(fileId)) : "No history available for file '" + fileId + "'";
        ModifiableFileHistory history = this.m_fileIdToHistoryMap.get(fileId);
        assert (history != null) : "Parameter 'history' of method 'getLastAddedHistoryEntry' must not be null";
        return (ModifiableFileHistory.FileHistoryEntry)history.getLastAddedEntry();
    }
}

