/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controllerinterface.system.ISearchExtension;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.element.NamedElementVisitor;
import com.hello2morrow.sonargraph.core.model.path.IComponent;
import com.hello2morrow.sonargraph.core.model.path.SourceFile;
import com.hello2morrow.sonargraph.core.model.programming.ProgrammingElement;
import com.hello2morrow.sonargraph.core.model.programming.SearchCriteria;
import com.hello2morrow.sonargraph.core.model.system.Extension;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.CustomPattern;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

final class SearchExtension
extends Extension
implements ISearchExtension {
    private final SoftwareSystem m_softwareSystem;

    static boolean includeElement(Elements elements, NamedElement element) {
        assert (elements != null) : "Parameter 'elements' of method 'includeElement' must not be null";
        assert (element != null) : "Parameter 'element' of method 'includeElement' must not be null";
        if (element.ignoreInModelSearch()) {
            return false;
        }
        return switch (elements) {
            case Elements.ALL -> true;
            case Elements.EXCLUDED -> element.isExcluded();
            case Elements.ISSUE_IGNORING -> element.ignoreIssues();
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unhandled elements constant: " + String.valueOf((Object)elements)));
                }
                yield false;
            }
        };
    }

    SearchExtension(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'SearchController' must not be null";
        this.m_softwareSystem = softwareSystem;
    }

    private CustomPattern getCustomPattern(String pattern, EnumSet<SearchCriteria> criteria) {
        assert (pattern != null && pattern.length() > 0) : "Parameter 'pattern' of method 'getCustomPattern' must not be empty";
        assert (criteria != null) : "Parameter 'criteria' of method 'getCustomPattern' must not be null";
        try {
            String convertedPattern = pattern;
            CustomPattern customPattern = null;
            customPattern = criteria.contains((Object)SearchCriteria.AUTO_MATCH_TRAILING_CHARACTERS) ? CustomPattern.compileWildcardPattern((String)(StringUtility.removeTrailingChar((String)convertedPattern, (char)'*') + "**"), (boolean)criteria.contains((Object)SearchCriteria.IGNORE_CASE)) : CustomPattern.compileWildcardPattern((String)convertedPattern, (boolean)criteria.contains((Object)SearchCriteria.IGNORE_CASE));
            return customPattern;
        }
        catch (IllegalArgumentException exc) {
            return null;
        }
    }

    @Override
    public boolean isPatternValid(String pattern, EnumSet<SearchCriteria> criteria) {
        assert (pattern != null) : "Parameter 'pattern' of method 'isPatternValid' must not be null";
        assert (criteria != null) : "Parameter 'criteria' of method 'isPatternValid' must not be null";
        if (pattern.length() == 0) {
            return false;
        }
        return this.getCustomPattern(pattern, criteria) != null;
    }

    @Override
    public List<ProgrammingElement> search(IWorkerContext workerContext, String pattern, EnumSet<SearchCriteria> criteria) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'search' must not be null";
        assert (pattern != null) : "Parameter 'pattern' of method 'search' must not be null";
        assert (criteria != null) : "Parameter 'criteria' of method 'search' must not be null";
        assert (this.isPatternValid(pattern, criteria)) : "Not a valid pattern: " + pattern;
        Elements elements = Elements.ALL;
        if (criteria.contains((Object)SearchCriteria.EXCLUDED_ONLY)) {
            elements = Elements.EXCLUDED;
            assert (!criteria.contains((Object)SearchCriteria.ISSUE_IGNORING_ONLY)) : "Must not be specified: " + String.valueOf((Object)SearchCriteria.ISSUE_IGNORING_ONLY);
        } else if (criteria.contains((Object)SearchCriteria.ISSUE_IGNORING_ONLY)) {
            elements = Elements.ISSUE_IGNORING;
            assert (!criteria.contains((Object)SearchCriteria.EXCLUDED_ONLY)) : "Must not be specified: " + String.valueOf((Object)SearchCriteria.EXCLUDED_ONLY);
        }
        SearchVisitor searchVisitor = new SearchVisitor(workerContext, this.getCustomPattern(pattern, criteria), criteria.contains((Object)SearchCriteria.FULL_NAME), criteria.contains((Object)SearchCriteria.OMIT_MEMBERS), elements);
        this.m_softwareSystem.getUniqueExistingChild(Workspace.class).accept(searchVisitor);
        return searchVisitor.getMatched();
    }

    @Override
    public List<NamedElement> searchNamedElements(IWorkerContext workerContext, String pattern, EnumSet<SearchCriteria> criteria) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'searchNamedElements' must not be null";
        assert (pattern != null) : "Parameter 'pattern' of method 'searchNamedElements' must not be null";
        assert (criteria != null) : "Parameter 'criteria' of method 'searchNamedElements' must not be null";
        assert (this.isPatternValid(pattern, criteria)) : "Not a valid pattern: " + pattern;
        Elements elements = Elements.ALL;
        if (criteria.contains((Object)SearchCriteria.EXCLUDED_ONLY)) {
            elements = Elements.EXCLUDED;
            assert (!criteria.contains((Object)SearchCriteria.ISSUE_IGNORING_ONLY)) : "Must not be specified: " + String.valueOf((Object)SearchCriteria.ISSUE_IGNORING_ONLY);
        } else if (criteria.contains((Object)SearchCriteria.ISSUE_IGNORING_ONLY)) {
            elements = Elements.ISSUE_IGNORING;
            assert (!criteria.contains((Object)SearchCriteria.EXCLUDED_ONLY)) : "Must not be specified: " + String.valueOf((Object)SearchCriteria.EXCLUDED_ONLY);
        }
        SearchNamedElementsVisitor searchVisitor = new SearchNamedElementsVisitor(workerContext, this.getCustomPattern(pattern, criteria), criteria.contains((Object)SearchCriteria.FULL_NAME), criteria.contains((Object)SearchCriteria.OMIT_MEMBERS), elements);
        this.m_softwareSystem.getUniqueExistingChild(Workspace.class).accept(searchVisitor);
        return searchVisitor.getMatched();
    }

    static enum Elements {
        ALL,
        EXCLUDED,
        ISSUE_IGNORING;

    }

    static final class SearchNamedElementsVisitor
    extends NamedElementVisitor
    implements ProgrammingElement.IVisitor {
        private final List<NamedElement> m_currentlyMatching = new ArrayList<NamedElement>();
        private final IWorkerContext m_currentWorkerContext;
        private final boolean m_fullName;
        private final boolean m_omitMembers;
        private final Elements m_elements;
        private final CustomPattern m_customPattern;

        SearchNamedElementsVisitor(IWorkerContext workerContext, CustomPattern customPattern, boolean fullName, boolean omitMembers, Elements elements) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'SearchNamedElementsVisitor' must not be null";
            assert (customPattern != null) : "Parameter 'customPattern' of method 'SearchNamedElementsVisitor' must not be null";
            assert (elements != null) : "Parameter 'elements' of method 'SearchNamedElementsVisitor' must not be null";
            this.m_fullName = fullName;
            this.m_omitMembers = omitMembers;
            this.m_currentWorkerContext = workerContext;
            this.m_customPattern = customPattern;
            this.m_elements = elements;
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
            if (!this.m_currentWorkerContext.hasBeenCanceled()) {
                if ((element instanceof IComponent || element instanceof SourceFile) && SearchExtension.includeElement(this.m_elements, element) && this.m_customPattern.matches((CharSequence)element.getRawPresentationName(!this.m_fullName))) {
                    this.m_currentlyMatching.add(element);
                }
                this.visitChildrenOf(element);
            }
        }

        @Override
        public void visitProgrammingElement(ProgrammingElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
            if (!this.m_currentWorkerContext.hasBeenCanceled()) {
                if (SearchExtension.includeElement(this.m_elements, element) && (!this.m_omitMembers || !element.isMember()) && this.m_customPattern.matches((CharSequence)element.getRawPresentationName(!this.m_fullName))) {
                    this.m_currentlyMatching.add(element);
                }
                this.visitChildrenOf(element);
            }
        }

        List<NamedElement> getMatched() {
            return this.m_currentlyMatching;
        }
    }

    static final class SearchVisitor
    extends NamedElementVisitor
    implements ProgrammingElement.IVisitor {
        private final List<ProgrammingElement> m_currentlyMatching = new ArrayList<ProgrammingElement>();
        private final IWorkerContext m_currentWorkerContext;
        private final boolean m_fullName;
        private final boolean m_omitMembers;
        private final Elements m_elements;
        private final CustomPattern m_customPattern;

        SearchVisitor(IWorkerContext workerContext, CustomPattern customPattern, boolean fullName, boolean omitMembers, Elements elements) {
            assert (workerContext != null) : "Parameter 'workerContext' of method 'SearchVisitor' must not be null";
            assert (customPattern != null) : "Parameter 'customPattern' of method 'SearchVisitor' must not be null";
            assert (elements != null) : "Parameter 'elements' of method 'SearchVisitor' must not be null";
            this.m_fullName = fullName;
            this.m_omitMembers = omitMembers;
            this.m_currentWorkerContext = workerContext;
            this.m_customPattern = customPattern;
            this.m_elements = elements;
        }

        @Override
        public void visitNamedElement(NamedElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitNamedElement' must not be null";
            if (!this.m_currentWorkerContext.hasBeenCanceled()) {
                this.visitChildrenOf(element);
            }
        }

        @Override
        public void visitProgrammingElement(ProgrammingElement element) {
            assert (element != null) : "Parameter 'element' of method 'visitProgrammingElement' must not be null";
            if (!this.m_currentWorkerContext.hasBeenCanceled()) {
                if (SearchExtension.includeElement(this.m_elements, element) && (!this.m_omitMembers || !element.isMember()) && this.m_customPattern.matches((CharSequence)element.getRawPresentationName(!this.m_fullName))) {
                    this.m_currentlyMatching.add(element);
                }
                this.visitChildrenOf(element);
            }
        }

        List<ProgrammingElement> getMatched() {
            return this.m_currentlyMatching;
        }
    }
}

