/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.controller.system;

import com.hello2morrow.sonargraph.core.controller.system.ArchitectureExtension;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProvider;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderAccessor;
import com.hello2morrow.sonargraph.core.controller.system.LanguageProviderRefactoringDescriptorProvider;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitecturalViewNodeCreator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.ArchitectureFileBasedCreator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.LazyArchitecturalViewElementCreator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.LogicalModuleScopeCreator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.LogicalSystemScopeCreator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.PhysicalWithRootDirectoriesCreator;
import com.hello2morrow.sonargraph.core.controller.system.explorationview.PhysicalWithoutRootDirectoriesCreator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureFile;
import com.hello2morrow.sonargraph.core.model.architecture.IAssignableAttributeRetriever;
import com.hello2morrow.sonargraph.core.model.element.IElementResolver;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewStructureMode;
import com.hello2morrow.sonargraph.core.model.explorationview.IExplorationViewRepresentationOwner;
import com.hello2morrow.sonargraph.core.model.programming.LogicalRoot;
import com.hello2morrow.sonargraph.core.model.refactoring.AssignableToArtifactRefactoringDescriptor;
import com.hello2morrow.sonargraph.core.model.refactoring.RecursiveElementRefactoringDescriptor;
import com.hello2morrow.sonargraph.core.model.system.LogicalModuleNamespaces;
import com.hello2morrow.sonargraph.core.model.system.LogicalSystemNamespaces;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.ComponentContainer;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.CategoryProvider;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArchitecturalViewRepresentationCreator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitecturalViewRepresentationCreator.class);

    private ArchitecturalViewRepresentationCreator() {
    }

    static final Map<String, IAssignableAttributeRetriever> createAvailableAttributeRetrievers(LanguageProviderAccessor accessor) {
        assert (accessor != null) : "Parameter 'accessor' of method 'createAvailableAttributeRetrievers' must not be null";
        LOGGER.debug("Collect available attribute retrievers");
        THashMap nameToRetriever = new THashMap();
        ArrayList<IAssignableAttributeRetriever> retrievers = new ArrayList<IAssignableAttributeRetriever>(ArchitectureExtension.createCoreAssignableAttributeRetrievers());
        accessor.getAvailableLanguageProviders().forEach(lp -> {
            boolean bl = retrievers.addAll(lp.createAssignableAttributeRetrievers());
        });
        for (IAssignableAttributeRetriever nextRetriever : retrievers) {
            IAssignableAttributeRetriever previous = nameToRetriever.put(nextRetriever.getName(), nextRetriever);
            assert (previous == null) : "'previous' of method 'createAvailableAttributeRetrievers' must be null: " + nextRetriever.getName();
        }
        return nameToRetriever;
    }

    static ExplorationViewRepresentation createRepresentation(LanguageProviderAccessor accessor, SoftwareSystem softwareSystem, ExplorationViewStructureMode structureMode, IElementResolver resolver, IExplorationViewRepresentationOwner owner, String basedOnArchitectureFileIdentifyingPath) {
        assert (accessor != null) : "Parameter 'accessor' of method 'createRepresentation' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createRepresentation' must not be null";
        assert (structureMode != null) : "Parameter 'structureMode' of method 'createRepresentation' must not be null";
        assert (resolver != null) : "Parameter 'resolver' of method 'createRepresentation' must not be null";
        assert (owner != null) : "Parameter 'owner' of method 'createRepresentation' must not be null";
        assert (basedOnArchitectureFileIdentifyingPath == null || !basedOnArchitectureFileIdentifyingPath.isEmpty()) : "Parameter 'basedOnArchitectureFileIdentifyingPath' of method 'createRepresentation' must be null or not empty";
        LOGGER.debug("Create architectural view representation '" + owner.getId() + "'");
        assert (owner.getNamedElement().getUniqueChild(ExplorationViewRepresentation.class) == null) : "Representation already created";
        THashMap languageToRecursiveElementCreationDescriptor = new THashMap();
        THashMap languageToAssignableToArtifactCreationDescriptor = new THashMap();
        CategoryProvider categoryProvider = new CategoryProvider();
        ArrayList<CategoryProvider> basedUpon = new ArrayList<CategoryProvider>();
        for (LanguageProvider nextLanguageProvider : accessor.getLanguageProviders(softwareSystem.getUsedLanguages())) {
            AssignableToArtifactRefactoringDescriptor nextAssignableToArtifactCreationDescriptor;
            RecursiveElementRefactoringDescriptor nextRecursiveElementCreationDescriptor;
            LanguageProviderRefactoringDescriptorProvider nextAdapter = nextLanguageProvider.getRefactoringDescriptorProvider();
            switch (structureMode) {
                case LOGICAL_MODULE_SCOPE: {
                    basedUpon.add(nextLanguageProvider.getLogicalCategoryProvider());
                    nextRecursiveElementCreationDescriptor = nextAdapter.getLogicalModuleScopeRecursiveElementRefactoringDescriptor(softwareSystem);
                    nextAssignableToArtifactCreationDescriptor = nextAdapter.getLogicalModuleScopeAssignableToArtifactRefactoringDescriptor(softwareSystem);
                    break;
                }
                case LOGICAL_SYSTEM_SCOPE: {
                    basedUpon.add(nextLanguageProvider.getLogicalCategoryProvider());
                    nextRecursiveElementCreationDescriptor = nextAdapter.getLogicalSystemScopeRecursiveElementRefactoringDescriptor(softwareSystem, softwareSystem.getUniqueExistingChild(Workspace.class));
                    nextAssignableToArtifactCreationDescriptor = nextAdapter.getLogicalSystemScopeAssignableToArtifactRefactoringDescriptor(softwareSystem);
                    break;
                }
                case PHYSICAL_WITH_ROOT_DIRECTORIES: 
                case PHYSICAL_WITHOUT_ROOT_DIRECTORIES: {
                    basedUpon.add(nextLanguageProvider.getPhysicalCategoryProvider());
                    nextRecursiveElementCreationDescriptor = nextAdapter.getPhysicalRecursiveElementRefactoringDescriptor(softwareSystem);
                    nextAssignableToArtifactCreationDescriptor = nextAdapter.getPhysicalAssignableToArtifactRefactoringDescriptor(softwareSystem);
                    break;
                }
                default: {
                    nextRecursiveElementCreationDescriptor = null;
                    nextAssignableToArtifactCreationDescriptor = null;
                    assert (false) : "Unhandled mode: " + String.valueOf((Object)structureMode);
                    break;
                }
            }
            assert (nextRecursiveElementCreationDescriptor != null) : "'nextRecursiveElementCreationDescriptor' of method 'loadArchitecturalView' must not be null";
            languageToRecursiveElementCreationDescriptor.put(nextLanguageProvider.getLanguage(), nextRecursiveElementCreationDescriptor);
            assert (nextAssignableToArtifactCreationDescriptor != null) : "'nextAssignableToArtifactCreationDescriptor' of method 'loadArchitecturalView' must not be null";
            languageToAssignableToArtifactCreationDescriptor.put(nextLanguageProvider.getLanguage(), nextAssignableToArtifactCreationDescriptor);
        }
        if (!basedUpon.isEmpty()) {
            categoryProvider.addCategoryProviders(basedUpon);
        }
        ExplorationViewRepresentation representation = new ExplorationViewRepresentation(owner.getId(), structureMode, categoryProvider, ArchitecturalViewRepresentationCreator.createAvailableAttributeRetrievers(accessor), (Map<Language, RecursiveElementRefactoringDescriptor>)languageToRecursiveElementCreationDescriptor, (Map<Language, AssignableToArtifactRefactoringDescriptor>)languageToAssignableToArtifactCreationDescriptor, resolver, new LazyArchitecturalViewElementCreator(), owner.getOperationMode(), "ArchitectureFilterName", basedOnArchitectureFileIdentifyingPath);
        return representation;
    }

    /*
     * WARNING - void declaration
     */
    static boolean createNodes(IWorkerContext workerContext, SoftwareSystem softwareSystem, ExplorationViewRepresentation representation, ArchitectureFile architectureFile) {
        void creator22;
        void toplevelElements22;
        void createMessage22;
        assert (workerContext != null) : "Parameter 'workerContext' of method 'createNodes' must not be null";
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createNodes' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'createNodes' must not be null";
        switch (representation.getStructureMode()) {
            case PHYSICAL_WITHOUT_ROOT_DIRECTORIES: {
                assert (architectureFile == null) : "Parameter 'architectureFile' of method 'createNodes' must be null";
                Object createMessage = "Creating physical structure without root directories";
                ArchitecturalViewNodeCreator creator = new PhysicalWithoutRootDirectoriesCreator(workerContext, representation);
                List<? extends NamedElement> toplevelElements = softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(ComponentContainer.class);
                break;
            }
            case PHYSICAL_WITH_ROOT_DIRECTORIES: {
                List<? extends NamedElement> toplevelElements;
                ArchitecturalViewNodeCreator creator;
                Object createMessage;
                if (architectureFile != null) {
                    createMessage = "Creating physical structure with root directories from architecture file '" + architectureFile.getIdentifyingPath() + "'";
                    creator = new ArchitectureFileBasedCreator(workerContext, representation);
                    toplevelElements = ArchitectureFileBasedCreator.getTopLevelElements(architectureFile);
                    break;
                }
                createMessage = "Creating physical structure with root directories";
                creator = new PhysicalWithRootDirectoriesCreator(workerContext, representation);
                toplevelElements = softwareSystem.getUniqueExistingChild(Workspace.class).getChildren(ComponentContainer.class);
                break;
            }
            case LOGICAL_MODULE_SCOPE: {
                List<? extends NamedElement> toplevelElements;
                ArchitecturalViewNodeCreator creator;
                Object createMessage;
                if (architectureFile != null) {
                    createMessage = "Creating logical structure from architecture file '" + architectureFile.getIdentifyingPath() + "'";
                    creator = new ArchitectureFileBasedCreator(workerContext, representation);
                    toplevelElements = ArchitectureFileBasedCreator.getTopLevelElements(architectureFile);
                    break;
                }
                createMessage = "Creating logical structure module scope";
                creator = new LogicalModuleScopeCreator(workerContext, representation);
                toplevelElements = softwareSystem.getUniqueExistingChild(LogicalModuleNamespaces.class).getChildren(LogicalRoot.class);
                break;
            }
            case LOGICAL_SYSTEM_SCOPE: {
                assert (architectureFile == null) : "Parameter 'architectureFile' of method 'createNodes' must be null";
                Object createMessage = "Creating logical structure system scope";
                ArchitecturalViewNodeCreator creator = new LogicalSystemScopeCreator(workerContext, representation);
                List<? extends NamedElement> toplevelElements = softwareSystem.getUniqueExistingChild(LogicalSystemNamespaces.class).getChildren(LogicalRoot.class);
                break;
            }
            default: {
                assert (false) : "Unhandled structure mode: " + String.valueOf((Object)representation.getStructureMode());
                Object creator22 = null;
                Object createMessage22 = null;
                Object toplevelElements22 = null;
                return false;
            }
        }
        LOGGER.debug((String)createMessage22);
        workerContext.working((String)createMessage22, true);
        workerContext.beginBlockOfWork(toplevelElements22.size());
        for (NamedElement namedElement : toplevelElements22) {
            if (workerContext.hasBeenCanceled()) {
                LOGGER.debug((String)createMessage22 + " - done (cancelled)");
                return false;
            }
            namedElement.accept((NamedElement.INamedElementVisitor)creator22);
            workerContext.workItemCompleted();
        }
        boolean bl = creator22.finish();
        LOGGER.debug((String)createMessage22 + " - done");
        return bl;
    }
}

