/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.treemap;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.treemap.ITreeMapCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.treemap.ITreeMapCommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.treemap.TreeMapCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ITreeMapExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.treemap.TreeMapFile;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.ArrayList;
import java.util.List;

public final class LoadTreeMapCommand
extends TreeMapCommand<ILoadTreeMapInteraction> {
    public LoadTreeMapCommand(ISoftwareSystemProvider provider, ILoadTreeMapInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.LOAD_TREE_MAP;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        LoadTreeMapData data = new LoadTreeMapData();
        if (((ILoadTreeMapInteraction)this.getInteraction()).collect(data)) {
            ITreeMapExtension extension = this.getController().getSoftwareSystem().getExtension(ITreeMapExtension.class);
            OperationResult result = extension.open(workerContext, data.getFile(), data.getModules());
            ((ILoadTreeMapInteraction)this.getInteraction()).processLoadTreeMapResult(result);
        }
    }

    public static interface ILoadTreeMapInteraction
    extends ITreeMapCommandInteraction {
        public boolean collect(LoadTreeMapData var1);

        public void processLoadTreeMapResult(OperationResult var1);
    }

    public static final class LoadTreeMapData
    implements ITreeMapCommandInteractionData {
        private TreeMapFile m_file;
        private List<Module> m_modules;

        LoadTreeMapData() {
        }

        public final void setFile(TreeMapFile file, List<Module> modules) {
            assert (file != null) : "Parameter 'file' of method 'setFile' must not be null";
            assert (modules != null && !modules.isEmpty()) : "Parameter 'modules' of method 'setFile' must not be empty";
            this.m_file = file;
            this.m_modules = new ArrayList<Module>(modules);
        }

        final TreeMapFile getFile() {
            assert (this.m_file != null) : "'m_file' of method 'getFile' must not be null";
            return this.m_file;
        }

        List<Module> getModules() {
            assert (this.m_modules != null && !this.m_modules.isEmpty()) : "'m_modules' of method 'getModules' must not be empty";
            return this.m_modules;
        }
    }
}

