/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.resolution;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.SimpleSoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IIssueExtension;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.Priority;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.Result;
import java.util.List;

public final class CreateToDoCommand
extends SimpleSoftwareSystemBasedCommand {
    private final List<Element> m_elements;
    private final String m_comment;
    private final String m_assignee;
    private final Priority m_priority;

    public CreateToDoCommand(ISoftwareSystemProvider provider, SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction interaction, List<Element> elements, String comment, String assignee, Priority priority) {
        super(provider, interaction);
        assert (elements != null && !elements.isEmpty()) : "Parameter 'elements' of method 'CreateToDoCommand' must not be empty";
        assert (assignee != null) : "Parameter 'ass' of method 'CreateToDoCommand' must not be null";
        assert (priority != null) : "Parameter 'priority' of method 'CreateToDoCommand' must not be null";
        this.m_elements = elements;
        this.m_comment = comment;
        this.m_assignee = assignee;
        this.m_priority = priority;
    }

    @Override
    public final ICommandId getId() {
        return CoreCommandId.CREATE_TODO_TASK;
    }

    @Override
    public final Result isEnabled() {
        Result enabled = super.isEnabled();
        if (enabled.isSuccess() && !this.getController().getSoftwareSystem().getCurrentModel().isModifiable()) {
            enabled.addErrorMessage("Virtual model not modifiable");
        }
        return enabled;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        OperationResult result = this.getController().getSoftwareSystem().getExtension(IIssueExtension.class).createToDo(workerContext, this.m_elements, this.m_comment, this.m_assignee, this.m_priority);
        ((SimpleSoftwareSystemBasedCommand.ISimpleCommandInteraction)this.getInteraction()).process(result);
    }
}

