/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.qualitygate;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionWithResult;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IQualityGateExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.qualitygate.QualityGate;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.List;

public final class DeleteQualityGateCommand
extends SoftwareSystemBasedCommand<IDeleteInteraction> {
    public DeleteQualityGateCommand(ISoftwareSystemProvider provider, IDeleteInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.DELETE_QUALITY_GATE;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        InteractionData data = new InteractionData();
        StringBuilder question = new StringBuilder();
        question.append("Deleting quality gates cannot be undone.").append(StringUtility.LINE_SEPARATOR).append(StringUtility.LINE_SEPARATOR).append("Do you want to continue?");
        if (!((IDeleteInteraction)this.getInteraction()).collect(data) || !((IDeleteInteraction)this.getInteraction()).confirmDeletion(question.toString())) {
            return;
        }
        IQualityGateExtension extension = this.getController().getSoftwareSystem().getExtension(IQualityGateExtension.class);
        extension.delete(workerContext, data.getToDelete());
    }

    public static interface IDeleteInteraction
    extends ICommandInteractionWithResult {
        public boolean collect(InteractionData var1);

        public boolean confirmDeletion(String var1);
    }

    public static final class InteractionData {
        private final List<QualityGate> m_toDelete = new ArrayList<QualityGate>();

        public void addQualityGate(QualityGate toDelete) {
            assert (toDelete != null) : "Parameter 'toDelete' of method 'setQualityGate' must not be null";
            this.m_toDelete.add(toDelete);
        }

        public List<QualityGate> getToDelete() {
            return this.m_toDelete;
        }
    }
}

