/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.diff;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.ISystemDiffExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.diff.BaselineType;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class EnableBaselineCommand
extends SoftwareSystemBasedCommand<EnableBaselineCommandInteraction> {
    public EnableBaselineCommand(ISoftwareSystemProvider provider, EnableBaselineCommandInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.ENABLE_BASELINE;
    }

    @Override
    public ActivityMode getActivityMode() {
        return ActivityMode.MODAL;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    public boolean providesProgress() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        EnableBaselineInteractionData data;
        EnableBaselineCommandInteraction interaction = (EnableBaselineCommandInteraction)this.getInteraction();
        if (!interaction.collect(data = new EnableBaselineInteractionData())) {
            return;
        }
        OperationResult result = this.getController().getSoftwareSystem().getExtension(ISystemDiffExtension.class).enableBaseline(workerContext, data.getBaselineType(), data.enable());
        interaction.processResult(result);
    }

    public static interface EnableBaselineCommandInteraction
    extends ICommandInteraction {
        public boolean collect(EnableBaselineInteractionData var1);

        public void processResult(OperationResult var1);
    }

    public static final class EnableBaselineInteractionData
    implements ICommandInteractionData {
        private BaselineType m_baselineType;
        private boolean m_enable;

        EnableBaselineInteractionData() {
        }

        public void setData(BaselineType baselineType, boolean enable) {
            assert (baselineType != null) : "Parameter 'baselineType' of method 'setData' must not be null";
            this.m_baselineType = baselineType;
            this.m_enable = enable;
        }

        BaselineType getBaselineType() {
            assert (this.m_baselineType != null) : "'m_baselineType' of method 'getBaselineType' must not be null";
            return this.m_baselineType;
        }

        boolean enable() {
            return this.m_enable;
        }
    }
}

