/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArtifactFilterData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.explorationview.ArtifactNode;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class EditArtifactCommand
extends ArchitecturalViewCommand<IEditArtifactInteraction> {
    public EditArtifactCommand(ISoftwareSystemProvider provider, IEditArtifactInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.EDIT_ARCHITECTURAL_VIEW_ARTIFACT;
    }

    @Override
    public boolean isUndoable() {
        return true;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        EditArtifactData data = new EditArtifactData();
        if (!((IEditArtifactInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        OperationResult result = extension.editArtifact(workerContext, data.getArtifact(), data.getTargetInfo(), data.getShortName(), data.getArtifactProperties(), data.getFilter());
        ((IEditArtifactInteraction)this.getInteraction()).processEditArtifactResult(result);
    }

    public static final class EditArtifactData
    extends ArtifactFilterData {
        private ArtifactNode m_artifactNode;

        public void setArtifact(ArtifactNode artifactNode) {
            assert (artifactNode != null) : "Parameter 'artifactNode' of method 'setArtifact' must not be null";
            this.m_artifactNode = artifactNode;
        }

        ArtifactNode getArtifact() {
            assert (this.m_artifactNode != null) : "Parameter 'm_artifactNode' of method 'getArtifact' must not be null";
            return this.m_artifactNode;
        }
    }

    public static interface IEditArtifactInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(EditArtifactData var1);

        public void processEditArtifactResult(OperationResult var1);
    }
}

