/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewCommand;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.ArchitecturalViewRepresentationData;
import com.hello2morrow.sonargraph.core.command.system.architecturalview.IArchitecturalViewCommandInteraction;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IArchitecturalViewExtension;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class ClearFocusCommand
extends ArchitecturalViewCommand<IClearFocusInteraction> {
    public ClearFocusCommand(ISoftwareSystemProvider provider, IClearFocusInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CLEAR_ARCHITECTURAL_VIEW_FOCUS;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (this.getController().hasSoftwareSystem()) : "No system available";
        ArchitecturalViewRepresentationData data = new ArchitecturalViewRepresentationData();
        if (!((IClearFocusInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        IArchitecturalViewExtension extension = this.getController().getSoftwareSystem().getExtension(IArchitecturalViewExtension.class);
        OperationResult result = extension.clearFocus(workerContext, data.getRepresentation());
        ((IClearFocusInteraction)this.getInteraction()).processClearResult(result);
    }

    public static interface IClearFocusInteraction
    extends IArchitecturalViewCommandInteraction {
        public boolean collect(ArchitecturalViewRepresentationData var1);

        public void processClearResult(OperationResult var1);
    }
}

