/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SonargraphCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IQualityModelImportExportExtension;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IQualityModelImportExtension;
import com.hello2morrow.sonargraph.core.model.path.ImportQualityModel;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import de.schlichtherle.truezip.file.TFile;

public final class LoadQualityModelCommand
extends SonargraphCommand {
    private final TFile m_userInput;
    private final boolean m_isSystemCreation;
    private ImportQualityModel m_importQualityModel;

    public LoadQualityModelCommand(ISoftwareSystemProvider provider, TFile userInput, boolean isSystemCreation) {
        super(provider);
        assert (userInput != null) : "Parameter 'userInput' of method 'LoadQualityModelImportCandidatesCommand' must not be null";
        this.m_userInput = userInput;
        this.m_isSystemCreation = isSystemCreation;
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.LOAD_QUALITY_MODEL_IMPORT_CANDIDATES;
    }

    @Override
    protected boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        this.m_importQualityModel = this.m_isSystemCreation ? this.getController().getInstallation().getExtension(IQualityModelImportExtension.class).createQualityModel(this.m_userInput) : this.getController().getSoftwareSystem().getExtension(IQualityModelImportExportExtension.class).createQualityModel(this.m_userInput);
    }

    public ImportQualityModel getImportQualityModel() {
        return this.m_importQualityModel;
    }
}

