/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IAnalyzerExtension;
import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerConfigurationFile;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;

public final class DeleteAnalyzerConfigurationFileCommand
extends SoftwareSystemBasedCommand<IInteraction> {
    public DeleteAnalyzerConfigurationFileCommand(IInteraction interaction, ISoftwareSystemProvider provider) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.DELETE_ANALYZER_FILE;
    }

    @Override
    public boolean isUndoable() {
        return false;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        InteractionData data = new InteractionData();
        if (!((IInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        OperationResult result = this.getController().getSoftwareSystem().getExtension(IAnalyzerExtension.class).delete(workerContext, data.getAnalyzerConfigurationFile());
        ((IInteraction)this.getInteraction()).processDeletionResult(result);
    }

    public static interface IInteraction
    extends ICommandInteraction {
        public boolean collect(InteractionData var1);

        public void processDeletionResult(OperationResult var1);
    }

    public static final class InteractionData
    implements ICommandInteractionData {
        private AnalyzerConfigurationFile m_analyzerConfigurationFile;

        public void setConfigurationFile(AnalyzerConfigurationFile file) {
            assert (file != null) : "Parameter 'file' of method 'setConfigurationFile' must not be null";
            this.m_analyzerConfigurationFile = file;
        }

        public AnalyzerConfigurationFile getAnalyzerConfigurationFile() {
            return this.m_analyzerConfigurationFile;
        }
    }
}

