/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteraction;
import com.hello2morrow.sonargraph.core.command.common.ICommandInteractionData;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.command.system.base.SoftwareSystemBasedCommand;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IVirtualModelExtension;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.ModifiableModel;
import com.hello2morrow.sonargraph.core.model.system.VirtualModel;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;

public final class CreateModifiableModelCommand
extends SoftwareSystemBasedCommand<ICreateInteraction> {
    public static ITextValidator getModelNameValidator(ISoftwareSystemProvider provider) {
        assert (provider != null) : "Parameter 'provider' of method 'getModelNameValidator' must not be null";
        IVirtualModelExtension virtualModelExtension = provider.getSoftwareSystem().getExtension(IVirtualModelExtension.class);
        return virtualModelExtension.getModifiableModelNameValidator();
    }

    public CreateModifiableModelCommand(ISoftwareSystemProvider provider, ICreateInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.CREATE_MODIFIABLE_MODEL;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'internalRun' must not be null";
        CreateModifiableModelData createData = new CreateModifiableModelData();
        if (((ICreateInteraction)this.getInteraction()).collect(createData)) {
            IVirtualModelExtension virtualModelExtension = this.getController().getSoftwareSystem().getExtension(IVirtualModelExtension.class);
            OperationResultWithOutcome<ModifiableModel> result = virtualModelExtension.createModifiableModel(workerContext, createData.getModelName(), createData.getDescription(), createData.getBasedOn(), createData.setModel());
            ((ICreateInteraction)this.getInteraction()).processCreateResult((OperationResult)result);
        }
    }

    public static final class CreateModifiableModelData
    implements ICommandInteractionData {
        private String m_modelName;
        private String m_description = "";
        private VirtualModel m_basedOn;
        private boolean m_set;

        CreateModifiableModelData() {
        }

        final String getModelName() {
            return this.m_modelName;
        }

        public final void setModelName(String modelName) {
            assert (modelName != null && modelName.length() > 0) : "Parameter 'modelName' of method 'setModelName' must not be empty";
            this.m_modelName = modelName;
        }

        final String getDescription() {
            assert (this.m_description != null) : "Parameter 'm_description' of method 'getDescription' must not be null";
            return this.m_description;
        }

        public final void setDescription(String description) {
            assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
            this.m_description = description;
        }

        public final void setBasedOn(VirtualModel virtualModel) {
            assert (virtualModel != null) : "Parameter 'virtualModel' of method 'setBasedOn' must not be null";
            this.m_basedOn = virtualModel;
        }

        final VirtualModel getBasedOn() {
            assert (this.m_basedOn != null) : "Parameter 'm_basedOn' of method 'getBasedOn' must not be null";
            return this.m_basedOn;
        }

        boolean setModel() {
            return this.m_set;
        }

        public void setModel(boolean set) {
            this.m_set = set;
        }
    }

    public static interface ICreateInteraction
    extends ICommandInteraction {
        public boolean collect(CreateModifiableModelData var1);

        public void processCreateResult(OperationResult var1);
    }
}

