/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.command.system;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.CreateRefactoringCommand;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.controllerinterface.system.IIssueExtension;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.StructureMode;
import com.hello2morrow.sonargraph.core.model.refactoring.DeleteRefactoringData;
import com.hello2morrow.sonargraph.core.model.system.IIssueProvider;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import java.util.List;

public final class CreateDeleteRefactoringCommand
extends CreateRefactoringCommand<IInteraction> {
    public CreateDeleteRefactoringCommand(ISoftwareSystemProvider provider, IInteraction interaction) {
        super(provider, interaction);
    }

    @Override
    public ICommandId getId() {
        return CoreCommandId.REFACTORING_DELETE;
    }

    @Override
    protected void internalRun(IWorkerContext workerContext) {
        InteractionData data = new InteractionData();
        if (!((IInteraction)this.getInteraction()).collect(data)) {
            return;
        }
        OperationResult result = this.getController().getSoftwareSystem().getExtension(IIssueExtension.class).createDeleteRefactoring(workerContext, data.getDeleteRefactoringData(), data.getAssignee(), data.getPriority(), data.getDescription());
        ((IInteraction)this.getInteraction()).processResult(result);
    }

    public static DeleteRefactoringData createDeleteRefactoringData(SoftwareSystem softwareSystem, List<Element> selected, StructureMode structureMode) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'createDeleteRefactoringData' must not be null";
        assert (selected != null) : "Parameter 'selected' of method 'createDeleteRefactoringData' must not be null";
        assert (structureMode != null) : "Parameter 'structureMode' of method 'createDeleteRefactoringData' must not be null";
        return softwareSystem.getExtension(IIssueProvider.class).isDeleteRefactoringPossible(selected, structureMode);
    }

    public static interface IInteraction
    extends CreateRefactoringCommand.IInteraction {
        public boolean collect(InteractionData var1);
    }

    public static final class InteractionData
    extends CreateRefactoringCommand.InteractionData {
        private DeleteRefactoringData m_data;

        public void setDeleteRefactoringData(DeleteRefactoringData data) {
            assert (data != null) : "Parameter 'data' of method 'setDeleteRefactoringData' must not be null";
            this.m_data = data;
        }

        public DeleteRefactoringData getDeleteRefactoringData() {
            return this.m_data;
        }
    }
}

