/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.core.api.model;

import com.hello2morrow.sonargraph.api.IDirectoryAccess;
import com.hello2morrow.sonargraph.api.IModuleAccess;
import com.hello2morrow.sonargraph.api.INamedElementAccess;
import com.hello2morrow.sonargraph.core.api.model.ElementAccess;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricLevel;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import java.util.ArrayList;
import java.util.List;

public class ModuleAccess
extends ElementAccess<Module>
implements IModuleAccess {
    public ModuleAccess(Module element) {
        super(element);
    }

    public final List<IDirectoryAccess> getSourceRootDirectories() {
        ArrayList<IDirectoryAccess> result = new ArrayList<IDirectoryAccess>();
        for (RootDirectoryPath rootDirectoryPath : ((Module)this.m_element).getSourceRootDirectoryPaths()) {
            if (!rootDirectoryPath.isEnabled()) continue;
            result.add((IDirectoryAccess)this.m_factory.createAccessObject(rootDirectoryPath));
        }
        return result;
    }

    @Override
    public Object getMetricLevel() {
        return CoreMetricLevel.MODULE;
    }

    public final String getLanguage() {
        return ((Module)this.m_element).getLanguage().getPresentationName();
    }

    public Float getACDMetric() {
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_ACD);
    }

    public Integer getBiggestComponentCycleGroupMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_BIGGEST_COMPONENT_CYCLE_GROUP);
    }

    public Integer getCCDMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_CCD);
    }

    public Float getPropagationCostMetric() {
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_PROPAGATION_COST);
    }

    public Integer getCodeCommentLinesMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_CODE_COMMENT_LINES);
    }

    public Integer getCommentLinesMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_COMMENT_LINES);
    }

    public Integer getLinesOfCodeMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_LINES_OF_CODE);
    }

    public Float getNCCDMetric() {
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_NCCD);
    }

    public Integer getNumberOfComponentCycleGroupsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_COMPONENT_CYCLE_GROUPS);
    }

    public Integer getNumberOfComponentsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_COMPONENTS);
    }

    public Integer getNumberOfCyclicComponentsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_CYCLIC_COMPONENTS);
    }

    public Integer getNumberOfIgnoredCyclicComponentsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_IGNORED_CYCLIC_COMPONENTS);
    }

    public Integer getNumberOfStatementsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_STATEMENTS);
    }

    public Integer getSourceElementCountMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_SOURCE_ELEMENT_COUNT);
    }

    public Integer getTotalLinesMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_TOTAL_LINES);
    }

    public Integer getComponentCyclicityMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_CYCLICITY_COMPONENTS);
    }

    public Float getComponentRelativeCyclicityMetric() {
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_RELATIVE_CYCLICITY_COMPONENTS);
    }

    public Integer getComponentStructuralDebtIndexMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_STRUCTURAL_DEBT_INDEX_COMPONENTS);
    }

    public Integer getComponentReferencesToCutMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_PARSER_DEPENDENCIES_TO_REMOVE_COMPONENTS);
    }

    public Integer getComponentComponentDependenciesToCutMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_COMPONENT_DEPENDENCIES_TO_REMOVE_COMPONENTS);
    }

    public Integer getNumberOfUnassignedComponentsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_UNASSIGNED_COMPONENTS);
    }

    public Integer getNumberOfComponentViolationsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_VIOLATIONS_COMPONENT_DEPENDENCIES);
    }

    public Integer getNumberOfViolatingComponentsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_VIOLATING_COMPONENTS);
    }

    @Deprecated
    public Integer getNumberOfAllViolatingComponentsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_VIOLATING_COMPONENTS);
    }

    public Integer getNumberOfParserDependencyViolationsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_VIOLATIONS_PARSER_DEPENDENCIES);
    }

    public Integer getNumberOfIgnoredParserDependencyViolationsMetric() {
        return (Integer)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_IGNORED_VIOLATIONS_PARSER_DEPENDENCIES);
    }

    public Float getMaintainabilityLevelMetric() {
        return (Float)this.m_factory.getMetricValue((NamedElement)this.m_element, CoreMetricLevel.MODULE, CoreMetricId.CORE_MAINTAINABILITY_LEVEL);
    }

    @Override
    public void accept(INamedElementAccess.INamedElementAccessVisitor visitor) {
        if (visitor instanceof IModuleAccess.IVisitor) {
            ((IModuleAccess.IVisitor)visitor).visitModuleAccess((IModuleAccess)this);
        } else {
            super.accept(visitor);
        }
    }
}

