/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.event;

import com.hello2morrow.sonargraph.foundation.event.Dispatcher;
import com.hello2morrow.sonargraph.foundation.event.Event;
import com.hello2morrow.sonargraph.foundation.event.EventHandler;
import com.hello2morrow.sonargraph.foundation.event.IEventForwarder;
import com.hello2morrow.sonargraph.foundation.event.IRegistrantRequestPerformed;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventManager.class);
    private static final EventManager s_instance = new EventManager();
    private final Dispatcher m_dispatcher = new Dispatcher();

    private EventManager() {
    }

    public static EventManager getInstance() {
        return s_instance;
    }

    public void setEventForwarder(IEventForwarder forwarder) {
        this.m_dispatcher.setEventForwarder(forwarder);
    }

    public <T extends Event> void dispatch(Object emitter, T event) {
        assert (event != null) : "'event' must not be null";
        if (LOGGER.isTraceEnabled()) {
            event.addDebugInfo("Event dispatch info [Emitter: " + emitter.getClass().getName() + "]" + StringUtility.LINE_SEPARATOR + ExceptionUtility.collectAll(new Throwable("Event dispatch stack")));
        }
        this.m_dispatcher.dispatch(this.m_dispatcher.getEventAdapter(event.getClass()), emitter, event);
    }

    public <T extends Event> boolean attach(EventHandler<T> handler) {
        assert (handler != null) : "'handler' must not be null";
        if (!this.isAttached(handler.getEventClass(), handler.getRegistrant())) {
            this.m_dispatcher.addEventHandler(this.m_dispatcher.getEventAdapter(handler.getEventClass()), handler);
            return true;
        }
        return false;
    }

    public <T extends Event> boolean detach(Class<T> eventClass, Object registrant) {
        assert (eventClass != null) : "Parameter 'eventClass' of method 'detach' must not be null";
        assert (registrant != null) : "Parameter 'registrant' of method 'detach' must not be null";
        if (this.isAttached(eventClass, registrant)) {
            this.m_dispatcher.removeEventHandler(eventClass, registrant);
            return true;
        }
        return false;
    }

    public <T extends Event> boolean isAttached(Class<T> eventClass, Object registrant) {
        assert (eventClass != null) : "Parameter 'eventClass' of method 'isAttached' must not be null";
        assert (registrant != null) : "Parameter 'registrant' of method 'isAttached' must not be null";
        return this.m_dispatcher.isAttached(eventClass, registrant);
    }

    public <T extends Event> boolean isEventHandled(Class<T> eventClass) {
        assert (eventClass != null) : "Parameter 'eventClass' of method 'isEventHandled' must not be null";
        return this.m_dispatcher.hasHandlers(this.m_dispatcher.getEventAdapter(eventClass));
    }

    public void putToSleep(Object registrant, IRegistrantRequestPerformed performed) {
        assert (registrant != null) : "Parameter 'registrant' of method 'putToSleep' must not be null";
        assert (performed != null) : "Parameter 'performed' of method 'putToSleep' must not be null";
        this.m_dispatcher.putToSleep(registrant, performed);
    }

    public void wakeUp(Object registrant, IRegistrantRequestPerformed performed) {
        assert (registrant != null) : "Parameter 'registrant' of method 'wakeUp' must not be null";
        assert (performed != null) : "Parameter 'performed' of method 'wakeUp' must not be null";
        this.m_dispatcher.wakeUp(registrant, performed);
    }
}

