/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.commandline;

import com.hello2morrow.sonargraph.foundation.commandline.ProcessMessageSink;
import com.hello2morrow.sonargraph.foundation.commandline.ProcessStream;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class ProcessExecutor {
    private ProcessExecutor() {
    }

    public static String execute(List<String> cmd, TFile workingDirectory, OperationResult operationResult, OperationResult.IMessageCause errorCause) {
        assert (cmd != null && cmd.size() > 0) : "Parameter 'cmd' of method 'execute' must not be empty";
        assert (operationResult != null) : "Parameter 'operationResult' of method 'execute' must not be null";
        assert (errorCause != null) : "Parameter 'errorCause' of method 'execute' must not be null";
        ProcessOperationResult processOperationResult = new ProcessOperationResult(operationResult.getDescription());
        ProcessExecutor.execute(cmd, workingDirectory, processOperationResult, errorCause);
        operationResult.addMessagesFrom(processOperationResult);
        return processOperationResult.getOutput();
    }

    public static boolean execute(List<String> cmd, TFile workingDirectory, ProcessOperationResult operationResult, OperationResult.IMessageCause errorCause) {
        assert (cmd != null && cmd.size() > 0) : "Parameter 'cmd' of method 'execute' must not be empty";
        assert (operationResult != null) : "Parameter 'operationResult' of method 'execute' must not be null";
        assert (errorCause != null) : "Parameter 'errorCause' of method 'execute' must not be null";
        String output = "";
        String errors = "";
        ProcessBuilder builder = new ProcessBuilder(cmd);
        if (workingDirectory != null) {
            builder.directory((File)workingDirectory);
        }
        Process process = null;
        try {
            process = builder.start();
            ProcessStream outputStream = new ProcessStream("STANDARD OUT", process.getInputStream(), null);
            ProcessStream errorStream = new ProcessStream("STANDARD ERR", process.getErrorStream(), operationResult.getMessageSink());
            outputStream.start();
            errorStream.start();
            process.waitFor();
            outputStream.join();
            errorStream.join();
            int exitValue = process.exitValue();
            output = outputStream.getOutput();
            errors = errorStream.getOutput();
            operationResult.setExitValue(exitValue);
            operationResult.setOutput(output);
            if (exitValue != 0) {
                String msg = errors.length() > 0 ? errors : output;
                operationResult.addWarning((OperationResult.IMessageCause)ProcessMessageCause.EXIT_VALUE_NOT_ZERO, "Exit value: %s%s", exitValue, msg.isEmpty() ? ", no output!" : "\n" + msg);
                operationResult.setOutput(msg);
                return false;
            }
            return true;
        }
        catch (IOException | InterruptedException ex) {
            operationResult.addError(errorCause, ex);
            operationResult.setExitValue(-1);
            operationResult.setOutput("");
            return false;
        }
    }

    public static OperationResultWithOutcome<String> which(String executable) {
        boolean success;
        assert (executable != null && executable.length() > 0) : "Parameter 'executable' of method 'which' must not be empty";
        ProcessOperationResult processResult = new ProcessOperationResult("Searching for executable " + executable);
        boolean bl = success = Platform.isWindows() ? ProcessExecutor.execute(Arrays.asList("where", executable), null, processResult, (OperationResult.IMessageCause)WhichMessageCause.WHERE_NOT_FOUND) : ProcessExecutor.execute(Arrays.asList("which", executable), null, processResult, (OperationResult.IMessageCause)WhichMessageCause.WHICH_NOT_FOUND);
        if (!success && processResult.getExitValue() == 1) {
            String usrLocalBin;
            TFile file;
            if (Platform.isMac() && (file = new TFile(usrLocalBin = "/usr/local/bin/" + executable)).exists() && file.isFile()) {
                processResult.setExitValue(0);
                processResult.setIsSuccess(true);
                processResult.setOutput(usrLocalBin);
                return processResult.adaptToOutcomeString();
            }
            processResult.addWarning((OperationResult.IMessageCause)WhichMessageCause.EXECUTABLE_NOT_FOUND, "'%s' not found.", executable);
            OperationResultWithOutcome<String> result = processResult.adaptToOutcomeString();
            result.setIsSuccess(false);
            return result;
        }
        return processResult.adaptToOutcomeString();
    }

    public static enum ProcessMessageCause implements OperationResult.IMessageCause
    {
        EXIT_VALUE_NOT_ZERO;


        @Override
        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName(this.name());
        }

        @Override
        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName(this.name());
        }
    }

    public static class ProcessOperationResult
    extends OperationResult {
        private int m_exitValue = -1;
        private String m_output;
        private final ProcessMessageSink m_messageSink;

        public ProcessOperationResult(String description) {
            this(description, null);
        }

        public ProcessOperationResult(String description, ProcessMessageSink messageSink) {
            super(description);
            this.m_messageSink = messageSink;
        }

        public ProcessMessageSink getMessageSink() {
            return this.m_messageSink;
        }

        public int getExitValue() {
            return this.m_exitValue;
        }

        public void setExitValue(int exitValue) {
            this.m_exitValue = exitValue;
        }

        public String getOutput() {
            return this.m_output == null ? "" : this.m_output;
        }

        public void setOutput(String output) {
            this.m_output = output;
        }

        public OperationResultWithOutcome<String> adaptToOutcomeString() {
            OperationResultWithOutcome<String> result = new OperationResultWithOutcome<String>(this.getDescription());
            result.addMessagesFrom(this);
            result.setOutcome(this.getOutput());
            return result;
        }
    }

    private static enum WhichMessageCause implements OperationResult.IMessageCause
    {
        WHICH_NOT_FOUND,
        WHERE_NOT_FOUND,
        EXECUTABLE_NOT_FOUND;


        @Override
        public String getStandardName() {
            return StringUtility.convertConstantNameToStandardName(this.name());
        }

        @Override
        public String getPresentationName() {
            return StringUtility.convertConstantNameToPresentationName(this.name());
        }
    }
}

