/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.windows;

import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.foundation.windows.WinRegistryJava11;
import com.hello2morrow.sonargraph.foundation.windows.WinRegistryJava8;
import java.util.List;
import java.util.Map;

public final class WinRegistry {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    public static final int REG_SUCCESS = 0;
    public static final int REG_NOTFOUND = 2;
    public static final int REG_ACCESSDENIED = 5;

    private WinRegistry() {
        assert (!Platform.isOperatingSystemUnixBased()) : "WinRegistry should only be used on Windows";
    }

    public static String readString(long hkey, String key, String valueName) {
        if (Platform.getJavaVersion() == 8) {
            return WinRegistryJava8.readString((int)hkey, key, valueName);
        }
        return WinRegistryJava11.readString(hkey, key, valueName);
    }

    public static Map<String, String> readStringValues(long hkey, String key) {
        if (Platform.getJavaVersion() == 8) {
            return WinRegistryJava8.readStringValues((int)hkey, key);
        }
        return WinRegistryJava11.readStringValues(hkey, key);
    }

    public static List<String> readStringSubKeys(int hkey, String key) {
        if (Platform.getJavaVersion() == 8) {
            return WinRegistryJava8.readStringSubKeys(hkey, key);
        }
        return WinRegistryJava11.readStringSubKeys(hkey, key);
    }
}

