/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SystemEnvSupport {
    private SystemEnvSupport() {
    }

    public static Pair<String, String> resolve(String input) {
        assert (input != null) : "Parameter 'input' of method 'resolve' must not be null";
        return SystemEnvSupport.resolve(input, Platform.isWindows());
    }

    static Pair<String, String> resolve(String input, boolean isWindows) {
        assert (input != null) : "Parameter 'input' of method 'resolve' must not be null";
        if (input.trim().isEmpty()) {
            return new Pair<String, String>(input, input);
        }
        String resolved = input;
        String escaped = input;
        for (Map.Entry<String, String> next : SystemEnvSupport.detectEnvVars(input, isWindows).entrySet()) {
            resolved = resolved.replace(next.getKey(), next.getValue());
            escaped = escaped.replace(next.getKey(), SystemEnvSupport.replacePlatformVarWithEscaped(next.getKey(), isWindows));
        }
        return new Pair<String, String>(resolved, escaped);
    }

    public static String resolveEscaped(String input) {
        assert (input != null) : "Parameter 'input' of method 'resolveEscaped' must not be null";
        if (input.trim().isEmpty()) {
            return input;
        }
        String resolved = input;
        for (Map.Entry<String, String> next : SystemEnvSupport.detectEscapedEnvVars(input).entrySet()) {
            resolved = resolved.replace(next.getKey(), next.getValue());
        }
        return resolved;
    }

    private static Map<String, String> detectEnvVars(String input, boolean isWindows) {
        assert (input != null) : "Parameter 'input' of method 'detectEnvVars' must not be null";
        if (input.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> envVars = new LinkedHashMap<String, String>();
        int groupStart = -1;
        int groupEnd = -1;
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (isWindows) {
                if (c == '%') {
                    if (groupStart == -1) {
                        groupStart = i;
                        groupEnd = -1;
                    } else if (groupEnd == -1) {
                        groupEnd = i;
                    }
                }
            } else {
                if (c == '$') {
                    groupStart = i;
                    groupEnd = -1;
                } else if ((c == '/' || c == ':') && groupEnd == -1) {
                    groupEnd = i;
                }
                if (i == input.length() - 1 && groupEnd == -1) {
                    groupEnd = i + 1;
                }
            }
            if (groupStart > -1 && groupEnd > -1) {
                String value;
                String key = input.substring(groupStart + 1, groupEnd);
                if (!key.trim().isEmpty() && (value = System.getenv(key)) != null) {
                    if (isWindows) {
                        envVars.put(input.substring(groupStart, groupEnd + 1), value);
                    } else {
                        envVars.put(input.substring(groupStart, groupEnd), value);
                    }
                }
                groupStart = -1;
            }
            ++i;
        }
        return envVars;
    }

    private static String replacePlatformVarWithEscaped(String key, boolean isWindows) {
        assert (key != null && key.length() > 0) : "Parameter 'key' of method 'replacePlatformVarWithEscaped' must not be empty";
        String part = isWindows ? key.substring(1, key.length() - 1) : key.substring(1);
        return "${" + part + "}";
    }

    private static Map<String, String> detectEscapedEnvVars(String input) {
        assert (input != null) : "Parameter 'input' of method 'detectEnvVars' must not be null";
        if (input.trim().isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> envVars = new LinkedHashMap<String, String>();
        int dollar = -1;
        int openingCurly = -1;
        int closingCurly = -1;
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c == '$') {
                if (dollar == -1) {
                    dollar = i;
                    openingCurly = -1;
                    closingCurly = -1;
                }
            } else if (c == '{' && openingCurly == -1) {
                if (dollar == i - 1) {
                    openingCurly = i;
                } else {
                    dollar = -1;
                    closingCurly = -1;
                }
            } else if (c == '}' && dollar > -1 && openingCurly > -1) {
                closingCurly = i;
            }
            if (dollar > -1 && closingCurly > -1) {
                String value;
                String key = input.substring(dollar + 2, closingCurly);
                if (!key.trim().isEmpty() && (value = System.getenv(key)) != null) {
                    envVars.put(input.substring(dollar, closingCurly + 1), value);
                }
                dollar = -1;
                openingCurly = -1;
                closingCurly = -1;
            }
            ++i;
        }
        return envVars;
    }
}

