/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class ExceptionUtility {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private ExceptionUtility() {
    }

    public static String collectAll(Throwable exc) {
        assert (exc != null) : "'exc' must not be null";
        StringBuffer buffer = new StringBuffer(1024);
        Throwable next = exc;
        while (next != null) {
            buffer.append(next.toString());
            buffer.append(LINE_SEPARATOR);
            StackTraceElement[] ste = next.getStackTrace();
            int i = 0;
            while (i < ste.length) {
                buffer.append(ste[i].toString());
                buffer.append(LINE_SEPARATOR);
                ++i;
            }
            next = next.getCause();
        }
        return buffer.toString();
    }

    public static String collectLast(Throwable exc) {
        assert (exc != null) : "Parameter 'exc' of method 'collectLast' must not be null";
        StringBuffer buffer = new StringBuffer(exc.toString());
        Throwable next = exc;
        Throwable last = exc;
        while (next != null) {
            if ((next = next.getCause()) == null) continue;
            last = next;
        }
        buffer.append(LINE_SEPARATOR);
        buffer.append(last.toString());
        StackTraceElement[] ste = last.getStackTrace();
        int i = 0;
        while (i < ste.length) {
            buffer.append(LINE_SEPARATOR);
            buffer.append(ste[i].toString());
            ++i;
        }
        return buffer.toString();
    }

    public static String collectFirstAndLast(Throwable exc) {
        assert (exc != null) : "exc != null (37)";
        StringBuffer buffer = new StringBuffer(exc.toString());
        StackTraceElement[] ste = exc.getStackTrace();
        int i = 0;
        while (i < ste.length) {
            buffer.append(LINE_SEPARATOR);
            buffer.append(ste[i].toString());
            ++i;
        }
        Throwable next = exc;
        Throwable last = null;
        while (next != null) {
            if ((next = next.getCause()) == null) continue;
            last = next;
        }
        if (last != null) {
            buffer.append(LINE_SEPARATOR);
            buffer.append(last.toString());
            ste = last.getStackTrace();
            int i2 = 0;
            while (i2 < ste.length) {
                buffer.append(LINE_SEPARATOR);
                buffer.append(ste[i2].toString());
                ++i2;
            }
        }
        return buffer.toString();
    }

    public static void printAll(PrintStream out, Throwable exc) {
        assert (out != null) : "out != null (74)";
        assert (exc != null) : "exc != null (75)";
        Throwable next = exc;
        while (next != null) {
            out.println(next.getMessage());
            next.printStackTrace(out);
            next = next.getCause();
        }
    }

    public static boolean checkReferences(Collection<?> collection) {
        assert (collection != null) : "Parameter 'collection' of method 'checkReferences' must not be null";
        for (Object next : collection) {
            if (next != null) continue;
            return false;
        }
        return true;
    }

    public static boolean stacktraceContains(Throwable throwable, String contains) {
        assert (throwable != null) : "Parameter 'throwable' of method 'stacktraceContains' must not be null";
        assert (contains != null && contains.length() > 0) : "Parameter 'contains' of method 'stacktraceContains' must not be empty";
        StackTraceElement[] ste = throwable.getStackTrace();
        if (ste != null) {
            StackTraceElement[] stackTraceElementArray = ste;
            int n = ste.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement next = stackTraceElementArray[n2];
                String nextAsString = next.toString();
                if (nextAsString != null && nextAsString.indexOf(contains) != -1) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static boolean stacktraceContainsPackagePrefix(String packagePrefix) {
        assert (packagePrefix != null && packagePrefix.length() > 0) : "Parameter 'packagePrefix' of method 'stacktraceContainsPackagePrefix' must not be empty";
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        List<StackTraceElement> list = Arrays.asList(stackTrace);
        for (StackTraceElement element : list) {
            if (!element.getClassName().startsWith(packagePrefix)) continue;
            return true;
        }
        return false;
    }

    public static Collection<StackTraceElement> collectAllStacktraceElements(Throwable throwable) {
        assert (throwable != null) : "Parameter 'throwable' of method 'collectAllStacktraceElements' must not be null";
        Throwable next = throwable;
        ArrayList<StackTraceElement> elements = new ArrayList<StackTraceElement>();
        while (next != null) {
            StackTraceElement[] ste = next.getStackTrace();
            int i = 0;
            while (i < ste.length) {
                elements.add(ste[i]);
                ++i;
            }
            next = next.getCause();
        }
        return elements;
    }

    public static List<String> collectCallers(int level) {
        assert (level > 0) : "Level must be > 0 but was " + level;
        Throwable throwable = new Throwable("Determine Callers");
        ArrayList<String> callers = new ArrayList<String>(level);
        StackTraceElement[] ste = throwable.getStackTrace();
        int i = 0;
        while (i < ste.length && i <= level) {
            if (i > 0) {
                callers.add(ste[i].toString());
            }
            ++i;
        }
        return callers;
    }
}

