/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.commandline;

import com.hello2morrow.sonargraph.foundation.commandline.ArgumentOption;
import com.hello2morrow.sonargraph.foundation.commandline.ICallback;
import com.hello2morrow.sonargraph.foundation.commandline.Option;

final class PropertyOption
extends ArgumentOption {
    private static final String ASSIGNMENT = "=";
    private static final String PROPERTY = "D";
    private boolean m_missingPropertyValue;

    static {
        Option.addCheck(new Check());
    }

    public PropertyOption(String propertyKey, String description, boolean mandatory) {
        super(propertyKey, description, mandatory);
        assert (propertyKey != null) : "propertyKey != null (31)";
        assert (propertyKey.length() > 0) : "propertyKey.length() > 0 (32)";
        assert (propertyKey.indexOf(ASSIGNMENT) == -1) : "propertyKey.indexOf(PropertyOption.ASSIGNMENT) == -1 (33)";
    }

    protected final void setMissingPropertyValue() {
        this.m_missingPropertyValue = true;
    }

    protected final void setPropertyValue(String value) {
        assert (value != null) : "value != null (43)";
        assert (value.length() > 0) : "value.length() > 0 (44)";
        this.setArgument(value);
    }

    @Override
    protected int process(String[] args, int index) {
        assert (args != null) : "args != null (50)";
        assert (args.length > 0) : "args.length > 0 (51)";
        assert (index >= 0) : "index >= 0 (52)";
        assert (index < args.length) : "index < args.length (53)";
        int resultingIndex = -1;
        int posOfAssignmentOp = args[index].indexOf(ASSIGNMENT);
        if (posOfAssignmentOp != -1 && args[index].substring(0, posOfAssignmentOp).equals(this.getOptionIdentifier())) {
            if (this.alreadyProcessed()) {
                this.setDuplicateOption();
            } else if (posOfAssignmentOp == args[index].length() - 1) {
                this.setMissingPropertyValue();
            } else {
                this.setPropertyValue(args[index].substring(posOfAssignmentOp + 1));
            }
            this.setProcessed();
            resultingIndex = index;
        }
        return resultingIndex;
    }

    @Override
    protected boolean isStateValid(ICallback cb) {
        if (this.m_missingPropertyValue) {
            cb.valueForPropertyOptionMissing(this.getOptionIdentifier());
        }
        return super.isStateValid(cb) && !this.m_missingPropertyValue;
    }

    static class Check
    extends Option.OptionIdentifierCheck {
        Check() {
        }

        @Override
        boolean checkOptionIdentifier(Option currentOption) {
            if (this.getCurrentOption() != currentOption) {
                return !currentOption.getOptionIdentifier().startsWith("-D") && currentOption.getOptionIdentifier().indexOf(PropertyOption.ASSIGNMENT) == -1;
            }
            return true;
        }
    }
}

