/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.commandline;

import com.hello2morrow.sonargraph.foundation.commandline.ArgumentOption;
import com.hello2morrow.sonargraph.foundation.commandline.DefaultReporter;
import com.hello2morrow.sonargraph.foundation.commandline.ICallback;
import com.hello2morrow.sonargraph.foundation.commandline.IntegerOption;
import com.hello2morrow.sonargraph.foundation.commandline.Option;
import com.hello2morrow.sonargraph.foundation.commandline.OrOption;
import com.hello2morrow.sonargraph.foundation.commandline.PropertyOption;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class CommandLineParser {
    private static CommandLineParser s_instance;
    private boolean m_initialized;
    private Set<String> m_unrecognizedOptions = new HashSet<String>();
    private Set<String> m_misplacedOptions = new HashSet<String>();
    private List<String> m_processedArguments = new ArrayList<String>();
    private int m_numberOfArguments;
    private String[] m_argumentDescriptions = new String[0];
    private boolean m_additionalArgumentsAllowed;
    private ICallback m_callback = new DefaultReporter();

    private CommandLineParser() {
        this.clear();
    }

    public static CommandLineParser getInstance() {
        if (s_instance == null) {
            s_instance = new CommandLineParser();
        }
        return s_instance;
    }

    public void clear() {
        this.m_unrecognizedOptions.clear();
        this.m_misplacedOptions.clear();
        this.m_processedArguments.clear();
        this.m_numberOfArguments = 0;
        this.m_argumentDescriptions = new String[0];
        this.m_additionalArgumentsAllowed = false;
        this.m_initialized = true;
        Option.init();
    }

    public void setCallbackIf(ICallback callbackIf) {
        this.m_callback = callbackIf;
    }

    public void addOption(String option, String description, boolean mandatory) {
        new Option(option, description, mandatory);
    }

    public void addPropertyOption(String propertyKey, String description, boolean mandatory) {
        new PropertyOption(propertyKey, description, mandatory);
    }

    public void addArgumentOption(String option, String description, boolean mandatory) {
        new ArgumentOption(option, description, mandatory);
    }

    public void addArgumentOption(String option, String argumentDescription, String description, boolean mandatory) {
        new ArgumentOption(option, argumentDescription, description, mandatory);
    }

    public void addIntegerOption(String option, String description, boolean mandatory) {
        new IntegerOption(option, description, mandatory);
    }

    public void addOrCombinedOption(String option, String[] or, String description, boolean mandatory) {
        new OrOption(option, or, description, mandatory);
    }

    public void addArguments(String[] argDescriptions, boolean additionalArgumentsAllowed) {
        assert (this.m_initialized) : "m_Initialized (78)";
        if (argDescriptions == null) {
            this.m_numberOfArguments = 0;
        } else {
            this.m_numberOfArguments = argDescriptions.length;
            this.m_argumentDescriptions = argDescriptions;
        }
        this.m_additionalArgumentsAllowed = additionalArgumentsAllowed;
    }

    public boolean parse(String[] args) {
        assert (args != null) : "Parameter 'args' of method 'parse' must not be null";
        boolean commandLineSyntaxIsCorrect = true;
        boolean processingArguments = false;
        this.m_callback.commandLine(args);
        int i = 0;
        while (i < args.length) {
            String next = args[i];
            assert (next != null) : "next != null (105)";
            assert (next.length() > 0) : "next.length() > 0 (106)";
            if (next.startsWith("-")) {
                int returnedIndex;
                if (processingArguments) {
                    this.m_misplacedOptions.add(next);
                }
                if ((returnedIndex = Option.processNextArgument(args, i)) == -1) {
                    this.m_unrecognizedOptions.add(next);
                } else {
                    i = returnedIndex;
                }
            } else {
                if (!processingArguments) {
                    processingArguments = true;
                }
                this.m_processedArguments.add(next);
            }
            ++i;
        }
        commandLineSyntaxIsCorrect = Option.areStatesValid(this.m_callback);
        if (!this.m_unrecognizedOptions.isEmpty()) {
            Iterator<String> unrecognizedOptionsIterator = this.m_unrecognizedOptions.iterator();
            while (unrecognizedOptionsIterator.hasNext()) {
                this.m_callback.unrecognizedOption(unrecognizedOptionsIterator.next());
            }
            commandLineSyntaxIsCorrect = false;
        }
        if (!this.m_misplacedOptions.isEmpty()) {
            Iterator<String> misplacedOptionsIterator = this.m_misplacedOptions.iterator();
            while (misplacedOptionsIterator.hasNext()) {
                this.m_callback.misplacedOption(misplacedOptionsIterator.next());
            }
            commandLineSyntaxIsCorrect = false;
        }
        String[] providedArguments = new String[this.m_processedArguments.size()];
        this.m_processedArguments.toArray(providedArguments);
        if (this.m_processedArguments.size() < this.m_numberOfArguments) {
            this.m_callback.missingArguments(this.m_argumentDescriptions, providedArguments);
            commandLineSyntaxIsCorrect = false;
        } else if (this.m_processedArguments.size() > this.m_numberOfArguments && !this.m_additionalArgumentsAllowed) {
            this.m_callback.tooManyArguments(this.m_argumentDescriptions, providedArguments);
            commandLineSyntaxIsCorrect = false;
        }
        return commandLineSyntaxIsCorrect;
    }

    public boolean wasOptionProvided(String option) {
        return Option.wasOptionProvided(option);
    }

    public boolean hasOptionAnArgument(String option) {
        return Option.hasOptionAnArgument(option);
    }

    public String getArgumentForOption(String option) {
        return Option.getArgumentForOption(option);
    }

    public boolean hasArguments() {
        return this.m_processedArguments.size() > 0;
    }

    public String[] getArguments() {
        assert (this.hasArguments()) : "hasArguments() (199)";
        String[] args = new String[this.m_processedArguments.size()];
        return this.m_processedArguments.toArray(args);
    }

    public String usage() {
        int i;
        StringBuffer buffer = new StringBuffer();
        String[] optionDescriptions = Option.getOptionDescriptions();
        if (optionDescriptions.length > 0) {
            buffer.append("Options:");
            buffer.append(StringUtility.LINE_SEPARATOR);
            i = 0;
            while (i < optionDescriptions.length) {
                buffer.append(optionDescriptions[i]);
                buffer.append(StringUtility.LINE_SEPARATOR);
                ++i;
            }
        }
        if (this.m_argumentDescriptions.length > 0) {
            buffer.append("Arguments:");
            buffer.append(StringUtility.LINE_SEPARATOR);
            i = 0;
            while (i < this.m_argumentDescriptions.length) {
                buffer.append(this.m_argumentDescriptions[i]);
                buffer.append(StringUtility.LINE_SEPARATOR);
                ++i;
            }
            if (this.m_additionalArgumentsAllowed) {
                buffer.append("-- additional arguments allowed --");
            } else {
                buffer.append("-- no additional arguments allowed --");
            }
        }
        return buffer.toString();
    }
}

