/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.activity;

import com.hello2morrow.sonargraph.foundation.activity.Activity;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.ExceptionUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkerContext
implements IWorkerContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkerContext.class);
    private final Activity m_activity = new Activity();

    protected WorkerContext() {
    }

    @Override
    public final void start(String message, ActivityMode mode, boolean providesProgress) {
        this.m_activity.start(message, mode, providesProgress);
        this.activityUpdated(this.m_activity);
        this.m_activity.started();
    }

    protected final Activity getActivity() {
        return this.m_activity;
    }

    protected final int getWorkedInPercent() {
        return this.m_activity.getWorkedInPercent();
    }

    @Override
    public final boolean hasBeenCanceled() {
        return this.m_activity.hasBeenCanceled();
    }

    public final void cancel() {
        this.m_activity.cancel();
        this.activityUpdated(this.m_activity);
    }

    @Override
    public final void stop() {
        this.m_activity.stop();
        this.activityUpdated(this.m_activity);
    }

    @Override
    public final void setNumberOfSteps(int steps) {
        this.m_activity.setNumberOfSteps(steps);
    }

    @Override
    public final void setNumberOfSteps(int steps, int[] weights) {
        this.m_activity.setNumberOfSteps(steps, weights);
        if (LOGGER.isTraceEnabled()) {
            String caller = ExceptionUtility.collectCallers(2).get(1);
            LOGGER.trace("Set number of steps: {}, caller: {}", (Object)this.m_activity.toString(), (Object)caller);
        }
    }

    @Override
    public final void beginSubTask(String message) {
        this.m_activity.beginSubTask(message);
        this.activityUpdated(this.m_activity);
        if (LOGGER.isTraceEnabled()) {
            String caller = ExceptionUtility.collectCallers(2).get(1);
            LOGGER.trace("Begin sub task: {}, caller: {}", (Object)this.m_activity.toString(), (Object)caller);
        }
    }

    @Override
    public final void endSubTask() {
        if (this.m_activity.endSubTask()) {
            this.activityUpdated(this.m_activity);
        }
        if (LOGGER.isTraceEnabled()) {
            String caller = ExceptionUtility.collectCallers(2).get(1);
            LOGGER.trace("End sub task: {}, caller: {}", (Object)this.m_activity.toString(), (Object)caller);
        }
    }

    @Override
    public final void beginBlockOfWork(int workItems) {
        this.m_activity.beginBlockOfWork(workItems);
    }

    @Override
    public final void workItemCompleted() {
        if (this.m_activity.workItemCompleted()) {
            this.activityUpdated(this.m_activity);
            if (LOGGER.isTraceEnabled()) {
                String caller = ExceptionUtility.collectCallers(2).get(1);
                LOGGER.trace("Work item completed: {}, caller: {}", (Object)this.m_activity.toString(), (Object)caller);
            }
        }
    }

    @Override
    public final void endStep() {
        if (this.m_activity.endStep()) {
            this.activityUpdated(this.m_activity);
        }
        if (LOGGER.isTraceEnabled()) {
            String caller = ExceptionUtility.collectCallers(2).get(1);
            LOGGER.trace("End step: {}, caller: {}", (Object)this.m_activity.toString(), (Object)caller);
        }
    }

    @Override
    public final void working(String message, boolean isMainStep) {
        this.m_activity.activity(message, isMainStep);
        this.activityUpdated(this.m_activity);
    }

    protected abstract void activityUpdated(Activity var1);

    public String toString() {
        return this.m_activity.toString();
    }
}

