/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.javapg.runtime.tree;

import com.hello2morrow.javapg.runtime.messaging.Position;
import com.hello2morrow.javapg.runtime.tree.Node;
import com.hello2morrow.javapg.runtime.tree.Visitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public abstract class InnerNode
extends Node
implements Iterable<Node> {
    static final List<Node> EMPTY = new ArrayList<Node>();
    ArrayList<Node> m_Children = null;

    public InnerNode(InnerNode parent) {
        super(parent);
    }

    public void addChild(Node child) {
        if (this.m_Children == null) {
            this.m_Children = new ArrayList(4);
        }
        this.m_Children.add(child);
    }

    public void addChildren(List<Object> children) {
        assert (children != null) : "Parameter 'children' of method 'addChildren' must not be null";
        if (this.m_Children == null) {
            this.m_Children = new ArrayList(children.size());
        }
        for (Object o : children) {
            if (o instanceof List) {
                this.addChildren((List)o);
                continue;
            }
            if (!(o instanceof Node)) continue;
            this.addChild((Node)o);
        }
    }

    public void addChildren(Object[] children) {
        assert (children != null) : "Parameter 'children' of method 'addChildren' must not be null";
        if (this.m_Children == null) {
            this.m_Children = new ArrayList(children.length);
        }
        int i = 0;
        while (i < children.length) {
            Object child = children[i];
            if (child instanceof Node) {
                this.addChild((Node)child);
            } else if (child instanceof Object[]) {
                this.addChildren((Object[])child);
            }
            ++i;
        }
    }

    public int size() {
        return this.m_Children == null ? 0 : this.m_Children.size();
    }

    public Node getChildAt(int i) {
        if (this.m_Children == null) {
            throw new IllegalArgumentException();
        }
        return this.m_Children.get(i);
    }

    public Node getChild(String name, int occurence) {
        if (this.m_Children == null) {
            return null;
        }
        int index = 0;
        int size = this.m_Children.size();
        while (index < size) {
            Node node;
            if (!(node = this.m_Children.get(index++)).getNodeName().equals(name)) continue;
            if (occurence == 0) {
                return node;
            }
            --occurence;
        }
        return null;
    }

    public List<Node> getChildren(String name) {
        return this.m_Children.stream().filter(n -> n.getNodeName().equals(name)).collect(Collectors.toList());
    }

    public Node getChild(String name) {
        return this.getChild(name, 0);
    }

    @Override
    public Object getAttribute(String key) {
        return super.getAttribute(key);
    }

    public Object getAttribute(String nodeName, String attrName) {
        Node node = this.getChild(nodeName);
        if (node == null) {
            return null;
        }
        return node.getAttribute(attrName);
    }

    public List<Node> getChildren() {
        return this.m_Children != null ? this.m_Children : EMPTY;
    }

    public void visitChildren(Visitor v, Node ... ignore) {
        if (this.m_Children == null) {
            return;
        }
        v.pushParent(this);
        if (ignore.length == 0) {
            for (Node node : this.m_Children) {
                node.accept(v);
            }
        } else {
            for (Node node : this.m_Children) {
                boolean ignored = false;
                Node[] nodeArray = ignore;
                int n = ignore.length;
                int n2 = 0;
                while (n2 < n) {
                    Node nextToIgnore = nodeArray[n2];
                    if (nextToIgnore == node) {
                        ignored = true;
                        break;
                    }
                    ++n2;
                }
                if (ignored) continue;
                node.accept(v);
            }
        }
        v.popParent();
    }

    public void visitChildren(Visitor v, String nodeName) {
        if (this.m_Children == null) {
            return;
        }
        for (Node node : this.m_Children) {
            if (!node.getNodeName().equals(nodeName)) continue;
            node.accept(v);
        }
    }

    public void visitChildrenExcept(Visitor v, String nodeName) {
        if (this.m_Children == null) {
            return;
        }
        for (Node node : this.m_Children) {
            if (node.getNodeName().equals(nodeName)) continue;
            node.accept(v);
        }
    }

    @Override
    public Iterator<Node> iterator() {
        assert (this.m_Children != null);
        return this.m_Children.iterator();
    }

    public void replaceNode(Node oldNode, Node newNode) {
        assert (this.m_Children != null);
        int pos = this.m_Children.indexOf(oldNode);
        this.m_Children.set(pos, newNode);
    }

    @Override
    public Position getPosition() {
        int sz;
        Position result = super.getPosition();
        if (result == null && (sz = this.size()) > 0) {
            int i = 0;
            while ((result = this.m_Children.get(i++).getPosition()) == null && i < sz) {
            }
            if (result != null) {
                this.setAttribute("$position", result);
            }
        }
        return result;
    }

    @Override
    public Position getEndPosition() {
        int sz;
        Position result = super.getEndPosition();
        if (result == null && (sz = this.size()) > 0) {
            int i = sz;
            while ((result = this.m_Children.get(--i).getEndPosition()) == null && i > 0) {
            }
            if (result != null) {
                this.setAttribute("$end", result);
            }
        }
        return result;
    }

    @Override
    public InnerNode clone() throws CloneNotSupportedException {
        InnerNode result = (InnerNode)super.clone();
        if (this.m_Children != null) {
            result.m_Children = new ArrayList(this.m_Children.size());
            for (Node n : this.m_Children) {
                n = n.clone();
                result.addChild(n);
            }
        }
        return result;
    }

    @Override
    protected void collectTerminals(List<Node> terminals) {
        this.getChildren().forEach(n -> n.collectTerminals(terminals));
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder();
        sb.append("InnerNodeName: " + this.getNodeName()).append("\n");
        sb.append("Lexeme:   " + this.getLexeme()).append("\n");
        sb.append("Attributes: " + String.valueOf(this.getAttributes())).append("\n");
        sb.append("Children: ").append("\n");
        for (Node node : this.m_Children) {
            sb.append(node.dump());
        }
        return sb.toString();
    }

    public void fitToSize() {
        if (this.m_Children != null) {
            this.m_Children.trimToSize();
        }
    }
}

