/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import java.util.Arrays;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Version {
    private static final Logger LOGGER = LoggerFactory.getLogger(Version.class);
    protected static final String SEPARATOR = ".";
    private static final int STANDARD_VERSION_PARTS = 4;
    private final int[] m_version;

    private static String filterDigits(String input) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < input.length() && Character.isDigit(input.charAt(i))) {
            result.append(input.charAt(i++));
        }
        if (i == 0) {
            return null;
        }
        return result.toString();
    }

    public static Version create(String versionAsString, boolean logErrors) {
        block6: {
            assert (versionAsString != null) : "'versionAsString' must not be null";
            try {
                StringTokenizer tokenizer = new StringTokenizer(versionAsString, SEPARATOR);
                int tokenCount = tokenizer.countTokens();
                if (tokenCount > 0) {
                    int[] version = new int[4];
                    int i = 0;
                    while (i < 4 && tokenizer.hasMoreTokens()) {
                        String digits = Version.filterDigits(tokenizer.nextToken());
                        if (digits == null) break;
                        version[i] = Integer.parseInt(digits);
                        ++i;
                    }
                    return new Version(version);
                }
                if (logErrors) {
                    LOGGER.error("Failed to compute version from '" + versionAsString + "' - no version parts");
                }
            }
            catch (NumberFormatException e) {
                if (!logErrors) break block6;
                LOGGER.error("Failed to compute version from '" + versionAsString + "'", (Throwable)e);
            }
        }
        return null;
    }

    public static Version create(String versionAsString) {
        return Version.create(versionAsString, true);
    }

    public static Version create(int major, int minor, int increment, int build) {
        return new Version(new int[]{major, minor, increment, build});
    }

    protected Version(int[] version) {
        assert (version != null) : "'version' must not be null";
        assert (version.length == 4) : "'version' must have 4 elements";
        this.m_version = version;
    }

    public final int[] getVersion() {
        return this.m_version;
    }

    public final int getMajor() {
        return this.m_version[0];
    }

    public final int getMinor() {
        return this.m_version[1];
    }

    public final int getIncrement() {
        return this.m_version[2];
    }

    public final int getBuild() {
        return this.m_version[3];
    }

    public int hashCode() {
        return Arrays.hashCode(this.m_version);
    }

    public boolean isAtLeast(Version other) {
        assert (other != null) : "Parameter 'other' of method 'isAtLeast' must not be null";
        VersionComparator versionComparator = new VersionComparator();
        return versionComparator.compare(this, other) == 1 || versionComparator.compare(this, other) == 0;
    }

    public boolean isAfter(Version other) {
        assert (other != null) : "Parameter 'other' of method 'isAfter' must not be null";
        return new VersionComparator().compare(this, other) == 1;
    }

    public boolean isBefore(Version other) {
        assert (other != null) : "Parameter 'other' of method 'isAfter' must not be null";
        return new VersionComparator().compare(this, other) == -1;
    }

    public String toString(int versionParts) {
        return IntStream.of(this.m_version).limit(versionParts).boxed().map(i -> i.toString()).collect(Collectors.joining(SEPARATOR));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        return Arrays.equals(this.m_version, other.m_version);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.m_version[0]);
        builder.append(SEPARATOR);
        builder.append(this.m_version[1]);
        builder.append(SEPARATOR);
        builder.append(this.m_version[2]);
        builder.append(SEPARATOR);
        builder.append(this.m_version[3]);
        return builder.toString();
    }

    public static final class VersionComparator
    implements Comparator<Version> {
        @Override
        public int compare(Version version1, Version version2) {
            assert (version1 != null) : "Parameter 'version1' of method 'compare' must not be null";
            assert (version2 != null) : "Parameter 'version2' of method 'compare' must not be null";
            int major = Integer.compare(version1.getMajor(), version2.getMajor());
            if (major != 0) {
                return major;
            }
            int minor = Integer.compare(version1.getMinor(), version2.getMinor());
            if (minor != 0) {
                return minor;
            }
            int increment = Integer.compare(version1.getIncrement(), version2.getIncrement());
            if (increment != 0) {
                return increment;
            }
            return Integer.compare(version1.getBuild(), version2.getBuild());
        }
    }
}

