/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.utilities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class CategoryProvider {
    private final List<ICategoryAdapter> m_dynamicCategoryProviders = new ArrayList<ICategoryAdapter>(2);
    private final Map<Class<?>, ICategoryAdapter> m_classToCategoryAdapter = new HashMap();

    public CategoryProvider() {
    }

    public CategoryProvider(List<CategoryProvider> providers) {
        this.addCategoryProviders(providers);
    }

    public void addCategoryProviders(List<CategoryProvider> providers) {
        assert (providers != null) : "Parameter 'providers' of method 'addCategoryProviders' must not be null";
        int i = providers.size() - 1;
        while (i >= 0) {
            CategoryProvider nextProvider = providers.get(i);
            this.m_classToCategoryAdapter.putAll(nextProvider.m_classToCategoryAdapter);
            this.m_dynamicCategoryProviders.addAll(nextProvider.m_dynamicCategoryProviders);
            --i;
        }
    }

    public void addDynamicCategoryAdapter(ICategoryAdapter adapter) {
        assert (adapter != null) : "Parameter 'adapter' of method 'addCategoryAdapter' must not be null";
        assert (!this.m_dynamicCategoryProviders.contains(adapter)) : "Already added: " + String.valueOf(adapter);
        this.m_dynamicCategoryProviders.add(adapter);
    }

    public void addCategoryAdapter(Class<?> clazz, ICategoryAdapter adapter) {
        assert (clazz != null) : "Parameter 'clazz' of method 'addCategoryAdapter' must not be null";
        assert (adapter != null) : "Parameter 'adapter' of method 'addCategoryAdapter' must not be null";
        ICategoryAdapter previous = this.m_classToCategoryAdapter.put(clazz, adapter);
        assert (previous == null) : "Parameter 'previous' of method 'addCategoryAdapter' must be null";
    }

    public void setCategory(Class<?> clazz, int category) {
        this.addCategoryAdapter(clazz, new ClassBasedCategoryAdapter(category));
    }

    public int getCategory(Object object) {
        int category;
        assert (object != null) : "Parameter 'object' of method 'getCategory' must not be null";
        for (ICategoryAdapter nextDynamicCategoryAdapter : this.m_dynamicCategoryProviders) {
            int category2 = nextDynamicCategoryAdapter.getCategory(object);
            if (category2 == Integer.MIN_VALUE) continue;
            return category2;
        }
        ICategoryAdapter categoryAdapter = this.m_classToCategoryAdapter.get(object.getClass());
        int n = category = categoryAdapter == null ? 0 : categoryAdapter.getCategory(object);
        if (category == Integer.MIN_VALUE) {
            return 0;
        }
        return category;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getName());
        for (ICategoryAdapter iCategoryAdapter : this.m_dynamicCategoryProviders) {
            builder.append("\n");
            builder.append("Dynamic category provider: ").append(iCategoryAdapter.getClass().getName());
        }
        for (Map.Entry entry : this.m_classToCategoryAdapter.entrySet()) {
            builder.append("\n");
            builder.append(((Class)entry.getKey()).getName()).append(": " + String.valueOf(entry.getValue()));
        }
        return builder.toString();
    }

    private final class ClassBasedCategoryAdapter
    implements ICategoryAdapter {
        private final int m_category;

        ClassBasedCategoryAdapter(int category) {
            this.m_category = category;
        }

        @Override
        public int getCategory(Object object) {
            return this.m_category;
        }

        public String toString() {
            return "[" + this.getClass().getName() + "] Category: " + this.m_category;
        }
    }

    public static interface ICategoryAdapter {
        public static final int NO_CATEGORY = Integer.MIN_VALUE;
        public static final int DEFAULT_CATEGORY = 0;

        public int getCategory(Object var1);
    }
}

