/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;

public final class SmartReader
extends Reader {
    private static final int BUFSIZE = 16384;
    private static final String SYSTEM_DEFAULT = System.getProperty("file.encoding");
    private static final String DEFAULT = "ISO-8859-1";
    private static final String UTF8 = "UTF-8";
    private static final String UTF16BE = "UTF-16BE";
    private static final String UTF16LE = "UTF-16LE";
    private static final int ENC_NONE = 0;
    private static final int ENC_DEFAULT = 1;
    private static final int ENC_UTF8 = 2;
    private static final int ENC_UTF16BE = 3;
    private static final int ENC_UTF16LE = 4;
    private final InputStream m_input;
    private final byte[] m_buffer = new byte[16384];
    private int m_validBytes = 0;
    private int m_position = 0;
    private boolean m_eofReached = false;
    private boolean m_yetToBeDeterminedIfEncodingIsUTF8 = false;
    private int m_encoding = 0;
    private CharsetDecoder m_decoder;
    private char m_lastCharInBuffer;
    private final CharBuffer m_overflowBuffer = CharBuffer.wrap(new char[10]);

    public SmartReader(InputStream input) {
        assert (input != null) : "Parameter 'input' of method 'SmartReader' must not be null";
        this.m_input = input;
        this.m_overflowBuffer.flip();
    }

    @Override
    public void close() throws IOException {
        this.m_input.close();
    }

    private int unprocessedBytesInBuffer() {
        return this.m_validBytes - this.m_position;
    }

    private void decoderChanged() {
        assert (this.m_decoder != null);
        this.m_decoder.onMalformedInput(CodingErrorAction.REPLACE);
        this.m_decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.m_decoder.replaceWith("?");
    }

    private void guessEncoding() {
        assert (this.m_position == 0);
        if (this.m_validBytes < 3) {
            this.m_encoding = 1;
        } else if (this.m_buffer[0] == 0 || this.m_buffer[0] == -2 && this.m_buffer[1] == -1) {
            this.m_encoding = 3;
        } else if (this.m_buffer[1] == 0 || this.m_buffer[0] == -1 && this.m_buffer[1] == -2) {
            this.m_encoding = 4;
        } else if (this.m_buffer[0] == -17 && this.m_buffer[1] == -69 && this.m_buffer[2] == -65) {
            this.m_encoding = 2;
            this.m_position = 3;
        } else {
            this.m_encoding = 1;
        }
        if (this.m_encoding == 1 && !SYSTEM_DEFAULT.equals(DEFAULT)) {
            try {
                this.m_decoder = Charset.forName(DEFAULT).newDecoder();
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        switch (this.m_encoding) {
            case 1: {
                if (this.m_decoder == null) {
                    this.m_decoder = Charset.forName(SYSTEM_DEFAULT).newDecoder();
                }
                this.m_yetToBeDeterminedIfEncodingIsUTF8 = true;
                break;
            }
            case 2: {
                this.m_decoder = Charset.forName(UTF8).newDecoder();
                break;
            }
            case 3: {
                this.m_decoder = Charset.forName(UTF16BE).newDecoder();
                break;
            }
            case 4: {
                this.m_decoder = Charset.forName(UTF16LE).newDecoder();
            }
        }
        assert (this.m_decoder != null);
        this.decoderChanged();
    }

    private void checkEncoding(byte b) {
        int upperHalfByte = b & 0xF0;
        int lowerHalfByte = b & 0xF;
        int followingBytes = 0;
        switch (upperHalfByte) {
            case 192: 
            case 208: {
                followingBytes = 1;
                break;
            }
            case 224: {
                followingBytes = 2;
                break;
            }
            case 240: {
                if (lowerHalfByte >= 8) break;
                followingBytes = 3;
            }
        }
        if (followingBytes == 0) {
            this.m_yetToBeDeterminedIfEncodingIsUTF8 = false;
        } else if (this.unprocessedBytesInBuffer() < followingBytes + 1) {
            this.m_yetToBeDeterminedIfEncodingIsUTF8 = false;
        } else {
            int i = 1;
            while (i <= followingBytes) {
                if ((this.m_buffer[this.m_position + i] & 0xC0) != 128) {
                    this.m_yetToBeDeterminedIfEncodingIsUTF8 = false;
                    break;
                }
                ++i;
            }
            if (this.m_yetToBeDeterminedIfEncodingIsUTF8) {
                this.m_encoding = 2;
                this.m_decoder = Charset.forName(UTF8).newDecoder();
                this.decoderChanged();
                this.m_yetToBeDeterminedIfEncodingIsUTF8 = false;
            }
        }
    }

    private void fillBufferWithAtLeastEightBytesIfPossible() throws IOException {
        while (!this.m_eofReached && this.unprocessedBytesInBuffer() < 8) {
            if (this.m_position > 0 && this.m_position < this.m_validBytes) {
                System.arraycopy(this.m_buffer, this.m_position, this.m_buffer, 0, this.m_validBytes - this.m_position);
            }
            this.m_validBytes -= this.m_position;
            this.m_position = 0;
            int bytesRead = this.m_input.read(this.m_buffer, this.m_validBytes, 16384 - this.m_validBytes);
            if (bytesRead == -1) {
                this.m_eofReached = true;
                continue;
            }
            this.m_validBytes += bytesRead;
        }
    }

    private int internalRead(char[] cbuf, int off, int len) throws IOException {
        int numberOfCharactersProduced;
        assert (len > 0) : "no buffer space given";
        while (true) {
            ByteBuffer source;
            CoderResult result;
            this.fillBufferWithAtLeastEightBytesIfPossible();
            if (this.unprocessedBytesInBuffer() == 0) {
                assert (this.m_eofReached);
                return -1;
            }
            if (this.m_encoding == 0) {
                this.guessEncoding();
            }
            CharBuffer destination = CharBuffer.wrap(cbuf, off, len);
            if (this.m_yetToBeDeterminedIfEncodingIsUTF8) {
                while (this.unprocessedBytesInBuffer() > 0 && destination.remaining() > 0) {
                    byte b = this.m_buffer[this.m_position];
                    if (b >= 0) {
                        destination.put((char)b);
                        ++this.m_position;
                        continue;
                    }
                    this.fillBufferWithAtLeastEightBytesIfPossible();
                    this.checkEncoding(b);
                    break;
                }
                int numberOfCharactersProduced2 = len - destination.remaining();
                if (numberOfCharactersProduced2 > 0) {
                    return numberOfCharactersProduced2;
                }
            }
            if ((result = this.m_decoder.decode(source = ByteBuffer.wrap(this.m_buffer, this.m_position, this.m_validBytes - this.m_position), destination, this.m_eofReached)) != CoderResult.UNDERFLOW && result != CoderResult.OVERFLOW) {
                throw new UnsupportedEncodingException("Expecting: " + this.m_decoder.charset().name());
            }
            int newPosition = this.m_validBytes - source.remaining();
            if (newPosition == this.m_position) {
                if (result == CoderResult.UNDERFLOW && !this.m_eofReached) continue;
                this.m_overflowBuffer.clear();
                result = this.m_decoder.decode(source, this.m_overflowBuffer, this.m_eofReached);
                if (result.isError()) {
                    result.throwException();
                }
                newPosition = this.m_validBytes - source.remaining();
                this.m_overflowBuffer.flip();
                while (destination.hasRemaining() && this.m_overflowBuffer.hasRemaining()) {
                    destination.append(this.m_overflowBuffer.get());
                }
            }
            this.m_position = newPosition;
            numberOfCharactersProduced = len - destination.remaining();
            if (numberOfCharactersProduced > 0) break;
        }
        return numberOfCharactersProduced;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int result = 0;
        int offset = off;
        while (this.m_overflowBuffer.hasRemaining() && len > 0) {
            cbuf[off++] = this.m_overflowBuffer.get();
            --len;
            ++result;
        }
        if (len > 0) {
            int c = this.internalRead(cbuf, off, len);
            if (c > 0) {
                result += c;
            } else if (result == 0) {
                result = c;
            }
        }
        if (result > 0) {
            this.m_lastCharInBuffer = cbuf[offset + result - 1];
        } else {
            assert (result == -1);
            if (this.m_lastCharInBuffer != '\n') {
                cbuf[off] = 10;
                this.m_lastCharInBuffer = (char)10;
                result = 1;
            }
        }
        return result;
    }

    public final List<String> readLines() throws IOException {
        int ch;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder(512);
        while ((ch = this.read()) != -1) {
            if (ch == 10) {
                lines.add(line.toString());
                line.setLength(0);
                continue;
            }
            if (ch == 13) {
                lines.add(line.toString());
                line.setLength(0);
                ch = this.read();
                if (ch == -1) break;
                if (ch == 10) continue;
                line.append((char)ch);
                continue;
            }
            line.append((char)ch);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        lines.trimToSize();
        return lines;
    }

    public final List<String> readLinesAndNormalizeLineBreaks() throws IOException {
        int ch;
        ArrayList<String> lines = new ArrayList<String>(100);
        StringBuilder line = new StringBuilder(1024);
        while ((ch = this.read()) != -1) {
            if (ch == 10) {
                line.append((char)ch);
                lines.add(line.toString());
                line.setLength(0);
                continue;
            }
            if (ch == 13) {
                line.append('\n');
                ch = this.read();
                if (ch == -1) break;
                if (ch == 10) {
                    lines.add(line.toString());
                    line.setLength(0);
                    continue;
                }
                lines.add(line.toString());
                line.setLength(0);
                line.append((char)ch);
                continue;
            }
            line.append((char)ch);
        }
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        return lines;
    }

    public String readContent() throws IOException {
        int ch;
        StringBuilder content = new StringBuilder(512);
        while ((ch = this.read()) != -1) {
            if (ch == 10) {
                content.append((char)ch);
                continue;
            }
            if (ch == 13) {
                content.append('\n');
                ch = this.read();
                if (ch == -1) break;
                if (ch == 10) continue;
                content.append((char)ch);
                continue;
            }
            content.append((char)ch);
        }
        return content.toString();
    }
}

