/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.foundation.file;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

class RegexScanner {
    private final File rootDir;
    private final List<Pattern> includePatterns;
    private final List<String> matches = new ArrayList<String>(128);

    public RegexScanner(File rootDir, List<String> includes, List<String> excludes) {
        if (rootDir == null) {
            throw new IllegalArgumentException("rootDir cannot be null.");
        }
        if (!rootDir.exists()) {
            throw new IllegalArgumentException("Directory does not exist: " + String.valueOf(rootDir));
        }
        if (!rootDir.isDirectory()) {
            throw new IllegalArgumentException("File must be a directory: " + String.valueOf(rootDir));
        }
        try {
            rootDir = rootDir.getCanonicalFile();
        }
        catch (IOException ex) {
            throw new RuntimeException("OS error determining canonical path: " + String.valueOf(rootDir), ex);
        }
        this.rootDir = rootDir;
        if (includes == null) {
            throw new IllegalArgumentException("includes cannot be null.");
        }
        if (excludes == null) {
            throw new IllegalArgumentException("excludes cannot be null.");
        }
        this.includePatterns = new ArrayList<Pattern>();
        for (String include : includes) {
            this.includePatterns.add(Pattern.compile(include, 2));
        }
        ArrayList<Pattern> excludePatterns = new ArrayList<Pattern>();
        for (String exclude : excludes) {
            excludePatterns.add(Pattern.compile(exclude, 2));
        }
        this.scanDir(rootDir);
        Iterator<String> matchIter = this.matches.iterator();
        while (matchIter.hasNext()) {
            String filePath = matchIter.next();
            for (Pattern exclude : excludePatterns) {
                if (!exclude.matcher(filePath).matches()) continue;
                matchIter.remove();
            }
        }
    }

    private void scanDir(File dir) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            for (Pattern include : this.includePatterns) {
                String filePath;
                int length = this.rootDir.getPath().length();
                if (!this.rootDir.getPath().endsWith(File.separator)) {
                    ++length;
                }
                if (!include.matcher(filePath = file.getPath().substring(length)).matches()) continue;
                this.matches.add(filePath);
                break;
            }
            if (file.isDirectory()) {
                this.scanDir(file);
            }
            ++n2;
        }
    }

    public List<String> matches() {
        return this.matches;
    }

    public File rootDir() {
        return this.rootDir;
    }
}

